package SNMP::Insight::MIB::Cisco_CDP;

#ABSTRACT: Support for data in CISCO-CDP-MIB

use Moose::Role;

our $VERSION = '0.002';    #TRIAL VERSION:

use SNMP::Insight::Moose::MIB;

use namespace::autoclean;
with 'SNMP::Insight::MIB';

mib_oid "1.3.6.1.4.1.9.9.23";

mib_name "CISCO-CDP-MIB";

has_table 'cdpCacheTable' => (
    oid     => '1.2.1',
    index   => 'cdpCacheAddress',
    columns => {
        "cdpCacheAddress"    => [ '4', 'munge_ipaddress' ],
        "cdpCacheDevicePort" => '7',
        "cdpCacheDeviceId"   => '6',
        "cdpCacheSysName"    => '17',
    }
);

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

SNMP::Insight::MIB::Cisco_CDP - Support for data in CISCO-CDP-MIB

=head1 VERSION

version 0.002

=head1 AUTHOR

Gabriele Mambrini <g.mambrini@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
