/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.IOException;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;

public class DestroyableRuntimeExecutingBrowserLauncher
extends AbstractBrowserLauncher {
    protected Process process;
    protected String commandPath;

    public DestroyableRuntimeExecutingBrowserLauncher(String commandPath, String sessionId) {
        super(sessionId);
        this.commandPath = commandPath;
        this.sessionId = sessionId;
    }

    public void close() {
        if (this.process == null) {
            return;
        }
        AsyncExecute.killProcess(this.process);
    }

    protected void launch(String url) {
        this.exec(this.commandPath + " " + url);
    }

    protected void exec(String command) {
        try {
            this.process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Error starting browser by executing command " + command + ": " + e);
        }
    }
}

