# Generated by default/object.tt
package Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters;
  use Moose;
  has AuthorizationEndpoint => (is => 'ro', isa => 'Str', required => 1);
  has ClientParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::CreateConnectionOAuthClientRequestParameters', required => 1);
  has HttpMethod => (is => 'ro', isa => 'Str', required => 1);
  has OAuthHttpParameters => (is => 'ro', isa => 'Paws::CloudWatchEvents::ConnectionHttpParameters');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters object:

  $service_obj->Method(Att1 => { AuthorizationEndpoint => $value, ..., OAuthHttpParameters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::CreateConnectionOAuthRequestParameters object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationEndpoint

=head1 DESCRIPTION

Contains the OAuth authorization parameters to use for the connection.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AuthorizationEndpoint => Str

The URL to the authorization endpoint when OAuth is specified as the
authorization type.


=head2 B<REQUIRED> ClientParameters => L<Paws::CloudWatchEvents::CreateConnectionOAuthClientRequestParameters>

A C<CreateConnectionOAuthClientRequestParameters> object that contains
the client parameters for OAuth authorization.


=head2 B<REQUIRED> HttpMethod => Str

The method to use for the authorization request.


=head2 OAuthHttpParameters => L<Paws::CloudWatchEvents::ConnectionHttpParameters>

A C<ConnectionHttpParameters> object that contains details about the
additional parameters to use for the connection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

