# Generated by default/object.tt
package Paws::GlobalAccelerator::ByoipCidrEvent;
  use Moose;
  has Message => (is => 'ro', isa => 'Str');
  has Timestamp => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::ByoipCidrEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::ByoipCidrEvent object:

  $service_obj->Method(Att1 => { Message => $value, ..., Timestamp => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::ByoipCidrEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->Message

=head1 DESCRIPTION

A complex type that contains a C<Message> and a C<Timestamp> value for
changes that you make in the status an IP address range that you bring
to AWS Global Accelerator through bring your own IP address (BYOIP).

=head1 ATTRIBUTES


=head2 Message => Str

A string that contains an C<Event> message describing changes that you
make in the status of an IP address range that you bring to AWS Global
Accelerator through bring your own IP address (BYOIP).


=head2 Timestamp => Str

A timestamp when you make a status change for an IP address range that
you bring to AWS Global Accelerator through bring your own IP address
(BYOIP).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

