package HTTP::Engine::Interface::PSGI;
use HTTP::Engine::Interface
    builder => 'CGI',
    writer  => {
        around => {
            finalize => sub { _finalize(@_) },
        },
    },
;

sub run {
    my($self, $env) = @_;

    # get PSGI response arrayrey. generated by _finalize
    $self->handle_request(
        _connection => {
            env           => $env,
            input_handle  => $env->{'psgi.input'},
            output_handle => undef,
        },
    );
}

# generate PSGI response
# hack to HTTP::Engine::Role::ResponseWriter::Finalize
sub _finalize {
    my($next, $writer, $req, $res) = @_;
    my @headers = %{ $res->headers };
    my $body = $res->body;
    $body = [ $body ] unless ref($body);
    [ $res->code, \@headers, $body ];
}

__INTERFACE__

__END__

=for stopwords PSGI

=head1 NAME

HTTP::Engine::Interface::PSGI - PSGI interface for HTTP::Engine

=head1 SYNOPSIS

use L<Plack> for L<PSGI> Impl
  use HTTP::Engine;
  use Plack::Loader;
  my $engine = HTTP::Engine->new(
      interface => {
          module => 'PSGI',
          request_handler => sub {
              HTTP::Engine::Response->new( body => 'ok' );
          },
      },
  );
  my $app = sub { $engine->run(@_) };
  Plack::Loader->load('Standalone', port => 801)->run($app); # see L<Plack::Server::Standalone> and  L<Plack::Loader>

=head1 AUTHOR

yappo

=head1 SEE ALSO

L<PSGI>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut
