use strict;
use warnings;
use utf8;
use Test::More;
use t::Util;

sub run;

my $parser = make_parser
    '26104,"604  ","6040983","ｷｮｳﾄﾌ","ｷｮｳﾄｼﾅｶｷﾞｮｳｸ","ｻｻﾔﾁｮｳ","京都府","京都市中京区","笹屋町（麩屋町通竹屋町下る、麩屋町通夷川上る、竹屋町通麩屋町西入>、竹屋",0,0,0,0,0,0',
    '26104,"604  ","6040983","ｷｮｳﾄﾌ","ｷｮｳﾄｼﾅｶｷﾞｮｳｸ","ｻｻﾔﾁｮｳ","京都府","京都市中京区","笹屋町（だみー、竹屋",0,0,0,0,0,0',
    '26104,"604  ","6040983","ｷｮｳﾄﾌ","ｷｮｳﾄｼﾅｶｷﾞｮｳｸ","ｻｻﾔﾁｮｳ","京都府","京都市中京区","町通麩屋町東入、竹屋町通御幸町西入、夷川通麩屋町西入、夷川通麩屋>町東入）",0,0,0,0,0,0'
;

my $row = $parser->fetch_obj;
is $row->town, '笹屋町';
is $row->town_kana, 'ササヤチョウ';
ok scalar(@{ $row->subtown }) > 0;
ok scalar(@{ $row->subtown_kana }) == 0;

done_testing;
