#########################################################################################
# Package        HiPi::Graphics::BitmapFont::SerifEPD103
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Graphics::BitmapFont::SerifEPD103;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Graphics::BitmapFont);

our $VERSION ='0.01';

my $gap_width = 0;
my $char_height = 103;
my $line_spacing = 0;
my $name = 'Serif 103';
my $space_width = 28;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 11, 
        'xoffset'  => 12, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x1F, 0x80, ##     000000  
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 23, 
        'xoffset'  => 9, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0xFE, 0x00, 0xFE, ##  0000000         0000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 60, 
        'xoffset'  => 7, 
        'xadvance' => 74, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x0F, 0xE0, 0x00, ##                           0000000            0000000         
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x0F, 0xE0, 0x00, ##                          00000000            0000000         
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, ##                          0000000            00000000         
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, ##                          0000000            00000000         
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x1F, 0xC0, 0x00, ##                          0000000            0000000          
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x1F, 0xC0, 0x00, ##                         00000000            0000000          
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0xC0, 0x00, ##                         0000000            00000000          
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0xC0, 0x00, ##                         0000000            00000000          
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x3F, 0x80, 0x00, ##                         0000000            0000000           
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x3F, 0x80, 0x00, ##                        00000000            0000000           
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x3F, 0x80, 0x00, ##                        0000000             0000000           
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x7F, 0x80, 0x00, ##                        0000000            00000000           
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x7F, 0x00, 0x00, ##                        0000000            0000000            
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x7F, 0x00, 0x00, ##                       00000000            0000000            
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x7F, 0x00, 0x00, ##                       00000000            0000000            
            0x00, 0x00, 0x07, 0xF0, 0x00, 0xFF, 0x00, 0x00, ##                       0000000            00000000            
            0x00, 0x00, 0x07, 0xF0, 0x00, 0xFE, 0x00, 0x00, ##                       0000000            0000000             
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0xFE, 0x00, 0x00, ##                      00000000            0000000             
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0xFE, 0x00, 0x00, ##                      00000000            0000000             
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##       0000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x3F, 0xC0, 0x03, 0xF8, 0x00, 0x00, ##                    00000000            0000000               
            0x00, 0x00, 0x3F, 0x80, 0x07, 0xF8, 0x00, 0x00, ##                    0000000            00000000               
            0x00, 0x00, 0x3F, 0x80, 0x07, 0xF8, 0x00, 0x00, ##                    0000000            00000000               
            0x00, 0x00, 0x3F, 0x80, 0x07, 0xF0, 0x00, 0x00, ##                    0000000            0000000                
            0x00, 0x00, 0x7F, 0x80, 0x07, 0xF0, 0x00, 0x00, ##                   00000000            0000000                
            0x00, 0x00, 0x7F, 0x80, 0x07, 0xF0, 0x00, 0x00, ##                   00000000            0000000                
            0x00, 0x00, 0x7F, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                   0000000            00000000                
            0x00, 0x00, 0x7F, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                   0000000            0000000                 
            0x00, 0x00, 0xFF, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                  00000000            0000000                 
            0x00, 0x00, 0xFF, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                  00000000            0000000                 
            0x00, 0x00, 0xFE, 0x00, 0x1F, 0xE0, 0x00, 0x00, ##                  0000000            00000000                 
            0x00, 0x00, 0xFE, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                  0000000            0000000                  
            0x00, 0x00, 0xFE, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                  0000000            0000000                  
            0x00, 0x01, 0xFE, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                 00000000            0000000                  
            0x00, 0x01, 0xFC, 0x00, 0x3F, 0xC0, 0x00, 0x00, ##                 0000000            00000000                  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##  0000000000000000000000000000000000000000000000000000000     
            0x00, 0x07, 0xF8, 0x00, 0x7F, 0x00, 0x00, 0x00, ##               00000000            0000000                    
            0x00, 0x07, 0xF0, 0x00, 0xFF, 0x00, 0x00, 0x00, ##               0000000            00000000                    
            0x00, 0x07, 0xF0, 0x00, 0xFE, 0x00, 0x00, 0x00, ##               0000000            0000000                     
            0x00, 0x0F, 0xF0, 0x00, 0xFE, 0x00, 0x00, 0x00, ##              00000000            0000000                     
            0x00, 0x0F, 0xF0, 0x00, 0xFE, 0x00, 0x00, 0x00, ##              00000000            0000000                     
            0x00, 0x0F, 0xE0, 0x01, 0xFE, 0x00, 0x00, 0x00, ##              0000000            00000000                     
            0x00, 0x0F, 0xE0, 0x01, 0xFC, 0x00, 0x00, 0x00, ##              0000000            0000000                      
            0x00, 0x1F, 0xE0, 0x01, 0xFC, 0x00, 0x00, 0x00, ##             00000000            0000000                      
            0x00, 0x1F, 0xE0, 0x01, 0xFC, 0x00, 0x00, 0x00, ##             00000000            0000000                      
            0x00, 0x1F, 0xC0, 0x03, 0xFC, 0x00, 0x00, 0x00, ##             0000000            00000000                      
            0x00, 0x1F, 0xC0, 0x03, 0xF8, 0x00, 0x00, 0x00, ##             0000000            0000000                       
            0x00, 0x1F, 0xC0, 0x03, 0xF8, 0x00, 0x00, 0x00, ##             0000000            0000000                       
            0x00, 0x3F, 0xC0, 0x03, 0xF8, 0x00, 0x00, 0x00, ##            00000000            0000000                       
            0x00, 0x3F, 0x80, 0x07, 0xF8, 0x00, 0x00, 0x00, ##            0000000            00000000                       
            0x00, 0x3F, 0x80, 0x07, 0xF0, 0x00, 0x00, 0x00, ##            0000000            0000000                        
            0x00, 0x3F, 0x80, 0x07, 0xF0, 0x00, 0x00, 0x00, ##            0000000            0000000                        
            0x00, 0x7F, 0x80, 0x07, 0xF0, 0x00, 0x00, 0x00, ##           00000000            0000000                        
            0x00, 0x7F, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##           0000000            00000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 41, 
        'xoffset'  => 7, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, ##               000000000000000             
            0x00, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##           00000000000000000000000         
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000      
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##        00000000000000000000000000000000   
            0x0F, 0xFE, 0x3C, 0x7F, 0xFC, 0x00, ##      00000000000   0000   0000000000000   
            0x1F, 0xF0, 0x3C, 0x0F, 0xFC, 0x00, ##     000000000      0000      0000000000   
            0x1F, 0xE0, 0x3C, 0x07, 0xFC, 0x00, ##     00000000       0000       000000000   
            0x3F, 0xC0, 0x3C, 0x03, 0xFC, 0x00, ##    00000000        0000        00000000   
            0x7F, 0xC0, 0x3C, 0x01, 0xFC, 0x00, ##   000000000        0000         0000000   
            0x7F, 0x80, 0x3C, 0x00, 0xFC, 0x00, ##   00000000         0000          000000   
            0x7F, 0x80, 0x3C, 0x00, 0xFC, 0x00, ##   00000000         0000          000000   
            0xFF, 0x80, 0x3C, 0x00, 0x7C, 0x00, ##  000000000         0000           00000   
            0xFF, 0x80, 0x3C, 0x00, 0x7C, 0x00, ##  000000000         0000           00000   
            0xFF, 0x80, 0x3C, 0x00, 0x7C, 0x00, ##  000000000         0000           00000   
            0xFF, 0x80, 0x3C, 0x00, 0x7C, 0x00, ##  000000000         0000           00000   
            0xFF, 0xC0, 0x3C, 0x00, 0x00, 0x00, ##  0000000000        0000                   
            0xFF, 0xC0, 0x3C, 0x00, 0x00, 0x00, ##  0000000000        0000                   
            0xFF, 0xE0, 0x3C, 0x00, 0x00, 0x00, ##  00000000000       0000                   
            0xFF, 0xE0, 0x3C, 0x00, 0x00, 0x00, ##  00000000000       0000                   
            0x7F, 0xF8, 0x3C, 0x00, 0x00, 0x00, ##   000000000000     0000                   
            0x7F, 0xFC, 0x3C, 0x00, 0x00, 0x00, ##   0000000000000    0000                   
            0x7F, 0xFF, 0xBC, 0x00, 0x00, 0x00, ##   0000000000000000 0000                   
            0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##    00000000000000000000                   
            0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##     00000000000000000000                  
            0x0F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##      0000000000000000000000               
            0x07, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##       000000000000000000000000            
            0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##        0000000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          0000000000000000000000000        
            0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##            0000000000000000000000000      
            0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, ##               00000000000000000000000     
            0x00, 0x00, 0xFF, 0xFF, 0xF8, 0x00, ##                  000000000000000000000    
            0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, ##                    00000000000000000000   
            0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, ##                    000000000000000000000  
            0x00, 0x00, 0x3C, 0x7F, 0xFF, 0x00, ##                    0000   000000000000000 
            0x00, 0x00, 0x3C, 0x1F, 0xFF, 0x00, ##                    0000     0000000000000 
            0x00, 0x00, 0x3C, 0x0F, 0xFF, 0x00, ##                    0000      000000000000 
            0x00, 0x00, 0x3C, 0x07, 0xFF, 0x80, ##                    0000       000000000000
            0x00, 0x00, 0x3C, 0x03, 0xFF, 0x80, ##                    0000        00000000000
            0x00, 0x00, 0x3C, 0x01, 0xFF, 0x80, ##                    0000         0000000000
            0x00, 0x00, 0x3C, 0x01, 0xFF, 0x80, ##                    0000         0000000000
            0xF8, 0x00, 0x3C, 0x00, 0xFF, 0x80, ##  00000             0000          000000000
            0xF8, 0x00, 0x3C, 0x00, 0xFF, 0x80, ##  00000             0000          000000000
            0xF8, 0x00, 0x3C, 0x00, 0xFF, 0x80, ##  00000             0000          000000000
            0xF8, 0x00, 0x3C, 0x00, 0xFF, 0x80, ##  00000             0000          000000000
            0xFC, 0x00, 0x3C, 0x00, 0xFF, 0x00, ##  000000            0000          00000000 
            0xFC, 0x00, 0x3C, 0x00, 0xFF, 0x00, ##  000000            0000          00000000 
            0xFC, 0x00, 0x3C, 0x01, 0xFF, 0x00, ##  000000            0000         000000000 
            0xFE, 0x00, 0x3C, 0x01, 0xFE, 0x00, ##  0000000           0000         00000000  
            0xFF, 0x00, 0x3C, 0x03, 0xFE, 0x00, ##  00000000          0000        000000000  
            0xFF, 0x80, 0x3C, 0x07, 0xFC, 0x00, ##  000000000         0000       000000000   
            0xFF, 0xC0, 0x3C, 0x0F, 0xF8, 0x00, ##  0000000000        0000      000000000    
            0xFF, 0xF8, 0x3C, 0x7F, 0xF0, 0x00, ##  0000000000000     0000   00000000000     
            0x7F, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##   0000000000000000000000000000000000      
            0x0F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##      00000000000000000000000000000        
            0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##         000000000000000000000000          
            0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, ##              00000000000000               
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, ##                    0000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 73, 
        'xoffset'  => 5, 
        'xadvance' => 83, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##            00000000                                   000000              
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##          0000000000000                                000000              
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##        00000000000000000                             000000               
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##       0000000000000000000                           0000000               
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##      00000000     00000000                          000000                
            0x00, 0x00, 0x3F, 0xC0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##     00000000       00000000                        000000                 
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##     0000000         0000000                        000000                 
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##    0000000           0000000                      000000                  
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##    0000000           0000000                     0000000                  
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##   0000000             0000000                    000000                   
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##   0000000             0000000                   000000                    
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##   0000000             0000000                   000000                    
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##  0000000               0000000                 000000                     
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##  0000000               0000000                0000000                     
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##  0000000               0000000                000000                      
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##  0000000               0000000               000000                       
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##  0000000               0000000               000000                       
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, ##  0000000               0000000              000000                        
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, ##  0000000               0000000             0000000                        
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, ##  0000000               0000000             000000                         
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, ##  0000000               0000000            000000                          
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, ##  0000000               0000000            000000                          
            0x00, 0x00, 0x03, 0xF8, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, ##  0000000               0000000           000000                           
            0x00, 0x00, 0x07, 0xF0, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, ##   0000000             0000000           0000000                           
            0x00, 0x00, 0x07, 0xF0, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, ##   0000000             0000000           000000                            
            0x00, 0x00, 0x07, 0xF0, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, ##   0000000             0000000          000000                             
            0x00, 0x00, 0x0F, 0xE0, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, ##    0000000           0000000           000000                             
            0x00, 0x00, 0x0F, 0xE0, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##    0000000           0000000          000000                              
            0x00, 0x00, 0x1F, 0xC0, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     0000000         0000000          0000000                              
            0x00, 0x00, 0x3F, 0xC0, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##     00000000       00000000          000000                               
            0x00, 0x00, 0x7F, 0x80, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, ##      00000000     00000000          000000                                
            0x00, 0x00, 0xFF, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, ##       0000000000000000000           000000                                
            0x00, 0x00, 0xFE, 0x00, 0x3F, 0x00, 0x01, 0xFC, 0x00, 0x00, ##        00000000000000000           000000               0000000           
            0x00, 0x00, 0xF8, 0x00, 0x7F, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##          0000000000000            0000000            0000000000000        
            0x00, 0x00, 0xE0, 0x00, 0x7E, 0x00, 0x3F, 0xFF, 0xE0, 0x00, ##            000000000              000000           00000000000000000      
            0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x7F, 0xFF, 0xF0, 0x00, ##                                  000000           0000000000000000000     
            0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0xFF, 0x07, 0xF8, 0x00, ##                                  000000          00000000     00000000    
            0x00, 0x00, 0x00, 0x01, 0xF8, 0x01, 0xFE, 0x03, 0xFC, 0x00, ##                                 000000          00000000       00000000   
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x01, 0xFC, 0x01, 0xFC, 0x00, ##                                0000000          0000000         0000000   
            0x00, 0x00, 0x00, 0x03, 0xF0, 0x03, 0xF8, 0x00, 0xFE, 0x00, ##                                000000          0000000           0000000  
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x03, 0xF8, 0x00, 0xFE, 0x00, ##                               000000           0000000           0000000  
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                               000000          0000000             0000000 
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                              000000           0000000             0000000 
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                             0000000           0000000             0000000 
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                             000000           0000000               0000000
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                            000000            0000000               0000000
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                            000000            0000000               0000000
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                           000000             0000000               0000000
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                          0000000             0000000               0000000
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                          000000              0000000               0000000
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                         000000               0000000               0000000
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                         000000               0000000               0000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                        000000                0000000               0000000
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                       0000000                0000000               0000000
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x0F, 0xE0, 0x00, 0x3F, 0x80, ##                       000000                 0000000               0000000
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                      000000                   0000000             0000000 
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                      000000                   0000000             0000000 
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x7F, 0x00, ##                     000000                    0000000             0000000 
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x03, 0xF8, 0x00, 0xFE, 0x00, ##                    0000000                     0000000           0000000  
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x03, 0xF8, 0x00, 0xFE, 0x00, ##                    000000                      0000000           0000000  
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x01, 0xFC, 0x01, 0xFC, 0x00, ##                   000000                        0000000         0000000   
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x01, 0xFE, 0x03, 0xFC, 0x00, ##                   000000                        00000000       00000000   
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFF, 0x07, 0xF8, 0x00, ##                  000000                          00000000     00000000    
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF0, 0x00, ##                 0000000                           0000000000000000000     
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xE0, 0x00, ##                 000000                             00000000000000000      
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##                000000                                0000000000000        
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, ##                000000                                   0000000           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 67, 
        'xoffset'  => 6, 
        'xadvance' => 77, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##                        00000000000                                  
            0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                    00000000000000000000                             
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                  000000000000000000000000000                        
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                 0000000000000000000000000000                        
            0x00, 0x07, 0xFE, 0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##               0000000000        000000000000                        
            0x00, 0x0F, 0xF8, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, ##              000000000            0000000000                        
            0x00, 0x0F, 0xF0, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##              00000000               00000000                        
            0x00, 0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##             00000000                00000000                        
            0x00, 0x3F, 0xC0, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##            00000000                  0000000                        
            0x00, 0x3F, 0xC0, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##            00000000                   000000                        
            0x00, 0x3F, 0x80, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##            0000000                    000000                        
            0x00, 0x7F, 0x80, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##           00000000                    000000                        
            0x00, 0x7F, 0x80, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, ##           00000000                     00000                        
            0x00, 0x7F, 0x80, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, ##           00000000                     00000                        
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           00000000                                                  
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           00000000                                                  
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           000000000                                                 
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           000000000                                                 
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           0000000000                                                
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##            000000000                                                
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##            0000000000                                               
            0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##            00000000000                                              
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##             00000000000                                             
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##              00000000000                                            
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##              00000000000                                            
            0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##               00000000000                                           
            0x00, 0x0F, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##              0000000000000                                          
            0x00, 0x3F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##            0000000000000000                                         
            0x00, 0x7F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##           000000000000000000                                        
            0x00, 0xFF, 0xFF, 0xF0, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##          00000000000000000000                  00000000000000000000 
            0x00, 0xFE, 0x7F, 0xF8, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##         00000000  000000000000                 00000000000000000000 
            0x00, 0xFC, 0x3F, 0xFC, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##        00000000    000000000000                00000000000000000000 
            0x00, 0xF8, 0x1F, 0xFE, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##       00000000      000000000000               00000000000000000000 
            0x00, 0xF0, 0x0F, 0xFF, 0x00, 0x00, 0x03, 0xE0, 0x00, ##      00000000        000000000000                      00000        
            0x00, 0xF0, 0x07, 0xFF, 0x80, 0x00, 0x07, 0xE0, 0x00, ##     000000000         000000000000                    000000        
            0x00, 0xE0, 0x03, 0xFF, 0xC0, 0x00, 0x07, 0xC0, 0x00, ##     00000000           000000000000                   00000         
            0x00, 0xE0, 0x01, 0xFF, 0xE0, 0x00, 0x07, 0xC0, 0x00, ##    000000000            000000000000                  00000         
            0x00, 0xC0, 0x00, 0xFF, 0xF0, 0x00, 0x07, 0xC0, 0x00, ##    00000000              000000000000                 00000         
            0x00, 0xC0, 0x00, 0x7F, 0xF8, 0x00, 0x07, 0xC0, 0x00, ##   000000000               000000000000                00000         
            0x00, 0xC0, 0x00, 0x3F, 0xFC, 0x00, 0x0F, 0x80, 0x00, ##   000000000                000000000000              00000          
            0x00, 0x80, 0x00, 0x1F, 0xFE, 0x00, 0x0F, 0x80, 0x00, ##   00000000                  000000000000             00000          
            0x00, 0x80, 0x00, 0x0F, 0xFF, 0x00, 0x0F, 0x80, 0x00, ##  000000000                   000000000000            00000          
            0x00, 0x80, 0x00, 0x07, 0xFF, 0x80, 0x1F, 0x00, 0x00, ##  000000000                    000000000000          00000           
            0x00, 0x80, 0x00, 0x03, 0xFF, 0x80, 0x1F, 0x00, 0x00, ##  000000000                     00000000000          00000           
            0x00, 0x80, 0x00, 0x01, 0xFF, 0xC0, 0x3F, 0x00, 0x00, ##  000000000                      00000000000        000000           
            0x00, 0x80, 0x00, 0x00, 0xFF, 0xE0, 0x3E, 0x00, 0x00, ##  000000000                       00000000000       00000            
            0x00, 0x80, 0x00, 0x00, 0x7F, 0xF0, 0x7E, 0x00, 0x00, ##  000000000                        00000000000     000000            
            0x00, 0x80, 0x00, 0x00, 0x3F, 0xF8, 0xFC, 0x00, 0x00, ##  000000000                         00000000000   000000             
            0x00, 0x80, 0x00, 0x00, 0x3F, 0xFC, 0xFC, 0x00, 0x00, ##  000000000                         000000000000  000000             
            0x00, 0xC0, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0x00, 0x00, ##  0000000000                         000000000000000000              
            0x00, 0xC0, 0x00, 0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x00, ##   000000000                          0000000000000000               
            0x00, 0xC0, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, 0x00, ##   000000000                           00000000000000                
            0x00, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##   0000000000                           0000000000000                
            0x00, 0xE0, 0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, ##   0000000000                            000000000000                
            0x00, 0xF0, 0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##    0000000000                            000000000000               
            0x00, 0xF8, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, ##    00000000000                           0000000000000              
            0x00, 0xFC, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, ##     00000000000                         000000000000000             
            0x00, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##      00000000000                       0000000000000000             
            0x00, 0xFF, 0x00, 0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##       00000000000                    0000000000000000000            
            0x00, 0xFF, 0xC0, 0x00, 0x3F, 0xF7, 0xFF, 0x00, 0x00, ##       0000000000000                0000000000 00000000000           
            0x00, 0xFF, 0xF8, 0x03, 0xFF, 0xE3, 0xFF, 0x80, 0x00, ##         00000000000000         0000000000000   00000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xE0, ##          000000000000000000000000000000000      00000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0xFF, 0xFF, 0xE0, ##           0000000000000000000000000000000        0000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xF8, 0x00, 0x7F, 0xFF, 0xE0, ##             00000000000000000000000000            000000000000000000
            0x00, 0x03, 0xFF, 0xFF, 0xE0, 0x00, 0x3F, 0xFF, 0xE0, ##                000000000000000000000               00000000000000000
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x00, ##                    000000000000                                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 7, 
        'xoffset'  => 9, 
        'xadvance' => 25, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 21, 
        'xoffset'  => 7, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x08, ##                      0
            0x00, 0x00, 0x38, ##                    000
            0x00, 0x00, 0xF8, ##                  00000
            0x00, 0x01, 0xF8, ##                 000000
            0x00, 0x03, 0xF8, ##                0000000
            0x00, 0x07, 0xE0, ##               000000  
            0x00, 0x1F, 0xC0, ##             0000000   
            0x00, 0x3F, 0x80, ##            0000000    
            0x00, 0x3F, 0x00, ##            000000     
            0x00, 0x7F, 0x00, ##           0000000     
            0x00, 0xFE, 0x00, ##          0000000      
            0x01, 0xFC, 0x00, ##         0000000       
            0x01, 0xFC, 0x00, ##         0000000       
            0x03, 0xF8, 0x00, ##        0000000        
            0x03, 0xF8, 0x00, ##        0000000        
            0x07, 0xF0, 0x00, ##       0000000         
            0x07, 0xF0, 0x00, ##       0000000         
            0x0F, 0xF0, 0x00, ##      00000000         
            0x0F, 0xE0, 0x00, ##      0000000          
            0x1F, 0xE0, 0x00, ##     00000000          
            0x1F, 0xE0, 0x00, ##     00000000          
            0x1F, 0xE0, 0x00, ##     00000000          
            0x3F, 0xC0, 0x00, ##    00000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0x80, 0x00, ##   00000000            
            0x7F, 0x80, 0x00, ##   00000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0xFF, 0x80, 0x00, ##  000000000            
            0x7F, 0x80, 0x00, ##   00000000            
            0x7F, 0x80, 0x00, ##   00000000            
            0x7F, 0x80, 0x00, ##   00000000            
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x7F, 0xC0, 0x00, ##   000000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x3F, 0xC0, 0x00, ##    00000000           
            0x1F, 0xE0, 0x00, ##     00000000          
            0x1F, 0xE0, 0x00, ##     00000000          
            0x1F, 0xE0, 0x00, ##     00000000          
            0x0F, 0xE0, 0x00, ##      0000000          
            0x0F, 0xF0, 0x00, ##      00000000         
            0x07, 0xF0, 0x00, ##       0000000         
            0x07, 0xF0, 0x00, ##       0000000         
            0x03, 0xF8, 0x00, ##        0000000        
            0x03, 0xF8, 0x00, ##        0000000        
            0x01, 0xFC, 0x00, ##         0000000       
            0x01, 0xFC, 0x00, ##         0000000       
            0x00, 0xFE, 0x00, ##          0000000      
            0x00, 0x7F, 0x00, ##           0000000     
            0x00, 0x3F, 0x80, ##            0000000    
            0x00, 0x1F, 0xC0, ##             0000000   
            0x00, 0x0F, 0xE0, ##              0000000  
            0x00, 0x07, 0xF0, ##               0000000 
            0x00, 0x03, 0xF8, ##                0000000
            0x00, 0x01, 0xF8, ##                 000000
            0x00, 0x00, 0x78, ##                   0000
            0x00, 0x00, 0x18, ##                     00
            0x00, 0x00, 0x08, ##                      0
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 21, 
        'xoffset'  => 7, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##                       
            0xC0, 0x00, 0x00, ##  00                   
            0xF0, 0x00, 0x00, ##  0000                 
            0xFC, 0x00, 0x00, ##  000000               
            0xFE, 0x00, 0x00, ##  0000000              
            0x7F, 0x00, 0x00, ##   0000000             
            0x3F, 0x80, 0x00, ##    0000000            
            0x1F, 0xC0, 0x00, ##     0000000           
            0x0F, 0xE0, 0x00, ##      0000000          
            0x07, 0xF0, 0x00, ##       0000000         
            0x03, 0xF8, 0x00, ##        0000000        
            0x03, 0xF8, 0x00, ##        0000000        
            0x01, 0xFC, 0x00, ##         0000000       
            0x00, 0xFE, 0x00, ##          0000000      
            0x00, 0xFE, 0x00, ##          0000000      
            0x00, 0xFF, 0x00, ##          00000000     
            0x00, 0x7F, 0x00, ##           0000000     
            0x00, 0x7F, 0x80, ##           00000000    
            0x00, 0x7F, 0x80, ##           00000000    
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x0F, 0xF0, ##              00000000 
            0x00, 0x0F, 0xF0, ##              00000000 
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF8, ##              000000000
            0x00, 0x0F, 0xF0, ##              00000000 
            0x00, 0x0F, 0xF0, ##              00000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xF0, ##             000000000 
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x1F, 0xE0, ##             00000000  
            0x00, 0x3F, 0xE0, ##            000000000  
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x3F, 0xC0, ##            00000000   
            0x00, 0x7F, 0x80, ##           00000000    
            0x00, 0x7F, 0x80, ##           00000000    
            0x00, 0x7F, 0x00, ##           0000000     
            0x00, 0xFF, 0x00, ##          00000000     
            0x00, 0xFE, 0x00, ##          0000000      
            0x01, 0xFE, 0x00, ##         00000000      
            0x01, 0xFC, 0x00, ##         0000000       
            0x03, 0xF8, 0x00, ##        0000000        
            0x03, 0xF8, 0x00, ##        0000000        
            0x07, 0xF0, 0x00, ##       0000000         
            0x0F, 0xE0, 0x00, ##      0000000          
            0x1F, 0xC0, 0x00, ##     0000000           
            0x3F, 0x80, 0x00, ##    0000000            
            0x7F, 0x00, 0x00, ##   0000000             
            0xFE, 0x00, 0x00, ##  0000000              
            0xF8, 0x00, 0x00, ##  00000                
            0xF0, 0x00, 0x00, ##  0000                 
            0xC0, 0x00, 0x00, ##  00                   
            0x00, 0x00, 0x00, ##                       
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 41, 
        'xoffset'  => 1, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x10, 0x00, 0x3E, 0x00, 0x04, 0x00, ##     0              00000              0   
            0x1C, 0x00, 0x3E, 0x00, 0x1C, 0x00, ##     000            00000            000   
            0x3E, 0x00, 0x3E, 0x00, 0x3E, 0x00, ##    00000           00000           00000  
            0x7F, 0x80, 0x3E, 0x00, 0xFF, 0x00, ##   00000000         00000         00000000 
            0x7F, 0xC0, 0x3E, 0x01, 0xFF, 0x00, ##   000000000        00000        000000000 
            0x7F, 0xF0, 0x3E, 0x07, 0xFF, 0x00, ##   00000000000      00000      00000000000 
            0x1F, 0xFC, 0x3E, 0x1F, 0xFC, 0x00, ##     00000000000    00000    00000000000   
            0x07, 0xFE, 0x3E, 0x3F, 0xF0, 0x00, ##       0000000000   00000   0000000000     
            0x01, 0xFF, 0xBE, 0xFF, 0xC0, 0x00, ##         0000000000 00000 0000000000       
            0x00, 0x7F, 0xFF, 0xFE, 0x00, 0x00, ##           0000000000000000000000          
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000              
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                  000000000                
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000              
            0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, ##              00000000000000000            
            0x00, 0x3F, 0xFF, 0xFF, 0x00, 0x00, ##            0000000000000000000000         
            0x01, 0xFF, 0xBE, 0xFF, 0xC0, 0x00, ##         0000000000 00000 0000000000       
            0x07, 0xFE, 0x3E, 0x3F, 0xF0, 0x00, ##       0000000000   00000   0000000000     
            0x1F, 0xFC, 0x3E, 0x1F, 0xFC, 0x00, ##     00000000000    00000    00000000000   
            0x7F, 0xF0, 0x3E, 0x07, 0xFF, 0x00, ##   00000000000      00000      00000000000 
            0x7F, 0xC0, 0x3E, 0x01, 0xFF, 0x00, ##   000000000        00000        000000000 
            0x7F, 0x80, 0x3E, 0x00, 0xFF, 0x00, ##   00000000         00000         00000000 
            0x3E, 0x00, 0x3E, 0x00, 0x3E, 0x00, ##    00000           00000           00000  
            0x1C, 0x00, 0x3E, 0x00, 0x1C, 0x00, ##     000            00000            000   
            0x10, 0x00, 0x3E, 0x00, 0x04, 0x00, ##     0              00000              0   
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    00000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 54, 
        'xoffset'  => 9, 
        'xadvance' => 72, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 16, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0xFF, ##          00000000
            0x00, 0xFF, ##          00000000
            0x00, 0xFF, ##          00000000
            0x00, 0xFF, ##          00000000
            0x00, 0xFF, ##          00000000
            0x00, 0xFF, ##          00000000
            0x00, 0xFE, ##          0000000 
            0x01, 0xFE, ##         00000000 
            0x01, 0xFE, ##         00000000 
            0x01, 0xFC, ##         0000000  
            0x03, 0xFC, ##        00000000  
            0x03, 0xFC, ##        00000000  
            0x03, 0xF8, ##        0000000   
            0x07, 0xF0, ##       0000000    
            0x0F, 0xF0, ##      00000000    
            0x1F, 0xE0, ##     00000000     
            0x3F, 0xC0, ##    00000000      
            0x7F, 0x80, ##   00000000       
            0xFF, 0x00, ##  00000000        
            0x7E, 0x00, ##   000000         
            0x3C, 0x00, ##    0000          
            0x10, 0x00, ##     0            
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 22, 
        'xoffset'  => 4, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 11, 
        'xoffset'  => 8, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xF8, ##                         000000
            0x00, 0x00, 0x03, 0xF8, ##                        0000000
            0x00, 0x00, 0x03, 0xF8, ##                        0000000
            0x00, 0x00, 0x03, 0xF0, ##                        000000 
            0x00, 0x00, 0x07, 0xF0, ##                       0000000 
            0x00, 0x00, 0x07, 0xF0, ##                       0000000 
            0x00, 0x00, 0x07, 0xE0, ##                       000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000   
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000   
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000   
            0x00, 0x00, 0x3F, 0x80, ##                    0000000    
            0x00, 0x00, 0x3F, 0x80, ##                    0000000    
            0x00, 0x00, 0x3F, 0x80, ##                    0000000    
            0x00, 0x00, 0x3F, 0x00, ##                    000000     
            0x00, 0x00, 0x7F, 0x00, ##                   0000000     
            0x00, 0x00, 0x7F, 0x00, ##                   0000000     
            0x00, 0x00, 0x7E, 0x00, ##                   000000      
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x00, 0xFC, 0x00, ##                  000000       
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x07, 0xE0, 0x00, ##               000000          
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x0F, 0xC0, 0x00, ##              000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0x7E, 0x00, 0x00, ##           000000              
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0xFC, 0x00, 0x00, ##          000000               
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x01, 0xF8, 0x00, 0x00, ##         000000                
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x0F, 0xC0, 0x00, 0x00, ##      000000                   
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                   
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                   
            0x1F, 0x80, 0x00, 0x00, ##     000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x7F, 0x00, 0x00, 0x00, ##   0000000                     
            0x7F, 0x00, 0x00, 0x00, ##   0000000                     
            0x7F, 0x00, 0x00, 0x00, ##   0000000                     
            0xFE, 0x00, 0x00, 0x00, ##  0000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                      
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 44, 
        'xoffset'  => 6, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000              
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##              00000000000000000000            
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000           
            0x00, 0x7F, 0xE0, 0x7F, 0xE0, 0x00, ##           0000000000      0000000000         
            0x00, 0xFF, 0x80, 0x1F, 0xF0, 0x00, ##          000000000          000000000        
            0x01, 0xFE, 0x00, 0x0F, 0xF0, 0x00, ##         00000000             00000000        
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##    000000000                      00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##  000000000                          00000000 
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##  000000000                          00000000 
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##   00000000                         000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0xC0, ##    00000000                       000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x07, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##       00000000                  00000000     
            0x03, 0xFC, 0x00, 0x03, 0xFC, 0x00, ##        00000000                00000000      
            0x01, 0xFC, 0x00, 0x07, 0xF8, 0x00, ##         0000000               00000000       
            0x01, 0xFE, 0x00, 0x07, 0xF8, 0x00, ##         00000000              00000000       
            0x00, 0xFF, 0x80, 0x1F, 0xF0, 0x00, ##          000000000          000000000        
            0x00, 0x7F, 0xE0, 0x7F, 0xE0, 0x00, ##           0000000000      0000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000           
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##              00000000000000000000            
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000              
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 32, 
        'xoffset'  => 11, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xF8, 0x00, ##                0000000           
            0x00, 0x07, 0xF8, 0x00, ##               00000000           
            0x00, 0x1F, 0xF8, 0x00, ##             0000000000           
            0x00, 0x3F, 0xF8, 0x00, ##            00000000000           
            0x00, 0xFF, 0xF8, 0x00, ##          0000000000000           
            0x01, 0xFF, 0xF8, 0x00, ##         00000000000000           
            0x07, 0xFF, 0xF8, 0x00, ##       0000000000000000           
            0x0F, 0xFF, 0xF8, 0x00, ##      00000000000000000           
            0x3F, 0xCF, 0xF8, 0x00, ##    00000000  000000000           
            0x7F, 0x8F, 0xF8, 0x00, ##   00000000   000000000           
            0xFE, 0x0F, 0xF8, 0x00, ##  0000000     000000000           
            0xFC, 0x0F, 0xF8, 0x00, ##  000000      000000000           
            0xF0, 0x0F, 0xF8, 0x00, ##  0000        000000000           
            0xE0, 0x0F, 0xF8, 0x00, ##  000         000000000           
            0x80, 0x0F, 0xF8, 0x00, ##  0           000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x00, 0x0F, 0xF8, 0x00, ##              000000000           
            0x7F, 0xFF, 0xFF, 0xFF, ##   0000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, ##   0000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, ##   0000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, ##   0000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 41, 
        'xoffset'  => 6, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, ##               00000000000                 
            0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, ##           0000000000000000000             
            0x03, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##        0000000000000000000000000          
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##     00000000000000000000000000000         
            0x7F, 0xFC, 0x03, 0xFF, 0xC0, 0x00, ##   0000000000000        000000000000       
            0xFF, 0xE0, 0x00, 0x7F, 0xE0, 0x00, ##  00000000000              0000000000      
            0xFF, 0xC0, 0x00, 0x3F, 0xF0, 0x00, ##  0000000000                0000000000     
            0xFF, 0x80, 0x00, 0x0F, 0xF8, 0x00, ##  000000000                   000000000    
            0xFF, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  00000000                    000000000    
            0xFE, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  0000000                      000000000   
            0xFE, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  0000000                       000000000  
            0xFC, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  000000                        000000000  
            0xFC, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  000000                        000000000  
            0xFC, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000                         000000000 
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000  
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000  
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000  
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000   
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000   
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000    
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000    
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##                              00000000     
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##                              0000000      
            0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##                             00000000      
            0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, ##                            00000000       
            0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, ##                            0000000        
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, ##                           0000000         
            0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                          00000000         
            0x00, 0x00, 0x01, 0xFE, 0x00, 0x00, ##                         00000000          
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x00, ##                        00000000           
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, ##                        0000000            
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, ##                       0000000             
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000              
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000               
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                 
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                  0000000                  
            0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, ##                 0000000                   
            0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##                0000000                    
            0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##               0000000                     
            0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##              0000000                      
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##             0000000                       
            0x00, 0x3F, 0x80, 0x00, 0x0F, 0x80, ##            0000000                   00000
            0x00, 0x7F, 0x00, 0x00, 0x0F, 0x80, ##           0000000                    00000
            0x00, 0xFE, 0x00, 0x00, 0x0F, 0x80, ##          0000000                     00000
            0x01, 0xFC, 0x00, 0x00, 0x0F, 0x80, ##         0000000                      00000
            0x03, 0xF8, 0x00, 0x00, 0x0F, 0x80, ##        0000000                       00000
            0x07, 0xF0, 0x00, 0x00, 0x0F, 0x80, ##       0000000                        00000
            0x0F, 0xE0, 0x00, 0x00, 0x0F, 0x80, ##      0000000                         00000
            0x1F, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##     0000000                          00000
            0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##    000000000000000000000000000000000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##   0000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 42, 
        'xoffset'  => 7, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, ##                000000000000                
            0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x00, ##           000000000000000000000            
            0x07, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##       000000000000000000000000000          
            0x3F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##    00000000000000000000000000000000        
            0x3F, 0xFE, 0x01, 0xFF, 0xE0, 0x00, ##    0000000000000        000000000000       
            0x3F, 0xF0, 0x00, 0x3F, 0xF0, 0x00, ##    0000000000              0000000000      
            0x3F, 0xE0, 0x00, 0x1F, 0xF8, 0x00, ##    000000000                0000000000     
            0x3F, 0xC0, 0x00, 0x0F, 0xFC, 0x00, ##    00000000                  0000000000    
            0x3F, 0x80, 0x00, 0x07, 0xFE, 0x00, ##    0000000                    0000000000   
            0x3F, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000                      000000000   
            0x3F, 0x00, 0x00, 0x03, 0xFE, 0x00, ##    000000                      000000000   
            0x3E, 0x00, 0x00, 0x03, 0xFF, 0x00, ##    00000                       0000000000  
            0x3E, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    00000                        000000000  
            0x3E, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    00000                        000000000  
            0x3E, 0x00, 0x00, 0x01, 0xFF, 0x00, ##    00000                        000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000  
            0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##                                 00000000   
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000   
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000   
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000    
            0x00, 0x00, 0x00, 0x07, 0xF8, 0x00, ##                               00000000     
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##                              00000000      
            0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##                            000000000       
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##                           000000000        
            0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, ##                        0000000000          
            0x00, 0x03, 0xFF, 0xFC, 0x00, 0x00, ##                0000000000000000            
            0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                0000000000000               
            0x00, 0x03, 0xFF, 0xF8, 0x00, 0x00, ##                000000000000000             
            0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, ##                000000000000000000          
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##                         00000000000        
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000      
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##                             0000000000     
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##                               000000000    
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000   
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000   
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000  
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##                                  00000000  
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##                                   000000000
            0xF8, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  00000                            000000000
            0xF8, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  00000                            000000000
            0xF8, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##  00000                            000000000
            0xF8, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000                           000000000 
            0xF8, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000                           000000000 
            0xFC, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  000000                          000000000 
            0xFC, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  000000                         000000000  
            0xFE, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  0000000                        000000000  
            0xFE, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  0000000                       000000000   
            0xFF, 0x00, 0x00, 0x07, 0xFE, 0x00, ##  00000000                     0000000000   
            0xFF, 0xC0, 0x00, 0x0F, 0xFC, 0x00, ##  0000000000                  0000000000    
            0xFF, 0xE0, 0x00, 0x3F, 0xF8, 0x00, ##  00000000000               00000000000     
            0xFF, 0xFC, 0x01, 0xFF, 0xF0, 0x00, ##  00000000000000         0000000000000      
            0x7F, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##   000000000000000000000000000000000        
            0x0F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##      0000000000000000000000000000          
            0x01, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##         00000000000000000000000            
            0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, ##              00000000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000            
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##                            0000000000            
            0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##                           00000000000            
            0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##                          000000000000            
            0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##                          000000000000            
            0x00, 0x00, 0x01, 0xFF, 0xF0, 0x00, ##                         0000000000000            
            0x00, 0x00, 0x03, 0xFF, 0xF0, 0x00, ##                        00000000000000            
            0x00, 0x00, 0x03, 0xFF, 0xF0, 0x00, ##                        00000000000000            
            0x00, 0x00, 0x07, 0xFF, 0xF0, 0x00, ##                       000000000000000            
            0x00, 0x00, 0x07, 0xDF, 0xF0, 0x00, ##                       00000 000000000            
            0x00, 0x00, 0x0F, 0xDF, 0xF0, 0x00, ##                      000000 000000000            
            0x00, 0x00, 0x1F, 0x9F, 0xF0, 0x00, ##                     000000  000000000            
            0x00, 0x00, 0x1F, 0x9F, 0xF0, 0x00, ##                     000000  000000000            
            0x00, 0x00, 0x3F, 0x1F, 0xF0, 0x00, ##                    000000   000000000            
            0x00, 0x00, 0x3E, 0x1F, 0xF0, 0x00, ##                    00000    000000000            
            0x00, 0x00, 0x7E, 0x1F, 0xF0, 0x00, ##                   000000    000000000            
            0x00, 0x00, 0xFC, 0x1F, 0xF0, 0x00, ##                  000000     000000000            
            0x00, 0x00, 0xFC, 0x1F, 0xF0, 0x00, ##                  000000     000000000            
            0x00, 0x01, 0xF8, 0x1F, 0xF0, 0x00, ##                 000000      000000000            
            0x00, 0x03, 0xF0, 0x1F, 0xF0, 0x00, ##                000000       000000000            
            0x00, 0x03, 0xF0, 0x1F, 0xF0, 0x00, ##                000000       000000000            
            0x00, 0x07, 0xE0, 0x1F, 0xF0, 0x00, ##               000000        000000000            
            0x00, 0x07, 0xC0, 0x1F, 0xF0, 0x00, ##               00000         000000000            
            0x00, 0x0F, 0xC0, 0x1F, 0xF0, 0x00, ##              000000         000000000            
            0x00, 0x1F, 0x80, 0x1F, 0xF0, 0x00, ##             000000          000000000            
            0x00, 0x1F, 0x80, 0x1F, 0xF0, 0x00, ##             000000          000000000            
            0x00, 0x3F, 0x00, 0x1F, 0xF0, 0x00, ##            000000           000000000            
            0x00, 0x7E, 0x00, 0x1F, 0xF0, 0x00, ##           000000            000000000            
            0x00, 0x7E, 0x00, 0x1F, 0xF0, 0x00, ##           000000            000000000            
            0x00, 0xFC, 0x00, 0x1F, 0xF0, 0x00, ##          000000             000000000            
            0x00, 0xFC, 0x00, 0x1F, 0xF0, 0x00, ##          000000             000000000            
            0x01, 0xF8, 0x00, 0x1F, 0xF0, 0x00, ##         000000              000000000            
            0x03, 0xF0, 0x00, 0x1F, 0xF0, 0x00, ##        000000               000000000            
            0x03, 0xF0, 0x00, 0x1F, 0xF0, 0x00, ##        000000               000000000            
            0x07, 0xE0, 0x00, 0x1F, 0xF0, 0x00, ##       000000                000000000            
            0x07, 0xC0, 0x00, 0x1F, 0xF0, 0x00, ##       00000                 000000000            
            0x0F, 0xC0, 0x00, 0x1F, 0xF0, 0x00, ##      000000                 000000000            
            0x1F, 0x80, 0x00, 0x1F, 0xF0, 0x00, ##     000000                  000000000            
            0x1F, 0x80, 0x00, 0x1F, 0xF0, 0x00, ##     000000                  000000000            
            0x3F, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##    000000                   000000000            
            0x7E, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##   000000                    000000000            
            0x7E, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##   000000                    000000000            
            0xFC, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##  000000                     000000000            
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##                             000000000            
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, ##                   00000000000000000000000000000  
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, ##                   00000000000000000000000000000  
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, ##                   00000000000000000000000000000  
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, ##                   00000000000000000000000000000  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 41, 
        'xoffset'  => 7, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##     000000000000000000000000000000000     
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000                                 
            0x1F, 0x03, 0xFF, 0x80, 0x00, 0x00, ##     00000      00000000000                
            0x1F, 0x1F, 0xFF, 0xF8, 0x00, 0x00, ##     00000   000000000000000000            
            0x1F, 0x7F, 0xFF, 0xFE, 0x00, 0x00, ##     00000 0000000000000000000000          
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##     00000000000000000000000000000         
            0x1F, 0xFC, 0x03, 0xFF, 0xC0, 0x00, ##     00000000000        000000000000       
            0x1F, 0xF0, 0x00, 0x7F, 0xE0, 0x00, ##     000000000             0000000000      
            0x1F, 0xC0, 0x00, 0x3F, 0xF0, 0x00, ##     0000000                0000000000     
            0x1F, 0x80, 0x00, 0x0F, 0xF8, 0x00, ##     000000                   000000000    
            0x1F, 0x00, 0x00, 0x07, 0xF8, 0x00, ##     00000                     00000000    
            0x1E, 0x00, 0x00, 0x07, 0xFC, 0x00, ##     0000                      000000000   
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000  
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##                                000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##                                 000000000 
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##                                  000000000
            0xF8, 0x00, 0x00, 0x00, 0xFF, 0x80, ##  00000                           000000000
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0xF8, 0x00, 0x00, 0x01, 0xFF, 0x00, ##  00000                          000000000 
            0xFC, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  000000                        000000000  
            0xFC, 0x00, 0x00, 0x03, 0xFE, 0x00, ##  000000                        000000000  
            0xFE, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  0000000                      000000000   
            0xFE, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##  0000000                     000000000    
            0xFF, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##  00000000                   0000000000    
            0xFF, 0x80, 0x00, 0x3F, 0xF0, 0x00, ##  000000000                 0000000000     
            0xFF, 0xE0, 0x00, 0x7F, 0xE0, 0x00, ##  00000000000              0000000000      
            0xFF, 0xFC, 0x03, 0xFF, 0xC0, 0x00, ##  00000000000000        000000000000       
            0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##   0000000000000000000000000000000         
            0x0F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##      00000000000000000000000000           
            0x01, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##         000000000000000000000             
            0x00, 0x0F, 0xFF, 0x00, 0x00, 0x00, ##              000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 44, 
        'xoffset'  => 6, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, ##                       00000000000            
            0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, ##                   00000000000000000000       
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0x80, ##                 00000000000000000000000000   
            0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x80, ##               0000000000000000000000000000   
            0x00, 0x1F, 0xF8, 0x07, 0xFF, 0x80, ##             0000000000        000000000000   
            0x00, 0x3F, 0xC0, 0x01, 0xFF, 0x80, ##            00000000             0000000000   
            0x00, 0x7F, 0x00, 0x00, 0x7F, 0x80, ##           0000000                 00000000   
            0x00, 0xFE, 0x00, 0x00, 0x3F, 0x80, ##          0000000                   0000000   
            0x01, 0xFC, 0x00, 0x00, 0x3F, 0x80, ##         0000000                    0000000   
            0x01, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##         000000                      000000   
            0x03, 0xF8, 0x00, 0x00, 0x1F, 0x80, ##        0000000                      000000   
            0x07, 0xF0, 0x00, 0x00, 0x0F, 0x80, ##       0000000                        00000   
            0x07, 0xE0, 0x00, 0x00, 0x0F, 0x80, ##       000000                         00000   
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##      0000000                                 
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##      0000000                                 
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##     0000000                                  
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##     0000000                                  
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##     0000000                                  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##    00000000                                  
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, ##    0000000                                   
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x00, ##    0000000                                   
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                   
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                   
            0x7F, 0x80, 0x1F, 0xF8, 0x00, 0x00, ##   00000000          0000000000               
            0x7F, 0x81, 0xFF, 0xFF, 0x00, 0x00, ##   00000000      00000000000000000            
            0x7F, 0x87, 0xFF, 0xFF, 0xC0, 0x00, ##   00000000    000000000000000000000          
            0xFF, 0x8F, 0xFF, 0xFF, 0xF0, 0x00, ##  000000000   000000000000000000000000        
            0xFF, 0xBF, 0xE0, 0x3F, 0xF8, 0x00, ##  000000000 000000000       00000000000       
            0xFF, 0xFF, 0x00, 0x0F, 0xFC, 0x00, ##  0000000000000000            0000000000      
            0xFF, 0xFE, 0x00, 0x03, 0xFE, 0x00, ##  000000000000000               000000000     
            0xFF, 0xFC, 0x00, 0x01, 0xFF, 0x00, ##  00000000000000                 000000000    
            0xFF, 0xF8, 0x00, 0x00, 0xFF, 0x80, ##  0000000000000                   000000000   
            0xFF, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##  000000000000                    000000000   
            0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xC0, ##  000000000000                     000000000  
            0xFF, 0xF0, 0x00, 0x00, 0x7F, 0xC0, ##  000000000000                     000000000  
            0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##  00000000000                       000000000 
            0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##  00000000000                       000000000 
            0xFF, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##  00000000000                       000000000 
            0xFF, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##  0000000000                        000000000 
            0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##  0000000000                         000000000
            0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##  0000000000                         000000000
            0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##  0000000000                         000000000
            0xFF, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##  0000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x7F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                         000000000
            0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                         000000000
            0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##    000000000                       000000000 
            0x3F, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##    000000000                       000000000 
            0x1F, 0xE0, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                       000000000 
            0x1F, 0xE0, 0x00, 0x00, 0x3F, 0xC0, ##     00000000                       00000000  
            0x0F, 0xF0, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                     000000000  
            0x0F, 0xF0, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                     000000000  
            0x07, 0xF8, 0x00, 0x00, 0xFF, 0x80, ##       00000000                   000000000   
            0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, ##       00000000                   00000000    
            0x03, 0xFC, 0x00, 0x01, 0xFF, 0x00, ##        00000000                 000000000    
            0x01, 0xFE, 0x00, 0x03, 0xFE, 0x00, ##         00000000               000000000     
            0x00, 0xFF, 0x80, 0x0F, 0xFC, 0x00, ##          000000000           0000000000      
            0x00, 0x7F, 0xE0, 0x3F, 0xF8, 0x00, ##           0000000000       00000000000       
            0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##            0000000000000000000000000         
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000          
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000             
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 42, 
        'xoffset'  => 7, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##  00000000000000000000000000000000000000000 
            0xF8, 0x00, 0x00, 0x00, 0x3F, 0x80, ##  00000                             0000000 
            0xF8, 0x00, 0x00, 0x00, 0x3F, 0x00, ##  00000                             000000  
            0xF8, 0x00, 0x00, 0x00, 0x7F, 0x00, ##  00000                            0000000  
            0xF8, 0x00, 0x00, 0x00, 0x7E, 0x00, ##  00000                            000000   
            0xF8, 0x00, 0x00, 0x00, 0x7E, 0x00, ##  00000                            000000   
            0xF8, 0x00, 0x00, 0x00, 0xFE, 0x00, ##  00000                           0000000   
            0xF8, 0x00, 0x00, 0x00, 0xFC, 0x00, ##  00000                           000000    
            0xF8, 0x00, 0x00, 0x01, 0xFC, 0x00, ##  00000                          0000000    
            0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, ##                                 000000     
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##                                0000000     
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##                                0000000     
            0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                                000000      
            0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, ##                               0000000      
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##                               000000       
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##                              0000000       
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##                              000000        
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##                              000000        
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, ##                             0000000        
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##                             000000         
            0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, ##                            0000000         
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##                            000000          
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, ##                           0000000          
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                           000000           
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                           000000           
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, ##                          0000000           
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##                          000000            
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, ##                         0000000            
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000             
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                         000000             
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, ##                        0000000             
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##                        000000              
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, ##                       0000000              
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                       000000               
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                      0000000               
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                      000000                
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##                     0000000                
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                     000000                 
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##                    0000000                 
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##                    000000                  
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##                    000000                  
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                   0000000                  
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##                   000000                   
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                  0000000                   
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                  000000                    
            0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, ##                 0000000                    
            0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                 000000                     
            0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                 000000                     
            0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##                0000000                     
            0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                000000                      
            0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##               0000000                      
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                       
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##               000000                       
            0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##              0000000                       
            0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##              000000                        
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##             0000000                        
            0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, ##             000000                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 44, 
        'xoffset'  => 6, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##            000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xE0, 0x00, ##           00000000000000000000000000         
            0x01, 0xFF, 0xC0, 0x3F, 0xF8, 0x00, ##         00000000000        00000000000       
            0x03, 0xFF, 0x00, 0x0F, 0xFC, 0x00, ##        0000000000            0000000000      
            0x07, 0xFE, 0x00, 0x07, 0xFE, 0x00, ##       0000000000              0000000000     
            0x0F, 0xFC, 0x00, 0x03, 0xFE, 0x00, ##      0000000000                000000000     
            0x0F, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##      000000000                  000000000    
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##      000000000                  000000000    
            0x07, 0xFC, 0x00, 0x03, 0xFE, 0x00, ##       000000000                000000000     
            0x03, 0xFE, 0x00, 0x07, 0xFC, 0x00, ##        000000000              000000000      
            0x01, 0xFF, 0x00, 0x0F, 0xF8, 0x00, ##         000000000            000000000       
            0x00, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##          0000000000        0000000000        
            0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##            000000000000000000000000          
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x07, 0xFF, 0xFF, 0x00, 0x00, ##               0000000000000000000            
            0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##            0000000000000000000000000         
            0x00, 0xFF, 0xC0, 0x3F, 0xF8, 0x00, ##          0000000000        00000000000       
            0x03, 0xFE, 0x00, 0x07, 0xFC, 0x00, ##        000000000              000000000      
            0x07, 0xFC, 0x00, 0x03, 0xFE, 0x00, ##       000000000                000000000     
            0x0F, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##      000000000                  000000000    
            0x1F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##     000000000                    000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xE0, 0x00, 0x00, 0x7F, 0xE0, ##   0000000000                      0000000000 
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xF0, 0x00, 0x00, 0xFF, 0x80, ##    0000000000                    000000000   
            0x1F, 0xF8, 0x00, 0x01, 0xFF, 0x80, ##     0000000000                  0000000000   
            0x0F, 0xFC, 0x00, 0x03, 0xFF, 0x00, ##      0000000000                0000000000    
            0x07, 0xFE, 0x00, 0x07, 0xFE, 0x00, ##       0000000000              0000000000     
            0x03, 0xFF, 0xC0, 0x3F, 0xFC, 0x00, ##        000000000000        000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##         000000000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFF, 0xE0, 0x00, ##           00000000000000000000000000         
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##              00000000000000000000            
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 44, 
        'xoffset'  => 5, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                  00000000000                 
            0x00, 0x07, 0xFF, 0xFC, 0x00, 0x00, ##               00000000000000000              
            0x00, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##             000000000000000000000            
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000          
            0x01, 0xFF, 0xC0, 0x7F, 0xE0, 0x00, ##         00000000000       0000000000         
            0x03, 0xFE, 0x00, 0x1F, 0xF0, 0x00, ##        000000000            000000000        
            0x07, 0xFC, 0x00, 0x07, 0xF8, 0x00, ##       000000000               00000000       
            0x0F, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##      000000000                 00000000      
            0x0F, 0xF0, 0x00, 0x03, 0xFE, 0x00, ##      00000000                  000000000     
            0x1F, 0xF0, 0x00, 0x01, 0xFE, 0x00, ##     000000000                   00000000     
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##    000000000                     00000000    
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##    000000000                     00000000    
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, ##    00000000                      000000000   
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, ##   000000000                       00000000   
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                       000000000  
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##   00000000                        000000000  
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000  
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##  000000000                        000000000  
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF0, ##  000000000                         0000000000
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF0, ##  000000000                         0000000000
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF0, ##  000000000                         0000000000
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0xF0, ##  000000000                        00000000000
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0xF0, ##   00000000                        00000000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0xF0, ##   000000000                       00000000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0xF0, ##   000000000                       00000000000
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0xF0, ##   000000000                       00000000000
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0xF0, ##    000000000                     000000000000
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0xF0, ##    000000000                     000000000000
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0xF0, ##     000000000                   0000000000000
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0xF0, ##     000000000                   0000000000000
            0x0F, 0xF8, 0x00, 0x03, 0xFF, 0xF0, ##      000000000                 00000000000000
            0x07, 0xFC, 0x00, 0x07, 0xFF, 0xF0, ##       000000000               000000000000000
            0x03, 0xFE, 0x00, 0x1F, 0xDF, 0xF0, ##        000000000            0000000 000000000
            0x01, 0xFF, 0xC0, 0x7F, 0x9F, 0xF0, ##         00000000000       00000000  000000000
            0x00, 0xFF, 0xFF, 0xFF, 0x1F, 0xE0, ##          000000000000000000000000   00000000 
            0x00, 0x3F, 0xFF, 0xFC, 0x1F, 0xE0, ##            00000000000000000000     00000000 
            0x00, 0x0F, 0xFF, 0xF0, 0x1F, 0xE0, ##              0000000000000000       00000000 
            0x00, 0x01, 0xFF, 0x80, 0x1F, 0xE0, ##                 0000000000          00000000 
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##                                     00000000 
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, ##                                     00000000 
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##                                    00000000  
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##                                    00000000  
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, ##                                    00000000  
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, ##                                    0000000   
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, ##                                    0000000   
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, ##                                   00000000   
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, ##                                   0000000    
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, ##                                   0000000    
            0x1F, 0x00, 0x00, 0x00, 0xFE, 0x00, ##     00000                        0000000     
            0x1F, 0x00, 0x00, 0x00, 0xFE, 0x00, ##     00000                        0000000     
            0x1F, 0x80, 0x00, 0x01, 0xFC, 0x00, ##     000000                      0000000      
            0x1F, 0x80, 0x00, 0x03, 0xF8, 0x00, ##     000000                     0000000       
            0x1F, 0x80, 0x00, 0x03, 0xF8, 0x00, ##     000000                     0000000       
            0x1F, 0xC0, 0x00, 0x07, 0xF0, 0x00, ##     0000000                   0000000        
            0x1F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, ##     00000000                00000000         
            0x1F, 0xF0, 0x00, 0x3F, 0xC0, 0x00, ##     000000000              00000000          
            0x1F, 0xFE, 0x01, 0xFF, 0x80, 0x00, ##     000000000000        0000000000           
            0x1F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##     0000000000000000000000000000             
            0x1F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##     00000000000000000000000000               
            0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##         00000000000000000000                 
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, ##              00000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 11, 
        'xoffset'  => 9, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 17, 
        'xoffset'  => 3, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x7C, 0x00, ##           00000   
            0x00, 0xFE, 0x00, ##          0000000  
            0x01, 0xFF, 0x00, ##         000000000 
            0x03, 0xFF, 0x80, ##        00000000000
            0x03, 0xFF, 0x80, ##        00000000000
            0x03, 0xFF, 0x80, ##        00000000000
            0x03, 0xFF, 0x80, ##        00000000000
            0x03, 0xFF, 0x80, ##        00000000000
            0x01, 0xFF, 0x00, ##         000000000 
            0x00, 0xFE, 0x00, ##          0000000  
            0x00, 0x7C, 0x00, ##           00000   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0x00, 0x00, ##                   
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0xFF, 0x00, ##          00000000 
            0x00, 0xFE, 0x00, ##          0000000  
            0x00, 0xFE, 0x00, ##          0000000  
            0x01, 0xFE, 0x00, ##         00000000  
            0x01, 0xFE, 0x00, ##         00000000  
            0x01, 0xFC, 0x00, ##         0000000   
            0x03, 0xFC, 0x00, ##        00000000   
            0x03, 0xF8, 0x00, ##        0000000    
            0x07, 0xF8, 0x00, ##       00000000    
            0x07, 0xF0, 0x00, ##       0000000     
            0x0F, 0xF0, 0x00, ##      00000000     
            0x1F, 0xE0, 0x00, ##     00000000      
            0x3F, 0xC0, 0x00, ##    00000000       
            0x7F, 0x80, 0x00, ##   00000000        
            0xFF, 0x00, 0x00, ##  00000000         
            0x7E, 0x00, 0x00, ##   000000          
            0x38, 0x00, 0x00, ##    000            
            0x10, 0x00, 0x00, ##     0             
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 55, 
        'xoffset'  => 9, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, ##                                                       00
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, ##                                                    00000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFE, ##                                                 00000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFE, ##                                              00000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE, ##                                            0000000000000
            0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, ##                                         0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFE, ##                                      0000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF8, ##                                   00000000000000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, ##                                 00000000000000000000    
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##                              00000000000000000000       
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, ##                           00000000000000000000          
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, ##                         00000000000000000000            
            0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##                      00000000000000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, ##                   00000000000000000000                  
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                00000000000000000000                     
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##              00000000000000000000                       
            0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##           00000000000000000000                          
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        00000000000000000000                             
            0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##      00000000000000000000                               
            0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##   00000000000000000000                                  
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  000000000000000000                                     
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000                                       
            0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000                                          
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000000000                                            
            0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000                                          
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000                                       
            0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000000                                    
            0x3F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##    0000000000000000000                                  
            0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##      00000000000000000000                               
            0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##         00000000000000000000                            
            0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##            00000000000000000000                         
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##              00000000000000000000                       
            0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##                 00000000000000000000                    
            0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, ##                    00000000000000000000                 
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, ##                       00000000000000000000              
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, ##                         00000000000000000000            
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, ##                            00000000000000000000         
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, ##                               00000000000000000000      
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, ##                                 00000000000000000000    
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, ##                                    00000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFE, ##                                       000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFE, ##                                          000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE, ##                                            0000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFE, ##                                               0000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, ##                                                  0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, ##                                                     0000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, ##                                                       00
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 54, 
        'xoffset'  => 9, 
        'xadvance' => 72, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 55, 
        'xoffset'  => 9, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00                                                     
            0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  00000                                                  
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                                
            0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000                                             
            0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000                                          
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000000000000                                       
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  000000000000000000                                     
            0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##   00000000000000000000                                  
            0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, ##      00000000000000000000                               
            0x01, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##         0000000000000000000                             
            0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##           00000000000000000000                          
            0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##              00000000000000000000                       
            0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##                 00000000000000000000                    
            0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, ##                   00000000000000000000                  
            0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, 0x00, ##                      00000000000000000000               
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, 0x00, ##                         00000000000000000000            
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFC, 0x00, ##                           000000000000000000000         
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##                              00000000000000000000       
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, ##                                 00000000000000000000    
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, ##                                    00000000000000000000 
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFE, ##                                      0000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFE, ##                                         0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFE, ##                                            0000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFE, ##                                              00000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xFE, ##                                           00000000000000
            0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFE, ##                                        00000000000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFE, ##                                      0000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF8, ##                                   00000000000000000000  
            0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xC0, ##                                00000000000000000000     
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##                              00000000000000000000       
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, ##                           00000000000000000000          
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##                        00000000000000000000             
            0x00, 0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##                     00000000000000000000                
            0x00, 0x00, 0x7F, 0xFF, 0xF8, 0x00, 0x00, ##                   00000000000000000000                  
            0x00, 0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                00000000000000000000                     
            0x00, 0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##             00000000000000000000                        
            0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##           0000000000000000000                           
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##        00000000000000000000                             
            0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##     00000000000000000000                                
            0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000                                   
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  000000000000000000                                     
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                        
            0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000                                           
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                              
            0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000000                                                
            0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0000                                                   
            0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  0                                                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 36, 
        'xoffset'  => 6, 
        'xadvance' => 46, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xF8, 0x00, 0x00, ##            00000000000               
            0x03, 0xFF, 0xFF, 0x80, 0x00, ##        0000000000000000000           
            0x1F, 0xFF, 0xFF, 0xE0, 0x00, ##     000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  00000000000000000000000000000       
            0xFF, 0xF0, 0x1F, 0xFC, 0x00, ##  000000000000       00000000000      
            0xFF, 0x80, 0x03, 0xFF, 0x00, ##  000000000             0000000000    
            0xFF, 0x00, 0x01, 0xFF, 0x00, ##  00000000               000000000    
            0xFE, 0x00, 0x00, 0xFF, 0x80, ##  0000000                 000000000   
            0xFC, 0x00, 0x00, 0x7F, 0xC0, ##  000000                   000000000  
            0xFC, 0x00, 0x00, 0x7F, 0xC0, ##  000000                   000000000  
            0xF8, 0x00, 0x00, 0x3F, 0xE0, ##  00000                     000000000 
            0xF8, 0x00, 0x00, 0x3F, 0xE0, ##  00000                     000000000 
            0xF0, 0x00, 0x00, 0x3F, 0xE0, ##  0000                      000000000 
            0xF0, 0x00, 0x00, 0x1F, 0xF0, ##  0000                       000000000
            0xF0, 0x00, 0x00, 0x1F, 0xF0, ##  0000                       000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x1F, 0xF0, ##                             000000000
            0x00, 0x00, 0x00, 0x3F, 0xF0, ##                            0000000000
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000 
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000 
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000 
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000  
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000  
            0x00, 0x00, 0x01, 0xFF, 0x80, ##                         0000000000   
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x07, 0xFF, 0x00, ##                       00000000000    
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x1F, 0xFC, 0x00, ##                     00000000000      
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000        
            0x00, 0x03, 0xFF, 0xE0, 0x00, ##                0000000000000         
            0x00, 0x0F, 0xFF, 0x80, 0x00, ##              0000000000000           
            0x00, 0x0F, 0xFE, 0x00, 0x00, ##              00000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000                
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                      
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x1F, 0xC0, 0x00, 0x00, ##             0000000                  
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                 
            0x00, 0x7F, 0xF0, 0x00, 0x00, ##           00000000000                
            0x00, 0x7F, 0xF0, 0x00, 0x00, ##           00000000000                
            0x00, 0x7F, 0xF0, 0x00, 0x00, ##           00000000000                
            0x00, 0x7F, 0xF0, 0x00, 0x00, ##           00000000000                
            0x00, 0x7F, 0xF0, 0x00, 0x00, ##           00000000000                
            0x00, 0x3F, 0xE0, 0x00, 0x00, ##            000000000                 
            0x00, 0x1F, 0xC0, 0x00, 0x00, ##             0000000                  
            0x00, 0x0F, 0x80, 0x00, 0x00, ##              00000                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 75, 
        'xoffset'  => 6, 
        'xadvance' => 87, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                                   0000000000000                             
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                              0000000000000000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                           0000000000000000000000000000                      
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                        0000000000000000000000000000000000                   
            0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x03, 0xFF, 0xC0, 0x00, 0x00, ##                      00000000000000            000000000000                 
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                     00000000000                    000000000                
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##                   0000000000                          00000000              
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, ##                 0000000000                              0000000             
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##                000000000                                  000000            
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, ##               00000000                                     0000000          
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##              00000000                                        000000         
            0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##             00000000                                          000000        
            0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##            0000000                                             00000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF0, 0x00, ##           0000000                                               00000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, ##          0000000                                                 00000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, ##         00000000                                                  00000     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3C, 0x00, ##         0000000                                                    0000     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, ##        0000000                                                     00000    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, ##       0000000                                                       0000    
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0x00, ##       0000000                    00000000                            0000   
            0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x7F, 0x00, 0x0F, 0x00, ##      0000000                   0000000000000      0000000            0000   
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF8, 0x7F, 0x00, 0x07, 0x80, ##      0000000                 00000000000000000    0000000             0000  
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x7F, 0x00, 0x07, 0x80, ##     0000000                00000000000000000000   0000000             0000  
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x7F, 0x00, 0x07, 0xC0, ##     0000000               0000000000000000000000  0000000             00000 
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x3F, 0x7F, 0x00, 0x03, 0xC0, ##    0000000               00000000000       000000 0000000              0000 
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x0F, 0xFF, 0x00, 0x03, 0xC0, ##    0000000               000000000           000000000000              0000 
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x07, 0xFF, 0x00, 0x03, 0xC0, ##    0000000              000000000             00000000000              0000 
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x03, 0xFF, 0x00, 0x03, 0xC0, ##   0000000              000000000               0000000000              0000 
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x01, 0xFF, 0x00, 0x01, 0xE0, ##   0000000              00000000                 000000000               0000
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x01, 0xFF, 0x00, 0x01, 0xE0, ##   0000000              00000000                 000000000               0000
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, 0x01, 0xE0, ##   0000000             00000000                   00000000               0000
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, 0x01, 0xE0, ##   0000000             00000000                   00000000               0000
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000              00000000                    0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000             00000000                     0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000             00000000                     0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000             00000000                     0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000             00000000                     0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x01, 0xE0, ##  0000000             00000000                     0000000               0000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x03, 0xE0, ##  0000000             00000000                     0000000              00000
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000000             00000000                     0000000              0000 
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000000             00000000                     0000000              0000 
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x03, 0xC0, ##  0000000             00000000                     0000000              0000 
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x07, 0xC0, ##  0000000             00000000                     0000000             00000 
            0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0x00, 0x07, 0x80, ##  0000000             00000000                     0000000             0000  
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x7F, 0x00, 0x0F, 0x80, ##  0000000              00000000                    0000000            00000  
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, 0x0F, 0x00, ##   0000000             00000000                   00000000            0000   
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0xFF, 0x00, 0x1F, 0x00, ##   0000000             00000000                   00000000           00000   
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x01, 0xFF, 0x00, 0x3E, 0x00, ##   0000000              00000000                 000000000          00000    
            0x00, 0x00, 0x03, 0xFC, 0x00, 0x01, 0xFF, 0x00, 0x7E, 0x00, ##   0000000              00000000                 000000000         000000    
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x03, 0xFF, 0x00, 0xFC, 0x00, ##   0000000              000000000               0000000000        000000     
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x07, 0xFF, 0x01, 0xF8, 0x00, ##    0000000              000000000             00000000000       000000      
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x0F, 0xFF, 0x07, 0xF0, 0x00, ##    0000000               000000000           000000000000     0000000       
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x3F, 0x7F, 0x1F, 0xE0, 0x00, ##    0000000               00000000000       000000 0000000   00000000        
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, 0x00, ##     0000000               0000000000000000000000  0000000000000000          
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x7F, 0xFF, 0x00, 0x00, ##     0000000                00000000000000000000   000000000000000           
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF8, 0x7F, 0xFC, 0x00, 0x00, ##      0000000                 00000000000000000    0000000000000             
            0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x7F, 0xE0, 0x00, 0x00, ##      0000000                  00000000000000      0000000000                
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x7E, 0x00, 0x00, 0x00, ##       0000000                    00000000         000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##       0000000                                                               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##        0000000                                                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##        00000000                                                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000                                                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##           0000000                                                           
            0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##            0000000                                                          
            0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##             0000000                                                         
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, ##              00000000                                       0               
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, ##               00000000                                     00               
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, ##                000000000                                 00000              
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##                 0000000000                              000000              
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, ##                   0000000000                          0000000               
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                    000000000000                    000000000                
            0x00, 0x00, 0x0F, 0xFF, 0xC0, 0x03, 0xFF, 0x80, 0x00, 0x00, ##                      00000000000000            00000000000                  
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##                        000000000000000000000000000000000                    
            0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                          00000000000000000000000000000                      
            0x00, 0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                             00000000000000000000000                         
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                                  0000000000000                              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 64, 
        'xoffset'  => 0, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##                              0000000                             
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##                              00000000                            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##                             000000000                            
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##                             000000000                            
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##                             0000000000                           
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                           
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                           
            0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, ##                            000000000000                          
            0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, ##                           0000000000000                          
            0x00, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, ##                           00000000000000                         
            0x00, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##                          000000000000000                         
            0x00, 0x00, 0x00, 0xFB, 0xFE, 0x00, 0x00, 0x00, ##                          00000 000000000                         
            0x00, 0x00, 0x00, 0xFB, 0xFF, 0x00, 0x00, 0x00, ##                          00000 0000000000                        
            0x00, 0x00, 0x01, 0xFB, 0xFF, 0x00, 0x00, 0x00, ##                         000000 0000000000                        
            0x00, 0x00, 0x01, 0xF1, 0xFF, 0x00, 0x00, 0x00, ##                         00000   000000000                        
            0x00, 0x00, 0x01, 0xF1, 0xFF, 0x80, 0x00, 0x00, ##                         00000   0000000000                       
            0x00, 0x00, 0x03, 0xF0, 0xFF, 0x80, 0x00, 0x00, ##                        000000    000000000                       
            0x00, 0x00, 0x03, 0xE0, 0xFF, 0xC0, 0x00, 0x00, ##                        00000     0000000000                      
            0x00, 0x00, 0x07, 0xE0, 0xFF, 0xC0, 0x00, 0x00, ##                       000000     0000000000                      
            0x00, 0x00, 0x07, 0xC0, 0x7F, 0xC0, 0x00, 0x00, ##                       00000       000000000                      
            0x00, 0x00, 0x07, 0xC0, 0x7F, 0xE0, 0x00, 0x00, ##                       00000       0000000000                     
            0x00, 0x00, 0x0F, 0xC0, 0x7F, 0xE0, 0x00, 0x00, ##                      000000       0000000000                     
            0x00, 0x00, 0x0F, 0x80, 0x3F, 0xE0, 0x00, 0x00, ##                      00000         000000000                     
            0x00, 0x00, 0x0F, 0x80, 0x3F, 0xF0, 0x00, 0x00, ##                      00000         0000000000                    
            0x00, 0x00, 0x1F, 0x80, 0x1F, 0xF0, 0x00, 0x00, ##                     000000          000000000                    
            0x00, 0x00, 0x1F, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     00000           0000000000                   
            0x00, 0x00, 0x3F, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                    000000           0000000000                   
            0x00, 0x00, 0x3E, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##                    00000             000000000                   
            0x00, 0x00, 0x3E, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##                    00000             0000000000                  
            0x00, 0x00, 0x7E, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##                   000000             0000000000                  
            0x00, 0x00, 0x7C, 0x00, 0x07, 0xFC, 0x00, 0x00, ##                   00000               000000000                  
            0x00, 0x00, 0x7C, 0x00, 0x07, 0xFE, 0x00, 0x00, ##                   00000               0000000000                 
            0x00, 0x00, 0xFC, 0x00, 0x03, 0xFE, 0x00, 0x00, ##                  000000                000000000                 
            0x00, 0x00, 0xF8, 0x00, 0x03, 0xFF, 0x00, 0x00, ##                  00000                 0000000000                
            0x00, 0x01, 0xF8, 0x00, 0x03, 0xFF, 0x00, 0x00, ##                 000000                 0000000000                
            0x00, 0x01, 0xF8, 0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000                  000000000                
            0x00, 0x01, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##                 00000                   0000000000               
            0x00, 0x03, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##                000000                   0000000000               
            0x00, 0x03, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##                00000                     000000000               
            0x00, 0x03, 0xE0, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##                00000                     0000000000              
            0x00, 0x07, 0xE0, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##               000000                      000000000              
            0x00, 0x07, 0xC0, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##               00000                       0000000000             
            0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##               00000000000000000000000000000000000000             
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##              000000000000000000000000000000000000000             
            0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##              0000000000000000000000000000000000000000            
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##             00000000000000000000000000000000000000000            
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##             00000                           000000000            
            0x00, 0x1F, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##             00000                           0000000000           
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##            00000                             000000000           
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##            00000                             000000000           
            0x00, 0x3E, 0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##            00000                             0000000000          
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##           00000                               000000000          
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, ##           00000                               0000000000         
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xFE, 0x00, ##          000000                               0000000000         
            0x00, 0xF8, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##          00000                                 000000000         
            0x00, 0xF8, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          00000                                 0000000000        
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, ##         000000                                 0000000000        
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         00000                                   000000000        
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x80, ##         00000                                   0000000000       
            0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##        000000                                    000000000       
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##        00000                                     0000000000      
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, ##  000000000000000000                       00000000000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, ##  000000000000000000                       00000000000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, ##  000000000000000000                       00000000000000000000000
            0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x7F, 0xFF, 0xFF, ##  000000000000000000                       00000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 53, 
        'xoffset'  => 5, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##  00000000000000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0x80, 0x00, 0x7F, 0xFE, 0x00, ##          000000000                00000000000000      
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0x00, ##          000000000                   000000000000     
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x00, ##          000000000                    00000000000     
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xC0, ##          000000000                      00000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x00, ##          000000000                    00000000000     
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xFE, 0x00, ##          000000000                   00000000000      
            0x00, 0xFF, 0x80, 0x00, 0x7F, 0xF8, 0x00, ##          000000000                000000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000          
            0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##          0000000000000000000000000000000              
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##          000000000000000000000000000000000            
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##          000000000000000000000000000000000000         
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFC, 0x00, ##          000000000                  00000000000       
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFE, 0x00, ##          000000000                     000000000      
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, ##          000000000                        00000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##          000000000                        000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##          000000000                         000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##          000000000                          00000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF0, ##          000000000                           00000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, ##          000000000                           000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##          000000000                          000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##          000000000                         000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, ##          000000000                        000000000   
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, ##          000000000                     0000000000     
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFE, 0x00, ##          000000000                  000000000000      
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000000000000000000000000000       
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  00000000000000000000000000000000000000000            
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  000000000000000000000000000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 56, 
        'xoffset'  => 5, 
        'xadvance' => 66, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, ##                           0000000000000                  
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0xE0, 0x00, ##                       0000000000000000000000             
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##                    00000000000000000000000000000         
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##                  0000000000000000000000000000000000      
            0x00, 0x03, 0xFF, 0x80, 0x1F, 0xFF, 0xF8, ##                00000000000          000000000000000000   
            0x00, 0x07, 0xFC, 0x00, 0x01, 0xFF, 0xFE, ##               000000000                 0000000000000000 
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x7F, 0xFE, ##             000000000                     00000000000000 
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xFE, ##            00000000                         000000000000 
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x0F, 0xFE, ##           00000000                           00000000000 
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFE, ##          00000000                             0000000000 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFE, ##         00000000                               000000000 
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xFE, ##        00000000                                000000000 
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFE, ##        00000000                                 00000000 
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFE, ##       00000000                                   0000000 
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFE, ##      00000000                                    0000000 
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFE, ##      00000000                                    0000000 
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7E, ##     000000000                                     000000 
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7E, ##     00000000                                      000000 
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7E, ##     00000000                                      000000 
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3E, ##    000000000                                       00000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##    00000000                                              
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##    00000000                                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##   00000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                               
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, ##   00000000                                               
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                              
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##    00000000                                              
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, ##    00000000                                              
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##    000000000                                             
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, ##     00000000                                             
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0xFF, ##     00000000                                     00000000
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, ##     000000000                                    00000000
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFE, ##      00000000                                    0000000 
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x01, 0xFE, ##       0000000                                   00000000 
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x01, 0xFE, ##       00000000                                  00000000 
            0x03, 0xF8, 0x00, 0x00, 0x00, 0x03, 0xFC, ##        0000000                                 00000000  
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xF8, ##         0000000                               00000000   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x07, 0xF8, ##         00000000                              00000000   
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##          00000000                            00000000    
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##           00000000                          00000000     
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##            00000000                        00000000      
            0x00, 0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x80, ##             00000000                     000000000       
            0x00, 0x07, 0xFC, 0x00, 0x03, 0xFF, 0x00, ##               000000000                0000000000        
            0x00, 0x03, 0xFF, 0x80, 0x1F, 0xFE, 0x00, ##                00000000000          000000000000         
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##                  00000000000000000000000000000           
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##                    0000000000000000000000000             
            0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, ##                      000000000000000000000               
            0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                          000000000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 60, 
        'xoffset'  => 5, 
        'xadvance' => 70, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000000000000000000000000000                           
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000000000000000000000000000                      
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000000000000000000000000000                   
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  0000000000000000000000000000000000000000000                 
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##          000000000              00000000000000               
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFE, 0x00, 0x00, ##          000000000                  000000000000             
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x00, 0x00, ##          000000000                    00000000000            
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##          000000000                      00000000000          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##          000000000                       00000000000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##          000000000                         0000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##          000000000                          0000000000       
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##          000000000                           0000000000      
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          000000000                            000000000      
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFE, 0x00, ##          000000000                            0000000000     
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          000000000                             0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          000000000                             0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x80, ##          000000000                              0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x80, ##          000000000                              0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                               0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                               0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##          000000000                                000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##          000000000                                 0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                                0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                               0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                               0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                               0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x80, ##          000000000                              0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xFF, 0x80, ##          000000000                              0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          000000000                             0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          000000000                             0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFE, 0x00, ##          000000000                            0000000000     
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##          000000000                           0000000000      
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##          000000000                           0000000000      
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##          000000000                          0000000000       
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##          000000000                         0000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##          000000000                       00000000000         
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##          000000000                      00000000000          
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x00, 0x00, ##          000000000                    00000000000            
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFE, 0x00, 0x00, ##          000000000                  000000000000             
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##          000000000              00000000000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  0000000000000000000000000000000000000000000                 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000000000000000000000000000                   
            0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##  00000000000000000000000000000000000000                      
            0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000000000000000000000000000                           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 52, 
        'xoffset'  => 5, 
        'xadvance' => 64, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000 
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000 
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##          0000000000000000000000000000000000000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##          00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 52, 
        'xoffset'  => 5, 
        'xadvance' => 61, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  0000000000000000000000000000000000000000000000000000
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##          00000000000000000000000000000000000000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, ##          000000000                              00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##          00000000000000000000000000000000000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##          000000000                     00000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                   
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                         
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                         
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                         
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 58, 
        'xoffset'  => 5, 
        'xadvance' => 70, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                            0000000000000                   
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##                       000000000000000000000000             
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                    0000000000000000000000000000000         
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, ##                  0000000000000000000000000000000000000     
            0x00, 0x03, 0xFF, 0xC0, 0x07, 0xFF, 0xFF, 0x00, ##                000000000000           0000000000000000000  
            0x00, 0x07, 0xFC, 0x00, 0x00, 0xFF, 0xFF, 0x00, ##               000000000                  0000000000000000  
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xFF, 0x00, ##             000000000                      00000000000000  
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x0F, 0xFF, 0x00, ##            00000000                          000000000000  
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x07, 0xFF, 0x00, ##           00000000                            00000000000  
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, ##          00000000                              0000000000  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         00000000                                000000000  
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##        00000000                                  00000000  
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, ##        00000000                                  00000000  
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, ##       00000000                                    0000000  
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, ##      00000000                                     0000000  
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, ##      00000000                                     0000000  
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##     000000000                                      000000  
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##     00000000                                       000000  
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##     00000000                                       000000  
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, ##    000000000                                        00000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##    00000000                                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                                
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##   000000000                                                
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##   00000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000                                                 
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, ##  000000000                            000000000000000000000
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, ##  000000000                            000000000000000000000
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, ##  000000000                            000000000000000000000
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xFF, 0xFF, 0xC0, ##  000000000                            000000000000000000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   00000000                                        000000000
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                                       000000000
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                                       000000000
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                                       000000000
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##   000000000                                       000000000
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##    00000000                                       000000000
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                                      000000000
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##     00000000                                      000000000
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##     00000000                                      000000000
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##     000000000                                     000000000
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000
            0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      000000000                                    000000000
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##       00000000                                    000000000
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##        00000000                                   000000000
            0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##        000000000                                  000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##         00000000                                  000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##          00000000                                 000000000
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, 0xFF, 0xC0, ##           00000000                               0000000000
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xC0, ##            000000000                           000000000000
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x0F, 0xFF, 0xC0, ##             000000000                        00000000000000
            0x00, 0x07, 0xFC, 0x00, 0x00, 0x7F, 0xFF, 0x80, ##               000000000                   0000000000000000 
            0x00, 0x03, 0xFF, 0xC0, 0x07, 0xFF, 0xFE, 0x00, ##                000000000000           000000000000000000   
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##                  000000000000000000000000000000000000      
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                    0000000000000000000000000000000         
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                       0000000000000000000000000            
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, ##                           000000000000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 66, 
        'xoffset'  => 5, 
        'xadvance' => 76, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          00000000000000000000000000000000000000000000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                                000000000        
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000                0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 25, 
        'xoffset'  => 5, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0x00, 0xFF, 0x80, 0x00, ##          000000000        
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 38, 
        'xoffset'  => -7, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##             000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##             000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##             000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFC, ##             000000000000000000000000000
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000        
            0x00, 0x00, 0x07, 0xF8, 0x00, ##                       00000000         
            0xF8, 0x00, 0x07, 0xF8, 0x00, ##  00000                00000000         
            0xF8, 0x00, 0x0F, 0xF8, 0x00, ##  00000               000000000         
            0xF8, 0x00, 0x0F, 0xF8, 0x00, ##  00000               000000000         
            0xF8, 0x00, 0x0F, 0xF8, 0x00, ##  00000               000000000         
            0xFC, 0x00, 0x0F, 0xF0, 0x00, ##  000000              00000000          
            0xFC, 0x00, 0x1F, 0xF0, 0x00, ##  000000             000000000          
            0xFC, 0x00, 0x1F, 0xE0, 0x00, ##  000000             00000000           
            0xFE, 0x00, 0x7F, 0xC0, 0x00, ##  0000000          000000000            
            0xFF, 0x80, 0xFF, 0xC0, 0x00, ##  000000000       0000000000            
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000             
            0xFF, 0xFF, 0xFE, 0x00, 0x00, ##  00000000000000000000000               
            0x1F, 0xFF, 0xF8, 0x00, 0x00, ##     000000000000000000                 
            0x01, 0xFF, 0xC0, 0x00, 0x00, ##         00000000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 62, 
        'xoffset'  => 5, 
        'xadvance' => 65, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000    
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000    
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xC0, 0x00, ##          000000000                          0000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0x80, 0x00, ##          000000000                         0000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0x00, 0x00, ##          000000000                        0000000              
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFE, 0x00, 0x00, ##          000000000                       0000000               
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFC, 0x00, 0x00, ##          000000000                      0000000                
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xF8, 0x00, 0x00, ##          000000000                     0000000                 
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xF0, 0x00, 0x00, ##          000000000                    0000000                  
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##          000000000                   0000000                   
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##          000000000                  0000000                    
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0x80, 0x00, 0x00, ##          000000000                 0000000                     
            0x00, 0xFF, 0x80, 0x00, 0xFE, 0x00, 0x00, 0x00, ##          000000000               0000000                       
            0x00, 0xFF, 0x80, 0x01, 0xFC, 0x00, 0x00, 0x00, ##          000000000              0000000                        
            0x00, 0xFF, 0x80, 0x03, 0xF8, 0x00, 0x00, 0x00, ##          000000000             0000000                         
            0x00, 0xFF, 0x80, 0x07, 0xF0, 0x00, 0x00, 0x00, ##          000000000            0000000                          
            0x00, 0xFF, 0x80, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##          000000000           0000000                           
            0x00, 0xFF, 0x80, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##          000000000          0000000                            
            0x00, 0xFF, 0x80, 0x3F, 0x80, 0x00, 0x00, 0x00, ##          000000000         0000000                             
            0x00, 0xFF, 0x80, 0x7F, 0x00, 0x00, 0x00, 0x00, ##          000000000        0000000                              
            0x00, 0xFF, 0x80, 0xFE, 0x00, 0x00, 0x00, 0x00, ##          000000000       0000000                               
            0x00, 0xFF, 0x81, 0xFC, 0x00, 0x00, 0x00, 0x00, ##          000000000      0000000                                
            0x00, 0xFF, 0x83, 0xF8, 0x00, 0x00, 0x00, 0x00, ##          000000000     0000000                                 
            0x00, 0xFF, 0x8F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##          000000000   0000000                                   
            0x00, 0xFF, 0x9F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##          000000000  0000000                                    
            0x00, 0xFF, 0xBF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000 0000000                                     
            0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##          0000000000000000                                      
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          00000000000000000                                     
            0x00, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##          000000000000000000                                    
            0x00, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##          0000000000000000000                                   
            0x00, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##          00000000000000000000                                  
            0x00, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, 0x00, ##          000000000000000000000                                 
            0x00, 0xFF, 0xBF, 0xFC, 0x00, 0x00, 0x00, 0x00, ##          000000000 000000000000                                
            0x00, 0xFF, 0x9F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##          000000000  000000000000                               
            0x00, 0xFF, 0x8F, 0xFF, 0x00, 0x00, 0x00, 0x00, ##          000000000   000000000000                              
            0x00, 0xFF, 0x87, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000    000000000000                             
            0x00, 0xFF, 0x83, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##          000000000     000000000000                            
            0x00, 0xFF, 0x81, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##          000000000      00000000000                            
            0x00, 0xFF, 0x80, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##          000000000       00000000000                           
            0x00, 0xFF, 0x80, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##          000000000        00000000000                          
            0x00, 0xFF, 0x80, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##          000000000         00000000000                         
            0x00, 0xFF, 0x80, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##          000000000          00000000000                        
            0x00, 0xFF, 0x80, 0x0F, 0xFE, 0x00, 0x00, 0x00, ##          000000000           00000000000                       
            0x00, 0xFF, 0x80, 0x07, 0xFF, 0x00, 0x00, 0x00, ##          000000000            00000000000                      
            0x00, 0xFF, 0x80, 0x03, 0xFF, 0x80, 0x00, 0x00, ##          000000000             00000000000                     
            0x00, 0xFF, 0x80, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##          000000000              00000000000                    
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##          000000000               00000000000                   
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##          000000000               000000000000                  
            0x00, 0xFF, 0x80, 0x00, 0x7F, 0xF8, 0x00, 0x00, ##          000000000                000000000000                 
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##          000000000                 000000000000                
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFE, 0x00, 0x00, ##          000000000                  000000000000               
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0x00, 0x00, ##          000000000                   000000000000              
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0x80, 0x00, ##          000000000                    000000000000             
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0xC0, 0x00, ##          000000000                     000000000000            
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0xE0, 0x00, ##          000000000                      000000000000           
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xF0, 0x00, ##          000000000                       000000000000          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xF8, 0x00, ##          000000000                        000000000000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xFC, 0x00, ##          000000000                         000000000000        
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x1F, 0xFF, 0xFC, ##  0000000000000000000000000                  0000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFC, ##  0000000000000000000000000                   000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x07, 0xFF, 0xFC, ##  0000000000000000000000000                    00000000000000000
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0xFC, ##  0000000000000000000000000                     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 51, 
        'xoffset'  => 5, 
        'xadvance' => 58, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  0000000000000000000000000                          
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  0000000000000000000000000                          
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  0000000000000000000000000                          
            0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, 0x00, ##  0000000000000000000000000                          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, ##          000000000                             00000
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##          0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 80, 
        'xoffset'  => 4, 
        'xadvance' => 88, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, ##  0000000000000000000                                           000000000000000000
            0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, ##  0000000000000000000                                           000000000000000000
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, ##  00000000000000000000                                          000000000000000000
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xFF, ##  00000000000000000000                                         0000000000000000000
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, ##           000000000000                                        00000000000        
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, ##           000000000000                                       000000000000        
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0x00, ##           0000000000000                                      000000000000        
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00, ##           0000000000000                                     0000000000000        
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0x00, ##           00000000000000                                    0000000000000        
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, ##           00000000000000                                   00000000000000        
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0x00, ##           000000000000000                                  00000000000000        
            0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, ##           00000 000000000                                 00000 000000000        
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x7D, 0xFF, 0x00, ##           00000 0000000000                                00000 000000000        
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xF9, 0xFF, 0x00, ##           00000  000000000                               00000  000000000        
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xF9, 0xFF, 0x00, ##           00000  0000000000                              00000  000000000        
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x01, 0xF1, 0xFF, 0x00, ##           00000   000000000                             00000   000000000        
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, 0x01, 0xF1, 0xFF, 0x00, ##           00000   0000000000                            00000   000000000        
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x03, 0xE1, 0xFF, 0x00, ##           00000    000000000                           00000    000000000        
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x03, 0xE1, 0xFF, 0x00, ##           00000    0000000000                          00000    000000000        
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, 0x07, 0xC1, 0xFF, 0x00, ##           00000     000000000                         00000     000000000        
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x07, 0xC1, 0xFF, 0x00, ##           00000     0000000000                        00000     000000000        
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x0F, 0x81, 0xFF, 0x00, ##           00000      000000000                       00000      000000000        
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x0F, 0x81, 0xFF, 0x00, ##           00000      000000000                       00000      000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, 0x1F, 0x01, 0xFF, 0x00, ##           00000       000000000                     00000       000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, 0x00, 0x1F, 0x01, 0xFF, 0x00, ##           00000       000000000                     00000       000000000        
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x3E, 0x01, 0xFF, 0x00, ##           00000        000000000                   00000        000000000        
            0x00, 0x00, 0x03, 0xFE, 0x00, 0x00, 0x3E, 0x01, 0xFF, 0x00, ##           00000        000000000                   00000        000000000        
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x3E, 0x01, 0xFF, 0x00, ##           00000         000000000                  00000        000000000        
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x7C, 0x01, 0xFF, 0x00, ##           00000         000000000                 00000         000000000        
            0x00, 0x00, 0x01, 0xFF, 0x80, 0x00, 0x7C, 0x01, 0xFF, 0x00, ##           00000         0000000000                00000         000000000        
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0xF8, 0x01, 0xFF, 0x00, ##           00000          000000000               00000          000000000        
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, 0xF8, 0x01, 0xFF, 0x00, ##           00000          0000000000              00000          000000000        
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x01, 0xF0, 0x01, 0xFF, 0x00, ##           00000           000000000             00000           000000000        
            0x00, 0x00, 0x00, 0x7F, 0xE0, 0x01, 0xF0, 0x01, 0xFF, 0x00, ##           00000           0000000000            00000           000000000        
            0x00, 0x00, 0x00, 0x3F, 0xE0, 0x03, 0xE0, 0x01, 0xFF, 0x00, ##           00000            000000000           00000            000000000        
            0x00, 0x00, 0x00, 0x3F, 0xF0, 0x03, 0xE0, 0x01, 0xFF, 0x00, ##           00000            0000000000          00000            000000000        
            0x00, 0x00, 0x00, 0x1F, 0xF0, 0x07, 0xC0, 0x01, 0xFF, 0x00, ##           00000             000000000         00000             000000000        
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x07, 0xC0, 0x01, 0xFF, 0x00, ##           00000             0000000000        00000             000000000        
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x0F, 0x80, 0x01, 0xFF, 0x00, ##           00000              000000000       00000              000000000        
            0x00, 0x00, 0x00, 0x0F, 0xFC, 0x0F, 0x80, 0x01, 0xFF, 0x00, ##           00000              0000000000      00000              000000000        
            0x00, 0x00, 0x00, 0x07, 0xFC, 0x1F, 0x00, 0x01, 0xFF, 0x00, ##           00000               000000000     00000               000000000        
            0x00, 0x00, 0x00, 0x07, 0xFE, 0x1F, 0x00, 0x01, 0xFF, 0x00, ##           00000               0000000000    00000               000000000        
            0x00, 0x00, 0x00, 0x03, 0xFE, 0x3E, 0x00, 0x01, 0xFF, 0x00, ##           00000                000000000   00000                000000000        
            0x00, 0x00, 0x00, 0x03, 0xFF, 0x3E, 0x00, 0x01, 0xFF, 0x00, ##           00000                0000000000  00000                000000000        
            0x00, 0x00, 0x00, 0x01, 0xFF, 0x7C, 0x00, 0x01, 0xFF, 0x00, ##           00000                 000000000 00000                 000000000        
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0x00, ##           00000                 000000000000000                 000000000        
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x01, 0xFF, 0x00, ##           00000                 000000000000000                 000000000        
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##           00000                  0000000000000                  000000000        
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##           00000                  0000000000000                  000000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x01, 0xFF, 0x00, ##           00000                   00000000000                   000000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x01, 0xFF, 0x00, ##           00000                   00000000000                   000000000        
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##           00000                    000000000                    000000000        
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x00, ##           00000                    000000000                    000000000        
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x01, 0xFF, 0x00, ##           00000                     0000000                     000000000        
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x01, 0xFF, 0x00, ##           00000                     0000000                     000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##           00000                                                 000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##           00000                                                 000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##           00000                                                 000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##           00000                                                 000000000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##           00000                                                 000000000        
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##   000000000000000000000                                 0000000000000000000000000
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##   000000000000000000000                                 0000000000000000000000000
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##   000000000000000000000                                 0000000000000000000000000
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##   000000000000000000000                                 0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 68, 
        'xoffset'  => 4, 
        'xadvance' => 76, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF0, ##  00000000000000000                             0000000000000000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF0, ##  00000000000000000                             0000000000000000000000
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF0, ##  000000000000000000                            0000000000000000000000
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xF0, ##  0000000000000000000                           0000000000000000000000
            0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000000000                                  00000         
            0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000000000                                  00000         
            0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           000000000000                                 00000         
            0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           0000000000000                                00000         
            0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000000000000                               00000         
            0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000000000000                               00000         
            0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           000000000000000                              00000         
            0x00, 0x7F, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           0000000000000000                             00000         
            0x00, 0x7D, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000 00000000000                            00000         
            0x00, 0x7C, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000  0000000000                            00000         
            0x00, 0x7C, 0x7F, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000   0000000000                           00000         
            0x00, 0x7C, 0x7F, 0xF0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000   00000000000                          00000         
            0x00, 0x7C, 0x3F, 0xF8, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000    00000000000                         00000         
            0x00, 0x7C, 0x1F, 0xF8, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000     0000000000                         00000         
            0x00, 0x7C, 0x0F, 0xFC, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000      0000000000                        00000         
            0x00, 0x7C, 0x0F, 0xFE, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000      00000000000                       00000         
            0x00, 0x7C, 0x07, 0xFF, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000       00000000000                      00000         
            0x00, 0x7C, 0x03, 0xFF, 0x00, 0x00, 0x03, 0xE0, 0x00, ##           00000        0000000000                      00000         
            0x00, 0x7C, 0x01, 0xFF, 0x80, 0x00, 0x03, 0xE0, 0x00, ##           00000         0000000000                     00000         
            0x00, 0x7C, 0x01, 0xFF, 0xC0, 0x00, 0x03, 0xE0, 0x00, ##           00000         00000000000                    00000         
            0x00, 0x7C, 0x00, 0xFF, 0xC0, 0x00, 0x03, 0xE0, 0x00, ##           00000          0000000000                    00000         
            0x00, 0x7C, 0x00, 0x7F, 0xE0, 0x00, 0x03, 0xE0, 0x00, ##           00000           0000000000                   00000         
            0x00, 0x7C, 0x00, 0x3F, 0xF0, 0x00, 0x03, 0xE0, 0x00, ##           00000            0000000000                  00000         
            0x00, 0x7C, 0x00, 0x3F, 0xF8, 0x00, 0x03, 0xE0, 0x00, ##           00000            00000000000                 00000         
            0x00, 0x7C, 0x00, 0x1F, 0xF8, 0x00, 0x03, 0xE0, 0x00, ##           00000             0000000000                 00000         
            0x00, 0x7C, 0x00, 0x0F, 0xFC, 0x00, 0x03, 0xE0, 0x00, ##           00000              0000000000                00000         
            0x00, 0x7C, 0x00, 0x07, 0xFE, 0x00, 0x03, 0xE0, 0x00, ##           00000               0000000000               00000         
            0x00, 0x7C, 0x00, 0x07, 0xFF, 0x00, 0x03, 0xE0, 0x00, ##           00000               00000000000              00000         
            0x00, 0x7C, 0x00, 0x03, 0xFF, 0x00, 0x03, 0xE0, 0x00, ##           00000                0000000000              00000         
            0x00, 0x7C, 0x00, 0x01, 0xFF, 0x80, 0x03, 0xE0, 0x00, ##           00000                 0000000000             00000         
            0x00, 0x7C, 0x00, 0x01, 0xFF, 0xC0, 0x03, 0xE0, 0x00, ##           00000                 00000000000            00000         
            0x00, 0x7C, 0x00, 0x00, 0xFF, 0xE0, 0x03, 0xE0, 0x00, ##           00000                  00000000000           00000         
            0x00, 0x7C, 0x00, 0x00, 0x7F, 0xE0, 0x03, 0xE0, 0x00, ##           00000                   0000000000           00000         
            0x00, 0x7C, 0x00, 0x00, 0x3F, 0xF0, 0x03, 0xE0, 0x00, ##           00000                    0000000000          00000         
            0x00, 0x7C, 0x00, 0x00, 0x3F, 0xF8, 0x03, 0xE0, 0x00, ##           00000                    00000000000         00000         
            0x00, 0x7C, 0x00, 0x00, 0x1F, 0xFC, 0x03, 0xE0, 0x00, ##           00000                     00000000000        00000         
            0x00, 0x7C, 0x00, 0x00, 0x0F, 0xFC, 0x03, 0xE0, 0x00, ##           00000                      0000000000        00000         
            0x00, 0x7C, 0x00, 0x00, 0x07, 0xFE, 0x03, 0xE0, 0x00, ##           00000                       0000000000       00000         
            0x00, 0x7C, 0x00, 0x00, 0x07, 0xFF, 0x03, 0xE0, 0x00, ##           00000                       00000000000      00000         
            0x00, 0x7C, 0x00, 0x00, 0x03, 0xFF, 0x83, 0xE0, 0x00, ##           00000                        00000000000     00000         
            0x00, 0x7C, 0x00, 0x00, 0x01, 0xFF, 0x83, 0xE0, 0x00, ##           00000                         0000000000     00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0xFF, 0xC3, 0xE0, 0x00, ##           00000                          0000000000    00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0xFF, 0xE3, 0xE0, 0x00, ##           00000                          00000000000   00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x7F, 0xF3, 0xE0, 0x00, ##           00000                           00000000000  00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x3F, 0xF3, 0xE0, 0x00, ##           00000                            0000000000  00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0xFB, 0xE0, 0x00, ##           00000                             0000000000 00000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xE0, 0x00, ##           00000                             0000000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, ##           00000                              000000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xE0, 0x00, ##           00000                               00000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##           00000                                0000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, ##           00000                                0000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, ##           00000                                 000000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##           00000                                  00000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##           00000                                   0000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##           00000                                   0000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##           00000                                    000000000         
            0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##  0000000000000000000000                             00000000         
            0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##  0000000000000000000000                             00000000         
            0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##  0000000000000000000000                              0000000         
            0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##  0000000000000000000000                               000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE0, 0x00, ##                                                        00000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 62, 
        'xoffset'  => 5, 
        'xadvance' => 72, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                           000000000000                         
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                       00000000000000000000                     
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                    00000000000000000000000000                  
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                  000000000000000000000000000000                
            0x00, 0x03, 0xFF, 0x80, 0x0F, 0xFF, 0x00, 0x00, ##                00000000000           000000000000              
            0x00, 0x07, 0xFC, 0x00, 0x01, 0xFF, 0x80, 0x00, ##               000000000                 0000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##              00000000                     0000000000           
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##            00000000                         000000000          
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##           00000000                           000000000         
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          00000000                             000000000        
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##         00000000                               000000000       
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         0000000                                 00000000       
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##        00000000                                 000000000      
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       00000000                                   000000000     
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       0000000                                    000000000     
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##      00000000                                     0000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##    000000000                                       0000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##   00000000                                           000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##   00000000                                           000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##    000000000                                       0000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000    
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       0000000                                    000000000     
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       00000000                                   000000000     
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##        00000000                                 000000000      
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         0000000                                 00000000       
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##         00000000                               00000000        
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          00000000                             000000000        
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##           00000000                           000000000         
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##            00000000                         000000000          
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##              00000000                     000000000            
            0x00, 0x07, 0xFC, 0x00, 0x01, 0xFF, 0x80, 0x00, ##               000000000                 0000000000             
            0x00, 0x03, 0xFF, 0x80, 0x0F, 0xFF, 0x00, 0x00, ##                00000000000           000000000000              
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                  000000000000000000000000000000                
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                    00000000000000000000000000                  
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                       00000000000000000000                     
            0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                           000000000000                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 51, 
        'xoffset'  => 5, 
        'xadvance' => 59, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##  000000000000000000000000000000000000               
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  0000000000000000000000000000000000000000           
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000000000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  00000000000000000000000000000000000000000000       
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xF8, 0x00, ##          000000000               0000000000000      
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFC, 0x00, ##          000000000                  00000000000     
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xFE, 0x00, ##          000000000                   00000000000    
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, ##          000000000                     0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, ##          000000000                     0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xE0, ##          000000000                        0000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0xC0, ##          000000000                       0000000000 
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x80, ##          000000000                      0000000000  
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, ##          000000000                     0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, ##          000000000                     0000000000   
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFE, 0x00, ##          000000000                    0000000000    
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xFC, 0x00, ##          000000000                  00000000000     
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xF8, 0x00, ##          000000000               0000000000000      
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##          000000000000000000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##          0000000000000000000000000000000000         
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##          00000000000000000000000000000000           
            0x00, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##          0000000000000000000000000000               
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000000                                  
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                        
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                        
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                        
            0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##  000000000000000000000000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 62, 
        'xoffset'  => 5, 
        'xadvance' => 72, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                           000000000000                         
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                       00000000000000000000                     
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                    00000000000000000000000000                  
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                  000000000000000000000000000000                
            0x00, 0x03, 0xFF, 0x80, 0x0F, 0xFF, 0x00, 0x00, ##                00000000000           000000000000              
            0x00, 0x07, 0xFC, 0x00, 0x01, 0xFF, 0x80, 0x00, ##               000000000                 0000000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##              00000000                     0000000000           
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##            00000000                         000000000          
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##           00000000                           000000000         
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          00000000                             000000000        
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##         00000000                               000000000       
            0x01, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         0000000                                 00000000       
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##        00000000                                 000000000      
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       00000000                                   000000000     
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       0000000                                    000000000     
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xE0, ##      00000000                                     0000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##    000000000                                       0000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##   00000000                                           000000000 
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##  000000000                                           0000000000
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##   00000000                                           000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF8, ##   000000000                                         0000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##   000000000                                         000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##    00000000                                         000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, ##    000000000                                       0000000000  
            0x3F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##    000000000                                       000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, ##     00000000                                       000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##     000000000                                     000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xC0, ##      00000000                                     000000000    
            0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##      00000000                                    000000000     
            0x07, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, ##       00000000                                   000000000     
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, ##        00000000                                 000000000      
            0x03, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFE, 0x00, ##        00000000                                 00000000       
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x03, 0xFE, 0x00, ##         00000000                               000000000       
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          00000000                             000000000        
            0x00, 0x7F, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##           00000000                           000000000         
            0x00, 0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##            00000000                         000000000          
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##             000000000                     000000000            
            0x00, 0x0F, 0xFC, 0x00, 0x01, 0xFF, 0x80, 0x00, ##              0000000000                 0000000000             
            0x00, 0x03, 0xFF, 0x80, 0x0F, 0xFF, 0x00, 0x00, ##                00000000000           000000000000              
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                  000000000000000000000000000000                
            0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                    00000000000000000000000000                  
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                       00000000000000000000                     
            0x00, 0x00, 0x00, 0x7F, 0xFC, 0x00, 0x00, 0x00, ##                           0000000000000                        
            0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                                  000000                        
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, ##                                  00000000                      
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                                   00000000                     
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                                    000000000                   
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                                    000000000000                
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xFF, 0xF8, 0x00, ##                                     000000000000000000         
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF8, 0x00, ##                                      00000000000000000         
            0x00, 0x00, 0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, ##                                       0000000000000000         
            0x00, 0x00, 0x00, 0x00, 0x03, 0xFF, 0xF8, 0x00, ##                                        000000000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, ##                                          0000000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, ##                                           000000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##                                              000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, ##                                                 000000         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 63, 
        'xoffset'  => 5, 
        'xadvance' => 66, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000000000000000000000000000                          
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000000000000000000000000000                      
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##  0000000000000000000000000000000000000000000                    
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, ##  000000000000000000000000000000000000000000000                  
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##          000000000                 000000000000                 
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFE, 0x00, 0x00, ##          000000000                    0000000000                
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, 0x00, ##          000000000                     0000000000               
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x00, 0x00, ##          000000000                      000000000               
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          000000000                       000000000              
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          000000000                       000000000              
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x00, 0x00, ##          000000000                      000000000               
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFF, 0x00, 0x00, ##          000000000                     0000000000               
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFE, 0x00, 0x00, ##          000000000                    0000000000                
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##          000000000                 00000000000                  
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##          000000000000000000000000000000000000                   
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##          000000000000000000000000000000000                      
            0x00, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##          00000000000000000000000000000                          
            0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##          0000000000000000000000000000000                        
            0x00, 0xFF, 0x80, 0x03, 0xFF, 0x00, 0x00, 0x00, ##          000000000             0000000000                       
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##          000000000               0000000000                     
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##          000000000                 000000000                    
            0x00, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##          000000000                 000000000                    
            0x00, 0xFF, 0x80, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##          000000000                  000000000                   
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##          000000000                   000000000                  
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##          000000000                   000000000                  
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFC, 0x00, 0x00, ##          000000000                    000000000                 
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFC, 0x00, 0x00, ##          000000000                    000000000                 
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFE, 0x00, 0x00, ##          000000000                     000000000                
            0x00, 0xFF, 0x80, 0x00, 0x03, 0xFE, 0x00, 0x00, ##          000000000                     000000000                
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x00, 0x00, ##          000000000                      000000000               
            0x00, 0xFF, 0x80, 0x00, 0x01, 0xFF, 0x00, 0x00, ##          000000000                      000000000               
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          000000000                       000000000              
            0x00, 0xFF, 0x80, 0x00, 0x00, 0xFF, 0x80, 0x00, ##          000000000                       000000000              
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##          000000000                        000000000             
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##          000000000                         000000000            
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##          000000000                          000000000           
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##          000000000                          000000000           
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##          000000000                           000000000          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xF8, 0x00, ##          000000000                           000000000          
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          000000000                            000000000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFC, 0x00, ##          000000000                            000000000         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x07, 0xFE, 0x00, ##          000000000                            0000000000        
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xFE, ##  00000000000000000000000000                    00000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x03, 0xFF, 0xFE, ##  00000000000000000000000000                    00000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x01, 0xFF, 0xFE, ##  00000000000000000000000000                     0000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x01, 0xFF, 0xFE, ##  00000000000000000000000000                     0000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 46, 
        'xoffset'  => 7, 
        'xadvance' => 59, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, ##                  0000000000000                 
            0x00, 0x1F, 0xFF, 0xFF, 0xE0, 0x00, ##             000000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xFE, 0x00, ##           000000000000000000000000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##         000000000000000000000000000000000000   
            0x03, 0xFF, 0x80, 0x1F, 0xFF, 0xE0, ##        00000000000          0000000000000000   
            0x07, 0xFC, 0x00, 0x01, 0xFF, 0xE0, ##       000000000                 000000000000   
            0x0F, 0xF8, 0x00, 0x00, 0xFF, 0xE0, ##      000000000                   00000000000   
            0x1F, 0xF0, 0x00, 0x00, 0x3F, 0xE0, ##     000000000                      000000000   
            0x3F, 0xE0, 0x00, 0x00, 0x1F, 0xE0, ##    000000000                        00000000   
            0x3F, 0xC0, 0x00, 0x00, 0x1F, 0xE0, ##    00000000                         00000000   
            0x7F, 0xC0, 0x00, 0x00, 0x0F, 0xE0, ##   000000000                          0000000   
            0x7F, 0x80, 0x00, 0x00, 0x0F, 0xE0, ##   00000000                           0000000   
            0x7F, 0x80, 0x00, 0x00, 0x07, 0xE0, ##   00000000                            000000   
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xE0, ##  000000000                            000000   
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xE0, ##  000000000                            000000   
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xE0, ##  000000000                            000000   
            0xFF, 0x80, 0x00, 0x00, 0x07, 0xE0, ##  000000000                            000000   
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                     
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                     
            0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  0000000000                                    
            0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##  0000000000                                    
            0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  00000000000                                   
            0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##   00000000000                                  
            0x7F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##   000000000000                                 
            0x7F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##   00000000000000                               
            0x3F, 0xFF, 0x80, 0x00, 0x00, 0x00, ##    000000000000000                             
            0x3F, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##    000000000000000000                          
            0x1F, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##     00000000000000000000                       
            0x0F, 0xFF, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000000000000000                   
            0x0F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##      00000000000000000000000000                
            0x03, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##        000000000000000000000000000             
            0x01, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, ##         0000000000000000000000000000           
            0x00, 0x7F, 0xFF, 0xFF, 0xF8, 0x00, ##           0000000000000000000000000000         
            0x00, 0x1F, 0xFF, 0xFF, 0xFE, 0x00, ##             0000000000000000000000000000       
            0x00, 0x07, 0xFF, 0xFF, 0xFF, 0x00, ##               000000000000000000000000000      
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xC0, ##                  00000000000000000000000000    
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xE0, ##                     000000000000000000000000   
            0x00, 0x00, 0x01, 0xFF, 0xFF, 0xE0, ##                         00000000000000000000   
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                            000000000000000000  
            0x00, 0x00, 0x00, 0x0F, 0xFF, 0xF0, ##                              0000000000000000  
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xF8, ##                                 00000000000000 
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, ##                                   000000000000 
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xF8, ##                                    00000000000 
            0x00, 0x00, 0x00, 0x00, 0x1F, 0xFC, ##                                     00000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##                                      0000000000
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xFC, ##                                      0000000000
            0x00, 0x00, 0x00, 0x00, 0x07, 0xFC, ##                                       000000000
            0x00, 0x00, 0x00, 0x00, 0x07, 0xFC, ##                                       000000000
            0x7C, 0x00, 0x00, 0x00, 0x07, 0xFC, ##   00000                               000000000
            0x7C, 0x00, 0x00, 0x00, 0x07, 0xFC, ##   00000                               000000000
            0x7C, 0x00, 0x00, 0x00, 0x07, 0xFC, ##   00000                               000000000
            0x7C, 0x00, 0x00, 0x00, 0x07, 0xFC, ##   00000                               000000000
            0x7E, 0x00, 0x00, 0x00, 0x07, 0xF8, ##   000000                              00000000 
            0x7E, 0x00, 0x00, 0x00, 0x07, 0xF8, ##   000000                              00000000 
            0x7E, 0x00, 0x00, 0x00, 0x0F, 0xF8, ##   000000                             000000000 
            0x7F, 0x00, 0x00, 0x00, 0x0F, 0xF0, ##   0000000                            00000000  
            0x7F, 0x00, 0x00, 0x00, 0x1F, 0xF0, ##   0000000                           000000000  
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000   
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000   
            0x7F, 0xE0, 0x00, 0x00, 0xFF, 0xC0, ##   0000000000                     0000000000    
            0x7F, 0xF8, 0x00, 0x03, 0xFF, 0x80, ##   000000000000                 00000000000     
            0x7F, 0xFF, 0x00, 0x1F, 0xFF, 0x00, ##   000000000000000           0000000000000      
            0x3F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##    000000000000000000000000000000000000        
            0x07, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##       0000000000000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000            
            0x00, 0x01, 0xFF, 0xF8, 0x00, 0x00, ##                 00000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 56, 
        'xoffset'  => 1, 
        'xadvance' => 58, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, ##  00000000000000000000000000000000000000000000000000000000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0xF8, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x1F, ##  00000                   000000000                  00000
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 65, 
        'xoffset'  => 4, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000                   000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000                   000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000                   000000000000000000000
            0x00, 0xFF, 0xFF, 0x80, 0x00, 0x0F, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000                   000000000000000000000
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##          000000000                                  000000        
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                                 00000         
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##           0000000000                               000000         
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            000000000                               00000          
            0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            000000000                               00000          
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##            0000000000                             000000          
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##             000000000                            000000           
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##             0000000000                           000000           
            0x00, 0x0F, 0xFC, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##              0000000000                         000000            
            0x00, 0x0F, 0xFF, 0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, ##              000000000000                     00000000            
            0x00, 0x07, 0xFF, 0xC0, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##               0000000000000                 000000000             
            0x00, 0x03, 0xFF, 0xF8, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                000000000000000           00000000000              
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                 00000000000000000000000000000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                   0000000000000000000000000000000                 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##                     0000000000000000000000000000                  
            0x00, 0x00, 0x07, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##                       00000000000000000000000                     
            0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                            0000000000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 65, 
        'xoffset'  => -1, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                       0000000000000000000
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                       0000000000000000000
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                       0000000000000000000
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                       0000000000000000000
            0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##        0000000000                                     000000      
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         0000000000                                    00000       
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##         0000000000                                   000000       
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                                   00000        
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          0000000000                                  00000        
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##          0000000000                                 000000        
            0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                                 00000         
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##           0000000000                               000000         
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, ##           0000000000                               00000          
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            0000000000                              00000          
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##            0000000000                             000000          
            0x00, 0x1F, 0xF0, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, ##             000000000                             00000           
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, ##             0000000000                            00000           
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##             0000000000                           000000           
            0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x00, ##              000000000                           00000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##              0000000000                         000000            
            0x00, 0x07, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##               000000000                         00000             
            0x00, 0x07, 0xFE, 0x00, 0x00, 0x01, 0xF0, 0x00, 0x00, ##               0000000000                        00000             
            0x00, 0x07, 0xFE, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##               0000000000                       000000             
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, ##                000000000                       00000              
            0x00, 0x03, 0xFF, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##                0000000000                     000000              
            0x00, 0x03, 0xFF, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                0000000000                     00000               
            0x00, 0x01, 0xFF, 0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, ##                 000000000                     00000               
            0x00, 0x01, 0xFF, 0x80, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##                 0000000000                   000000               
            0x00, 0x00, 0xFF, 0x80, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                  000000000                   00000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x0F, 0x80, 0x00, 0x00, ##                  0000000000                  00000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                  0000000000                 000000                
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x1F, 0x00, 0x00, 0x00, ##                   000000000                 00000                 
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x3F, 0x00, 0x00, 0x00, ##                   0000000000               000000                 
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                   0000000000               00000                  
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x3E, 0x00, 0x00, 0x00, ##                    000000000               00000                  
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x7E, 0x00, 0x00, 0x00, ##                    0000000000             000000                  
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                     000000000             00000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x7C, 0x00, 0x00, 0x00, ##                     0000000000            00000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                     0000000000           000000                   
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0xF8, 0x00, 0x00, 0x00, ##                      000000000           00000                    
            0x00, 0x00, 0x0F, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                      0000000000         000000                    
            0x00, 0x00, 0x0F, 0xFC, 0x01, 0xF0, 0x00, 0x00, 0x00, ##                      0000000000         00000                     
            0x00, 0x00, 0x07, 0xFE, 0x01, 0xF0, 0x00, 0x00, 0x00, ##                       0000000000        00000                     
            0x00, 0x00, 0x07, 0xFE, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                       0000000000       000000                     
            0x00, 0x00, 0x03, 0xFE, 0x03, 0xE0, 0x00, 0x00, 0x00, ##                        000000000       00000                      
            0x00, 0x00, 0x03, 0xFF, 0x07, 0xE0, 0x00, 0x00, 0x00, ##                        0000000000     000000                      
            0x00, 0x00, 0x03, 0xFF, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                        0000000000     00000                       
            0x00, 0x00, 0x01, 0xFF, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                         000000000     00000                       
            0x00, 0x00, 0x01, 0xFF, 0x8F, 0xC0, 0x00, 0x00, 0x00, ##                         0000000000   000000                       
            0x00, 0x00, 0x01, 0xFF, 0x8F, 0x80, 0x00, 0x00, 0x00, ##                         0000000000   00000                        
            0x00, 0x00, 0x00, 0xFF, 0xCF, 0x80, 0x00, 0x00, 0x00, ##                          0000000000  00000                        
            0x00, 0x00, 0x00, 0xFF, 0xDF, 0x80, 0x00, 0x00, 0x00, ##                          0000000000 000000                        
            0x00, 0x00, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0x00, 0x00, ##                           000000000 00000                         
            0x00, 0x00, 0x00, 0x7F, 0xFF, 0x00, 0x00, 0x00, 0x00, ##                           000000000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                           00000000000000                          
            0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                            0000000000000                          
            0x00, 0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                            0000000000000                          
            0x00, 0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                            000000000000                           
            0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                             00000000000                           
            0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                             0000000000                            
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                              000000000                            
            0x00, 0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                              000000000                            
            0x00, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##                              00000000                             
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 89, 
        'xoffset'  => 1, 
        'xadvance' => 91, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x01, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                    0000000                     000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x01, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                    0000000                     000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x01, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                   000000000                    000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x01, 0xFF, 0xFF, 0x80, ##  00000000000000000000000                   000000000                    000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        000000000                           000000000                           00000      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x03, 0xC0, 0x00, ##         000000000                         00000000000                          0000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                         00000000000                         00000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                         00000000000                         00000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                         00000000000                         00000       
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x07, 0x80, 0x00, ##          000000000                       0000000000000                        0000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                       0000000000000                       00000        
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000                       0000000000000                       00000        
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xFC, 0x00, 0x00, 0x0F, 0x80, 0x00, ##           000000000                     00000 000000000                      00000        
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xFC, 0x00, 0x00, 0x0F, 0x00, 0x00, ##           000000000                     00000 000000000                      0000         
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF7, 0xFC, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                     00000 000000000                     00000         
            0x00, 0x00, 0x00, 0x00, 0x01, 0xE3, 0xFC, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           000000000                     0000   00000000                     00000         
            0x00, 0x00, 0x00, 0x00, 0x03, 0xE3, 0xFE, 0x00, 0x00, 0x1E, 0x00, 0x00, ##            000000000                   00000   000000000                    0000          
            0x00, 0x00, 0x00, 0x00, 0x03, 0xE3, 0xFE, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            000000000                   00000   000000000                   00000          
            0x00, 0x00, 0x00, 0x00, 0x03, 0xE1, 0xFE, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            000000000                   00000    00000000                   00000          
            0x00, 0x00, 0x00, 0x00, 0x07, 0xC1, 0xFF, 0x00, 0x00, 0x3E, 0x00, 0x00, ##             00000000                  00000     000000000                  00000          
            0x00, 0x00, 0x00, 0x00, 0x07, 0xC1, 0xFF, 0x00, 0x00, 0x3C, 0x00, 0x00, ##             000000000                 00000     000000000                  0000           
            0x00, 0x00, 0x00, 0x00, 0x07, 0xC1, 0xFF, 0x00, 0x00, 0x7C, 0x00, 0x00, ##             000000000                 00000     000000000                 00000           
            0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0xFF, 0x00, 0x00, 0x7C, 0x00, 0x00, ##             000000000                 0000       00000000                 00000           
            0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0xFF, 0x80, 0x00, 0x78, 0x00, 0x00, ##              000000000               00000       000000000                0000            
            0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0xFF, 0x80, 0x00, 0x78, 0x00, 0x00, ##              000000000               00000       000000000                0000            
            0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x7F, 0x80, 0x00, 0xF8, 0x00, 0x00, ##              000000000               00000        00000000               00000            
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x7F, 0xC0, 0x00, 0xF8, 0x00, 0x00, ##              000000000              00000         000000000              00000            
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x7F, 0xC0, 0x00, 0xF0, 0x00, 0x00, ##               000000000             00000         000000000              0000             
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, 0x7F, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               000000000             00000         000000000             00000             
            0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x3F, 0xC0, 0x01, 0xF0, 0x00, 0x00, ##               000000000             0000           00000000             00000             
            0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x3F, 0xE0, 0x01, 0xF0, 0x00, 0x00, ##                000000000           00000           000000000            00000             
            0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x3F, 0xE0, 0x01, 0xE0, 0x00, 0x00, ##                000000000           00000           000000000            0000              
            0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x1F, 0xE0, 0x03, 0xE0, 0x00, 0x00, ##                000000000           00000            00000000           00000              
            0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x1F, 0xF0, 0x03, 0xE0, 0x00, 0x00, ##                000000000          00000             000000000          00000              
            0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x1F, 0xF0, 0x03, 0xC0, 0x00, 0x00, ##                 000000000         00000             000000000          0000               
            0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x1F, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##                 000000000         00000             000000000         00000               
            0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0x0F, 0xF0, 0x07, 0xC0, 0x00, 0x00, ##                 000000000         0000               00000000         00000               
            0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x0F, 0xF8, 0x07, 0xC0, 0x00, 0x00, ##                  000000000       00000               000000000        00000               
            0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x0F, 0xF8, 0x07, 0x80, 0x00, 0x00, ##                  000000000       00000               000000000        0000                
            0x00, 0x00, 0x00, 0x00, 0xF8, 0x00, 0x0F, 0xF8, 0x0F, 0x80, 0x00, 0x00, ##                  000000000       00000               000000000       00000                
            0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x07, 0xFC, 0x0F, 0x80, 0x00, 0x00, ##                  000000000      00000                 000000000      00000                
            0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x07, 0xFC, 0x0F, 0x00, 0x00, 0x00, ##                   000000000     00000                 000000000      0000                 
            0x00, 0x00, 0x00, 0x00, 0xF0, 0x00, 0x07, 0xFC, 0x0F, 0x00, 0x00, 0x00, ##                   000000000     00000                 000000000      0000                 
            0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x03, 0xFE, 0x1F, 0x00, 0x00, 0x00, ##                   000000000     0000                   000000000    00000                 
            0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x03, 0xFE, 0x1F, 0x00, 0x00, 0x00, ##                   000000000    00000                   000000000    00000                 
            0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x03, 0xFE, 0x1E, 0x00, 0x00, 0x00, ##                    000000000   00000                   000000000    0000                  
            0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x03, 0xFE, 0x3E, 0x00, 0x00, 0x00, ##                    000000000   00000                   000000000   00000                  
            0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x01, 0xFF, 0x3E, 0x00, 0x00, 0x00, ##                    000000000  00000                     000000000  00000                  
            0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x01, 0xFF, 0x3E, 0x00, 0x00, 0x00, ##                     000000000 00000                     000000000  00000                  
            0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x01, 0xFF, 0x3C, 0x00, 0x00, 0x00, ##                     000000000 00000                     000000000  0000                   
            0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##                     000000000 00000                      00000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000000                       00000000000000                   
            0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                      0000000000000                       0000000000000                    
            0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                      0000000000000                       0000000000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                      000000000000                         000000000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                       00000000000                         000000000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##                       00000000000                         00000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, ##                       00000000000                          0000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, ##                       0000000000                           0000000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, ##                        000000000                           000000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, 0x00, ##                        000000000                           000000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##                        00000000                             00000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##                        00000000                             00000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 61, 
        'xoffset'  => 1, 
        'xadvance' => 63, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000   
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000   
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000   
            0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000000            000000000000000000000   
            0x01, 0xFF, 0xC0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         00000000000                           00000           
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##          00000000000                         000000           
            0x00, 0xFF, 0xF0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          000000000000                        00000            
            0x00, 0x7F, 0xF0, 0x00, 0x00, 0x1F, 0x00, 0x00, ##           00000000000                       00000             
            0x00, 0x3F, 0xF8, 0x00, 0x00, 0x3F, 0x00, 0x00, ##            00000000000                     000000             
            0x00, 0x3F, 0xF8, 0x00, 0x00, 0x3E, 0x00, 0x00, ##            00000000000                     00000              
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x7E, 0x00, 0x00, ##             00000000000                   000000              
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0xFC, 0x00, 0x00, ##              00000000000                 000000               
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0xF8, 0x00, 0x00, ##              00000000000                 00000                
            0x00, 0x07, 0xFF, 0x00, 0x01, 0xF8, 0x00, 0x00, ##               00000000000               000000                
            0x00, 0x03, 0xFF, 0x80, 0x03, 0xF0, 0x00, 0x00, ##                00000000000             000000                 
            0x00, 0x03, 0xFF, 0x80, 0x03, 0xE0, 0x00, 0x00, ##                00000000000             00000                  
            0x00, 0x01, 0xFF, 0xC0, 0x07, 0xE0, 0x00, 0x00, ##                 00000000000           000000                  
            0x00, 0x00, 0xFF, 0xE0, 0x0F, 0xC0, 0x00, 0x00, ##                  00000000000         000000                   
            0x00, 0x00, 0xFF, 0xE0, 0x0F, 0x80, 0x00, 0x00, ##                  00000000000         00000                    
            0x00, 0x00, 0x7F, 0xF0, 0x1F, 0x80, 0x00, 0x00, ##                   00000000000       000000                    
            0x00, 0x00, 0x7F, 0xF8, 0x3F, 0x00, 0x00, 0x00, ##                   000000000000     000000                     
            0x00, 0x00, 0x3F, 0xF8, 0x3E, 0x00, 0x00, 0x00, ##                    00000000000     00000                      
            0x00, 0x00, 0x1F, 0xFC, 0x7E, 0x00, 0x00, 0x00, ##                     00000000000   000000                      
            0x00, 0x00, 0x1F, 0xFC, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000  000000                       
            0x00, 0x00, 0x0F, 0xFE, 0xF8, 0x00, 0x00, 0x00, ##                      00000000000 00000                        
            0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                       0000000000000000                        
            0x00, 0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##                       000000000000000                         
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                        0000000000000                          
            0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                         000000000000                          
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                         00000000000                           
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                          00000000000                          
            0x00, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##                          000000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##                           00000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xF8, 0x00, 0x00, 0x00, ##                           000000000000                        
            0x00, 0x00, 0x00, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##                          00000000000000                       
            0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##                         000000000000000                       
            0x00, 0x00, 0x01, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##                         0000000000000000                      
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##                        000000000000000000                     
            0x00, 0x00, 0x07, 0xE7, 0xFF, 0x00, 0x00, 0x00, ##                       000000  00000000000                     
            0x00, 0x00, 0x07, 0xC3, 0xFF, 0x80, 0x00, 0x00, ##                       00000    00000000000                    
            0x00, 0x00, 0x0F, 0xC3, 0xFF, 0xC0, 0x00, 0x00, ##                      000000    000000000000                   
            0x00, 0x00, 0x1F, 0x81, 0xFF, 0xC0, 0x00, 0x00, ##                     000000      00000000000                   
            0x00, 0x00, 0x1F, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                     00000        00000000000                  
            0x00, 0x00, 0x3F, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                    000000        00000000000                  
            0x00, 0x00, 0x7E, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   000000          00000000000                 
            0x00, 0x00, 0x7C, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                   00000            00000000000                
            0x00, 0x00, 0xFC, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                  000000            00000000000                
            0x00, 0x01, 0xF8, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                 000000              00000000000               
            0x00, 0x01, 0xF0, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##                 00000                00000000000              
            0x00, 0x03, 0xF0, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##                000000                00000000000              
            0x00, 0x07, 0xE0, 0x00, 0x07, 0xFF, 0x00, 0x00, ##               000000                  00000000000             
            0x00, 0x07, 0xC0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##               00000                    00000000000            
            0x00, 0x0F, 0xC0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##              000000                    00000000000            
            0x00, 0x1F, 0x80, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##             000000                      00000000000           
            0x00, 0x1F, 0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##             00000                        00000000000          
            0x00, 0x3F, 0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##            000000                        00000000000          
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##           000000                          00000000000         
            0x00, 0x7C, 0x00, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##           00000                            0000000000         
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, ##          000000                            00000000000        
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, ##         000000                              00000000000       
            0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, ##  000000000000000000000               0000000000000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, ##  000000000000000000000               0000000000000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, ##  000000000000000000000               0000000000000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0x0F, 0xFF, 0xFF, 0xF8, ##  000000000000000000000               0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 59, 
        'xoffset'  => -1, 
        'xadvance' => 57, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  000000000000000000000000                 000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  000000000000000000000000                 000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  000000000000000000000000                 000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x7F, 0xFF, 0xE0, ##  000000000000000000000000                 000000000000000000
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, ##        0000000000                               000000      
            0x01, 0xFF, 0x80, 0x00, 0x00, 0x01, 0xF0, 0x00, ##         0000000000                              00000       
            0x01, 0xFF, 0x80, 0x00, 0x00, 0x03, 0xF0, 0x00, ##         0000000000                             000000       
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x03, 0xE0, 0x00, ##          0000000000                            00000        
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x07, 0xC0, 0x00, ##          00000000000                          00000         
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##           0000000000                         000000         
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x0F, 0x80, 0x00, ##            0000000000                        00000          
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x1F, 0x80, 0x00, ##            0000000000                       000000          
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x1F, 0x00, 0x00, ##             0000000000                      00000           
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x3E, 0x00, 0x00, ##             00000000000                    00000            
            0x00, 0x0F, 0xFC, 0x00, 0x00, 0x7E, 0x00, 0x00, ##              0000000000                   000000            
            0x00, 0x07, 0xFE, 0x00, 0x00, 0x7C, 0x00, 0x00, ##               0000000000                  00000             
            0x00, 0x07, 0xFE, 0x00, 0x00, 0xFC, 0x00, 0x00, ##               0000000000                 000000             
            0x00, 0x03, 0xFF, 0x00, 0x00, 0xF8, 0x00, 0x00, ##                0000000000                00000              
            0x00, 0x03, 0xFF, 0x80, 0x01, 0xF0, 0x00, 0x00, ##                00000000000              00000               
            0x00, 0x01, 0xFF, 0x80, 0x03, 0xF0, 0x00, 0x00, ##                 0000000000             000000               
            0x00, 0x00, 0xFF, 0xC0, 0x03, 0xE0, 0x00, 0x00, ##                  0000000000            00000                
            0x00, 0x00, 0xFF, 0xC0, 0x07, 0xE0, 0x00, 0x00, ##                  0000000000           000000                
            0x00, 0x00, 0x7F, 0xE0, 0x07, 0xC0, 0x00, 0x00, ##                   0000000000          00000                 
            0x00, 0x00, 0x7F, 0xF0, 0x0F, 0x80, 0x00, 0x00, ##                   00000000000        00000                  
            0x00, 0x00, 0x3F, 0xF0, 0x1F, 0x80, 0x00, 0x00, ##                    0000000000       000000                  
            0x00, 0x00, 0x1F, 0xF8, 0x1F, 0x00, 0x00, 0x00, ##                     0000000000      00000                   
            0x00, 0x00, 0x1F, 0xF8, 0x3F, 0x00, 0x00, 0x00, ##                     0000000000     000000                   
            0x00, 0x00, 0x0F, 0xFC, 0x3E, 0x00, 0x00, 0x00, ##                      0000000000    00000                    
            0x00, 0x00, 0x0F, 0xFE, 0x7C, 0x00, 0x00, 0x00, ##                      00000000000  00000                     
            0x00, 0x00, 0x07, 0xFE, 0xFC, 0x00, 0x00, 0x00, ##                       0000000000 000000                     
            0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                       0000000000000000                      
            0x00, 0x00, 0x03, 0xFF, 0xF8, 0x00, 0x00, 0x00, ##                        000000000000000                      
            0x00, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##                         0000000000000                       
            0x00, 0x00, 0x01, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                         000000000000                        
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                          00000000000                        
            0x00, 0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                          0000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, 0x00, ##                           000000000                         
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                   0000000000000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                   0000000000000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                   0000000000000000000000000                 
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, 0x00, ##                   0000000000000000000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 53, 
        'xoffset'  => 4, 
        'xadvance' => 60, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##   000000000000000000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##   00000000000000000000000000000000000000000000000000  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##   0000000000000000000000000000000000000000000000000   
            0x7C, 0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, ##   00000                                 00000000000   
            0x7C, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, ##   00000                                00000000000    
            0x7C, 0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, ##   00000                                0000000000     
            0x7C, 0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, ##   00000                               00000000000     
            0x7C, 0x00, 0x00, 0x00, 0x0F, 0xFE, 0x00, ##   00000                              00000000000      
            0x7C, 0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, ##   00000                             00000000000       
            0x7C, 0x00, 0x00, 0x00, 0x1F, 0xF8, 0x00, ##   00000                             0000000000        
            0x7C, 0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, ##   00000                            00000000000        
            0x7C, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##   00000                           00000000000         
            0x7C, 0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##   00000                           0000000000          
            0x00, 0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##                                  00000000000          
            0x00, 0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, ##                                 00000000000           
            0x00, 0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, ##                                00000000000            
            0x00, 0x00, 0x00, 0x03, 0xFF, 0x00, 0x00, ##                                0000000000             
            0x00, 0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, ##                               00000000000             
            0x00, 0x00, 0x00, 0x0F, 0xFE, 0x00, 0x00, ##                              00000000000              
            0x00, 0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, ##                              0000000000               
            0x00, 0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, ##                             00000000000               
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                            00000000000                
            0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                           00000000000                 
            0x00, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                           0000000000                  
            0x00, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##                          00000000000                  
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                         00000000000                   
            0x00, 0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, ##                         0000000000                    
            0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, ##                        00000000000                    
            0x00, 0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, ##                       00000000000                     
            0x00, 0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, ##                       0000000000                      
            0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, ##                      0000000000                       
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                       
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                    00000000000                        
            0x00, 0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, ##                    0000000000                         
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, ##                   00000000000                         
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, ##                  00000000000                          
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                  0000000000                           
            0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, 0x00, ##                 0000000000                            
            0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, ##                00000000000                            
            0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, 0x00, ##               00000000000                             
            0x00, 0x07, 0xFE, 0x00, 0x00, 0x00, 0x00, ##               0000000000                              
            0x00, 0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, ##              00000000000                              
            0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, ##             00000000000                               
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, ##             0000000000                                
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##            0000000000                                 
            0x00, 0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, ##           00000000000                                 
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##          00000000000                                  
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##          0000000000                                   
            0x01, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0xF8, ##         00000000000                              00000
            0x03, 0xFF, 0x80, 0x00, 0x00, 0x00, 0xF8, ##        00000000000                               00000
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xF8, ##        0000000000                                00000
            0x07, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xF8, ##       0000000000                                 00000
            0x0F, 0xFE, 0x00, 0x00, 0x00, 0x00, 0xF8, ##      00000000000                                 00000
            0x1F, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xF8, ##     00000000000                                  00000
            0x1F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xF8, ##     0000000000                                   00000
            0x3F, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xF8, ##    00000000000                                   00000
            0x7F, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xF8, ##   00000000000                                    00000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##   0000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 20, 
        'xoffset'  => 7, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0x00, 0x00, ##  00000000            
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0xFF, 0xFF, 0xF0, ##  00000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 29, 
        'xoffset'  => 0, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFE, 0x00, 0x00, 0x00, ##  0000000                      
            0xFE, 0x00, 0x00, 0x00, ##  0000000                      
            0x7E, 0x00, 0x00, 0x00, ##   000000                      
            0x7F, 0x00, 0x00, 0x00, ##   0000000                     
            0x7F, 0x00, 0x00, 0x00, ##   0000000                     
            0x3F, 0x00, 0x00, 0x00, ##    000000                     
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x3F, 0x80, 0x00, 0x00, ##    0000000                    
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                   
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                   
            0x1F, 0xC0, 0x00, 0x00, ##     0000000                   
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x0F, 0xE0, 0x00, 0x00, ##      0000000                  
            0x07, 0xE0, 0x00, 0x00, ##       000000                  
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x07, 0xF0, 0x00, 0x00, ##       0000000                 
            0x03, 0xF0, 0x00, 0x00, ##        000000                 
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x03, 0xF8, 0x00, 0x00, ##        0000000                
            0x01, 0xF8, 0x00, 0x00, ##         000000                
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x01, 0xFC, 0x00, 0x00, ##         0000000               
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0xFE, 0x00, 0x00, ##          0000000              
            0x00, 0x7E, 0x00, 0x00, ##           000000              
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0x7F, 0x00, 0x00, ##           0000000             
            0x00, 0x3F, 0x00, 0x00, ##            000000             
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x3F, 0x80, 0x00, ##            0000000            
            0x00, 0x1F, 0x80, 0x00, ##             000000            
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x1F, 0xC0, 0x00, ##             0000000           
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x0F, 0xE0, 0x00, ##              0000000          
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x07, 0xF0, 0x00, ##               0000000         
            0x00, 0x03, 0xF0, 0x00, ##                000000         
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x03, 0xF8, 0x00, ##                0000000        
            0x00, 0x01, 0xF8, 0x00, ##                 000000        
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x01, 0xFC, 0x00, ##                 0000000       
            0x00, 0x00, 0xFC, 0x00, ##                  000000       
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x00, 0xFE, 0x00, ##                  0000000      
            0x00, 0x00, 0x7F, 0x00, ##                   0000000     
            0x00, 0x00, 0x7F, 0x00, ##                   0000000     
            0x00, 0x00, 0x7F, 0x00, ##                   0000000     
            0x00, 0x00, 0x3F, 0x00, ##                    000000     
            0x00, 0x00, 0x3F, 0x80, ##                    0000000    
            0x00, 0x00, 0x3F, 0x80, ##                    0000000    
            0x00, 0x00, 0x1F, 0x80, ##                     000000    
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000   
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000   
            0x00, 0x00, 0x0F, 0xC0, ##                      000000   
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x0F, 0xE0, ##                      0000000  
            0x00, 0x00, 0x07, 0xF0, ##                       0000000 
            0x00, 0x00, 0x07, 0xF0, ##                       0000000 
            0x00, 0x00, 0x07, 0xF0, ##                       0000000 
            0x00, 0x00, 0x03, 0xF8, ##                        0000000
            0x00, 0x00, 0x03, 0xF8, ##                        0000000
            0x00, 0x00, 0x03, 0xF8, ##                        0000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 19, 
        'xoffset'  => 7, 
        'xadvance' => 33, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0x00, 0x1F, 0xE0, ##             00000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0xFF, 0xFF, 0xE0, ##  0000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 55, 
        'xoffset'  => 9, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x01, 0xFF, 0x00, 0x00, 0x00, ##                         000000000                       
            0x00, 0x00, 0x03, 0xFF, 0x80, 0x00, 0x00, ##                        00000000000                      
            0x00, 0x00, 0x07, 0xFF, 0xC0, 0x00, 0x00, ##                       0000000000000                     
            0x00, 0x00, 0x0F, 0xFF, 0xE0, 0x00, 0x00, ##                      000000000000000                    
            0x00, 0x00, 0x1F, 0xFF, 0xF0, 0x00, 0x00, ##                     00000000000000000                   
            0x00, 0x00, 0x3F, 0xFF, 0xF8, 0x00, 0x00, ##                    0000000000000000000                  
            0x00, 0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x00, ##                   000000000000000000000                 
            0x00, 0x00, 0xFF, 0xFF, 0xFE, 0x00, 0x00, ##                  00000000000000000000000                
            0x00, 0x01, 0xFF, 0xC7, 0xFF, 0x00, 0x00, ##                 00000000000   00000000000               
            0x00, 0x03, 0xFF, 0x83, 0xFF, 0x80, 0x00, ##                00000000000     00000000000              
            0x00, 0x07, 0xFF, 0x01, 0xFF, 0xC0, 0x00, ##               00000000000       00000000000             
            0x00, 0x0F, 0xFE, 0x00, 0xFF, 0xE0, 0x00, ##              00000000000         00000000000            
            0x00, 0x1F, 0xF8, 0x00, 0x3F, 0xF0, 0x00, ##             0000000000             0000000000           
            0x00, 0x3F, 0xF0, 0x00, 0x1F, 0xF8, 0x00, ##            0000000000               0000000000          
            0x00, 0x7F, 0xE0, 0x00, 0x0F, 0xFC, 0x00, ##           0000000000                 0000000000         
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xFE, 0x00, ##          000000000                    0000000000        
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         000000000                       00000000        
            0x03, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x00, ##        000000000                         00000000       
            0x07, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x80, ##       000000000                           00000000      
            0x07, 0xF0, 0x00, 0x00, 0x00, 0x1F, 0xC0, ##       0000000                               0000000     
            0x0F, 0xE0, 0x00, 0x00, 0x00, 0x0F, 0xE0, ##      0000000                                 0000000    
            0x1F, 0xC0, 0x00, 0x00, 0x00, 0x07, 0xF0, ##     0000000                                   0000000   
            0x3F, 0x80, 0x00, 0x00, 0x00, 0x03, 0xF8, ##    0000000                                     0000000  
            0x7E, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, ##   000000                                         000000 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 44, 
        'xoffset'  => 0, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, ##  00000000000000000000000000000000000000000000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 20, 
        'xoffset'  => 7, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x7F, 0x80, 0x00, ##   00000000           
            0x3F, 0xC0, 0x00, ##    00000000          
            0x3F, 0xC0, 0x00, ##    00000000          
            0x1F, 0xE0, 0x00, ##     00000000         
            0x0F, 0xF0, 0x00, ##      00000000        
            0x07, 0xF0, 0x00, ##       0000000        
            0x03, 0xF8, 0x00, ##        0000000       
            0x01, 0xFC, 0x00, ##         0000000      
            0x00, 0xFC, 0x00, ##          000000      
            0x00, 0x7E, 0x00, ##           000000     
            0x00, 0x3F, 0x00, ##            000000    
            0x00, 0x1F, 0x80, ##             000000   
            0x00, 0x0F, 0x80, ##              00000   
            0x00, 0x0F, 0xC0, ##              000000  
            0x00, 0x07, 0xE0, ##               000000 
            0x00, 0x03, 0xE0, ##                00000 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 45, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFF, 0x00, 0x00, 0x00, ##               00000000000                     
            0x00, 0x7F, 0xFF, 0xF0, 0x00, 0x00, ##           0000000000000000000                 
            0x03, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##        000000000000000000000000               
            0x0F, 0xFF, 0xFF, 0xFF, 0x00, 0x00, ##      0000000000000000000000000000             
            0x0F, 0xFE, 0x03, 0xFF, 0x80, 0x00, ##      00000000000       00000000000            
            0x0F, 0xF0, 0x00, 0x7F, 0xC0, 0x00, ##      00000000             000000000           
            0x0F, 0xE0, 0x00, 0x1F, 0xE0, 0x00, ##      0000000                00000000          
            0x0F, 0xC0, 0x00, 0x0F, 0xE0, 0x00, ##      000000                  0000000          
            0x0F, 0x80, 0x00, 0x0F, 0xF0, 0x00, ##      00000                   00000000         
            0x0F, 0x80, 0x00, 0x07, 0xF0, 0x00, ##      00000                    0000000         
            0x0F, 0x00, 0x00, 0x07, 0xF8, 0x00, ##      0000                     00000000        
            0x0F, 0x00, 0x00, 0x03, 0xF8, 0x00, ##      0000                      0000000        
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, ##                                0000000        
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000       
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000       
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000       
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000       
            0x00, 0x00, 0x00, 0x03, 0xFC, 0x00, ##                                00000000       
            0x00, 0x07, 0xFF, 0xFF, 0xFC, 0x00, ##               0000000000000000000000000       
            0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, ##           00000000000000000000000000000       
            0x01, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##         0000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##        00000000000000000000000000000000       
            0x0F, 0xFF, 0x00, 0x03, 0xFC, 0x00, ##      000000000000              00000000       
            0x1F, 0xF8, 0x00, 0x03, 0xFC, 0x00, ##     0000000000                 00000000       
            0x1F, 0xF0, 0x00, 0x03, 0xFC, 0x00, ##     000000000                  00000000       
            0x3F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##    000000000                   00000000       
            0x7F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##   000000000                    00000000       
            0x7F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##   000000000                    00000000       
            0x7F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##   000000000                    00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  000000000                     00000000       
            0xFF, 0x80, 0x00, 0x07, 0xFC, 0x00, ##  000000000                    000000000       
            0x7F, 0xC0, 0x00, 0x07, 0xFC, 0x00, ##   000000000                   000000000       
            0x7F, 0xC0, 0x00, 0x07, 0xFC, 0x00, ##   000000000                   000000000       
            0x7F, 0xE0, 0x00, 0x0F, 0xFC, 0x00, ##   0000000000                 0000000000       
            0x3F, 0xE0, 0x00, 0x1F, 0xFC, 0x00, ##    000000000                00000000000       
            0x3F, 0xF0, 0x00, 0x3F, 0xFC, 0x00, ##    0000000000              000000000000       
            0x1F, 0xFC, 0x00, 0x7B, 0xFF, 0xF8, ##     00000000000           0000 000000000000000
            0x0F, 0xFF, 0x01, 0xF3, 0xFF, 0xF8, ##      000000000000       00000  000000000000000
            0x07, 0xFF, 0xFF, 0xE3, 0xFF, 0xF8, ##       0000000000000000000000   000000000000000
            0x03, 0xFF, 0xFF, 0xC3, 0xFF, 0xF8, ##        00000000000000000000    000000000000000
            0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##          0000000000000000                     
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x00, ##             0000000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 48, 
        'xoffset'  => 3, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                 
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                 
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                 
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, ##         00000000                                 
            0x01, 0xFE, 0x00, 0x7F, 0xC0, 0x00, ##         00000000          000000000              
            0x01, 0xFE, 0x03, 0xFF, 0xF0, 0x00, ##         00000000       00000000000000            
            0x01, 0xFE, 0x0F, 0xFF, 0xFC, 0x00, ##         00000000     000000000000000000          
            0x01, 0xFE, 0x1F, 0xFF, 0xFF, 0x00, ##         00000000    000000000000000000000        
            0x01, 0xFE, 0x3F, 0xFF, 0xFF, 0x80, ##         00000000   00000000000000000000000       
            0x01, 0xFE, 0x7E, 0x03, 0xFF, 0xC0, ##         00000000  000000       000000000000      
            0x01, 0xFE, 0xF8, 0x00, 0x7F, 0xE0, ##         00000000 00000            0000000000     
            0x01, 0xFF, 0xF0, 0x00, 0x3F, 0xE0, ##         0000000000000              000000000     
            0x01, 0xFF, 0xE0, 0x00, 0x1F, 0xF0, ##         000000000000                000000000    
            0x01, 0xFF, 0xC0, 0x00, 0x0F, 0xF8, ##         00000000000                  000000000   
            0x01, 0xFF, 0x80, 0x00, 0x0F, 0xF8, ##         0000000000                   000000000   
            0x01, 0xFF, 0x80, 0x00, 0x07, 0xFC, ##         0000000000                    000000000  
            0x01, 0xFF, 0x00, 0x00, 0x07, 0xFC, ##         000000000                     000000000  
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFC, ##         000000000                      00000000  
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, ##         000000000                      000000000 
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, ##         000000000                      000000000 
            0x01, 0xFE, 0x00, 0x00, 0x03, 0xFE, ##         00000000                       000000000 
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFE, ##         00000000                        00000000 
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, ##         00000000                        000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFE, ##         00000000                        00000000 
            0x01, 0xFE, 0x00, 0x00, 0x03, 0xFE, ##         00000000                       000000000 
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, ##         000000000                      000000000 
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, ##         000000000                      000000000 
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFC, ##         000000000                      00000000  
            0x01, 0xFF, 0x00, 0x00, 0x07, 0xFC, ##         000000000                     000000000  
            0x01, 0xFF, 0x80, 0x00, 0x07, 0xFC, ##         0000000000                    000000000  
            0x01, 0xFF, 0x80, 0x00, 0x0F, 0xF8, ##         0000000000                   000000000   
            0x01, 0xFF, 0xC0, 0x00, 0x0F, 0xF8, ##         00000000000                  000000000   
            0x01, 0xFF, 0xE0, 0x00, 0x1F, 0xF0, ##         000000000000                000000000    
            0x01, 0xFE, 0xF0, 0x00, 0x3F, 0xE0, ##         00000000 0000              000000000     
            0x01, 0xFE, 0xF8, 0x00, 0x7F, 0xE0, ##         00000000 00000            0000000000     
            0xFF, 0xFE, 0x7E, 0x03, 0xFF, 0xC0, ##  000000000000000  000000       000000000000      
            0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x80, ##  000000000000000   00000000000000000000000       
            0xFF, 0xFE, 0x1F, 0xFF, 0xFF, 0x00, ##  000000000000000    000000000000000000000        
            0xFF, 0xFE, 0x0F, 0xFF, 0xFC, 0x00, ##  000000000000000     000000000000000000          
            0x00, 0x00, 0x03, 0xFF, 0xF8, 0x00, ##                        000000000000000           
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##                           000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 40, 
        'xoffset'  => 4, 
        'xadvance' => 48, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xF0, 0x00, ##                   00000000000            
            0x00, 0x07, 0xFF, 0xFF, 0x80, ##               00000000000000000000       
            0x00, 0x1F, 0xFF, 0xFF, 0xF0, ##             0000000000000000000000000    
            0x00, 0x3F, 0xFF, 0xFF, 0xFC, ##            0000000000000000000000000000  
            0x00, 0xFF, 0xC0, 0x3F, 0xFE, ##          0000000000        0000000000000 
            0x01, 0xFF, 0x00, 0x07, 0xFE, ##         000000000             0000000000 
            0x03, 0xFC, 0x00, 0x03, 0xFE, ##        00000000                000000000 
            0x07, 0xF8, 0x00, 0x01, 0xFE, ##       00000000                  00000000 
            0x0F, 0xF8, 0x00, 0x00, 0xFE, ##      000000000                   0000000 
            0x0F, 0xF0, 0x00, 0x00, 0x7E, ##      00000000                     000000 
            0x1F, 0xE0, 0x00, 0x00, 0x7E, ##     00000000                      000000 
            0x1F, 0xE0, 0x00, 0x00, 0x7E, ##     00000000                      000000 
            0x3F, 0xE0, 0x00, 0x00, 0x3E, ##    000000000                       00000 
            0x3F, 0xC0, 0x00, 0x00, 0x3E, ##    00000000                        00000 
            0x7F, 0xC0, 0x00, 0x00, 0x3E, ##   000000000                        00000 
            0x7F, 0xC0, 0x00, 0x00, 0x3E, ##   000000000                        00000 
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                               
            0x7F, 0x80, 0x00, 0x00, 0x00, ##   00000000                               
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x00, ##   000000000                              
            0x7F, 0xC0, 0x00, 0x00, 0x3F, ##   000000000                        000000
            0x3F, 0xC0, 0x00, 0x00, 0x3F, ##    00000000                        000000
            0x3F, 0xE0, 0x00, 0x00, 0x3F, ##    000000000                       000000
            0x1F, 0xE0, 0x00, 0x00, 0x7F, ##     00000000                      0000000
            0x1F, 0xE0, 0x00, 0x00, 0x7E, ##     00000000                      000000 
            0x0F, 0xF0, 0x00, 0x00, 0xFE, ##      00000000                    0000000 
            0x0F, 0xF8, 0x00, 0x00, 0xFC, ##      000000000                   000000  
            0x07, 0xF8, 0x00, 0x01, 0xF8, ##       00000000                  000000   
            0x03, 0xFC, 0x00, 0x03, 0xF8, ##        00000000                0000000   
            0x01, 0xFF, 0x00, 0x0F, 0xF0, ##         000000000            00000000    
            0x00, 0xFF, 0xC0, 0x3F, 0xE0, ##          0000000000        000000000     
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##           0000000000000000000000000      
            0x00, 0x1F, 0xFF, 0xFF, 0x00, ##             000000000000000000000        
            0x00, 0x07, 0xFF, 0xFC, 0x00, ##               00000000000000000          
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000             
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 49, 
        'xoffset'  => 4, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##                            000000000000000        
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##                            000000000000000        
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##                            000000000000000        
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0x80, 0x00, ##                            000000000000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x03, 0xFE, 0x00, 0x7F, 0x80, 0x00, ##                000000000          00000000        
            0x00, 0x0F, 0xFF, 0xC0, 0x7F, 0x80, 0x00, ##              00000000000000       00000000        
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0x80, 0x00, ##            000000000000000000     00000000        
            0x00, 0xFF, 0xFF, 0xF8, 0x7F, 0x80, 0x00, ##          000000000000000000000    00000000        
            0x01, 0xFF, 0xFF, 0xFC, 0x7F, 0x80, 0x00, ##         00000000000000000000000   00000000        
            0x03, 0xFF, 0xC0, 0x7E, 0x7F, 0x80, 0x00, ##        000000000000       000000  00000000        
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x07, 0xFC, 0x00, 0x0F, 0x7F, 0x80, 0x00, ##       000000000              0000 00000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    000000000                     000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    000000000                     000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x07, 0xFC, 0x00, 0x0F, 0x7F, 0x80, 0x00, ##       000000000              0000 00000000        
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x03, 0xFF, 0x80, 0x7E, 0x7F, 0xFF, 0x80, ##        00000000000        000000  0000000000000000
            0x01, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0x80, ##         00000000000000000000000   0000000000000000
            0x00, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0x80, ##          000000000000000000000    0000000000000000
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0xFF, 0x80, ##            000000000000000000     0000000000000000
            0x00, 0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##             000000000000000                       
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                000000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 43, 
        'xoffset'  => 4, 
        'xadvance' => 51, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000            
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000          
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000         
            0x00, 0xFF, 0xC0, 0x7F, 0xF0, 0x00, ##          0000000000       00000000000       
            0x01, 0xFF, 0x00, 0x0F, 0xF8, 0x00, ##         000000000            000000000      
            0x03, 0xFC, 0x00, 0x07, 0xFC, 0x00, ##        00000000               000000000     
            0x07, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##       00000000                 000000000    
            0x0F, 0xF8, 0x00, 0x01, 0xFE, 0x00, ##      000000000                  00000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000   
            0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x00, ##     00000000                     00000000   
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##    000000000                      00000000  
            0x3F, 0xC0, 0x00, 0x00, 0x7F, 0xC0, ##    00000000                       000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##   000000000                        00000000 
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##   00000000                         00000000 
            0x7F, 0x80, 0x00, 0x00, 0x3F, 0xC0, ##   00000000                         00000000 
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000
            0xFF, 0x80, 0x00, 0x00, 0x3F, 0xE0, ##  000000000                         000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##  0000000000000000000000000000000000000000000
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0xFF, 0x80, 0x00, 0x00, 0x00, 0x00, ##  000000000                                  
            0x7F, 0x80, 0x00, 0x00, 0x00, 0x00, ##   00000000                                  
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                 
            0x7F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##   000000000                                 
            0x7F, 0xC0, 0x00, 0x00, 0x0F, 0xC0, ##   000000000                          000000 
            0x3F, 0xC0, 0x00, 0x00, 0x0F, 0xC0, ##    00000000                          000000 
            0x3F, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##    000000000                        000000  
            0x1F, 0xE0, 0x00, 0x00, 0x1F, 0x80, ##     00000000                        000000  
            0x1F, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##     000000000                      0000000  
            0x0F, 0xF0, 0x00, 0x00, 0x3F, 0x00, ##      00000000                      000000   
            0x0F, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##      000000000                    0000000   
            0x07, 0xFC, 0x00, 0x00, 0xFE, 0x00, ##       000000000                  0000000    
            0x03, 0xFE, 0x00, 0x01, 0xFC, 0x00, ##        000000000                0000000     
            0x01, 0xFF, 0x00, 0x07, 0xF8, 0x00, ##         000000000             00000000      
            0x00, 0xFF, 0xE0, 0x1F, 0xF0, 0x00, ##          00000000000        000000000       
            0x00, 0x3F, 0xFF, 0xFF, 0xE0, 0x00, ##            0000000000000000000000000        
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000          
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000            
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 34, 
        'xoffset'  => 3, 
        'xadvance' => 32, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x3F, 0xF0, 0x00, ##                    0000000000      
            0x00, 0x01, 0xFF, 0xFF, 0x00, ##                 00000000000000000  
            0x00, 0x07, 0xFF, 0xFF, 0xC0, ##               000000000000000000000
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, ##              0000000000000000000000
            0x00, 0x1F, 0xF0, 0x3F, 0xC0, ##             000000000      00000000
            0x00, 0x3F, 0xC0, 0x0F, 0xC0, ##            00000000          000000
            0x00, 0x7F, 0x80, 0x07, 0xC0, ##           00000000            00000
            0x00, 0x7F, 0x00, 0x07, 0xC0, ##           0000000             00000
            0x00, 0xFF, 0x00, 0x03, 0xC0, ##          00000000              0000
            0x00, 0xFF, 0x00, 0x03, 0xC0, ##          00000000              0000
            0x00, 0xFE, 0x00, 0x03, 0xC0, ##          0000000               0000
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000      
            0xFF, 0xFF, 0xFF, 0xF0, 0x00, ##  0000000000000000000000000000      
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                   
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000         
            0xFF, 0xFF, 0xFF, 0x80, 0x00, ##  0000000000000000000000000         
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 49, 
        'xoffset'  => 4, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                000000000                          
            0x00, 0x0F, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##              00000000000000                       
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0xFF, 0x80, ##            000000000000000000     0000000000000000
            0x00, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0x80, ##          000000000000000000000    0000000000000000
            0x01, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0x80, ##         00000000000000000000000   0000000000000000
            0x03, 0xFF, 0xC0, 0xFE, 0x7F, 0xFF, 0x80, ##        000000000000      0000000  0000000000000000
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x07, 0xFC, 0x00, 0x0F, 0x7F, 0x80, 0x00, ##       000000000              0000 00000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    000000000                     000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x07, 0xFC, 0x00, 0x0F, 0x7F, 0x80, 0x00, ##       000000000              0000 00000000        
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x03, 0xFF, 0xC0, 0x7E, 0x7F, 0x80, 0x00, ##        000000000000       000000  00000000        
            0x01, 0xFF, 0xFF, 0xFC, 0x7F, 0x80, 0x00, ##         00000000000000000000000   00000000        
            0x00, 0xFF, 0xFF, 0xF8, 0x7F, 0x80, 0x00, ##          000000000000000000000    00000000        
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0x80, 0x00, ##            000000000000000000     00000000        
            0x00, 0x0F, 0xFF, 0xC0, 0x7F, 0x80, 0x00, ##              00000000000000       00000000        
            0x00, 0x03, 0xFE, 0x00, 0x7F, 0x80, 0x00, ##                000000000          00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                                  00000000         
            0x00, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##                                  00000000         
            0x0F, 0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, ##      0000                        00000000         
            0x0F, 0x80, 0x00, 0x00, 0xFF, 0x00, 0x00, ##      00000                       00000000         
            0x0F, 0x80, 0x00, 0x01, 0xFE, 0x00, 0x00, ##      00000                      00000000          
            0x0F, 0x80, 0x00, 0x01, 0xFE, 0x00, 0x00, ##      00000                      00000000          
            0x0F, 0xC0, 0x00, 0x03, 0xFC, 0x00, 0x00, ##      000000                    00000000           
            0x0F, 0xC0, 0x00, 0x07, 0xF8, 0x00, 0x00, ##      000000                   00000000            
            0x0F, 0xE0, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##      0000000                 000000000            
            0x0F, 0xF8, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##      000000000              000000000             
            0x0F, 0xFE, 0x00, 0xFF, 0xE0, 0x00, 0x00, ##      00000000000         00000000000              
            0x0F, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##      00000000000000000000000000000                
            0x03, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, ##        00000000000000000000000000                 
            0x00, 0x7F, 0xFF, 0xFC, 0x00, 0x00, 0x00, ##           000000000000000000000                   
            0x00, 0x03, 0xFF, 0xC0, 0x00, 0x00, 0x00, ##                000000000000                       
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 50, 
        'xoffset'  => 4, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x7F, 0x80, 0x00, 0x00, ##         00000000          00000000                 
            0x01, 0xFE, 0x03, 0xFF, 0xF0, 0x00, 0x00, ##         00000000       00000000000000              
            0x01, 0xFE, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##         00000000     000000000000000000            
            0x01, 0xFE, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##         00000000    00000000000000000000           
            0x01, 0xFE, 0x3F, 0xFF, 0xFF, 0x00, 0x00, ##         00000000   0000000000000000000000          
            0x01, 0xFE, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##         00000000  00000000000000000000000          
            0x01, 0xFE, 0x7E, 0x07, 0xFF, 0x80, 0x00, ##         00000000  000000      000000000000         
            0x01, 0xFE, 0xF0, 0x01, 0xFF, 0x80, 0x00, ##         00000000 0000           0000000000         
            0x01, 0xFF, 0xE0, 0x00, 0x7F, 0xC0, 0x00, ##         000000000000              000000000        
            0x01, 0xFF, 0xC0, 0x00, 0x7F, 0xC0, 0x00, ##         00000000000               000000000        
            0x01, 0xFF, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##         00000000000                00000000        
            0x01, 0xFF, 0x80, 0x00, 0x3F, 0xC0, 0x00, ##         0000000000                 00000000        
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         000000000                  000000000       
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         000000000                  000000000       
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         000000000                   00000000       
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         000000000                   00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 23, 
        'xoffset'  => 3, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x70, 0x00, ##           000           
            0x01, 0xFC, 0x00, ##         0000000         
            0x01, 0xFC, 0x00, ##         0000000         
            0x03, 0xFE, 0x00, ##        000000000        
            0x03, 0xFE, 0x00, ##        000000000        
            0x03, 0xFE, 0x00, ##        000000000        
            0x03, 0xFE, 0x00, ##        000000000        
            0x01, 0xFC, 0x00, ##         0000000         
            0x01, 0xFC, 0x00, ##         0000000         
            0x00, 0x70, 0x00, ##           000           
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0x00, 0x00, 0x00, ##                         
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 27, 
        'xoffset'  => -8, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0x00, ##                      0000   
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x7F, 0xE0, ##                   0000000000
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x3F, 0xC0, ##                    00000000 
            0x00, 0x00, 0x0F, 0x00, ##                      0000   
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x00, 0x00, 0x00, ##                             
            0x00, 0x0F, 0xFF, 0xE0, ##              000000000000000
            0x00, 0x0F, 0xFF, 0xE0, ##              000000000000000
            0x00, 0x0F, 0xFF, 0xE0, ##              000000000000000
            0x00, 0x0F, 0xFF, 0xE0, ##              000000000000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0x00, 0x00, 0x1F, 0xE0, ##                     00000000
            0xF0, 0x00, 0x1F, 0xE0, ##  0000               00000000
            0xF0, 0x00, 0x1F, 0xC0, ##  0000               0000000 
            0xF0, 0x00, 0x3F, 0xC0, ##  0000              00000000 
            0xF8, 0x00, 0x3F, 0xC0, ##  00000             00000000 
            0xF8, 0x00, 0x3F, 0x80, ##  00000             0000000  
            0xFC, 0x00, 0x7F, 0x80, ##  000000           00000000  
            0xFE, 0x00, 0xFF, 0x00, ##  0000000         00000000   
            0xFF, 0x03, 0xFE, 0x00, ##  00000000      000000000    
            0xFF, 0xFF, 0xFC, 0x00, ##  0000000000000000000000     
            0xFF, 0xFF, 0xF8, 0x00, ##  000000000000000000000      
            0x1F, 0xFF, 0xE0, 0x00, ##     0000000000000000        
            0x03, 0xFF, 0x00, 0x00, ##        0000000000           
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 50, 
        'xoffset'  => 3, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##  000000000000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                   
            0x01, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##         00000000             00000000000000000000  
            0x01, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##         00000000             00000000000000000000  
            0x01, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##         00000000             00000000000000000000  
            0x01, 0xFE, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##         00000000             00000000000000000000  
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0x00, 0x00, ##         00000000                  0000000          
            0x01, 0xFE, 0x00, 0x00, 0xFE, 0x00, 0x00, ##         00000000                 0000000           
            0x01, 0xFE, 0x00, 0x01, 0xFC, 0x00, 0x00, ##         00000000                0000000            
            0x01, 0xFE, 0x00, 0x03, 0xF8, 0x00, 0x00, ##         00000000               0000000             
            0x01, 0xFE, 0x00, 0x07, 0xF0, 0x00, 0x00, ##         00000000              0000000              
            0x01, 0xFE, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##         00000000             0000000               
            0x01, 0xFE, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##         00000000            0000000                
            0x01, 0xFE, 0x00, 0x3F, 0x80, 0x00, 0x00, ##         00000000           0000000                 
            0x01, 0xFE, 0x00, 0x7F, 0x00, 0x00, 0x00, ##         00000000          0000000                  
            0x01, 0xFE, 0x00, 0xFC, 0x00, 0x00, 0x00, ##         00000000         000000                    
            0x01, 0xFE, 0x01, 0xF8, 0x00, 0x00, 0x00, ##         00000000        000000                     
            0x01, 0xFE, 0x03, 0xF0, 0x00, 0x00, 0x00, ##         00000000       000000                      
            0x01, 0xFE, 0x07, 0xE0, 0x00, 0x00, 0x00, ##         00000000      000000                       
            0x01, 0xFE, 0x0F, 0xF0, 0x00, 0x00, 0x00, ##         00000000     00000000                      
            0x01, 0xFE, 0x1F, 0xF0, 0x00, 0x00, 0x00, ##         00000000    000000000                      
            0x01, 0xFE, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##         00000000   00000000000                     
            0x01, 0xFE, 0x7F, 0xFC, 0x00, 0x00, 0x00, ##         00000000  0000000000000                    
            0x01, 0xFE, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##         00000000 000000000000000                   
            0x01, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, ##         000000000000000000000000                   
            0x01, 0xFF, 0xF3, 0xFF, 0x00, 0x00, 0x00, ##         0000000000000  0000000000                  
            0x01, 0xFF, 0xE1, 0xFF, 0x80, 0x00, 0x00, ##         000000000000    0000000000                 
            0x01, 0xFF, 0x80, 0xFF, 0x80, 0x00, 0x00, ##         0000000000       000000000                 
            0x01, 0xFF, 0x00, 0xFF, 0xC0, 0x00, 0x00, ##         000000000        0000000000                
            0x01, 0xFE, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##         00000000          0000000000               
            0x01, 0xFE, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##         00000000           000000000               
            0x01, 0xFE, 0x00, 0x3F, 0xF0, 0x00, 0x00, ##         00000000           0000000000              
            0x01, 0xFE, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##         00000000            0000000000             
            0x01, 0xFE, 0x00, 0x0F, 0xF8, 0x00, 0x00, ##         00000000             000000000             
            0x01, 0xFE, 0x00, 0x07, 0xFC, 0x00, 0x00, ##         00000000              000000000            
            0x01, 0xFE, 0x00, 0x07, 0xFE, 0x00, 0x00, ##         00000000              0000000000           
            0x01, 0xFE, 0x00, 0x03, 0xFE, 0x00, 0x00, ##         00000000               000000000           
            0x01, 0xFE, 0x00, 0x01, 0xFF, 0x00, 0x00, ##         00000000                000000000          
            0x01, 0xFE, 0x00, 0x01, 0xFF, 0x80, 0x00, ##         00000000                0000000000         
            0x01, 0xFE, 0x00, 0x00, 0xFF, 0xC0, 0x00, ##         00000000                 0000000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xC0, 0x00, ##         00000000                  000000000        
            0x01, 0xFE, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##         00000000                  0000000000       
            0x01, 0xFE, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##         00000000                   0000000000      
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 23, 
        'xoffset'  => 2, 
        'xadvance' => 28, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0xFF, 0xFE, 0x00, ##  000000000000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0x01, 0xFE, 0x00, ##         00000000        
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0xFF, 0xFF, 0xFE, ##  00000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 77, 
        'xoffset'  => 4, 
        'xadvance' => 83, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00, ##                           0000000                    00000000                 
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                        0000000000000              00000000000000              
            0x00, 0x00, 0x07, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000      0000000000000000           0000000000000000             
            0x00, 0x00, 0x1F, 0xFF, 0xFC, 0x03, 0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000    0000000000000000000        00000000000000000000           
            0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x07, 0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000   000000000000000000000      000000000000000000000           
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0x07, 0xFF, 0xFF, 0xE0, 0x00, ##  000000000000000  00000000000000000000000     0000000000000000000000          
            0x00, 0x00, 0x7C, 0x07, 0xFF, 0x0F, 0xC0, 0xFF, 0xF0, 0x00, ##         00000000  00000       00000000000    000000      000000000000         
            0x00, 0x00, 0xF0, 0x01, 0xFF, 0x9E, 0x00, 0x3F, 0xF0, 0x00, ##         00000000 0000           0000000000  0000           0000000000         
            0x00, 0x00, 0xE0, 0x00, 0xFF, 0x9C, 0x00, 0x0F, 0xF8, 0x00, ##         00000000 000             000000000  000              000000000        
            0x00, 0x00, 0xC0, 0x00, 0xFF, 0xF8, 0x00, 0x0F, 0xF8, 0x00, ##         00000000000              0000000000000               000000000        
            0x00, 0x00, 0x80, 0x00, 0x7F, 0xF8, 0x00, 0x07, 0xF8, 0x00, ##         0000000000                000000000000                00000000        
            0x00, 0x00, 0x80, 0x00, 0x7F, 0xF0, 0x00, 0x07, 0xF8, 0x00, ##         0000000000                00000000000                 00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0xF0, 0x00, 0x07, 0xFC, 0x00, ##         000000000                 00000000000                 000000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##         000000000                  000000000                   00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##         000000000                  000000000                   00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xE0, 0x00, 0x03, 0xFC, 0x00, ##         000000000                  000000000                   00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##         00000000                   00000000                    00000000       
            0x00, 0x00, 0xFC, 0x0F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000      000000000000000000000      0000000000000000000000
            0x00, 0x00, 0xFC, 0x0F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000      000000000000000000000      0000000000000000000000
            0x00, 0x00, 0xFC, 0x0F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000      000000000000000000000      0000000000000000000000
            0x00, 0x00, 0xFC, 0x0F, 0xFF, 0xFF, 0x81, 0xFF, 0xFF, 0xF8, ##  0000000000000000000000      000000000000000000000      0000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 50, 
        'xoffset'  => 4, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, ##                           00000000                 
            0x00, 0x00, 0x03, 0xFF, 0xF0, 0x00, 0x00, ##                        00000000000000              
            0xFF, 0xFE, 0x0F, 0xFF, 0xFC, 0x00, 0x00, ##  000000000000000     000000000000000000            
            0xFF, 0xFE, 0x1F, 0xFF, 0xFE, 0x00, 0x00, ##  000000000000000    00000000000000000000           
            0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000   0000000000000000000000          
            0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000  00000000000000000000000          
            0x01, 0xFE, 0x7E, 0x07, 0xFF, 0x80, 0x00, ##         00000000  000000      000000000000         
            0x01, 0xFE, 0xF0, 0x01, 0xFF, 0x80, 0x00, ##         00000000 0000           0000000000         
            0x01, 0xFF, 0xE0, 0x00, 0xFF, 0xC0, 0x00, ##         000000000000             0000000000        
            0x01, 0xFF, 0xC0, 0x00, 0x7F, 0xC0, 0x00, ##         00000000000               000000000        
            0x01, 0xFF, 0xC0, 0x00, 0x3F, 0xC0, 0x00, ##         00000000000                00000000        
            0x01, 0xFF, 0x80, 0x00, 0x3F, 0xC0, 0x00, ##         0000000000                 00000000        
            0x01, 0xFF, 0x80, 0x00, 0x3F, 0xE0, 0x00, ##         0000000000                 000000000       
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         000000000                  000000000       
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         000000000                   00000000       
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         000000000                   00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000       
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0xFF, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xC0, ##  0000000000000000000000      0000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 44, 
        'xoffset'  => 4, 
        'xadvance' => 52, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000           
            0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##            000000000000000000000000          
            0x00, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##          0000000000        0000000000        
            0x01, 0xFF, 0x00, 0x0F, 0xF8, 0x00, ##         000000000            000000000       
            0x03, 0xFE, 0x00, 0x07, 0xFC, 0x00, ##        000000000              000000000      
            0x07, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##       00000000                 000000000     
            0x0F, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##      000000000                  000000000    
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x80, ##     00000000                     000000000   
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0xFF, 0x80, 0x00, 0x00, 0x1F, 0xF0, ##  000000000                          000000000
            0x7F, 0x80, 0x00, 0x00, 0x1F, 0xE0, ##   00000000                          00000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x7F, 0xC0, 0x00, 0x00, 0x3F, 0xE0, ##   000000000                        000000000 
            0x3F, 0xC0, 0x00, 0x00, 0x3F, 0xC0, ##    00000000                        00000000  
            0x3F, 0xE0, 0x00, 0x00, 0x7F, 0xC0, ##    000000000                      000000000  
            0x1F, 0xE0, 0x00, 0x00, 0x7F, 0x80, ##     00000000                      00000000   
            0x1F, 0xE0, 0x00, 0x00, 0xFF, 0x80, ##     00000000                     000000000   
            0x0F, 0xF0, 0x00, 0x00, 0xFF, 0x00, ##      00000000                    00000000    
            0x0F, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##      000000000                  000000000    
            0x07, 0xF8, 0x00, 0x03, 0xFE, 0x00, ##       00000000                 000000000     
            0x03, 0xFE, 0x00, 0x07, 0xFC, 0x00, ##        000000000              000000000      
            0x01, 0xFF, 0x00, 0x0F, 0xF8, 0x00, ##         000000000            000000000       
            0x00, 0xFF, 0xC0, 0x3F, 0xF0, 0x00, ##          0000000000        0000000000        
            0x00, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##            000000000000000000000000          
            0x00, 0x1F, 0xFF, 0xFF, 0x80, 0x00, ##             0000000000000000000000           
            0x00, 0x07, 0xFF, 0xFE, 0x00, 0x00, ##               000000000000000000             
            0x00, 0x00, 0x7F, 0xE0, 0x00, 0x00, ##                   0000000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 49, 
        'xoffset'  => 2, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##                           000000000               
            0xFF, 0xFE, 0x03, 0xFF, 0xF8, 0x00, 0x00, ##  000000000000000       000000000000000            
            0xFF, 0xFE, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##  000000000000000     0000000000000000000          
            0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000   0000000000000000000000         
            0xFF, 0xFE, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##  000000000000000  0000000000000000000000000       
            0x01, 0xFE, 0xFF, 0x01, 0xFF, 0xE0, 0x00, ##         00000000 00000000       000000000000      
            0x01, 0xFE, 0xF8, 0x00, 0x7F, 0xF0, 0x00, ##         00000000 00000            00000000000     
            0x01, 0xFF, 0xF0, 0x00, 0x1F, 0xF0, 0x00, ##         0000000000000               000000000     
            0x01, 0xFF, 0xE0, 0x00, 0x0F, 0xF8, 0x00, ##         000000000000                 000000000    
            0x01, 0xFF, 0xC0, 0x00, 0x07, 0xFC, 0x00, ##         00000000000                   000000000   
            0x01, 0xFF, 0x80, 0x00, 0x07, 0xFC, 0x00, ##         0000000000                    000000000   
            0x01, 0xFF, 0x80, 0x00, 0x03, 0xFE, 0x00, ##         0000000000                     000000000  
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##         000000000                      000000000  
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         000000000                       00000000  
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         000000000                       000000000 
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         000000000                       000000000 
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         00000000                        000000000 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x00, ##         00000000                         00000000 
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x00, 0xFF, 0x80, ##         00000000                         000000000
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         00000000                        000000000 
            0x01, 0xFE, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         00000000                        000000000 
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         000000000                       000000000 
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFF, 0x00, ##         000000000                       000000000 
            0x01, 0xFF, 0x00, 0x00, 0x01, 0xFE, 0x00, ##         000000000                       00000000  
            0x01, 0xFF, 0x00, 0x00, 0x03, 0xFE, 0x00, ##         000000000                      000000000  
            0x01, 0xFF, 0x80, 0x00, 0x03, 0xFE, 0x00, ##         0000000000                     000000000  
            0x01, 0xFF, 0x80, 0x00, 0x07, 0xFC, 0x00, ##         0000000000                    000000000   
            0x01, 0xFF, 0xC0, 0x00, 0x07, 0xFC, 0x00, ##         00000000000                   000000000   
            0x01, 0xFF, 0xE0, 0x00, 0x0F, 0xF8, 0x00, ##         000000000000                 000000000    
            0x01, 0xFE, 0xF0, 0x00, 0x1F, 0xF0, 0x00, ##         00000000 0000               000000000     
            0x01, 0xFE, 0xF8, 0x00, 0x7F, 0xF0, 0x00, ##         00000000 00000            00000000000     
            0x01, 0xFE, 0x7F, 0x01, 0xFF, 0xE0, 0x00, ##         00000000  0000000       000000000000      
            0x01, 0xFE, 0x3F, 0xFF, 0xFF, 0xC0, 0x00, ##         00000000   000000000000000000000000       
            0x01, 0xFE, 0x1F, 0xFF, 0xFF, 0x00, 0x00, ##         00000000    000000000000000000000         
            0x01, 0xFE, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##         00000000     0000000000000000000          
            0x01, 0xFE, 0x03, 0xFF, 0xF8, 0x00, 0x00, ##         00000000       000000000000000            
            0x01, 0xFE, 0x00, 0x7F, 0xC0, 0x00, 0x00, ##         00000000          000000000               
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                  
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                          
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                          
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                          
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 49, 
        'xoffset'  => 4, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x03, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                000000000                          
            0x00, 0x0F, 0xFF, 0xC0, 0x7F, 0xFF, 0x80, ##              00000000000000       0000000000000000
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0xFF, 0x80, ##            000000000000000000     0000000000000000
            0x00, 0xFF, 0xFF, 0xFC, 0x7F, 0xFF, 0x80, ##          0000000000000000000000   0000000000000000
            0x01, 0xFF, 0xFF, 0xFE, 0x7F, 0xFF, 0x80, ##         000000000000000000000000  0000000000000000
            0x03, 0xFF, 0xC0, 0x7F, 0x7F, 0x80, 0x00, ##        000000000000       0000000 00000000        
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x07, 0xFC, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##       000000000              0000000000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    000000000                     000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0xFF, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##  000000000                        00000000        
            0x7F, 0x80, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   00000000                        00000000        
            0x7F, 0xC0, 0x00, 0x00, 0x7F, 0x80, 0x00, ##   000000000                       00000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x7F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##   000000000                      000000000        
            0x3F, 0xC0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    00000000                      000000000        
            0x3F, 0xE0, 0x00, 0x00, 0xFF, 0x80, 0x00, ##    000000000                     000000000        
            0x3F, 0xE0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##    000000000                    0000000000        
            0x1F, 0xF0, 0x00, 0x01, 0xFF, 0x80, 0x00, ##     000000000                   0000000000        
            0x1F, 0xF0, 0x00, 0x03, 0xFF, 0x80, 0x00, ##     000000000                  00000000000        
            0x0F, 0xF8, 0x00, 0x07, 0xFF, 0x80, 0x00, ##      000000000                000000000000        
            0x07, 0xFC, 0x00, 0x0F, 0x7F, 0x80, 0x00, ##       000000000              0000 00000000        
            0x07, 0xFE, 0x00, 0x1F, 0x7F, 0x80, 0x00, ##       0000000000            00000 00000000        
            0x03, 0xFF, 0x80, 0x7E, 0x7F, 0x80, 0x00, ##        00000000000        000000  00000000        
            0x01, 0xFF, 0xFF, 0xFC, 0x7F, 0x80, 0x00, ##         00000000000000000000000   00000000        
            0x00, 0xFF, 0xFF, 0xF8, 0x7F, 0x80, 0x00, ##          000000000000000000000    00000000        
            0x00, 0x3F, 0xFF, 0xF0, 0x7F, 0x80, 0x00, ##            000000000000000000     00000000        
            0x00, 0x1F, 0xFF, 0xC0, 0x7F, 0x80, 0x00, ##             000000000000000       00000000        
            0x00, 0x03, 0xFE, 0x00, 0x7F, 0x80, 0x00, ##                000000000          00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                                   00000000        
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, ##                            00000000000000000000000
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, ##                            00000000000000000000000
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, ##                            00000000000000000000000
            0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFF, 0x80, ##                            00000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 38, 
        'xoffset'  => 4, 
        'xadvance' => 42, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x7F, 0xC0, ##                           000000000    
            0x00, 0x00, 0x03, 0xFF, 0xF8, ##                        000000000000000 
            0xFF, 0xFE, 0x07, 0xFF, 0xFC, ##  000000000000000      00000000000000000
            0xFF, 0xFE, 0x1F, 0xFF, 0xFC, ##  000000000000000    0000000000000000000
            0xFF, 0xFE, 0x3F, 0xFF, 0xFC, ##  000000000000000   00000000000000000000
            0xFF, 0xFE, 0x7F, 0xFF, 0xFC, ##  000000000000000  000000000000000000000
            0x01, 0xFE, 0x7E, 0x03, 0xFC, ##         00000000  000000       00000000
            0x01, 0xFE, 0xF8, 0x01, 0xFC, ##         00000000 00000          0000000
            0x01, 0xFE, 0xE0, 0x00, 0xFC, ##         00000000 000             000000
            0x01, 0xFF, 0xC0, 0x00, 0xFC, ##         00000000000              000000
            0x01, 0xFF, 0xC0, 0x00, 0x7C, ##         00000000000               00000
            0x01, 0xFF, 0x80, 0x00, 0x7C, ##         0000000000                00000
            0x01, 0xFF, 0x80, 0x00, 0x7C, ##         0000000000                00000
            0x01, 0xFF, 0x00, 0x00, 0x00, ##         000000000                      
            0x01, 0xFF, 0x00, 0x00, 0x00, ##         000000000                      
            0x01, 0xFF, 0x00, 0x00, 0x00, ##         000000000                      
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0x01, 0xFE, 0x00, 0x00, 0x00, ##         00000000                       
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000              
            0xFF, 0xFF, 0xFF, 0x00, 0x00, ##  000000000000000000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 35, 
        'xoffset'  => 5, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xFE, 0x00, 0x00, ##              00000000000            
            0x00, 0xFF, 0xFF, 0xE0, 0x00, ##          0000000000000000000        
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000     
            0x07, 0xFF, 0xFF, 0xFF, 0x80, ##       0000000000000000000000000000  
            0x1F, 0xF8, 0x07, 0xFF, 0x80, ##     0000000000        000000000000  
            0x1F, 0xC0, 0x00, 0xFF, 0x80, ##     0000000              000000000  
            0x3F, 0x80, 0x00, 0x7F, 0x80, ##    0000000                00000000  
            0x7F, 0x00, 0x00, 0x3F, 0x80, ##   0000000                  0000000  
            0x7E, 0x00, 0x00, 0x1F, 0x80, ##   000000                    000000  
            0xFE, 0x00, 0x00, 0x1F, 0x80, ##  0000000                    000000  
            0xFE, 0x00, 0x00, 0x0F, 0x80, ##  0000000                     00000  
            0xFE, 0x00, 0x00, 0x0F, 0x80, ##  0000000                     00000  
            0xFE, 0x00, 0x00, 0x0F, 0x80, ##  0000000                     00000  
            0xFE, 0x00, 0x00, 0x00, 0x00, ##  0000000                            
            0xFF, 0x00, 0x00, 0x00, 0x00, ##  00000000                           
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                          
            0xFF, 0xC0, 0x00, 0x00, 0x00, ##  0000000000                         
            0x7F, 0xF0, 0x00, 0x00, 0x00, ##   00000000000                       
            0x7F, 0xFC, 0x00, 0x00, 0x00, ##   0000000000000                     
            0x3F, 0xFF, 0x80, 0x00, 0x00, ##    000000000000000                  
            0x3F, 0xFF, 0xF8, 0x00, 0x00, ##    0000000000000000000              
            0x1F, 0xFF, 0xFF, 0x00, 0x00, ##     000000000000000000000           
            0x07, 0xFF, 0xFF, 0xC0, 0x00, ##       000000000000000000000         
            0x03, 0xFF, 0xFF, 0xF0, 0x00, ##        0000000000000000000000       
            0x00, 0xFF, 0xFF, 0xFC, 0x00, ##          0000000000000000000000     
            0x00, 0x1F, 0xFF, 0xFE, 0x00, ##             00000000000000000000    
            0x00, 0x03, 0xFF, 0xFF, 0x00, ##                000000000000000000   
            0x00, 0x00, 0x7F, 0xFF, 0x80, ##                   0000000000000000  
            0x00, 0x00, 0x0F, 0xFF, 0xC0, ##                      00000000000000 
            0x00, 0x00, 0x03, 0xFF, 0xC0, ##                        000000000000 
            0x00, 0x00, 0x00, 0xFF, 0xE0, ##                          00000000000
            0x00, 0x00, 0x00, 0x7F, 0xE0, ##                           0000000000
            0x00, 0x00, 0x00, 0x3F, 0xE0, ##                            000000000
            0x00, 0x00, 0x00, 0x1F, 0xE0, ##                             00000000
            0xF8, 0x00, 0x00, 0x1F, 0xE0, ##  00000                      00000000
            0xF8, 0x00, 0x00, 0x1F, 0xE0, ##  00000                      00000000
            0xF8, 0x00, 0x00, 0x1F, 0xE0, ##  00000                      00000000
            0xF8, 0x00, 0x00, 0x1F, 0xE0, ##  00000                      00000000
            0xFC, 0x00, 0x00, 0x1F, 0xC0, ##  000000                     0000000 
            0xFC, 0x00, 0x00, 0x3F, 0xC0, ##  000000                    00000000 
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000  
            0xFF, 0x00, 0x00, 0x7F, 0x80, ##  00000000                 00000000  
            0xFF, 0x80, 0x00, 0xFF, 0x00, ##  000000000               00000000   
            0xFF, 0xF0, 0x07, 0xFE, 0x00, ##  000000000000         0000000000    
            0xFF, 0xFF, 0xFF, 0xFC, 0x00, ##  000000000000000000000000000000     
            0x1F, 0xFF, 0xFF, 0xF0, 0x00, ##     0000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xC0, 0x00, ##        00000000000000000000         
            0x00, 0x3F, 0xFE, 0x00, 0x00, ##            0000000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 31, 
        'xoffset'  => 2, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000  
            0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000000000000000000000  
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x00, ##        00000000                 
            0x03, 0xFC, 0x00, 0x7E, ##        00000000           000000
            0x03, 0xFC, 0x00, 0x7E, ##        00000000           000000
            0x03, 0xFC, 0x00, 0x7E, ##        00000000           000000
            0x03, 0xFC, 0x00, 0x7E, ##        00000000           000000
            0x01, 0xFC, 0x00, 0xFC, ##         0000000          000000 
            0x01, 0xFE, 0x00, 0xFC, ##         00000000         000000 
            0x01, 0xFE, 0x01, 0xFC, ##         00000000        0000000 
            0x00, 0xFF, 0x03, 0xF8, ##          00000000      0000000  
            0x00, 0xFF, 0xFF, 0xF8, ##          000000000000000000000  
            0x00, 0x7F, 0xFF, 0xF0, ##           0000000000000000000   
            0x00, 0x1F, 0xFF, 0xC0, ##             000000000000000     
            0x00, 0x03, 0xFE, 0x00, ##                000000000        
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 51, 
        'xoffset'  => 2, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xE0, 0x00, ##  000000000000000             000000000000000        
            0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xE0, 0x00, ##  000000000000000             000000000000000        
            0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xE0, 0x00, ##  000000000000000             000000000000000        
            0xFF, 0xFE, 0x00, 0x0F, 0xFF, 0xE0, 0x00, ##  000000000000000             000000000000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##         00000000                    00000000        
            0x01, 0xFE, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         00000000                   000000000        
            0x01, 0xFE, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         00000000                   000000000        
            0x01, 0xFE, 0x00, 0x00, 0x3F, 0xE0, 0x00, ##         00000000                   000000000        
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##         000000000                 0000000000        
            0x00, 0xFF, 0x00, 0x00, 0x7F, 0xE0, 0x00, ##          00000000                 0000000000        
            0x00, 0xFF, 0x00, 0x00, 0xFF, 0xE0, 0x00, ##          00000000                00000000000        
            0x00, 0xFF, 0x80, 0x00, 0xFF, 0xE0, 0x00, ##          000000000               00000000000        
            0x00, 0xFF, 0x80, 0x01, 0xDF, 0xE0, 0x00, ##          000000000              000 00000000        
            0x00, 0x7F, 0xC0, 0x03, 0xDF, 0xE0, 0x00, ##           000000000            0000 00000000        
            0x00, 0x7F, 0xF0, 0x1F, 0x9F, 0xE0, 0x00, ##           00000000000       000000  00000000        
            0x00, 0x3F, 0xFF, 0xFF, 0x9F, 0xFF, 0xE0, ##            00000000000000000000000  0000000000000000
            0x00, 0x3F, 0xFF, 0xFF, 0x1F, 0xFF, 0xE0, ##            0000000000000000000000   0000000000000000
            0x00, 0x1F, 0xFF, 0xFE, 0x1F, 0xFF, 0xE0, ##             00000000000000000000    0000000000000000
            0x00, 0x0F, 0xFF, 0xFC, 0x1F, 0xFF, 0xE0, ##              000000000000000000     0000000000000000
            0x00, 0x03, 0xFF, 0xF0, 0x00, 0x00, 0x00, ##                00000000000000                       
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x00, 0x00, ##                   00000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 49, 
        'xoffset'  => 0, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0x07, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, ##       000000000                         00000     
            0x03, 0xFC, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        00000000                        00000      
            0x03, 0xFE, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        000000000                       00000      
            0x01, 0xFE, 0x00, 0x00, 0x07, 0xE0, 0x00, ##         00000000                      000000      
            0x01, 0xFF, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                     00000       
            0x01, 0xFF, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                     00000       
            0x00, 0xFF, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          00000000                    00000        
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0x80, 0x00, ##          000000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x1F, 0x80, 0x00, ##           00000000                  000000        
            0x00, 0x7F, 0xC0, 0x00, 0x1F, 0x00, 0x00, ##           000000000                 00000         
            0x00, 0x7F, 0xC0, 0x00, 0x1F, 0x00, 0x00, ##           000000000                 00000         
            0x00, 0x3F, 0xC0, 0x00, 0x3E, 0x00, 0x00, ##            00000000                00000          
            0x00, 0x3F, 0xE0, 0x00, 0x3E, 0x00, 0x00, ##            000000000               00000          
            0x00, 0x1F, 0xE0, 0x00, 0x7E, 0x00, 0x00, ##             00000000              000000          
            0x00, 0x1F, 0xF0, 0x00, 0x7C, 0x00, 0x00, ##             000000000             00000           
            0x00, 0x0F, 0xF0, 0x00, 0x7C, 0x00, 0x00, ##              00000000             00000           
            0x00, 0x0F, 0xF0, 0x00, 0xF8, 0x00, 0x00, ##              00000000            00000            
            0x00, 0x0F, 0xF8, 0x00, 0xF8, 0x00, 0x00, ##              000000000           00000            
            0x00, 0x07, 0xF8, 0x01, 0xF8, 0x00, 0x00, ##               00000000          000000            
            0x00, 0x07, 0xFC, 0x01, 0xF0, 0x00, 0x00, ##               000000000         00000             
            0x00, 0x03, 0xFC, 0x01, 0xF0, 0x00, 0x00, ##                00000000         00000             
            0x00, 0x03, 0xFC, 0x03, 0xE0, 0x00, 0x00, ##                00000000        00000              
            0x00, 0x03, 0xFE, 0x03, 0xE0, 0x00, 0x00, ##                000000000       00000              
            0x00, 0x01, 0xFE, 0x07, 0xE0, 0x00, 0x00, ##                 00000000      000000              
            0x00, 0x01, 0xFF, 0x07, 0xC0, 0x00, 0x00, ##                 000000000     00000               
            0x00, 0x00, 0xFF, 0x07, 0xC0, 0x00, 0x00, ##                  00000000     00000               
            0x00, 0x00, 0xFF, 0x0F, 0x80, 0x00, 0x00, ##                  00000000    00000                
            0x00, 0x00, 0xFF, 0x8F, 0x80, 0x00, 0x00, ##                  000000000   00000                
            0x00, 0x00, 0x7F, 0x9F, 0x80, 0x00, 0x00, ##                   00000000  000000                
            0x00, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0x00, ##                   000000000 00000                 
            0x00, 0x00, 0x3F, 0xDF, 0x00, 0x00, 0x00, ##                    00000000 00000                 
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x0F, 0xFC, 0x00, 0x00, 0x00, ##                      0000000000                   
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##                      000000000                    
            0x00, 0x00, 0x07, 0xF8, 0x00, 0x00, 0x00, ##                       00000000                    
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                        000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 72, 
        'xoffset'  => 1, 
        'xadvance' => 74, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0xFF, 0xF0, 0x00, 0x1F, 0x80, 0x00, 0xFF, 0xFF, ##  00000000000000000000               000000               0000000000000000
            0x00, 0xFF, 0xF0, 0x00, 0x3F, 0x80, 0x00, 0xFF, 0xFF, ##  00000000000000000000              0000000               0000000000000000
            0x00, 0xFF, 0xF0, 0x00, 0x3F, 0x80, 0x00, 0xFF, 0xFF, ##  00000000000000000000              0000000               0000000000000000
            0x00, 0xFF, 0xF0, 0x00, 0x3F, 0xC0, 0x00, 0xFF, 0xFF, ##  00000000000000000000              00000000              0000000000000000
            0x00, 0xF8, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x03, 0xE0, ##       00000000                    000000000                    00000     
            0x00, 0xF8, 0x00, 0x00, 0x7F, 0xC0, 0x00, 0x03, 0xE0, ##       00000000                    000000000                    00000     
            0x00, 0xFC, 0x00, 0x00, 0x7F, 0xE0, 0x00, 0x03, 0xC0, ##        00000000                   0000000000                   0000      
            0x00, 0xFC, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x07, 0xC0, ##        00000000                  00000000000                  00000      
            0x00, 0xFC, 0x00, 0x00, 0xFF, 0xE0, 0x00, 0x07, 0xC0, ##        00000000                  00000000000                  00000      
            0x00, 0xFE, 0x00, 0x00, 0xFF, 0xF0, 0x00, 0x07, 0x80, ##         00000000                 000000000000                 0000       
            0x00, 0xFE, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x0F, 0x80, ##         00000000                0000000000000                00000       
            0x00, 0xFE, 0x00, 0x01, 0xFF, 0xF0, 0x00, 0x0F, 0x80, ##         00000000                0000000000000                00000       
            0x00, 0xFF, 0x00, 0x01, 0xEF, 0xF8, 0x00, 0x0F, 0x00, ##          00000000               0000 000000000               0000        
            0x00, 0xFF, 0x00, 0x03, 0xE7, 0xF8, 0x00, 0x1F, 0x00, ##          00000000              00000  00000000              00000        
            0x00, 0xFF, 0x00, 0x03, 0xE7, 0xF8, 0x00, 0x1F, 0x00, ##          00000000              00000  00000000              00000        
            0x00, 0x7F, 0x80, 0x03, 0xC7, 0xFC, 0x00, 0x1E, 0x00, ##           00000000             0000   000000000             0000         
            0x00, 0x7F, 0x80, 0x07, 0xC3, 0xFC, 0x00, 0x3E, 0x00, ##           00000000            00000    00000000            00000         
            0x00, 0x7F, 0x80, 0x07, 0xC3, 0xFC, 0x00, 0x3E, 0x00, ##           00000000            00000    00000000            00000         
            0x00, 0x3F, 0xC0, 0x0F, 0x83, 0xFE, 0x00, 0x3C, 0x00, ##            00000000          00000     000000000           0000          
            0x00, 0x3F, 0xC0, 0x0F, 0x81, 0xFE, 0x00, 0x7C, 0x00, ##            00000000          00000      00000000          00000          
            0x00, 0x3F, 0xC0, 0x0F, 0x81, 0xFE, 0x00, 0x7C, 0x00, ##            00000000          00000      00000000          00000          
            0x00, 0x1F, 0xE0, 0x1F, 0x01, 0xFF, 0x00, 0x78, 0x00, ##             00000000        00000       000000000         0000           
            0x00, 0x1F, 0xE0, 0x1F, 0x00, 0xFF, 0x00, 0xF8, 0x00, ##             00000000        00000        00000000        00000           
            0x00, 0x1F, 0xE0, 0x1F, 0x00, 0xFF, 0x00, 0xF8, 0x00, ##             00000000        00000        00000000        00000           
            0x00, 0x0F, 0xE0, 0x3E, 0x00, 0xFF, 0x80, 0xF0, 0x00, ##              0000000       00000         000000000       0000            
            0x00, 0x0F, 0xF0, 0x3E, 0x00, 0x7F, 0x81, 0xF0, 0x00, ##              00000000      00000          00000000      00000            
            0x00, 0x0F, 0xF0, 0x3E, 0x00, 0x7F, 0x81, 0xF0, 0x00, ##              00000000      00000          00000000      00000            
            0x00, 0x0F, 0xF0, 0x7C, 0x00, 0x7F, 0xC1, 0xF0, 0x00, ##              00000000     00000           000000000     00000            
            0x00, 0x07, 0xF8, 0x7C, 0x00, 0x3F, 0xC3, 0xE0, 0x00, ##               00000000    00000            00000000    00000             
            0x00, 0x07, 0xF8, 0x7C, 0x00, 0x3F, 0xC3, 0xE0, 0x00, ##               00000000    00000            00000000    00000             
            0x00, 0x07, 0xF8, 0xF8, 0x00, 0x3F, 0xE3, 0xE0, 0x00, ##               00000000   00000             000000000   00000             
            0x00, 0x03, 0xFC, 0xF8, 0x00, 0x1F, 0xE7, 0xC0, 0x00, ##                00000000  00000              00000000  00000              
            0x00, 0x03, 0xFC, 0xF8, 0x00, 0x1F, 0xE7, 0xC0, 0x00, ##                00000000  00000              00000000  00000              
            0x00, 0x03, 0xFD, 0xF0, 0x00, 0x1F, 0xF7, 0xC0, 0x00, ##                00000000 00000               000000000 00000              
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##                 0000000000000                0000000000000               
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##                 0000000000000                0000000000000               
            0x00, 0x01, 0xFF, 0xE0, 0x00, 0x0F, 0xFF, 0x80, 0x00, ##                 000000000000                 0000000000000               
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0x00, 0x00, ##                  00000000000                  00000000000                
            0x00, 0x00, 0xFF, 0xE0, 0x00, 0x07, 0xFF, 0x00, 0x00, ##                  00000000000                  00000000000                
            0x00, 0x00, 0xFF, 0xC0, 0x00, 0x07, 0xFF, 0x00, 0x00, ##                  0000000000                   00000000000                
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x03, 0xFE, 0x00, 0x00, ##                   000000000                    000000000                 
            0x00, 0x00, 0x7F, 0xC0, 0x00, 0x03, 0xFE, 0x00, 0x00, ##                   000000000                    000000000                 
            0x00, 0x00, 0x7F, 0x80, 0x00, 0x03, 0xFE, 0x00, 0x00, ##                   00000000                     000000000                 
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x01, 0xFC, 0x00, 0x00, ##                    0000000                      0000000                  
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x01, 0xFC, 0x00, 0x00, ##                    0000000                      0000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 47, 
        'xoffset'  => 1, 
        'xadvance' => 49, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF8, ##  00000000000000000000        00000000000000000  
            0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF8, ##  00000000000000000000        00000000000000000  
            0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF8, ##  00000000000000000000        00000000000000000  
            0xFF, 0xFF, 0xF0, 0x0F, 0xFF, 0xF8, ##  00000000000000000000        00000000000000000  
            0x03, 0xFE, 0x00, 0x00, 0x3E, 0x00, ##        000000000                   00000        
            0x01, 0xFF, 0x00, 0x00, 0x7C, 0x00, ##         000000000                 00000         
            0x01, 0xFF, 0x80, 0x00, 0xF8, 0x00, ##         0000000000               00000          
            0x00, 0xFF, 0x80, 0x01, 0xF8, 0x00, ##          000000000              000000          
            0x00, 0x7F, 0xC0, 0x01, 0xF0, 0x00, ##           000000000             00000           
            0x00, 0x7F, 0xE0, 0x03, 0xE0, 0x00, ##           0000000000           00000            
            0x00, 0x3F, 0xF0, 0x07, 0xE0, 0x00, ##            0000000000         000000            
            0x00, 0x1F, 0xF0, 0x0F, 0xC0, 0x00, ##             000000000        000000             
            0x00, 0x0F, 0xF8, 0x0F, 0x80, 0x00, ##              000000000       00000              
            0x00, 0x0F, 0xFC, 0x1F, 0x00, 0x00, ##              0000000000     00000               
            0x00, 0x07, 0xFC, 0x3F, 0x00, 0x00, ##               000000000    000000               
            0x00, 0x03, 0xFE, 0x3E, 0x00, 0x00, ##                000000000   00000                
            0x00, 0x03, 0xFF, 0x7C, 0x00, 0x00, ##                0000000000 00000                 
            0x00, 0x01, 0xFF, 0xFC, 0x00, 0x00, ##                 000000000000000                 
            0x00, 0x00, 0xFF, 0xF8, 0x00, 0x00, ##                  0000000000000                  
            0x00, 0x00, 0xFF, 0xF0, 0x00, 0x00, ##                  000000000000                   
            0x00, 0x00, 0x7F, 0xF0, 0x00, 0x00, ##                   00000000000                   
            0x00, 0x00, 0x3F, 0xE0, 0x00, 0x00, ##                    000000000                    
            0x00, 0x00, 0x1F, 0xF0, 0x00, 0x00, ##                     000000000                   
            0x00, 0x00, 0x1F, 0xF8, 0x00, 0x00, ##                     0000000000                  
            0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, ##                    00000000000                  
            0x00, 0x00, 0x3F, 0xFC, 0x00, 0x00, ##                    000000000000                 
            0x00, 0x00, 0x7F, 0xFE, 0x00, 0x00, ##                   00000000000000                
            0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, ##                  0000000000000000               
            0x00, 0x00, 0xF9, 0xFF, 0x00, 0x00, ##                  00000  000000000               
            0x00, 0x01, 0xF0, 0xFF, 0x80, 0x00, ##                 00000    000000000              
            0x00, 0x03, 0xF0, 0xFF, 0xC0, 0x00, ##                000000    0000000000             
            0x00, 0x03, 0xE0, 0x7F, 0xC0, 0x00, ##                00000      000000000             
            0x00, 0x07, 0xC0, 0x3F, 0xE0, 0x00, ##               00000        000000000            
            0x00, 0x0F, 0x80, 0x1F, 0xF0, 0x00, ##              00000          000000000           
            0x00, 0x1F, 0x80, 0x1F, 0xF8, 0x00, ##             000000          0000000000          
            0x00, 0x1F, 0x00, 0x0F, 0xF8, 0x00, ##             00000            000000000          
            0x00, 0x3E, 0x00, 0x07, 0xFC, 0x00, ##            00000              000000000         
            0x00, 0x7E, 0x00, 0x07, 0xFE, 0x00, ##           000000              0000000000        
            0x00, 0x7C, 0x00, 0x03, 0xFE, 0x00, ##           00000                000000000        
            0x00, 0xF8, 0x00, 0x01, 0xFF, 0x00, ##          00000                  000000000       
            0x01, 0xF8, 0x00, 0x00, 0xFF, 0x80, ##         000000                   000000000      
            0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xFE, ##   00000000000000000        000000000000000000000
            0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xFE, ##   00000000000000000        000000000000000000000
            0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xFE, ##   00000000000000000        000000000000000000000
            0x7F, 0xFF, 0xC0, 0x3F, 0xFF, 0xFE, ##   00000000000000000        000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 49, 
        'xoffset'  => 0, 
        'xadvance' => 50, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0xFF, 0xFF, 0xF8, 0x00, 0xFF, 0xFF, 0x80, ##  000000000000000000000           00000000000000000
            0x07, 0xFC, 0x00, 0x00, 0x01, 0xF0, 0x00, ##       000000000                         00000     
            0x03, 0xFC, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        00000000                        00000      
            0x03, 0xFE, 0x00, 0x00, 0x03, 0xE0, 0x00, ##        000000000                       00000      
            0x01, 0xFE, 0x00, 0x00, 0x07, 0xE0, 0x00, ##         00000000                      000000      
            0x01, 0xFE, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         00000000                      00000       
            0x01, 0xFF, 0x00, 0x00, 0x07, 0xC0, 0x00, ##         000000000                     00000       
            0x00, 0xFF, 0x00, 0x00, 0x0F, 0x80, 0x00, ##          00000000                    00000        
            0x00, 0xFF, 0x80, 0x00, 0x0F, 0x80, 0x00, ##          000000000                   00000        
            0x00, 0x7F, 0x80, 0x00, 0x1F, 0x80, 0x00, ##           00000000                  000000        
            0x00, 0x7F, 0x80, 0x00, 0x1F, 0x00, 0x00, ##           00000000                  00000         
            0x00, 0x7F, 0xC0, 0x00, 0x1F, 0x00, 0x00, ##           000000000                 00000         
            0x00, 0x3F, 0xC0, 0x00, 0x3E, 0x00, 0x00, ##            00000000                00000          
            0x00, 0x3F, 0xE0, 0x00, 0x3E, 0x00, 0x00, ##            000000000               00000          
            0x00, 0x1F, 0xE0, 0x00, 0x7E, 0x00, 0x00, ##             00000000              000000          
            0x00, 0x1F, 0xE0, 0x00, 0x7C, 0x00, 0x00, ##             00000000              00000           
            0x00, 0x1F, 0xF0, 0x00, 0x7C, 0x00, 0x00, ##             000000000             00000           
            0x00, 0x0F, 0xF0, 0x00, 0xF8, 0x00, 0x00, ##              00000000            00000            
            0x00, 0x0F, 0xF8, 0x00, 0xF8, 0x00, 0x00, ##              000000000           00000            
            0x00, 0x07, 0xF8, 0x00, 0xF8, 0x00, 0x00, ##               00000000           00000            
            0x00, 0x07, 0xF8, 0x01, 0xF0, 0x00, 0x00, ##               00000000          00000             
            0x00, 0x07, 0xFC, 0x01, 0xF0, 0x00, 0x00, ##               000000000         00000             
            0x00, 0x03, 0xFC, 0x03, 0xE0, 0x00, 0x00, ##                00000000        00000              
            0x00, 0x03, 0xFE, 0x03, 0xE0, 0x00, 0x00, ##                000000000       00000              
            0x00, 0x01, 0xFE, 0x03, 0xE0, 0x00, 0x00, ##                 00000000       00000              
            0x00, 0x01, 0xFE, 0x07, 0xC0, 0x00, 0x00, ##                 00000000      00000               
            0x00, 0x01, 0xFF, 0x07, 0xC0, 0x00, 0x00, ##                 000000000     00000               
            0x00, 0x00, 0xFF, 0x0F, 0x80, 0x00, 0x00, ##                  00000000    00000                
            0x00, 0x00, 0xFF, 0x8F, 0x80, 0x00, 0x00, ##                  000000000   00000                
            0x00, 0x00, 0xFF, 0x8F, 0x80, 0x00, 0x00, ##                  000000000   00000                
            0x00, 0x00, 0x7F, 0x9F, 0x00, 0x00, 0x00, ##                   00000000  00000                 
            0x00, 0x00, 0x7F, 0xDF, 0x00, 0x00, 0x00, ##                   000000000 00000                 
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x3F, 0xFE, 0x00, 0x00, 0x00, ##                    0000000000000                  
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x1F, 0xFC, 0x00, 0x00, 0x00, ##                     00000000000                   
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##                      000000000                    
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##                      000000000                    
            0x00, 0x00, 0x0F, 0xF8, 0x00, 0x00, 0x00, ##                      000000000                    
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##                       0000000                     
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, ##                        00000                      
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, ##                        00000                      
            0x00, 0x00, 0x03, 0xE0, 0x00, 0x00, 0x00, ##                        00000                      
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                       00000                       
            0x00, 0x00, 0x07, 0xC0, 0x00, 0x00, 0x00, ##                       00000                       
            0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x00, ##                       0000                        
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, ##                      00000                        
            0x00, 0x00, 0x0F, 0x80, 0x00, 0x00, 0x00, ##                      00000                        
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, ##                     00000                         
            0x00, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, ##                     00000                         
            0x1E, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, ##     0000            0000                          
            0x1E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, ##     0000           00000                          
            0x1E, 0x00, 0x3E, 0x00, 0x00, 0x00, 0x00, ##     0000           00000                          
            0x1F, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, ##     00000         00000                           
            0x1F, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, ##     00000        000000                           
            0x1F, 0xC1, 0xF8, 0x00, 0x00, 0x00, 0x00, ##     0000000     000000                            
            0x1F, 0xFF, 0xF0, 0x00, 0x00, 0x00, 0x00, ##     00000000000000000                             
            0x1F, 0xFF, 0xE0, 0x00, 0x00, 0x00, 0x00, ##     0000000000000000                              
            0x1F, 0xFF, 0xC0, 0x00, 0x00, 0x00, 0x00, ##     000000000000000                               
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, ##        0000000000                                 
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 39, 
        'xoffset'  => 4, 
        'xadvance' => 46, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7F, 0xFF, 0xFF, 0xFF, 0xFC, ##   0000000000000000000000000000000000000 
            0x7C, 0x00, 0x00, 0x1F, 0xF8, ##   00000                     0000000000  
            0x7C, 0x00, 0x00, 0x1F, 0xF0, ##   00000                     000000000   
            0x7C, 0x00, 0x00, 0x3F, 0xF0, ##   00000                    0000000000   
            0x7C, 0x00, 0x00, 0x7F, 0xE0, ##   00000                   0000000000    
            0x7C, 0x00, 0x00, 0xFF, 0xC0, ##   00000                  0000000000     
            0x7C, 0x00, 0x00, 0xFF, 0x80, ##   00000                  000000000      
            0x7C, 0x00, 0x01, 0xFF, 0x80, ##   00000                 0000000000      
            0x7C, 0x00, 0x03, 0xFF, 0x00, ##   00000                0000000000       
            0x00, 0x00, 0x07, 0xFE, 0x00, ##                       0000000000        
            0x00, 0x00, 0x07, 0xFC, 0x00, ##                       000000000         
            0x00, 0x00, 0x0F, 0xFC, 0x00, ##                      0000000000         
            0x00, 0x00, 0x1F, 0xF8, 0x00, ##                     0000000000          
            0x00, 0x00, 0x3F, 0xF0, 0x00, ##                    0000000000           
            0x00, 0x00, 0x3F, 0xF0, 0x00, ##                    0000000000           
            0x00, 0x00, 0x7F, 0xE0, 0x00, ##                   0000000000            
            0x00, 0x00, 0xFF, 0xC0, 0x00, ##                  0000000000             
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000              
            0x00, 0x01, 0xFF, 0x80, 0x00, ##                 0000000000              
            0x00, 0x03, 0xFF, 0x00, 0x00, ##                0000000000               
            0x00, 0x07, 0xFE, 0x00, 0x00, ##               0000000000                
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000                 
            0x00, 0x0F, 0xFC, 0x00, 0x00, ##              0000000000                 
            0x00, 0x1F, 0xF8, 0x00, 0x00, ##             0000000000                  
            0x00, 0x3F, 0xF0, 0x00, 0x00, ##            0000000000                   
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000                    
            0x00, 0x7F, 0xE0, 0x00, 0x00, ##           0000000000                    
            0x00, 0xFF, 0xC0, 0x00, 0x00, ##          0000000000                     
            0x01, 0xFF, 0x80, 0x00, 0x00, ##         0000000000                      
            0x03, 0xFF, 0x00, 0x00, 0x00, ##        0000000000                       
            0x03, 0xFF, 0x00, 0x00, 0x3E, ##        0000000000                  00000
            0x07, 0xFE, 0x00, 0x00, 0x3E, ##       0000000000                   00000
            0x0F, 0xFC, 0x00, 0x00, 0x3E, ##      0000000000                    00000
            0x1F, 0xF8, 0x00, 0x00, 0x3E, ##     0000000000                     00000
            0x1F, 0xF8, 0x00, 0x00, 0x3E, ##     0000000000                     00000
            0x3F, 0xF0, 0x00, 0x00, 0x3E, ##    0000000000                      00000
            0x7F, 0xE0, 0x00, 0x00, 0x3E, ##   0000000000                       00000
            0xFF, 0xC0, 0x00, 0x00, 0x3E, ##  0000000000                        00000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFE, ##  000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 34, 
        'xoffset'  => 11, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000
            0x00, 0x00, 0x0F, 0xFF, 0xC0, ##                      00000000000000
            0x00, 0x00, 0x7F, 0xFF, 0xC0, ##                   00000000000000000
            0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                  000000000000000000
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000        
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x1F, 0xF0, 0x00, 0x00, ##             000000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000                
            0x01, 0xFF, 0x80, 0x00, 0x00, ##         0000000000                 
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                   
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                     
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                     
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                   
            0x01, 0xFF, 0x80, 0x00, 0x00, ##         0000000000                 
            0x00, 0x7F, 0xC0, 0x00, 0x00, ##           000000000                
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000               
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000               
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, ##               0000000              
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000             
            0x00, 0x03, 0xF8, 0x00, 0x00, ##                0000000             
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000            
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000           
            0x00, 0x01, 0xFF, 0xC0, 0x00, ##                 00000000000        
            0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                  000000000000000000
            0x00, 0x00, 0x3F, 0xFF, 0xC0, ##                    0000000000000000
            0x00, 0x00, 0x0F, 0xFF, 0xC0, ##                      00000000000000
            0x00, 0x00, 0x00, 0xFF, 0xC0, ##                          0000000000
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 7, 
        'xoffset'  => 11, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 33, 
        'xoffset'  => 11, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                        
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                    
            0xFF, 0xFF, 0x00, 0x00, 0x00, ##  0000000000000000                 
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                
            0x01, 0xFF, 0xC0, 0x00, 0x00, ##         00000000000               
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000              
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000           
            0x00, 0x01, 0xFE, 0x00, 0x00, ##                 00000000          
            0x00, 0x00, 0xFF, 0xC0, 0x00, ##                  0000000000       
            0x00, 0x00, 0x7F, 0xFF, 0x80, ##                   0000000000000000
            0x00, 0x00, 0x0F, 0xFF, 0x80, ##                      0000000000000
            0x00, 0x00, 0x0F, 0xFF, 0x80, ##                      0000000000000
            0x00, 0x00, 0x3F, 0xFF, 0x80, ##                    000000000000000
            0x00, 0x00, 0xFF, 0xC0, 0x00, ##                  0000000000       
            0x00, 0x01, 0xFF, 0x00, 0x00, ##                 000000000         
            0x00, 0x03, 0xFC, 0x00, 0x00, ##                00000000           
            0x00, 0x07, 0xFC, 0x00, 0x00, ##               000000000           
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x07, 0xF8, 0x00, 0x00, ##               00000000            
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xF0, 0x00, 0x00, ##              00000000             
            0x00, 0x0F, 0xE0, 0x00, 0x00, ##              0000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x1F, 0xE0, 0x00, 0x00, ##             00000000              
            0x00, 0x3F, 0xC0, 0x00, 0x00, ##            00000000               
            0x01, 0xFF, 0xC0, 0x00, 0x00, ##         00000000000               
            0xFF, 0xFF, 0x80, 0x00, 0x00, ##  00000000000000000                
            0xFF, 0xFE, 0x00, 0x00, 0x00, ##  000000000000000                  
            0xFF, 0xF8, 0x00, 0x00, 0x00, ##  0000000000000                    
            0xFF, 0x80, 0x00, 0x00, 0x00, ##  000000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 55, 
        'xoffset'  => 9, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x00, 0x06, ##              00000000                                 00
            0x00, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x0E, ##          000000000000000                             000
            0x03, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x1E, ##        00000000000000000000                         0000
            0x07, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x7E, ##       000000000000000000000000                    000000
            0x1F, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFE, ##     00000000000000000000000000000               00000000
            0x3F, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFE, ##    000000000000000000000000000000000         00000000000
            0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##   00000000000000000000000000000000000000000000000000000 
            0xFF, 0xE0, 0x1F, 0xFF, 0xFF, 0xFF, 0xF8, ##  00000000000        0000000000000000000000000000000000  
            0xFF, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, ##  00000000               0000000000000000000000000000    
            0xFC, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xC0, ##  000000                   0000000000000000000000000     
            0xF0, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0x00, ##  0000                        00000000000000000000       
            0xC0, 0x00, 0x00, 0x01, 0xFF, 0xFC, 0x00, ##  00                             000000000000000         
            0x80, 0x00, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##  0                                  00000000            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '160' => {    # ' '
        'width'    => 0, 
        'xoffset'  => 0, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
            ##  
        ], 
    }, 
    '161' => {    # '¡'
        'width'    => 11, 
        'xoffset'  => 12, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x00, 0x00, ##             
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '162' => {    # '¢'
        'width'    => 41, 
        'xoffset'  => 7, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##                     000000                
            0x00, 0x03, 0xFF, 0xFE, 0x00, 0x00, ##                00000000000000000          
            0x00, 0x0F, 0xFF, 0xFF, 0xC0, 0x00, ##              0000000000000000000000       
            0x00, 0x3F, 0xFF, 0xFF, 0xF8, 0x00, ##            000000000000000000000000000    
            0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##          0000000000000000000000000000000  
            0x01, 0xFF, 0x8F, 0x1F, 0xFE, 0x00, ##         0000000000   0000   000000000000  
            0x03, 0xFE, 0x0F, 0x07, 0xFE, 0x00, ##        000000000     0000     0000000000  
            0x07, 0xFC, 0x0F, 0x03, 0xFE, 0x00, ##       000000000      0000      000000000  
            0x07, 0xF8, 0x0F, 0x01, 0xFE, 0x00, ##       00000000       0000       00000000  
            0x0F, 0xF0, 0x0F, 0x00, 0xFE, 0x00, ##      00000000        0000        0000000  
            0x1F, 0xF0, 0x0F, 0x00, 0x7E, 0x00, ##     000000000        0000         000000  
            0x1F, 0xE0, 0x0F, 0x00, 0x7E, 0x00, ##     00000000         0000         000000  
            0x3F, 0xE0, 0x0F, 0x00, 0x7E, 0x00, ##    000000000         0000         000000  
            0x3F, 0xC0, 0x0F, 0x00, 0x3E, 0x00, ##    00000000          0000          00000  
            0x7F, 0xC0, 0x0F, 0x00, 0x3E, 0x00, ##   000000000          0000          00000  
            0x7F, 0xC0, 0x0F, 0x00, 0x3E, 0x00, ##   000000000          0000          00000  
            0x7F, 0xC0, 0x0F, 0x00, 0x00, 0x00, ##   000000000          0000                 
            0x7F, 0x80, 0x0F, 0x00, 0x00, 0x00, ##   00000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0xFF, 0x80, 0x0F, 0x00, 0x00, 0x00, ##  000000000           0000                 
            0x7F, 0x80, 0x0F, 0x00, 0x00, 0x00, ##   00000000           0000                 
            0x7F, 0x80, 0x0F, 0x00, 0x00, 0x00, ##   00000000           0000                 
            0x7F, 0xC0, 0x0F, 0x00, 0x00, 0x00, ##   000000000          0000                 
            0x7F, 0xC0, 0x0F, 0x00, 0x3F, 0x80, ##   000000000          0000          0000000
            0x3F, 0xC0, 0x0F, 0x00, 0x3F, 0x00, ##    00000000          0000          000000 
            0x3F, 0xC0, 0x0F, 0x00, 0x7F, 0x00, ##    00000000          0000         0000000 
            0x3F, 0xE0, 0x0F, 0x00, 0x7F, 0x00, ##    000000000         0000         0000000 
            0x1F, 0xE0, 0x0F, 0x00, 0x7E, 0x00, ##     00000000         0000         000000  
            0x1F, 0xF0, 0x0F, 0x00, 0xFE, 0x00, ##     000000000        0000        0000000  
            0x0F, 0xF0, 0x0F, 0x00, 0xFC, 0x00, ##      00000000        0000        000000   
            0x07, 0xF8, 0x0F, 0x01, 0xFC, 0x00, ##       00000000       0000       0000000   
            0x03, 0xFC, 0x0F, 0x03, 0xF8, 0x00, ##        00000000      0000      0000000    
            0x01, 0xFE, 0x0F, 0x07, 0xF0, 0x00, ##         00000000     0000     0000000     
            0x00, 0xFF, 0x8F, 0x1F, 0xE0, 0x00, ##          000000000   0000   00000000      
            0x00, 0x7F, 0xFF, 0xFF, 0xC0, 0x00, ##           0000000000000000000000000       
            0x00, 0x3F, 0xFF, 0xFF, 0x80, 0x00, ##            00000000000000000000000        
            0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, ##              0000000000000000000          
            0x00, 0x01, 0xFF, 0xF0, 0x00, 0x00, ##                 0000000000000             
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x0F, 0x00, 0x00, 0x00, ##                      0000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '163' => {    # '£'
        'width'    => 42, 
        'xoffset'  => 6, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x03, 0xFF, 0xC0, 0x00, ##                        000000000000        
            0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, ##                    000000000000000000000   
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, ##                  0000000000000000000000000 
            0x00, 0x03, 0xFF, 0xFF, 0xFF, 0x80, ##                000000000000000000000000000 
            0x00, 0x07, 0xFF, 0x01, 0xFF, 0x80, ##               00000000000       0000000000 
            0x00, 0x0F, 0xFC, 0x00, 0x7F, 0x80, ##              0000000000           00000000 
            0x00, 0x1F, 0xF0, 0x00, 0x3F, 0x80, ##             000000000              0000000 
            0x00, 0x1F, 0xE0, 0x00, 0x1F, 0x80, ##             00000000                000000 
            0x00, 0x3F, 0xE0, 0x00, 0x1F, 0x80, ##            000000000                000000 
            0x00, 0x3F, 0xC0, 0x00, 0x0F, 0x80, ##            00000000                  00000 
            0x00, 0x7F, 0xC0, 0x00, 0x0F, 0x80, ##           000000000                  00000 
            0x00, 0x7F, 0xC0, 0x00, 0x0F, 0x80, ##           000000000                  00000 
            0x00, 0x7F, 0x80, 0x00, 0x0F, 0x80, ##           00000000                   00000 
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000        
            0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, ##  0000000000000000000000000000000000        
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, ##          000000000                         
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0x80, 0x00, 0x07, 0xC0, ##          000000000                    00000
            0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##          0000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##  000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '164' => {    # '¤'
        'width'    => 46, 
        'xoffset'  => 5, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x18, 0x00, 0x00, 0x00, 0x00, 0x60, ##     00                                    00   
            0x3C, 0x00, 0x00, 0x00, 0x00, 0xF0, ##    0000                                  0000  
            0x7E, 0x00, 0x00, 0x00, 0x01, 0xF8, ##   000000                                000000 
            0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC, ##  00000000                              00000000
            0xFF, 0x80, 0x00, 0x00, 0x03, 0xF8, ##  000000000                             0000000 
            0x7F, 0xC0, 0x1F, 0xE0, 0x07, 0xF8, ##   000000000         00000000          00000000 
            0x3F, 0xE0, 0xFF, 0xFC, 0x0F, 0xF0, ##    000000000     00000000000000      00000000  
            0x1F, 0xF1, 0xFF, 0xFF, 0x1F, 0xE0, ##     000000000   00000000000000000   00000000   
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##      00000000000000000000000000000000000000    
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##       000000000000000000000000000000000000     
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##        0000000000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##         00000000000000000000000000000000       
            0x00, 0xFF, 0xF0, 0x3F, 0xFC, 0x00, ##          000000000000      000000000000        
            0x00, 0xFF, 0x80, 0x07, 0xFC, 0x00, ##          000000000            000000000        
            0x00, 0xFF, 0x00, 0x03, 0xFC, 0x00, ##          00000000              00000000        
            0x01, 0xFE, 0x00, 0x01, 0xFE, 0x00, ##         00000000                00000000       
            0x01, 0xFC, 0x00, 0x00, 0xFE, 0x00, ##         0000000                  0000000       
            0x03, 0xFC, 0x00, 0x00, 0xFF, 0x00, ##        00000000                  00000000      
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000      
            0x07, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##       00000000                    0000000      
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF0, 0x00, 0x00, 0x3F, 0x80, ##       0000000                      0000000     
            0x07, 0xF8, 0x00, 0x00, 0x7F, 0x80, ##       00000000                    00000000     
            0x03, 0xF8, 0x00, 0x00, 0x7F, 0x00, ##        0000000                    0000000      
            0x03, 0xFC, 0x00, 0x00, 0xFF, 0x00, ##        00000000                  00000000      
            0x01, 0xFC, 0x00, 0x00, 0xFE, 0x00, ##         0000000                  0000000       
            0x01, 0xFE, 0x00, 0x01, 0xFE, 0x00, ##         00000000                00000000       
            0x00, 0xFF, 0x00, 0x03, 0xFC, 0x00, ##          00000000              00000000        
            0x00, 0xFF, 0x80, 0x0F, 0xFC, 0x00, ##          000000000           0000000000        
            0x00, 0xFF, 0xF0, 0x3F, 0xFC, 0x00, ##          000000000000      000000000000        
            0x01, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, ##         00000000000000000000000000000000       
            0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, ##        0000000000000000000000000000000000      
            0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, ##       000000000000000000000000000000000000     
            0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##      00000000000000000000000000000000000000    
            0x1F, 0xF3, 0xFF, 0xFE, 0x3F, 0xE0, ##     000000000  00000000000000000   000000000   
            0x3F, 0xE0, 0xFF, 0xFC, 0x1F, 0xF0, ##    000000000     00000000000000     000000000  
            0x7F, 0xC0, 0x1F, 0xE0, 0x0F, 0xF8, ##   000000000         00000000         000000000 
            0x7F, 0x80, 0x00, 0x00, 0x07, 0xFC, ##   00000000                            000000000
            0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC, ##  00000000                              00000000
            0x7E, 0x00, 0x00, 0x00, 0x01, 0xF8, ##   000000                                000000 
            0x3C, 0x00, 0x00, 0x00, 0x00, 0xF0, ##    0000                                  0000  
            0x18, 0x00, 0x00, 0x00, 0x00, 0x60, ##     00                                    00   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '165' => {    # '¥'
        'width'    => 56, 
        'xoffset'  => -1, 
        'xadvance' => 55, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, ##  000000000000000000000000              000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, ##  000000000000000000000000              000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, ##  000000000000000000000000              000000000000000000
            0xFF, 0xFF, 0xFF, 0x00, 0x03, 0xFF, 0xFF, ##  000000000000000000000000              000000000000000000
            0x03, 0xFF, 0x00, 0x00, 0x00, 0x07, 0xC0, ##        0000000000                             00000      
            0x01, 0xFF, 0x80, 0x00, 0x00, 0x0F, 0xC0, ##         0000000000                           000000      
            0x01, 0xFF, 0xC0, 0x00, 0x00, 0x0F, 0x80, ##         00000000000                          00000       
            0x00, 0xFF, 0xC0, 0x00, 0x00, 0x1F, 0x80, ##          0000000000                         000000       
            0x00, 0xFF, 0xE0, 0x00, 0x00, 0x1F, 0x00, ##          00000000000                        00000        
            0x00, 0x7F, 0xE0, 0x00, 0x00, 0x3E, 0x00, ##           0000000000                       00000         
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x3E, 0x00, ##            0000000000                      00000         
            0x00, 0x3F, 0xF0, 0x00, 0x00, 0x7C, 0x00, ##            0000000000                     00000          
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0x7C, 0x00, ##             0000000000                    00000          
            0x00, 0x1F, 0xF8, 0x00, 0x00, 0xF8, 0x00, ##             0000000000                   00000           
            0x00, 0x0F, 0xFC, 0x00, 0x01, 0xF8, 0x00, ##              0000000000                 000000           
            0x00, 0x0F, 0xFE, 0x00, 0x01, 0xF0, 0x00, ##              00000000000                00000            
            0x00, 0x07, 0xFE, 0x00, 0x03, 0xF0, 0x00, ##               0000000000               000000            
            0x00, 0x03, 0xFF, 0x00, 0x03, 0xE0, 0x00, ##                0000000000              00000             
            0x00, 0x03, 0xFF, 0x00, 0x07, 0xC0, 0x00, ##                0000000000             00000              
            0x00, 0x01, 0xFF, 0x80, 0x07, 0xC0, 0x00, ##                 0000000000            00000              
            0x00, 0x01, 0xFF, 0x80, 0x0F, 0x80, 0x00, ##                 0000000000           00000               
            0x00, 0x00, 0xFF, 0xC0, 0x0F, 0x80, 0x00, ##                  0000000000          00000               
            0x00, 0x00, 0xFF, 0xE0, 0x1F, 0x00, 0x00, ##                  00000000000        00000                
            0x00, 0x00, 0x7F, 0xE0, 0x1F, 0x00, 0x00, ##                   0000000000        00000                
            0x00, 0x00, 0x7F, 0xF0, 0x3E, 0x00, 0x00, ##                   00000000000      00000                 
            0x00, 0x00, 0x3F, 0xF0, 0x7E, 0x00, 0x00, ##                    0000000000     000000                 
            0x01, 0xFF, 0xFF, 0xF8, 0x7F, 0xFF, 0xC0, ##         0000000000000000000000    00000000000000000      
            0x01, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000   000000000000000000      
            0x01, 0xFF, 0xFF, 0xFC, 0xFF, 0xFF, 0xC0, ##         00000000000000000000000  000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000000000000000000000000      
            0x00, 0x00, 0x07, 0xFF, 0xF0, 0x00, 0x00, ##                       000000000000000                    
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                        0000000000000                     
            0x00, 0x00, 0x03, 0xFF, 0xE0, 0x00, 0x00, ##                        0000000000000                     
            0x00, 0x00, 0x01, 0xFF, 0xC0, 0x00, 0x00, ##                         00000000000                      
            0x00, 0x00, 0x01, 0xFF, 0x80, 0x00, 0x00, ##                         0000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000000000000000000000000      
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, ##         0000000000000000000000000000000000000000000      
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, ##                          000000000                       
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x80, 0x00, ##                  0000000000000000000000000               
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '166' => {    # '¦'
        'width'    => 7, 
        'xoffset'  => 11, 
        'xadvance' => 29, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0x00, ##         
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0xFE, ##  0000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '167' => {    # '§'
        'width'    => 36, 
        'xoffset'  => 4, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x07, 0xFF, 0x00, 0x00, ##               00000000000            
            0x00, 0x3F, 0xFF, 0xF8, 0x00, ##            0000000000000000000       
            0x00, 0xFF, 0xFF, 0xFE, 0x00, ##          00000000000000000000000     
            0x01, 0xFF, 0xFF, 0xFE, 0x00, ##         000000000000000000000000     
            0x03, 0xFE, 0x03, 0xFE, 0x00, ##        000000000       000000000     
            0x07, 0xF8, 0x00, 0xFE, 0x00, ##       00000000           0000000     
            0x0F, 0xF0, 0x00, 0x3E, 0x00, ##      00000000              00000     
            0x0F, 0xE0, 0x00, 0x3E, 0x00, ##      0000000               00000     
            0x0F, 0xE0, 0x00, 0x1E, 0x00, ##      0000000                0000     
            0x1F, 0xC0, 0x00, 0x1E, 0x00, ##     0000000                 0000     
            0x1F, 0xC0, 0x00, 0x1E, 0x00, ##     0000000                 0000     
            0x1F, 0xC0, 0x00, 0x00, 0x00, ##     0000000                          
            0x1F, 0xC0, 0x00, 0x00, 0x00, ##     0000000                          
            0x1F, 0xC0, 0x00, 0x00, 0x00, ##     0000000                          
            0x1F, 0xE0, 0x00, 0x00, 0x00, ##     00000000                         
            0x1F, 0xF0, 0x00, 0x00, 0x00, ##     000000000                        
            0x0F, 0xF8, 0x00, 0x00, 0x00, ##      000000000                       
            0x0F, 0xFC, 0x00, 0x00, 0x00, ##      0000000000                      
            0x07, 0xFE, 0x00, 0x00, 0x00, ##       0000000000                     
            0x03, 0xFF, 0x80, 0x00, 0x00, ##        00000000000                   
            0x03, 0xFF, 0xC0, 0x00, 0x00, ##        000000000000                  
            0x00, 0xFF, 0xF0, 0x00, 0x00, ##          000000000000                
            0x00, 0x7F, 0xFC, 0x00, 0x00, ##           0000000000000              
            0x00, 0xFF, 0xFE, 0x00, 0x00, ##          000000000000000             
            0x03, 0xFF, 0xFF, 0x80, 0x00, ##        0000000000000000000           
            0x0F, 0xE3, 0xFF, 0xE0, 0x00, ##      0000000   0000000000000         
            0x1F, 0xC1, 0xFF, 0xF0, 0x00, ##     0000000     0000000000000        
            0x3F, 0x80, 0x7F, 0xFC, 0x00, ##    0000000        0000000000000      
            0x7F, 0x00, 0x1F, 0xFE, 0x00, ##   0000000           000000000000     
            0x7F, 0x00, 0x0F, 0xFF, 0x00, ##   0000000            000000000000    
            0x7E, 0x00, 0x03, 0xFF, 0x80, ##   000000               00000000000   
            0xFE, 0x00, 0x00, 0xFF, 0xC0, ##  0000000                 0000000000  
            0xFE, 0x00, 0x00, 0x7F, 0xE0, ##  0000000                  0000000000 
            0xFE, 0x00, 0x00, 0x3F, 0xE0, ##  0000000                   000000000 
            0xFE, 0x00, 0x00, 0x1F, 0xE0, ##  0000000                    00000000 
            0xFF, 0x00, 0x00, 0x0F, 0xF0, ##  00000000                    00000000
            0xFF, 0x80, 0x00, 0x0F, 0xF0, ##  000000000                   00000000
            0xFF, 0x80, 0x00, 0x07, 0xF0, ##  000000000                    0000000
            0x7F, 0xC0, 0x00, 0x07, 0xF0, ##   000000000                   0000000
            0x7F, 0xE0, 0x00, 0x07, 0xF0, ##   0000000000                  0000000
            0x3F, 0xF8, 0x00, 0x07, 0xF0, ##    00000000000                0000000
            0x1F, 0xFC, 0x00, 0x07, 0xF0, ##     00000000000               0000000
            0x0F, 0xFE, 0x00, 0x0F, 0xE0, ##      00000000000             0000000 
            0x07, 0xFF, 0x80, 0x0F, 0xE0, ##       000000000000           0000000 
            0x03, 0xFF, 0xC0, 0x1F, 0xC0, ##        000000000000         0000000  
            0x01, 0xFF, 0xF0, 0x1F, 0x80, ##         0000000000000       000000   
            0x00, 0x7F, 0xFC, 0x3F, 0x00, ##           0000000000000    000000    
            0x00, 0x3F, 0xFF, 0xFE, 0x00, ##            000000000000000000000     
            0x00, 0x0F, 0xFF, 0xF8, 0x00, ##              00000000000000000       
            0x00, 0x03, 0xFF, 0xE0, 0x00, ##                0000000000000         
            0x00, 0x00, 0xFF, 0xF0, 0x00, ##                  000000000000        
            0x00, 0x00, 0x7F, 0xF8, 0x00, ##                   000000000000       
            0x00, 0x00, 0x1F, 0xFC, 0x00, ##                     00000000000      
            0x00, 0x00, 0x0F, 0xFE, 0x00, ##                      00000000000     
            0x00, 0x00, 0x03, 0xFF, 0x00, ##                        0000000000    
            0x00, 0x00, 0x01, 0xFF, 0x00, ##                         000000000    
            0x00, 0x00, 0x00, 0xFF, 0x00, ##                          00000000    
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x7F, 0x80, ##                           00000000   
            0x00, 0x00, 0x00, 0x3F, 0x80, ##                            0000000   
            0x00, 0x00, 0x00, 0x3F, 0x80, ##                            0000000   
            0x00, 0x00, 0x00, 0x3F, 0x80, ##                            0000000   
            0x1E, 0x00, 0x00, 0x3F, 0x80, ##     0000                   0000000   
            0x1E, 0x00, 0x00, 0x3F, 0x80, ##     0000                   0000000   
            0x1E, 0x00, 0x00, 0x7F, 0x00, ##     0000                  0000000    
            0x1F, 0x00, 0x00, 0x7F, 0x00, ##     00000                 0000000    
            0x1F, 0x00, 0x00, 0xFF, 0x00, ##     00000                00000000    
            0x1F, 0xC0, 0x03, 0xFE, 0x00, ##     0000000            000000000     
            0x1F, 0xF0, 0x0F, 0xFC, 0x00, ##     000000000        0000000000      
            0x1F, 0xFF, 0xFF, 0xF8, 0x00, ##     00000000000000000000000000       
            0x1F, 0xFF, 0xFF, 0xE0, 0x00, ##     000000000000000000000000         
            0x07, 0xFF, 0xFF, 0xC0, 0x00, ##       000000000000000000000          
            0x00, 0x3F, 0xFC, 0x00, 0x00, ##            000000000000              
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '168' => {    # '¨'
        'width'    => 26, 
        'xoffset'  => 9, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000   
            0x7F, 0x80, 0x7F, 0x80, ##   00000000        00000000 
            0x7F, 0x80, 0x7F, 0x80, ##   00000000        00000000 
            0xFF, 0xC0, 0xFF, 0xC0, ##  0000000000      0000000000
            0xFF, 0xC0, 0xFF, 0xC0, ##  0000000000      0000000000
            0xFF, 0xC0, 0xFF, 0xC0, ##  0000000000      0000000000
            0xFF, 0xC0, 0xFF, 0xC0, ##  0000000000      0000000000
            0x7F, 0x80, 0x7F, 0x80, ##   00000000        00000000 
            0x7F, 0x80, 0x7F, 0x80, ##   00000000        00000000 
            0x1E, 0x00, 0x1E, 0x00, ##     0000            0000   
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '169' => {    # '©'
        'width'    => 63, 
        'xoffset'  => 12, 
        'xadvance' => 87, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                          
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                        0000000000000000000                      
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                     0000000000000000000000000                   
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                   00000000000000000000000000000                 
            0x00, 0x01, 0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x00, ##                 00000000000           00000000000               
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                00000000                   00000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, 0x1F, 0xC0, 0x00, ##               0000000                       0000000             
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##             0000000                           0000000           
            0x00, 0x3F, 0x80, 0x00, 0x00, 0x01, 0xF8, 0x00, ##            0000000                              000000          
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##           000000                                 000000         
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, ##          000000                                   000000        
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##         000000                                     000000       
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, ##         00000                                       00000       
            0x03, 0xE0, 0x00, 0x1F, 0xF0, 0x00, 0x0F, 0x80, ##        00000                000000000                00000      
            0x07, 0xC0, 0x00, 0xFF, 0xFF, 0x00, 0x07, 0xC0, ##       00000              0000000000000000             00000     
            0x0F, 0x80, 0x03, 0xFF, 0xFF, 0xC0, 0x03, 0xC0, ##      00000             00000000000000000000            0000     
            0x0F, 0x80, 0x07, 0xFF, 0xFF, 0xF8, 0x03, 0xE0, ##      00000            000000000000000000000000         00000    
            0x1F, 0x00, 0x1F, 0xF0, 0x1F, 0xF8, 0x01, 0xF0, ##     00000           000000000       0000000000          00000   
            0x1E, 0x00, 0x1F, 0xC0, 0x03, 0xF8, 0x00, 0xF0, ##     0000            0000000            0000000           0000   
            0x3E, 0x00, 0x3F, 0x80, 0x01, 0xF8, 0x00, 0xF8, ##    00000           0000000              000000           00000  
            0x3C, 0x00, 0x7F, 0x00, 0x00, 0xF8, 0x00, 0x78, ##    0000           0000000                00000            0000  
            0x3C, 0x00, 0xFE, 0x00, 0x00, 0xF8, 0x00, 0x78, ##    0000          0000000                 00000            0000  
            0x7C, 0x00, 0xFE, 0x00, 0x00, 0x78, 0x00, 0x7C, ##   00000          0000000                  0000            00000 
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x78, 0x00, 0x3C, ##   0000          0000000                   0000             0000 
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x78, 0x00, 0x3C, ##   0000          0000000                   0000             0000 
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x38, 0x00, 0x3C, ##   0000          0000000                    000             0000 
            0xF8, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3E, ##  00000          000000                                     00000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x1E, ##  0000          0000000                                      0000
            0xF0, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3E, ##  0000           000000                                     00000
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3C, ##   0000          0000000                                    0000 
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x7C, 0x00, 0x3C, ##   0000          0000000                   00000            0000 
            0x78, 0x01, 0xFC, 0x00, 0x00, 0x7C, 0x00, 0x3C, ##   0000          0000000                   00000            0000 
            0x7C, 0x00, 0xFE, 0x00, 0x00, 0x7C, 0x00, 0x7C, ##   00000          0000000                  00000           00000 
            0x3C, 0x00, 0xFE, 0x00, 0x00, 0xF8, 0x00, 0x78, ##    0000          0000000                 00000            0000  
            0x3C, 0x00, 0x7F, 0x00, 0x01, 0xF8, 0x00, 0x78, ##    0000           0000000               000000            0000  
            0x3E, 0x00, 0x3F, 0x80, 0x01, 0xF0, 0x00, 0xF8, ##    00000           0000000              00000            00000  
            0x1E, 0x00, 0x3F, 0xC0, 0x07, 0xF0, 0x00, 0xF0, ##     0000           00000000           0000000            0000   
            0x1F, 0x00, 0x1F, 0xF0, 0x1F, 0xE0, 0x01, 0xF0, ##     00000           000000000       00000000            00000   
            0x0F, 0x80, 0x07, 0xFF, 0xFF, 0xC0, 0x03, 0xE0, ##      00000            000000000000000000000            00000    
            0x0F, 0x80, 0x03, 0xFF, 0xFF, 0x80, 0x03, 0xE0, ##      00000             0000000000000000000             00000    
            0x07, 0xC0, 0x00, 0xFF, 0xFE, 0x00, 0x07, 0xC0, ##       00000              000000000000000              00000     
            0x03, 0xE0, 0x00, 0x1F, 0xF0, 0x00, 0x0F, 0x80, ##        00000                000000000                00000      
            0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, ##        000000                                       00000       
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##         000000                                     000000       
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, ##          000000                                   000000        
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##           000000                                 000000         
            0x00, 0x3F, 0x80, 0x00, 0x00, 0x03, 0xF8, 0x00, ##            0000000                             0000000          
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##             0000000                           0000000           
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##              00000000                       00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                00000000                   00000000              
            0x00, 0x01, 0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x00, ##                 00000000000           00000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                   00000000000000000000000000000                 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                     0000000000000000000000000                   
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                        0000000000000000000                      
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '170' => {    # 'ª'
        'width'    => 34, 
        'xoffset'  => 5, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xF0, 0x00, 0x00, ##            0000000000              
            0x07, 0xFF, 0xFE, 0x00, 0x00, ##       000000000000000000           
            0x1F, 0xFF, 0xFF, 0x80, 0x00, ##     0000000000000000000000         
            0x1F, 0xE0, 0x3F, 0xC0, 0x00, ##     00000000       00000000        
            0x1F, 0x80, 0x07, 0xE0, 0x00, ##     000000            000000       
            0x1F, 0x00, 0x03, 0xF0, 0x00, ##     00000              000000      
            0x1E, 0x00, 0x01, 0xF8, 0x00, ##     0000                000000     
            0x1E, 0x00, 0x01, 0xF8, 0x00, ##     0000                000000     
            0x1C, 0x00, 0x00, 0xF8, 0x00, ##     000                  00000     
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000    
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000    
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000    
            0x00, 0x00, 0x00, 0xFC, 0x00, ##                          000000    
            0x00, 0x3F, 0xFF, 0xFC, 0x00, ##            00000000000000000000    
            0x03, 0xFF, 0xFF, 0xFC, 0x00, ##        000000000000000000000000    
            0x0F, 0xFF, 0xFF, 0xFC, 0x00, ##      00000000000000000000000000    
            0x1F, 0xF0, 0x00, 0xFC, 0x00, ##     000000000            000000    
            0x3F, 0xC0, 0x00, 0xFC, 0x00, ##    00000000              000000    
            0x7F, 0x00, 0x00, 0xFC, 0x00, ##   0000000                000000    
            0x7F, 0x00, 0x00, 0xFC, 0x00, ##   0000000                000000    
            0xFE, 0x00, 0x00, 0xFC, 0x00, ##  0000000                 000000    
            0xFE, 0x00, 0x00, 0xFC, 0x00, ##  0000000                 000000    
            0xFE, 0x00, 0x00, 0xFC, 0x00, ##  0000000                 000000    
            0xFE, 0x00, 0x00, 0xFC, 0x00, ##  0000000                 000000    
            0xFE, 0x00, 0x00, 0xFC, 0x00, ##  0000000                 000000    
            0xFE, 0x00, 0x01, 0xFC, 0x00, ##  0000000                0000000    
            0x7F, 0x00, 0x01, 0xFC, 0x00, ##   0000000               0000000    
            0x7F, 0x00, 0x03, 0xFC, 0x00, ##   0000000              00000000    
            0x3F, 0xC0, 0x07, 0xFC, 0x00, ##    00000000           000000000    
            0x1F, 0xF0, 0x1F, 0xFF, 0xC0, ##     000000000       000000000000000
            0x0F, 0xFF, 0xFC, 0xFF, 0xC0, ##      000000000000000000  0000000000
            0x07, 0xFF, 0xF8, 0xFF, 0xC0, ##       0000000000000000   0000000000
            0x00, 0xFF, 0xC0, 0x00, 0x00, ##          0000000000                
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                    
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFF, 0x00, ##    000000000000000000000000000000  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '171' => {    # '«'
        'width'    => 39, 
        'xoffset'  => 7, 
        'xadvance' => 54, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x02, ##                                        0
            0x00, 0x00, 0x10, 0x00, 0x06, ##                     0                 00
            0x00, 0x00, 0x30, 0x00, 0x0E, ##                    00                000
            0x00, 0x00, 0x70, 0x00, 0x1E, ##                   000               0000
            0x00, 0x01, 0xF0, 0x00, 0x3E, ##                 00000              00000
            0x00, 0x03, 0xF0, 0x00, 0x7C, ##                000000             00000 
            0x00, 0x07, 0xE0, 0x00, 0xFC, ##               000000             000000 
            0x00, 0x0F, 0xC0, 0x01, 0xF8, ##              000000             000000  
            0x00, 0x1F, 0x80, 0x03, 0xF0, ##             000000             000000   
            0x00, 0x3F, 0x00, 0x0F, 0xE0, ##            000000            0000000    
            0x00, 0x7F, 0x00, 0x1F, 0xC0, ##           0000000           0000000     
            0x00, 0xFE, 0x00, 0x3F, 0x80, ##          0000000           0000000      
            0x01, 0xFC, 0x00, 0x7F, 0x00, ##         0000000           0000000       
            0x07, 0xF8, 0x00, 0xFF, 0x00, ##       00000000           00000000       
            0x0F, 0xF0, 0x01, 0xFE, 0x00, ##      00000000           00000000        
            0x1F, 0xE0, 0x03, 0xFC, 0x00, ##     00000000           00000000         
            0x3F, 0xC0, 0x07, 0xF8, 0x00, ##    00000000           00000000          
            0x7F, 0xC0, 0x0F, 0xF0, 0x00, ##   000000000          00000000           
            0xFF, 0x80, 0x3F, 0xE0, 0x00, ##  000000000         000000000            
            0xFF, 0x00, 0x3F, 0xC0, 0x00, ##  00000000          00000000             
            0xFF, 0x00, 0x3F, 0xC0, 0x00, ##  00000000          00000000             
            0xFF, 0x00, 0x3F, 0xE0, 0x00, ##  00000000          000000000            
            0x7F, 0x80, 0x1F, 0xF0, 0x00, ##   00000000          000000000           
            0x3F, 0xC0, 0x0F, 0xF8, 0x00, ##    00000000          000000000          
            0x1F, 0xE0, 0x07, 0xFC, 0x00, ##     00000000          000000000         
            0x0F, 0xF0, 0x03, 0xFC, 0x00, ##      00000000          00000000         
            0x07, 0xF8, 0x00, 0xFE, 0x00, ##       00000000           0000000        
            0x03, 0xFC, 0x00, 0x7F, 0x00, ##        00000000           0000000       
            0x01, 0xFC, 0x00, 0x3F, 0x80, ##         0000000            0000000      
            0x00, 0xFE, 0x00, 0x1F, 0xC0, ##          0000000            0000000     
            0x00, 0x3F, 0x00, 0x0F, 0xE0, ##            000000            0000000    
            0x00, 0x1F, 0x80, 0x07, 0xF0, ##             000000            0000000   
            0x00, 0x0F, 0xC0, 0x03, 0xF0, ##              000000            000000   
            0x00, 0x07, 0xE0, 0x01, 0xF8, ##               000000            000000  
            0x00, 0x03, 0xF0, 0x00, 0xFC, ##                000000            000000 
            0x00, 0x01, 0xF0, 0x00, 0x3E, ##                 00000              00000
            0x00, 0x00, 0xF0, 0x00, 0x1E, ##                  0000               0000
            0x00, 0x00, 0x70, 0x00, 0x0E, ##                   000                000
            0x00, 0x00, 0x30, 0x00, 0x06, ##                    00                 00
            0x00, 0x00, 0x00, 0x00, 0x02, ##                                        0
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '172' => {    # '¬'
        'width'    => 54, 
        'xoffset'  => 10, 
        'xadvance' => 73, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, ##                                                 0000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '173' => {    # '­'
        'width'    => 22, 
        'xoffset'  => 4, 
        'xadvance' => 30, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0xFF, 0xFF, 0xFC, ##  0000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '174' => {    # '®'
        'width'    => 63, 
        'xoffset'  => 12, 
        'xadvance' => 87, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                          
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                        0000000000000000000                      
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                     0000000000000000000000000                   
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                   00000000000000000000000000000                 
            0x00, 0x01, 0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x00, ##                 00000000000           00000000000               
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                00000000                   00000000              
            0x00, 0x07, 0xF0, 0x00, 0x00, 0x1F, 0xC0, 0x00, ##               0000000                       0000000             
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##             0000000                           0000000           
            0x00, 0x3F, 0x80, 0x00, 0x00, 0x01, 0xF8, 0x00, ##            0000000                              000000          
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##           000000                                 000000         
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, ##          000000                                   000000        
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##         000000                                     000000       
            0x01, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, ##         00000                                       00000       
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, ##        00000                                         00000      
            0x07, 0xC0, 0xFF, 0xFF, 0xFC, 0x00, 0x07, 0xC0, ##       00000      0000000000000000000000               00000     
            0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xC0, ##      00000       0000000000000000000000000             0000     
            0x0F, 0x80, 0xFF, 0xFF, 0xFF, 0xC0, 0x03, 0xE0, ##      00000       00000000000000000000000000            00000    
            0x1F, 0x00, 0x0F, 0xC0, 0x1F, 0xE0, 0x01, 0xF0, ##     00000            000000         00000000            00000   
            0x1E, 0x00, 0x0F, 0xC0, 0x07, 0xF0, 0x00, 0xF0, ##     0000             000000           0000000            0000   
            0x3E, 0x00, 0x0F, 0xC0, 0x03, 0xF0, 0x00, 0xF8, ##    00000             000000            000000            00000  
            0x3C, 0x00, 0x0F, 0xC0, 0x03, 0xF8, 0x00, 0x78, ##    0000              000000            0000000            0000  
            0x3C, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x78, ##    0000              000000             000000            0000  
            0x7C, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x7C, ##   00000              000000             000000            00000 
            0x78, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x3C, ##   0000               000000             000000             0000 
            0x78, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x3C, ##   0000               000000             000000             0000 
            0x78, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x3C, ##   0000               000000             000000             0000 
            0xF8, 0x00, 0x0F, 0xC0, 0x03, 0xF8, 0x00, 0x3E, ##  00000               000000            0000000             00000
            0xF0, 0x00, 0x0F, 0xC0, 0x03, 0xF0, 0x00, 0x1E, ##  0000                000000            000000               0000
            0xF0, 0x00, 0x0F, 0xC0, 0x07, 0xF0, 0x00, 0x1E, ##  0000                000000           0000000               0000
            0xF0, 0x00, 0x0F, 0xC0, 0x1F, 0xE0, 0x00, 0x1E, ##  0000                000000         00000000                0000
            0xF0, 0x00, 0x0F, 0xFF, 0xFF, 0x80, 0x00, 0x1E, ##  0000                000000000000000000000                  0000
            0xF0, 0x00, 0x0F, 0xFF, 0xF8, 0x00, 0x00, 0x1E, ##  0000                00000000000000000                      0000
            0xF0, 0x00, 0x0F, 0xFF, 0xFE, 0x00, 0x00, 0x1E, ##  0000                0000000000000000000                    0000
            0xF0, 0x00, 0x0F, 0xC0, 0x7F, 0x00, 0x00, 0x1E, ##  0000                000000       0000000                   0000
            0xF0, 0x00, 0x0F, 0xC0, 0x3F, 0x80, 0x00, 0x1E, ##  0000                000000        0000000                  0000
            0xF0, 0x00, 0x0F, 0xC0, 0x1F, 0xC0, 0x00, 0x1E, ##  0000                000000         0000000                 0000
            0xF0, 0x00, 0x0F, 0xC0, 0x0F, 0xC0, 0x00, 0x1E, ##  0000                000000          000000                 0000
            0xF0, 0x00, 0x0F, 0xC0, 0x0F, 0xE0, 0x00, 0x3E, ##  0000                000000          0000000               00000
            0x78, 0x00, 0x0F, 0xC0, 0x07, 0xE0, 0x00, 0x3C, ##   0000               000000           000000               0000 
            0x78, 0x00, 0x0F, 0xC0, 0x07, 0xF0, 0x00, 0x3C, ##   0000               000000           0000000              0000 
            0x78, 0x00, 0x0F, 0xC0, 0x03, 0xF0, 0x00, 0x3C, ##   0000               000000            000000              0000 
            0x7C, 0x00, 0x0F, 0xC0, 0x03, 0xF8, 0x00, 0x7C, ##   00000              000000            0000000            00000 
            0x3C, 0x00, 0x0F, 0xC0, 0x01, 0xF8, 0x00, 0x78, ##    0000              000000             000000            0000  
            0x3C, 0x00, 0x0F, 0xC0, 0x01, 0xFC, 0x00, 0x78, ##    0000              000000             0000000           0000  
            0x3E, 0x00, 0x0F, 0xC0, 0x00, 0xFC, 0x00, 0xF8, ##    00000             000000              000000          00000  
            0x1E, 0x00, 0x0F, 0xC0, 0x00, 0xFE, 0x00, 0xF0, ##     0000             000000              0000000         0000   
            0x1F, 0x00, 0xFF, 0xF8, 0x00, 0x7F, 0xC1, 0xF0, ##     00000        0000000000000            000000000     00000   
            0x0F, 0x80, 0xFF, 0xF8, 0x00, 0x7F, 0xC3, 0xE0, ##      00000       0000000000000            000000000    00000    
            0x0F, 0x80, 0xFF, 0xF8, 0x00, 0x3F, 0xC3, 0xE0, ##      00000       0000000000000             00000000    00000    
            0x07, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xC0, ##       00000                                           00000     
            0x03, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x80, ##        00000                                         00000      
            0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x00, ##        000000                                       00000       
            0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, ##         000000                                     000000       
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, ##          000000                                   000000        
            0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##           000000                                 000000         
            0x00, 0x3F, 0x80, 0x00, 0x00, 0x03, 0xF8, 0x00, ##            0000000                             0000000          
            0x00, 0x1F, 0xC0, 0x00, 0x00, 0x07, 0xF0, 0x00, ##             0000000                           0000000           
            0x00, 0x0F, 0xF0, 0x00, 0x00, 0x1F, 0xE0, 0x00, ##              00000000                       00000000            
            0x00, 0x03, 0xFC, 0x00, 0x00, 0x7F, 0x80, 0x00, ##                00000000                   00000000              
            0x00, 0x01, 0xFF, 0xC0, 0x07, 0xFF, 0x00, 0x00, ##                 00000000000           00000000000               
            0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFC, 0x00, 0x00, ##                   00000000000000000000000000000                 
            0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xF0, 0x00, 0x00, ##                     0000000000000000000000000                   
            0x00, 0x00, 0x03, 0xFF, 0xFF, 0x80, 0x00, 0x00, ##                        0000000000000000000                      
            0x00, 0x00, 0x00, 0x3F, 0xF8, 0x00, 0x00, 0x00, ##                            00000000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '175' => {    # '¯'
        'width'    => 25, 
        'xoffset'  => 9, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0xFF, 0xFF, 0xFF, 0x80, ##  0000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 27, 
        'xoffset'  => 8, 
        'xadvance' => 43, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0x80, 0x00, ##            0000000          
            0x01, 0xFF, 0xF0, 0x00, ##         0000000000000       
            0x03, 0xFF, 0xF8, 0x00, ##        000000000000000      
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000    
            0x1F, 0xFF, 0xFE, 0x00, ##     00000000000000000000    
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000   
            0x3F, 0xE0, 0xFF, 0x80, ##    000000000     000000000  
            0x7F, 0x80, 0x3F, 0xC0, ##   00000000         00000000 
            0x7F, 0x00, 0x1F, 0xC0, ##   0000000           0000000 
            0x7E, 0x00, 0x0F, 0xC0, ##   000000             000000 
            0xFE, 0x00, 0x0F, 0xE0, ##  0000000             0000000
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xFC, 0x00, 0x07, 0xE0, ##  000000               000000
            0xFE, 0x00, 0x0F, 0xE0, ##  0000000             0000000
            0x7E, 0x00, 0x0F, 0xC0, ##   000000             000000 
            0x7F, 0x00, 0x1F, 0xC0, ##   0000000           0000000 
            0x7F, 0x80, 0x3F, 0xC0, ##   00000000         00000000 
            0x3F, 0xE0, 0xFF, 0x80, ##    000000000     000000000  
            0x3F, 0xFF, 0xFF, 0x00, ##    0000000000000000000000   
            0x1F, 0xFF, 0xFF, 0x00, ##     000000000000000000000   
            0x0F, 0xFF, 0xFE, 0x00, ##      0000000000000000000    
            0x07, 0xFF, 0xF8, 0x00, ##       0000000000000000      
            0x01, 0xFF, 0xF0, 0x00, ##         0000000000000       
            0x00, 0x3F, 0x80, 0x00, ##            0000000          
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '177' => {    # '±'
        'width'    => 54, 
        'xoffset'  => 9, 
        'xadvance' => 72, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##                          0000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                                                        
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, ##  000000000000000000000000000000000000000000000000000000
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '178' => {    # '²'
        'width'    => 26, 
        'xoffset'  => 4, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0x00, 0x00, ##         000000000          
            0x1F, 0xFF, 0xE0, 0x00, ##     0000000000000000       
            0x7F, 0xFF, 0xF8, 0x00, ##   00000000000000000000     
            0xFF, 0x03, 0xFC, 0x00, ##  00000000      00000000    
            0xFC, 0x00, 0xFE, 0x00, ##  000000          0000000   
            0xF8, 0x00, 0x7F, 0x00, ##  00000            0000000  
            0xF0, 0x00, 0x3F, 0x00, ##  0000              000000  
            0xF0, 0x00, 0x3F, 0x80, ##  0000              0000000 
            0xF0, 0x00, 0x1F, 0x80, ##  0000               000000 
            0xE0, 0x00, 0x1F, 0x80, ##  000                000000 
            0x00, 0x00, 0x1F, 0x80, ##                     000000 
            0x00, 0x00, 0x1F, 0x80, ##                     000000 
            0x00, 0x00, 0x1F, 0x80, ##                     000000 
            0x00, 0x00, 0x1F, 0x00, ##                     00000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3E, 0x00, ##                    00000   
            0x00, 0x00, 0x7C, 0x00, ##                   00000    
            0x00, 0x00, 0xFC, 0x00, ##                  000000    
            0x00, 0x00, 0xF8, 0x00, ##                  00000     
            0x00, 0x01, 0xF0, 0x00, ##                 00000      
            0x00, 0x03, 0xE0, 0x00, ##                00000       
            0x00, 0x07, 0xC0, 0x00, ##               00000        
            0x00, 0x0F, 0x80, 0x00, ##              00000         
            0x00, 0x1F, 0x00, 0x00, ##             00000          
            0x00, 0x3E, 0x00, 0x00, ##            00000           
            0x00, 0xFC, 0x00, 0x00, ##          000000            
            0x01, 0xF8, 0x00, 0x00, ##         000000             
            0x03, 0xF0, 0x00, 0x00, ##        000000              
            0x07, 0xE0, 0x01, 0xC0, ##       000000            000
            0x0F, 0xC0, 0x01, 0xC0, ##      000000             000
            0x1F, 0x80, 0x01, 0xC0, ##     000000              000
            0x3F, 0x00, 0x01, 0xC0, ##    000000               000
            0x7E, 0x00, 0x01, 0xC0, ##   000000                000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0xFF, 0xFF, 0xFF, 0xC0, ##  00000000000000000000000000
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '179' => {    # '³'
        'width'    => 26, 
        'xoffset'  => 4, 
        'xadvance' => 34, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x01, 0xFF, 0x80, 0x00, ##         0000000000         
            0x1F, 0xFF, 0xE0, 0x00, ##     0000000000000000       
            0x7F, 0xFF, 0xF8, 0x00, ##   00000000000000000000     
            0x7F, 0x03, 0xFC, 0x00, ##   0000000      00000000    
            0x7C, 0x00, 0xFE, 0x00, ##   00000          0000000   
            0x78, 0x00, 0x7E, 0x00, ##   0000            000000   
            0x78, 0x00, 0x3F, 0x00, ##   0000             000000  
            0x70, 0x00, 0x3F, 0x00, ##   000              000000  
            0x70, 0x00, 0x3F, 0x00, ##   000              000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x3F, 0x00, ##                    000000  
            0x00, 0x00, 0x7E, 0x00, ##                   000000   
            0x00, 0x00, 0x7E, 0x00, ##                   000000   
            0x00, 0x00, 0xFC, 0x00, ##                  000000    
            0x00, 0x03, 0xF8, 0x00, ##                0000000     
            0x00, 0x7F, 0xE0, 0x00, ##           0000000000       
            0x00, 0x7F, 0x00, 0x00, ##           0000000          
            0x00, 0x7F, 0xF0, 0x00, ##           00000000000      
            0x00, 0x03, 0xFC, 0x00, ##                00000000    
            0x00, 0x00, 0xFE, 0x00, ##                  0000000   
            0x00, 0x00, 0x7F, 0x00, ##                   0000000  
            0x00, 0x00, 0x3F, 0x80, ##                    0000000 
            0x00, 0x00, 0x3F, 0x80, ##                    0000000 
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000
            0x00, 0x00, 0x1F, 0xC0, ##                     0000000
            0xE0, 0x00, 0x1F, 0xC0, ##  000                0000000
            0xE0, 0x00, 0x1F, 0xC0, ##  000                0000000
            0xE0, 0x00, 0x3F, 0xC0, ##  000               00000000
            0xF0, 0x00, 0x3F, 0x80, ##  0000              0000000 
            0xF8, 0x00, 0x7F, 0x80, ##  00000            00000000 
            0xFC, 0x00, 0xFF, 0x00, ##  000000          00000000  
            0xFF, 0xFF, 0xFE, 0x00, ##  00000000000000000000000   
            0x7F, 0xFF, 0xF8, 0x00, ##   00000000000000000000     
            0x0F, 0xFF, 0xE0, 0x00, ##      000000000000000       
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '180' => {    # '´'
        'width'    => 19, 
        'xoffset'  => 17, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x3F, 0xE0, ##            000000000
            0x00, 0x3F, 0xC0, ##            00000000 
            0x00, 0x7F, 0x80, ##           00000000  
            0x00, 0xFF, 0x00, ##          00000000   
            0x00, 0xFE, 0x00, ##          0000000    
            0x01, 0xFC, 0x00, ##         0000000     
            0x03, 0xF8, 0x00, ##        0000000      
            0x03, 0xF0, 0x00, ##        000000       
            0x07, 0xE0, 0x00, ##       000000        
            0x0F, 0xE0, 0x00, ##      0000000        
            0x1F, 0xC0, 0x00, ##     0000000         
            0x1F, 0x80, 0x00, ##     000000          
            0x3F, 0x00, 0x00, ##    000000           
            0x7E, 0x00, 0x00, ##   000000            
            0x7C, 0x00, 0x00, ##   00000             
            0xF8, 0x00, 0x00, ##  00000              
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '181' => {    # 'µ'
        'width'    => 51, 
        'xoffset'  => 2, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xF0, 0x00, ##  000000000000000              000000000000000       
            0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xF0, 0x00, ##  000000000000000              000000000000000       
            0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xF0, 0x00, ##  000000000000000              000000000000000       
            0xFF, 0xFE, 0x00, 0x07, 0xFF, 0xF0, 0x00, ##  000000000000000              000000000000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##         00000000                     00000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##         00000000                    000000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##         00000000                    000000000       
            0x01, 0xFE, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##         00000000                    000000000       
            0x01, 0xFF, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##         000000000                   000000000       
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##         000000000                  0000000000       
            0x01, 0xFF, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##         000000000                  0000000000       
            0x01, 0xFF, 0x00, 0x00, 0x7F, 0xF0, 0x00, ##         000000000                 00000000000       
            0x01, 0xFF, 0x80, 0x00, 0x7F, 0xF0, 0x00, ##         0000000000                00000000000       
            0x01, 0xFF, 0xC0, 0x00, 0xEF, 0xF0, 0x00, ##         00000000000              000 00000000       
            0x01, 0xFF, 0xE0, 0x03, 0xEF, 0xF0, 0x00, ##         000000000000           00000 00000000       
            0x01, 0xFF, 0xF8, 0x0F, 0xCF, 0xF0, 0x00, ##         00000000000000       000000  00000000       
            0x01, 0xFF, 0xFF, 0xFF, 0x8F, 0xFF, 0xE0, ##         00000000000000000000000000   000000000000000
            0x01, 0xFF, 0xFF, 0xFF, 0x0F, 0xFF, 0xE0, ##         0000000000000000000000000    000000000000000
            0x01, 0xFF, 0xFF, 0xFE, 0x0F, 0xFF, 0xE0, ##         000000000000000000000000     000000000000000
            0x01, 0xFE, 0x7F, 0xF8, 0x0F, 0xFF, 0xE0, ##         00000000  000000000000       000000000000000
            0x01, 0xFE, 0x1F, 0xE0, 0x00, 0x00, 0x00, ##         00000000    00000000                        
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0x01, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00, ##         00000000                                    
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                            
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                            
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                            
            0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00, ##  00000000000000000000000                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '182' => {    # '¶'
        'width'    => 43, 
        'xoffset'  => 7, 
        'xadvance' => 56, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xE0, ##                 0000000000000000000000000000
            0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xE0, ##             00000000000000000000000000000000
            0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xE0, ##           0000000000000000000000000000000000
            0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, ##         000000000000000000000000000000000000
            0x03, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##        000000000000000000         00000     
            0x07, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##       0000000000000000000         00000     
            0x0F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##      00000000000000000000         00000     
            0x1F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##     000000000000000000000         00000     
            0x3F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##    0000000000000000000000         00000     
            0x3F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##    0000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0xFF, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##  000000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x7F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##   00000000000000000000000         00000     
            0x3F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##    0000000000000000000000         00000     
            0x1F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##     000000000000000000000         00000     
            0x1F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##     000000000000000000000         00000     
            0x0F, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##      00000000000000000000         00000     
            0x07, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##       0000000000000000000         00000     
            0x03, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##        000000000000000000         00000     
            0x00, 0xFF, 0xFF, 0x00, 0x7C, 0x00, ##          0000000000000000         00000     
            0x00, 0x3F, 0xFF, 0x00, 0x7C, 0x00, ##            00000000000000         00000     
            0x00, 0x0F, 0xFF, 0x00, 0x7C, 0x00, ##              000000000000         00000     
            0x00, 0x00, 0x7F, 0x00, 0x7C, 0x00, ##                   0000000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x1F, 0x00, 0x7C, 0x00, ##                     00000         00000     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '183' => {    # '·'
        'width'    => 11, 
        'xoffset'  => 8, 
        'xadvance' => 27, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x1F, 0x00, ##     00000   
            0x3F, 0x80, ##    0000000  
            0x7F, 0xC0, ##   000000000 
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0xFF, 0xE0, ##  00000000000
            0x7F, 0xC0, ##   000000000 
            0x3F, 0x80, ##    0000000  
            0x1F, 0x00, ##     00000   
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '184' => {    # '¸'
        'width'    => 18, 
        'xoffset'  => 12, 
        'xadvance' => 44, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x78, 0x00, ##           0000     
            0x00, 0x7C, 0x00, ##           00000    
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x3E, 0x00, ##            00000   
            0x00, 0x1F, 0x00, ##             00000  
            0x00, 0x1F, 0x80, ##             000000 
            0x00, 0x0F, 0x80, ##              00000 
            0x00, 0x0F, 0xC0, ##              000000
            0x00, 0x0F, 0xC0, ##              000000
            0x00, 0x0F, 0xC0, ##              000000
            0x00, 0x1F, 0xC0, ##             0000000
            0xE0, 0x7F, 0xC0, ##  000      000000000
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x80, ##  00000000000000000 
            0xFF, 0xFF, 0x00, ##  0000000000000000  
            0xFF, 0xFE, 0x00, ##  000000000000000   
            0x3F, 0xF0, 0x00, ##    0000000000      
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '185' => {    # '¹'
        'width'    => 22, 
        'xoffset'  => 6, 
        'xadvance' => 35, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x3C, 0x00, ##            0000        
            0x00, 0xFC, 0x00, ##          000000        
            0x03, 0xFC, 0x00, ##        00000000        
            0x0F, 0xFC, 0x00, ##      0000000000        
            0x1F, 0xFC, 0x00, ##     00000000000        
            0x7F, 0xFC, 0x00, ##   0000000000000        
            0xFC, 0xFC, 0x00, ##  000000  000000        
            0xF8, 0xFC, 0x00, ##  00000   000000        
            0xE0, 0xFC, 0x00, ##  000     000000        
            0x80, 0xFC, 0x00, ##  0       000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x00, 0xFC, 0x00, ##          000000        
            0x7F, 0xFF, 0xFC, ##   000000000000000000000
            0x7F, 0xFF, 0xFC, ##   000000000000000000000
            0x7F, 0xFF, 0xFC, ##   000000000000000000000
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '186' => {    # 'º'
        'width'    => 33, 
        'xoffset'  => 4, 
        'xadvance' => 41, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x7F, 0xFF, 0x00, 0x00, ##           000000000000000         
            0x01, 0xFF, 0xFF, 0xC0, 0x00, ##         0000000000000000000       
            0x03, 0xF8, 0x0F, 0xE0, 0x00, ##        0000000       0000000      
            0x07, 0xE0, 0x03, 0xF0, 0x00, ##       000000           000000     
            0x0F, 0xC0, 0x01, 0xF8, 0x00, ##      000000             000000    
            0x1F, 0x80, 0x00, 0xFC, 0x00, ##     000000               000000   
            0x3F, 0x80, 0x00, 0xFE, 0x00, ##    0000000               0000000  
            0x3F, 0x00, 0x00, 0x7E, 0x00, ##    000000                 000000  
            0x7F, 0x00, 0x00, 0x7F, 0x00, ##   0000000                 0000000 
            0x7F, 0x00, 0x00, 0x7F, 0x00, ##   0000000                 0000000 
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0xFE, 0x00, 0x00, 0x3F, 0x80, ##  0000000                   0000000
            0x7E, 0x00, 0x00, 0x3F, 0x00, ##   000000                   000000 
            0x7F, 0x00, 0x00, 0x7F, 0x00, ##   0000000                 0000000 
            0x7F, 0x00, 0x00, 0x7F, 0x00, ##   0000000                 0000000 
            0x3F, 0x00, 0x00, 0x7E, 0x00, ##    000000                 000000  
            0x3F, 0x80, 0x00, 0xFE, 0x00, ##    0000000               0000000  
            0x1F, 0x80, 0x00, 0xFC, 0x00, ##     000000               000000   
            0x0F, 0xC0, 0x01, 0xF8, 0x00, ##      000000             000000    
            0x07, 0xE0, 0x03, 0xF8, 0x00, ##       000000           0000000    
            0x03, 0xF8, 0x0F, 0xE0, 0x00, ##        0000000       0000000      
            0x01, 0xFF, 0xFF, 0xC0, 0x00, ##         0000000000000000000       
            0x00, 0x7F, 0xFF, 0x00, 0x00, ##           000000000000000         
            0x00, 0x0F, 0xF8, 0x00, 0x00, ##              000000000            
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x00, 0x00, 0x00, 0x00, 0x00, ##                                   
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000  
            0x3F, 0xFF, 0xFF, 0xFE, 0x00, ##    00000000000000000000000000000  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '187' => {    # '»'
        'width'    => 39, 
        'xoffset'  => 8, 
        'xadvance' => 53, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x20, 0x00, 0x00, ##                    0                    
            0x80, 0x00, 0x30, 0x00, 0x00, ##  0                 00                   
            0xC0, 0x00, 0x38, 0x00, 0x00, ##  00                000                  
            0xE0, 0x00, 0x3C, 0x00, 0x00, ##  000               0000                 
            0xF8, 0x00, 0x3E, 0x00, 0x00, ##  00000             00000                
            0xFC, 0x00, 0x1F, 0x00, 0x00, ##  000000             00000               
            0x7E, 0x00, 0x1F, 0x80, 0x00, ##   000000            000000              
            0x3F, 0x00, 0x0F, 0xC0, 0x00, ##    000000            000000             
            0x1F, 0x80, 0x07, 0xE0, 0x00, ##     000000            000000            
            0x0F, 0xC0, 0x03, 0xF8, 0x00, ##      000000            0000000          
            0x0F, 0xE0, 0x01, 0xFC, 0x00, ##      0000000            0000000         
            0x07, 0xF0, 0x00, 0xFE, 0x00, ##       0000000            0000000        
            0x03, 0xF8, 0x00, 0x7F, 0x00, ##        0000000            0000000       
            0x01, 0xFE, 0x00, 0x7F, 0x80, ##         00000000          00000000      
            0x00, 0xFF, 0x00, 0x3F, 0xC0, ##          00000000          00000000     
            0x00, 0x7F, 0x80, 0x1F, 0xE0, ##           00000000          00000000    
            0x00, 0x7F, 0xC0, 0x0F, 0xF0, ##           000000000          00000000   
            0x00, 0x3F, 0xE0, 0x07, 0xF8, ##            000000000          00000000  
            0x00, 0x1F, 0xF0, 0x03, 0xFE, ##             000000000          000000000
            0x00, 0x0F, 0xF0, 0x01, 0xFE, ##              00000000           00000000
            0x00, 0x0F, 0xF0, 0x01, 0xFE, ##              00000000           00000000
            0x00, 0x1F, 0xF0, 0x03, 0xFE, ##             000000000          000000000
            0x00, 0x1F, 0xE0, 0x07, 0xFC, ##             00000000          000000000 
            0x00, 0x3F, 0xC0, 0x0F, 0xF8, ##            00000000          000000000  
            0x00, 0x7F, 0x80, 0x1F, 0xF0, ##           00000000          000000000   
            0x00, 0xFF, 0x00, 0x1F, 0xE0, ##          00000000           00000000    
            0x01, 0xFE, 0x00, 0x3F, 0x80, ##         00000000           0000000      
            0x03, 0xFC, 0x00, 0x7F, 0x00, ##        00000000           0000000       
            0x03, 0xF8, 0x00, 0xFE, 0x00, ##        0000000           0000000        
            0x07, 0xF0, 0x01, 0xFC, 0x00, ##       0000000           0000000         
            0x0F, 0xE0, 0x03, 0xF8, 0x00, ##      0000000           0000000          
            0x1F, 0x80, 0x07, 0xF0, 0x00, ##     000000            0000000           
            0x3F, 0x00, 0x07, 0xE0, 0x00, ##    000000             000000            
            0x7E, 0x00, 0x0F, 0xC0, 0x00, ##   000000             000000             
            0xFC, 0x00, 0x1F, 0x80, 0x00, ##  000000             000000              
            0xF8, 0x00, 0x3E, 0x00, 0x00, ##  00000             00000                
            0xF0, 0x00, 0x3C, 0x00, 0x00, ##  0000              0000                 
            0xE0, 0x00, 0x38, 0x00, 0x00, ##  000               000                  
            0xC0, 0x00, 0x30, 0x00, 0x00, ##  00                00                   
            0x80, 0x00, 0x20, 0x00, 0x00, ##  0                 0                    
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '188' => {    # '¼'
        'width'    => 75, 
        'xoffset'  => 6, 
        'xadvance' => 84, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##                                                      0000000                
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##            0000                                      000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##          000000                                     0000000                 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##        00000000                                     000000                  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##      0000000000                                    000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##     00000000000                                   0000000                   
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##   0000000000000                                   000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##  000000  000000                                  0000000                    
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##  0000    000000                                  000000                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##  000     000000                                 000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##  0       000000                                0000000                      
            0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##          000000                                000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, ##          000000                               0000000                       
            0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##          000000                               000000                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##          000000                              000000                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##          000000                             0000000                         
            0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, ##          000000                             000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, ##          000000                            0000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, ##          000000                            000000                           
            0x00, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, ##          000000                           000000                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, ##          000000                          0000000                            
            0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, ##          000000                          000000                             
            0x00, 0x00, 0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x00, ##          000000                         0000000                             
            0x00, 0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, ##          000000                         000000                              
            0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, ##          000000                        000000                               
            0x00, 0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, 0x00, ##          000000                       0000000                               
            0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##          000000                       000000                                
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, ##          000000                      0000000                                
            0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, ##          000000                      000000                                 
            0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, ##          000000                     000000                                  
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x03, 0xF0, 0x00, ##          000000                    0000000                     000000       
            0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x07, 0xF0, 0x00, ##          000000                    000000                     0000000       
            0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x0F, 0xF0, 0x00, ##          000000                   0000000                    00000000       
            0x00, 0x00, 0xFC, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##   000000000000000000000          0000000                    000000000       
            0x00, 0x00, 0xFC, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0xF0, 0x00, ##   000000000000000000000          000000                     000000000       
            0x00, 0x00, 0xFC, 0x01, 0xFC, 0x00, 0x00, 0x3F, 0xF0, 0x00, ##   000000000000000000000         0000000                    0000000000       
            0x00, 0x00, 0xFC, 0x01, 0xF8, 0x00, 0x00, 0x7B, 0xF0, 0x00, ##   000000000000000000000         000000                    0000 000000       
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0xF3, 0xF0, 0x00, ##                                0000000                   0000  000000       
            0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0xE3, 0xF0, 0x00, ##                               0000000                    000   000000       
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x01, 0xE3, 0xF0, 0x00, ##                               000000                    0000   000000       
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x03, 0xC3, 0xF0, 0x00, ##                              0000000                   0000    000000       
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0x83, 0xF0, 0x00, ##                              000000                   0000     000000       
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x07, 0x83, 0xF0, 0x00, ##                             0000000                   0000     000000       
            0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x0F, 0x03, 0xF0, 0x00, ##                            0000000                   0000      000000       
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x1E, 0x03, 0xF0, 0x00, ##                            000000                   0000       000000       
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x1C, 0x03, 0xF0, 0x00, ##                           0000000                   000        000000       
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x3C, 0x03, 0xF0, 0x00, ##                           000000                   0000        000000       
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x78, 0x03, 0xF0, 0x00, ##                          0000000                  0000         000000       
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0xF0, 0x03, 0xF0, 0x00, ##                         0000000                  0000          000000       
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0xE0, 0x03, 0xF0, 0x00, ##                         000000                   000           000000       
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x01, 0xE0, 0x03, 0xF0, 0x00, ##                        0000000                  0000           000000       
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x03, 0xC0, 0x03, 0xF0, 0x00, ##                        000000                  0000            000000       
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x07, 0x80, 0x03, 0xF0, 0x00, ##                       0000000                 0000             000000       
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, ##                      0000000                  000000000000000000000000000000
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, ##                      000000                   000000000000000000000000000000
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, ##                     0000000                   000000000000000000000000000000
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xE0, ##                     000000                    000000000000000000000000000000
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                    0000000                                     000000       
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                   0000000                                      000000       
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                   000000                                       000000       
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                  0000000                                       000000       
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, ##                 0000000                                        000000       
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                 0000000                                  000000000000000000 
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                0000000                                   000000000000000000 
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC0, ##                000000                                    000000000000000000 
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xC0, ##               0000000                                    000000000000000000 
            0x00, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##              0000000                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '189' => {    # '½'
        'width'    => 72, 
        'xoffset'  => 6, 
        'xadvance' => 84, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, ##                                                       000000             
            0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, ##            0000                                      0000000             
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, ##          000000                                      000000              
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, ##        00000000                                     000000               
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, ##      0000000000                                    0000000               
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, ##     00000000000                                    000000                
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, ##   0000000000000                                   0000000                
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, ##  000000  000000                                   000000                 
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, ##  0000    000000                                  000000                  
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, ##  000     000000                                 0000000                  
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, ##  0       000000                                 000000                   
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, ##          000000                                0000000                   
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, ##          000000                               0000000                    
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##          000000                               000000                     
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##          000000                              0000000                     
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##          000000                              000000                      
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##          000000                             0000000                      
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, ##          000000                            0000000                       
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##          000000                            000000                        
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##          000000                           0000000                        
            0x00, 0xFC, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##          000000                           000000                         
            0x00, 0xFC, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, ##          000000                          0000000                         
            0x00, 0xFC, 0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, ##          000000                         0000000                          
            0x00, 0xFC, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##          000000                         000000                           
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##          000000                        0000000                           
            0x00, 0xFC, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##          000000                        000000                            
            0x00, 0xFC, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##          000000                       000000                             
            0x00, 0xFC, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, ##          000000                      0000000                             
            0x00, 0xFC, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##          000000                      000000                              
            0x00, 0xFC, 0x00, 0x00, 0x1F, 0xC0, 0x03, 0xFE, 0x00, ##          000000                     0000000            000000000         
            0x00, 0xFC, 0x00, 0x00, 0x3F, 0x80, 0x3F, 0xFF, 0xC0, ##          000000                    0000000         0000000000000000      
            0x00, 0xFC, 0x00, 0x00, 0x3F, 0x00, 0xFF, 0xFF, 0xF0, ##          000000                    000000        00000000000000000000    
            0x00, 0xFC, 0x00, 0x00, 0x7F, 0x00, 0xFE, 0x07, 0xF8, ##          000000                   0000000        0000000      00000000   
            0x00, 0xFF, 0xFC, 0x00, 0x7E, 0x00, 0xF8, 0x01, 0xFC, ##   000000000000000000000           000000         00000          0000000  
            0x00, 0xFF, 0xFC, 0x00, 0xFE, 0x00, 0xF0, 0x00, 0xFE, ##   000000000000000000000          0000000         0000            0000000 
            0x00, 0xFF, 0xFC, 0x01, 0xFC, 0x00, 0xF0, 0x00, 0x7E, ##   000000000000000000000         0000000          0000             000000 
            0x00, 0xFF, 0xFC, 0x01, 0xF8, 0x00, 0xE0, 0x00, 0x7F, ##   000000000000000000000         000000           000              0000000
            0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0xE0, 0x00, 0x3F, ##                                0000000           000               000000
            0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0xE0, 0x00, 0x3F, ##                                000000            000               000000
            0x00, 0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, 0x3F, ##                               0000000                              000000
            0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x3F, ##                              0000000                               000000
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x3F, ##                              000000                                000000
            0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, 0x3E, ##                             0000000                                00000 
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x7E, ##                             000000                                000000 
            0x00, 0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x00, 0x7C, ##                            0000000                                00000  
            0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, 0xFC, ##                           0000000                                000000  
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0xF8, ##                           000000                                 00000   
            0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x01, 0xF0, ##                          0000000                                00000    
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x03, 0xE0, ##                         0000000                                00000     
            0x00, 0x00, 0x01, 0xFC, 0x00, 0x00, 0x00, 0x07, 0xC0, ##                         0000000                               00000      
            0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x0F, 0x80, ##                        0000000                               00000       
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x1F, 0x00, ##                        000000                               00000        
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x00, 0x00, 0x3E, 0x00, ##                       0000000                              00000         
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x7C, 0x00, ##                      0000000                              00000          
            0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0xF8, 0x00, ##                      0000000                             00000           
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x01, 0xF0, 0x00, ##                     0000000                             00000            
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x03, 0xE0, 0x00, ##                     000000                             00000             
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x00, 0x07, 0xC0, 0x07, ##                    0000000                            00000           000
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x0F, 0x80, 0x07, ##                   0000000                            00000            000
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x07, ##                   0000000                          000000             000
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x07, ##                  0000000                          000000              000
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x07, ##                  000000                          000000               000
            0x00, 0x01, 0xFC, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##                 0000000                         0000000000000000000000000
            0x00, 0x03, 0xF8, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##                0000000                          0000000000000000000000000
            0x00, 0x03, 0xF0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##                000000                           0000000000000000000000000
            0x00, 0x07, 0xF0, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, ##               0000000                           0000000000000000000000000
            0x00, 0x0F, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##              0000000                                                     
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '190' => {    # '¾'
        'width'    => 77, 
        'xoffset'  => 4, 
        'xadvance' => 84, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, ##         0000000000                                     0000000                
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, ##     00000000000000000                                  000000                 
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, ##   00000000000000000000                                000000                  
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x0F, 0xE0, 0x00, 0x00, ##   0000000       0000000                              0000000                  
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, ##   00000          0000000                             000000                   
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, ##   0000            000000                            0000000                   
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, ##   000              000000                           000000                    
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, ##   000              000000                          000000                     
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, ##                    000000                         0000000                     
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, ##                    000000                         000000                      
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                    000000                        000000                       
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, ##                   000000                         000000                       
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x00, ##                   000000                        000000                        
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x03, 0xF8, 0x00, 0x00, 0x00, ##                  000000                        0000000                        
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0x00, ##                0000000                         000000                         
            0x00, 0x00, 0xE0, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##           0000000000                          000000                          
            0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x00, 0x00, ##           0000000                             000000                          
            0x00, 0x00, 0xF0, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, ##           00000000000                        000000                           
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x1F, 0xC0, 0x00, 0x00, 0x00, ##                00000000                     0000000                           
            0x00, 0x00, 0xFE, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, ##                  0000000                    000000                            
            0x00, 0x00, 0x7F, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, ##                   0000000                  000000                             
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x7F, 0x00, 0x00, 0x00, 0x00, ##                    0000000                0000000                             
            0x00, 0x00, 0x3F, 0x80, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, ##                    0000000                000000                              
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, ##                     0000000              0000000                              
            0x00, 0x00, 0x1F, 0xC0, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, ##                     0000000              000000                               
            0x00, 0x00, 0x1F, 0xC0, 0x01, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                     0000000             000000                                
            0x00, 0x00, 0x1F, 0xC0, 0x03, 0xF8, 0x00, 0x00, 0x00, 0x00, ##                     0000000            0000000                                
            0x00, 0x00, 0x1F, 0xC0, 0x03, 0xF0, 0x00, 0x00, 0x00, 0x00, ##  000                0000000            000000                                 
            0x00, 0x00, 0x1F, 0xC0, 0x07, 0xE0, 0x00, 0x00, 0x00, 0x00, ##  000                0000000           000000                                  
            0x00, 0x00, 0x3F, 0xC0, 0x07, 0xE0, 0x00, 0x00, 0xFC, 0x00, ##  000               00000000           000000                     000000       
            0x00, 0x00, 0x3F, 0x80, 0x0F, 0xC0, 0x00, 0x01, 0xFC, 0x00, ##  0000              0000000           000000                     0000000       
            0x00, 0x00, 0x7F, 0x80, 0x1F, 0xC0, 0x00, 0x03, 0xFC, 0x00, ##  0000             00000000          0000000                    00000000       
            0x00, 0x00, 0xFF, 0x00, 0x1F, 0x80, 0x00, 0x03, 0xFC, 0x00, ##  00000           00000000           000000                     00000000       
            0x00, 0x00, 0xFE, 0x00, 0x3F, 0x00, 0x00, 0x07, 0xFC, 0x00, ##  0000000       000000000           000000                     000000000       
            0x00, 0x00, 0xFC, 0x00, 0x3F, 0x00, 0x00, 0x0F, 0xFC, 0x00, ##  0000000000000000000000            000000                    0000000000       
            0x00, 0x00, 0xF0, 0x00, 0x7E, 0x00, 0x00, 0x1E, 0xFC, 0x00, ##    000000000000000000             000000                    0000 000000       
            0x00, 0x00, 0x80, 0x00, 0xFE, 0x00, 0x00, 0x1E, 0xFC, 0x00, ##        00000000000               0000000                    0000 000000       
            0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0x3C, 0xFC, 0x00, ##                                  000000                    0000  000000       
            0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0x78, 0xFC, 0x00, ##                                 000000                    0000   000000       
            0x00, 0x00, 0x00, 0x01, 0xF8, 0x00, 0x00, 0xF0, 0xFC, 0x00, ##                                 000000                   0000    000000       
            0x00, 0x00, 0x00, 0x03, 0xF0, 0x00, 0x00, 0xF0, 0xFC, 0x00, ##                                000000                    0000    000000       
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x01, 0xE0, 0xFC, 0x00, ##                               000000                    0000     000000       
            0x00, 0x00, 0x00, 0x07, 0xE0, 0x00, 0x03, 0xC0, 0xFC, 0x00, ##                               000000                   0000      000000       
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0x80, 0xFC, 0x00, ##                              000000                   0000       000000       
            0x00, 0x00, 0x00, 0x0F, 0xC0, 0x00, 0x07, 0x80, 0xFC, 0x00, ##                              000000                   0000       000000       
            0x00, 0x00, 0x00, 0x1F, 0x80, 0x00, 0x0F, 0x00, 0xFC, 0x00, ##                             000000                   0000        000000       
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x1E, 0x00, 0xFC, 0x00, ##                            000000                   0000         000000       
            0x00, 0x00, 0x00, 0x3F, 0x00, 0x00, 0x3C, 0x00, 0xFC, 0x00, ##                            000000                  0000          000000       
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x3C, 0x00, 0xFC, 0x00, ##                           000000                   0000          000000       
            0x00, 0x00, 0x00, 0x7E, 0x00, 0x00, 0x78, 0x00, 0xFC, 0x00, ##                           000000                  0000           000000       
            0x00, 0x00, 0x00, 0xFC, 0x00, 0x00, 0xF0, 0x00, 0xFC, 0x00, ##                          000000                  0000            000000       
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x01, 0xE0, 0x00, 0xFC, 0x00, ##                         000000                  0000             000000       
            0x00, 0x00, 0x01, 0xF8, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##                         000000                  000000000000000000000000000000
            0x00, 0x00, 0x03, 0xF0, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##                        000000                   000000000000000000000000000000
            0x00, 0x00, 0x07, 0xF0, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##                       0000000                   000000000000000000000000000000
            0x00, 0x00, 0x07, 0xE0, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xF8, ##                       000000                    000000000000000000000000000000
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                      000000                                      000000       
            0x00, 0x00, 0x0F, 0xC0, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                      000000                                      000000       
            0x00, 0x00, 0x1F, 0x80, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                     000000                                       000000       
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                    000000                                        000000       
            0x00, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x00, ##                    000000                                        000000       
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                   000000                                   000000000000000000 
            0x00, 0x00, 0x7E, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                   000000                                   000000000000000000 
            0x00, 0x00, 0xFC, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                  000000                                    000000000000000000 
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xF0, ##                 000000                                     000000000000000000 
            0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##                 000000                                                        
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, ##  
        ], 
    }, 
    '191' => {    # '¿'
        'width'    => 37, 
        'xoffset'  => 6, 
        'xadvance' => 47, 
        'bitmap'   => [ 
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x00, 0x00, 0x00, ##  
            0x00, 0x00, 0x1F, 0x00, 0x00, ##                     00000             
            0x00, 0x00, 0x3F, 0x80, 0x0