# Generated by WebService::BitbucketServer::WADL - DO NOT EDIT!
package WebService::BitbucketServer::CommentLikes::V1;
# ABSTRACT: Bindings for a Bitbucket Server REST API


use warnings;
use strict;

our $VERSION = '0.605'; # VERSION

use Moo;
use namespace::clean;


has context => (
    is          => 'ro',
    isa         => sub { die 'Not a WebService::BitbucketServer' if !$_[0]->isa('WebService::BitbucketServer'); },
    required    => 1,
);


sub _croak { require Carp; Carp::croak(@_) }

sub _get_url {
    my $url  = shift;
    my $args = shift || {};
    $url =~ s/\{([^:}]+)(?::\.\*)?\}/_get_path_parameter($1, $args)/eg;
    return $url;
}

sub _get_path_parameter {
    my $name = shift;
    my $args = shift || {};
    return delete $args->{$name} if defined $args->{$name};
    $name =~ s/([A-Z])/'_'.lc($1)/eg;
    return delete $args->{$name} if defined $args->{$name};
    _croak("Missing required parameter $name");
}


sub unlike_commit {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_commit_likers {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub like_commit {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


sub unlike_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'DELETE', url => $url, $data ? (data => $data) : ());
}


sub get_pull_request_likers {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'GET', url => $url, $data ? (data => $data) : ());
}


sub like_pull_request {
    my $self = shift;
    my $args = {@_ == 1 ? %{$_[0]} : @_};
    my $url  = _get_url('comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes', $args);
    my $data = (exists $args->{data} && $args->{data}) || (%$args && $args);
    $self->context->call(method => 'POST', url => $url, $data ? (data => $data) : ());
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::BitbucketServer::CommentLikes::V1 - Bindings for a Bitbucket Server REST API

=head1 VERSION

version 0.605

=head1 SYNOPSIS

    my $stash = WebService::BitbucketServer->new(
        base_url    => 'https://stash.example.com/',
        username    => 'bob',
        password    => 'secret',
    );
    my $api = $stash->comment_likes;

=head1 DESCRIPTION

This is a Bitbucket Server REST API for L<CommentLikes::V1|https://developer.atlassian.com/static/rest/bitbucket-server/5.10.0/bitbucket-comment-likes-rest.html>.

Original API documentation created by and copyright Atlassian.

=head1 ATTRIBUTES

=head2 context

Get the instance of L<WebService::BitbucketServer> passed to L</new>.

=head1 METHODS

=head2 new

    $api = WebService::BitbucketServer::CommentLikes::V1->new(context => $webservice_bitbucketserver_obj);

Create a new API.

Normally you would use C<<< $webservice_bitbucketserver_obj->comment_likes >>> instead.

=head2 unlike_commit

Unlike a commit comment in the specified repository, identified by C<<< commitId >>> and
C<<< commentId >>>.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    DELETE comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< commitId >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The currently authenticated user is the comment author

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>)

=item * C<<< 204 >>> - data, type: unknown

No content response indicating that the request succeeded

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, commit or comment does not exist

=back

=head2 get_commit_likers

Get a page of users who liked a commit comment in the specified repository, identified by C<<< commitId >>>
and C<<< commentId >>>.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    GET comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< commitId >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

Page of users who liked the specified comment

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>) to query the comment likes

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, commit or comment does not exist

=back

=head2 like_commit

Like a commit comment in the specified repository, identified by C<<< commitId >>> and
C<<< commentId >>>.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    POST comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< commitId >>> - string, default: none

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The currently authenticated user is the comment author

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>).

=item * C<<< 204 >>> - data, type: unknown

No content response indicating that the request succeeded

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, commit or comment does not exist

=back

=head2 unlike_pull_request

Unlike a pull request comment in the specified repository, identified by C<<< pullRequestId >>> and
C<<< commentId >>>.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    DELETE comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< pullRequestId >>> - long, default: none

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The currently authenticated user is the comment author

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>)

=item * C<<< 204 >>> - data, type: unknown

No content response indicating that the request succeeded

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, pull request or comment does not exist

=back

=head2 get_pull_request_likers

Get a page of users who liked a pull request comment in the specified repository, identified by
C<<< pullRequestId >>> and C<<< commentId >>>.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    GET comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< pullRequestId >>> - long, default: none

=back

Responses:

=over 4

=item * C<<< 200 >>> - data, type: application/json

Page of users who liked the specified comment

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>) to query the comment likes

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, pull request or comment does not exist

=back

=head2 like_pull_request

Like a pull request comment in the specified repository, identified by C<<< pullRequestId >>> and
C<<< commentId >>>. The like will be recorded against the requesting user.

The authenticated user must have the B<<< REPO_READ >>> (or higher) permission for the specified
repository to access this resource.

    POST comment-likes/1.0/projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/comments/{commentId}/likes

Parameters:

=over 4

=item * C<<< commentId >>> - long, default: none

=item * C<<< pullRequestId >>> - long, default: none

=back

Responses:

=over 4

=item * C<<< 400 >>> - errors, type: application/json

The currently authenticated user is the comment author

=item * C<<< 401 >>> - errors, type: application/json

The currently authenticated user does not have sufficient permission
(C<<< REPO_READ >>>).

=item * C<<< 204 >>> - data, type: unknown

No content response indicating that the request succeeded

=item * C<<< 404 >>> - errors, type: application/json

The specified repository, pull request or comment does not exist

=back

=head1 SEE ALSO

=over 4

=item * L<WebService::BitbucketServer>

=item * L<https://developer.atlassian.com/bitbucket/server/docs/latest/>

=back

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/chazmcgarvey/WebService-BitbucketServer/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Charles McGarvey <chazmcgarvey@brokenzipper.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by Charles McGarvey.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
