# Generated by default/object.tt
package Paws::GreengrassV2::DeploymentConfigurationValidationPolicy;
  use Moose;
  has TimeoutInSeconds => (is => 'ro', isa => 'Int', request_name => 'timeoutInSeconds', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::DeploymentConfigurationValidationPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::DeploymentConfigurationValidationPolicy object:

  $service_obj->Method(Att1 => { TimeoutInSeconds => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::DeploymentConfigurationValidationPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->TimeoutInSeconds

=head1 DESCRIPTION

Contains information about how long a component on a core device can
validate its configuration updates before it times out. Components can
use the SubscribeToValidateConfigurationUpdates
(https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates)
IPC operation to receive notifications when a deployment specifies a
configuration update. Then, components can respond with the
SendConfigurationValidityReport
(https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport)
IPC operation. For more information, see Create deployments
(https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html)
in the I<AWS IoT Greengrass V2 Developer Guide>.

=head1 ATTRIBUTES


=head2 TimeoutInSeconds => Int

The amount of time in seconds that a component can validate its
configuration updates. If the validation time exceeds this timeout,
then the deployment proceeds for the device.

Default: C<30>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

