#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

VERDENSERKLÆRINGEN OM MENNESKERETTIGHETENE
INNLEDNING
Da anerkjennelsen av menneskeverd og like og umistelige rettigheter for alle medlemmer av menneskeslekten er grunnlaget for frihet, rettferdighet og fred i verden,

da tilsidesettelse av og forakt for menneskerettighetene har ført til barbariske handlinger som har rystet menneskehetens samvittighet, og da framveksten av en verden hvor menneskene har tale- og trosfrihet og frihet fra frykt og nød, er blitt kunngjort som folkenes høyeste mål,

da det er nødvendig at menneskerettighetene blir beskyttet av loven for at menneskene ikke skal tvinges til som siste utvei å gjøre opprør mot tyranni og undertrykkelse,

da det er viktig å fremme utviklingen av vennskapelige forhold mellom nasjonene,

da De Forente Nasjoners folk i Pakten på ny har bekreftet sin tro på grunnleggende menneskerettigheter, på menneskeverd og på like rett for menn og kvinner og har besluttet å arbeide for sosialt framskritt og bedre levevilkår under større Frihet,

da medlemsstatene har forpliktet seg til i samarbeid med De Forente Nasjoner å sikre at menneskerettighetene og de grunnleggende friheter blir alminnelig respektert og overholdt,

da en allmenn forståelse av disse rettigheter og friheter er av den største betydning for å virkeliggjøre denne forpliktelse,

kunngjør

GENERALFORSAMLINGEN

nå denne VERDENSERKLÆRING OM MENNESKERETTIGHETENE som et felles mål for alle folk og alle nasjoner, for at hvert individ og hver samfunnsmyndighet, med denne erklæring stadig i tankene, skal søke gjennom undervisning og oppdragelse å fremme respekt for disse rettigheter og friheter, og ved nasjonale og internasjonale tiltak å sikre at de blir allment og effektivt anerkjent og overholdt både blant folkene i medlemsstatene selv og blant folkene i de områder som står under deres overhøyhet.

Artikkel 1.
Alle mennesker er født frie og med samme menneskeverd og menneskerettigheter. De er utstyrt med fornuft og samvittighet og bør handle mot hverandre i brorskapets ånd.

Artikkel 2.
Enhver har krav på alle de rettigheter og friheter som er nevnt i denne erklæring, uten forskjell av noen art, f. eks. på grunn av rase, farge, kjønn, språk, religion, politisk eller annen oppfatning, nasjonal eller sosial opprinnelse eiendom, fødsel eller annet forhold.

Det skal heller ikke gjøres noen forskjell på grunn av den politiske, rettslige eller internasjonale stilling som innehas av det land eller det område en person hører til, enten landet er uavhengig, står under tilsyn, er ikke-selvstyrende, eller på annen måte har begrenset suverenitet.

Artikkel 3.
Enhver har rett til liv, frihet og personlig sikkerhet.

Artikkel 4.
Ingen må holdes i slaveri eller trelldom. Slaveri og slavehandel i alle former er forbudt.

Artikkel 5.
Ingen må utsettes for tortur eller grusom, umenneskelig eller nedverdigende behandling eller straff.

Artikkel 6.
Ethvert menneske har krav på overalt å bli anerkjent som rettssubjekt.

Artikkel 7.
Alle er like for loven og har uten diskriminering rett til samme beskyttelse av loven. Alle har krav på samme beskyttelse mot diskriminering i strid med denne erklæring og mot enhver oppfordring til slik diskriminering.

Artikkel 8.
Enhver har rett til effektiv hjelp av de kompetente nasjonale domstoler mot handlinger som krenker de grunnleggende rettigheter han er gitt i forfatning eller lov.

Artikkel 9.
Ingen må utsettes for vilkårlig arrest, fengsling eller landsforvisning.

Artikkel 10.
Enhver har krav på under full likestilling å få sin sak rettferdig og offentlig behandlet av en uavhengig og upartisk domstol når hans rettigheter og plikter skal fastsettes,og når en straffeanklage mot ham skal avgjøres.

Artikkel 11.
Enhver som er anklaget for en straffbar handling har rett til å bli ansett som uskyldig til det er bevist ved offentlig domstolsbehandling, hvor han har hatt alle de garantier som er nødvendig for hans forsvar, at han er skyldig etter loven.
Ingen må dømmes for en handling eller unnlatelse som i henhold til nasjonal lov eller folkeretten ikke var straffbar på den tid da den ble begått. Heller ikke skal det kunne idømmes strengere straff enn den som det var hjemmel for på den tid da den straffbare handling ble begått.
Artikkel 12.
Ingen må utsettes for vilkårlig innblanding i privatliv, familie, hjem og korrespondanse, eller for angrep på ære og anseelse. Enhver har rett til lovens beskyttelse mot slik innblanding eller slike angrep.

Artikkel 13.
Enhver har rett til å bevege seg fritt og til fritt å velge oppholdssted innenfor en stats grenser.
Enhver har rett til å forlate et hvilket som helst land innbefattet sitt eget og til å vende tilbake til sitt land.
Artikkel 14.
Enhver har rett til i andre land å søke og ta imot asyl mot forfølgelse.
Denne rett kan ikke påberopes ved rettsforfølgelse som har reelt grunnlag i upolitiske forbrytelser eller handlinger som strider mot De Forente Nasjoners formål og prinsipper.
Artikkel 15.
Enhver har rett til et statsborgerskap.
Ingen skal vilkårlig berøves sitt statsborgerskap eller nektes retten til å forandre det.
Artikkel 16.
Voksne menn og kvinner har rett til å gifte seg og stifte familie uten noen begrensning som skyldes rase, nasjonalitet eller religion. De har krav på like rettigheter ved inngåelse av ekteskapet, under ekteskapet og ved dets oppløsning.
Ekteskap må bare inngås etter fritt og fullt samtykke av de vordende ektefeller.
Familien er den naturlige og grunnleggende enhet i samfunnet og har krav på samfunnets og statens beskyttelse.
Artikkel 17.
Enhver har rett til å eie eiendom alene eller sammen med andre.
Ingen må vilkårlig fratas sin eiendom.
Artikkel 18.
Enhver har rett til tanke-, samvittighets- og religionsfrihet. Denne rett omfatter frihet til å skifte religion eller tro, og frihet til enten alene eller sammen med andre, og offentlig eller privat, å gi uttrykk for sin religion eller tro gjennom undervisning, utøvelse, tilbedelse og ritualer.

Artikkel 19.
Enhver har rett til menings- og ytringsfrihet. Denne rett omfatter frihet til å hevde meninger uten innblanding og til å søke, motta og meddele opplysninger og ideer gjennom ethvert meddelelsesmiddel og uten hensyn til landegrenser.

Artikkel 20.
Enhver har rett til fritt å delta i fredelige møter og organisasjoner.
Ingen må tvinges til å tilhøre en organisasjon.
Artikkel 21.
Enhver har rett til å ta del i sitt lands styre, direkte eller gjennom fritt valgte representanter.
Enhver har rett til lik adgang til offentlig tjeneste i sitt land.
Folkets vilje skal være grunnlaget for offentlig myndighet. Denne vilje skal komme til uttrykk gjennom periodiske og reelle valg med allmenn og lik stemmerett og med hemmelig avstemning eller likeverdig fri stemmemåte.
Artikkel 22.
Enhver har som medlem av samfunnet rett til sosial trygghet og har krav på at de økonomiske, sosiale og kulturelle goder som er uunnværlige for hans verdighet og den frie utvikling av hans personlighet, blir skaffet til veie gjennom nasjonale tiltak og internasjonalt samarbeid i samsvar med hver enkelt stats organisasjon og ressurser.

Artikkel 23.
Enhver har rett til arbeid, til fritt valg av yrke, til rettferdige og gode arbeidsforhold og til beskyttelse mot arbeidsløshet.
Enhver har uten diskriminering rett til lik betaling for likt arbeid.
Enhver som arbeider har rett til en rettferdig og god betaling som sikrer hans familie og ham selv en menneskeverdig tilværelse, og som om nødvendig blir utfylt ved annen sosial beskyttelse.
Enhver har rett til å danne og gå inn i fagforeninger for å beskytte sine interesser.
Artikkel 24.
Enhver har rett til hvile og fritid, herunder rimelig begrensning av arbeidstiden og regelmessige ferier med lønn.

Artikkel 25.
Enhver har rett til en levestandard som er tilstrekkelig for hans og hans families helse og velvære, og som omfatter mat, klær, bolig og helseomsorg og nødvendige sosiale ytelser, og rett til trygghet i tilfelle av arbeidsløshet, sykdom, arbeidsuførhet, enkestand, alderdom eller annen mangel på eksistensmuligheter som skyldes forhold han ikke er herre over.
Mødre og barn har rett til spesiell omsorg og hjelp. Alle barn skal ha samme sosiale beskyttelse enten de er født i eller utenfor ekteskap.
Artikkel 26.
Enhver har rett til undervisning. Undervisningen skal være gratis, i det minste på de elementære og grunnleggende trinn. Elementærundervisning skal være obligatorisk. Alle skal ha adgang til yrkesopplæring, og det skal være lik adgang for alle til høyere undervisning på grunnlag av kvalifikasjoner.
Undervisningen skal ta sikte på å utvikle den menneskelige personlighet og styrke respekten for menneskerettighetene og de grunnleggende friheter. Den skal fremme forståelse, toleranse og vennskap mellom alle nasjoner og rasegrupper eller religiøse grupper og skal støtte De Forente Nasjoners arbeid for å opprettholde fred.
Foreldre har fortrinnsrett til å bestemme hva slags undervisning deres barn skal få.
Artikkel 27.
Enhver har rett til fritt å delta i samfunnets kulturelle liv, til å nyte kunst og til å få del i den vitenskapelige framgang og dens goder.
Enhver har rett til beskyttelse av de åndelige og materielle interesser som er et resultat av ethvert vitenskapelig, litterært eller kunstnerisk verk som han har skapt.
Artikkel 28.
Enhver har krav på en sosial og internasjonal orden som fullt ut kan virkeliggjøre de rettigheter og friheter som er nevnt i denne erklæring.

Artikkel 29.
Enhver har plikter overfor samfunnet som alene gjør den frie og fulle utvikling av hans personlighet mulig.
Under utøvelsen av sine rettigheter og friheter skal enhver bare være undergitt slike begrensninger som er fastsatt i lov utelukkende med det formål å sikre den nødvendige anerkjennelse av og respekt for andres rettigheter og friheter, og de krav som moralen, den offentlige orden og den alminnelige velferd i et demokratisk samfunn med rette stiller.
Disse rettigheter og friheter må ikke i noe tilfelle utøves i strid med De Forente Nasjoners formål og prinsipper.
Artikkel 30.
Intet i denne erklæring skal tolkes slik at det gir noen stat, gruppe eller person rett til å ta del i noen virksomhet eller foreta noen handling som tar sikte på å ødelegge noen av de rettigheter og friheter som er nevnt i Erklæringen.



TEXT

is(Text::Guess::Language->guess($text),'nb','is nb');

done_testing;
