package DateTime::Calendar::FrenchRevolutionary::Locale::fr;

use vars qw($VERSION);

$VERSION = '0.07'; # same as parent module DT::C::FR

my @months_short  = qw (Vnd Bru Fri Niv Plu Vnt Ger Flo Pra Mes The Fru S-C);
#my @add_days_short= qw (Vertu Gnie Trav Raison Rcomp Rvol);
my @months = qw(Vendmiaire Brumaire  Frimaire
                Nivse      Pluvise  Ventse
	        Germinal    Floral   Prairial
	        Messidor    Thermidor Fructidor);
push @months, "jour complmentaire";

my @decade_days = qw (Primidi Duodi Tridi Quartidi Quintidi Sextidi Septidi Octidi Nonidi Dcadi);
my @decade_days_short = qw (Pri Duo Tri Qua Qui Sex Sep Oct Non Dc);

my @am_pms = qw(AM PM);

my %date_formats = (
"short" => "\%d\/\%m\/\%Y",
"medium" => "\%a\ \%d\ \%b\ \%Y",
"long" => "\%A\ \%d\ \%B\ \%EY",
"full" => "\%A\ \%d\ \%B\ \%EY\,\ \%{feast_long\}",
);

my %time_formats = (
"short" => "\%H\:\%M",
"medium" => "\%H\:\%M\:\%S",
"long" => "\%H\:\%M\:\%S",
"full" => "\%H\ h\ \%M\ mn \%S\ s",
);

my $date_before_time = "1";
my $default_date_format_length = "medium";
my $default_time_format_length = "medium";
my $date_parts_order = "dmy";

# When initializing an array with lists within lists, it means one of two things:
# Either it is a newbie who does not know how to make multi-dimensional arrays,
# Or it is a (at least mildly) experienced Perl-coder who, for some reason, 
# wants to initialize a flat array with the concatenation of lists.
# I am a (at least mildly) experienced programmer who wants to use qw() and yet insert
# comments in some places.
my @feast = (
# Vendmiaire
	qw(
       0raisin           0safran           1chtaigne        1colchique        0cheval
       1balsamine        1carotte          2amarante         0panais           1cuve
       1pomme_de_terre   2immortelle       0potiron          0rsda           2ne
       1belle_de_nuit    1citrouille       0sarrasin         0tournesol        0pressoir
       0chanvre          1pche            0navet            2amaryllis        0boeuf
       2aubergine        0piment           1tomate           2orge             0tonneau
	),
# Brumaire
	qw(
       1pomme            0cleri           1poire            1betterave        2oie
       2hliotrope       1figue            1scorsonre       2alisier          1charrue
       0salsifis         1macre            0topinambour      2endive           0dindon
       4chervis          0cresson          1dentelaire       1grenade          1herse
       5bacchante        2azerole          1garance          2orange           0faisan
       1pistache         4macjon           0coing            0cormier          0rouleau
	),
# Frimaire
	qw(
       1raiponce         0turneps          1chicore         1nfle            0cochon
       1mche            0chou-fleur       0miel             0genivre         1pioche
       1cire             0raifort          0cdre            0sapin            0chevreuil
       2ajonc            0cyprs           0lierre           1sabine           0hoyau
       2rable-sucre     1bruyre          0roseau           2oseille          0grillon
       0pignon           0lige            1truffe           2olive            1pelle
	),
# Nivse
	qw(
       1tourbe           1houille          0bitume           0soufre           0chien
       1lave             1terre_vgtale   0fumier           0salptre         0flau
       0granit           2argile           2ardoise          0grs             0lapin
       0silex            1marne            1pierre__chaux   0marbre           0van
       1pierre__pltre  0sel              0fer              0cuivre           0chat
       2tain            0plomb            0zinc             0mercure          0crible
	),
# Pluvise
	qw(
       1laurole         1mousse           0fragon           0perce-neige      0taureau
       0laurier-thym     2amadouvier       0mzron         0peuplier         1cogne
       2ellbore         0brocoli          0laurier          2avelinier        1vache
       0buis             0lichen           2if               1pulmonaire       1serpette
       0thlaspi          0thymel          0chiendent        1tranasse        0livre
       1gude            0noisetier        0cyclamen         1chlidoine       0traneau
	),
# Ventse
	qw(
       0tussilage        0cornouiller      0violier          0trone           0bouc
       2asaret           2alaterne         1violette         0marsault         1bche
       0narcisse         2orme             1fumeterre        0vlar            1chvre
       2pinard          0doronic          0mouron           0cerfeuil         0cordeau
       1mandragore       0persil           0cochlaria       1pquerette       0thon
       0pissenlit        1sylvie           0capillaire       0frne            0plantoir
	),
# Germinal
	qw(
       1primevre        0platane          2asperge          1tulipe           1poule
       1blette           0bouleau          1jonquille        2aulne            0couvoir
       1pervenche        0charme           1morille          0htre            2abeille
       1laitue           0mlze           1cigu            0radis            1ruche
       0gainier          1romaine          0marronnier       1roquette         0pigeon
       0lilas            2anmone          1pense           1myrtille         0greffoir
	),
# Floral
	qw(
       1rose             0chne            1fougre          2aubpine         0rossignol
       2ancolie          0muguet           0champignon       1jacinthe         0rateau
       1rhubarbe         0sainfoin         0bton-d'or       4chamrisier      0ver__soie
       1consoude         1pimprenelle      1corbeille-d'or   2arroche          0sarcloir
       0statice          1fritillaire      1bourrache        1valriane        1carpe
       0fusain           1civette          1buglosse         0snev           1houlette
	),
# Prairial
	qw(
       1luzerne          2hmrocalle      0trfle           2anglique        0canard
       1mlisse          0fromental        0martagon         0serpolet         1faux
       1fraise           1btoine          0pois             2acacia           1caille
       2oeillet          0sureau           0pavot            0tilleul          1fourche
       0barbeau          1camomille        0chvrefeuille    0caille-lait      1tanche
       0jasmin           1verveine         0thym             1pivoine          0chariot
	),
# Messidor
	qw(
       0seigle           2avoine           2oignon           1vronique        0mulet
       0romarin          0concombre        2chalotte        2absinthe         1faucille
       0coriandre        2artichaut        1girofle         1lavande          0chamois
       0tabac            1groseille        1gesse            1cerise           0parc
       1menthe           0cumin            0haricot          2orcante         1pintade
       1sauge            2ail              1vesce            0bl              5chalmie
	),
# Thermidor
	qw(
       2pautre          0bouillon-blanc   0melon            2ivraie           0blier
       1prle            2armoise          0carthame         1mre             2arrosoir
       4panis            4salicor          2abricot          0basilic          1brebis
       1guimauve         0lin              2amande           1gentiane         2cluse
       1carline          0cprier          1lentille         2aune            1loutre
       1myrte            0colza            0lupin            0coton            0moulin
	),
# Fructidor
	qw(
       1prune            0millet           0lycoperdon       2escourgeon       0saumon
       1tubreuse        4sucrion          2apocyn           1rglisse         2chelle
       1pastque         0fenouil          2pine-vinette    1noix             1truite
       0citron           1cardre          0nerprun          0tagette          1hotte
       2glantier        1noisette         0houblon          0sorgho           2crevisse
       5bagarade         1verge-d'or       0mas             0marron           0panier
	),
# Jours complmentaires
	qw(
       1vertu            0gnie            0travail          2opinion          3rcompenses
       1rvolution
	 ));
my @prefix = ('jour du ', 'jour de la ', "jour de l'", 'jour des ');

my %event = ();

sub new {
  return bless {},  $_[0];
}

sub month_name {
    my ($self, $date) = @_;
    return $months[$date->month_0]
}

sub month_abbreviation {
    my ($self, $date) = @_;
    return $months_short[$date->month_0]
}

sub day_name {
    my ($self, $date) = @_;
    return $decade_days[$date->day_of_decade_0];
}

sub day_abbreviation {
    my ($self, $date) = @_;
    return $decade_days_short[$date->day_of_decade_0];
}

sub am_pm                    { $_[0]->am_pms->             [ $_[1]->hour < 5 ? 0 : 1 ] }

sub _raw_feast {
  my ($self, $date) = @_;
  $feast[$date->day_of_year_0];
}

sub feast_short {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  return substr($lb, 1);
}

sub feast_long {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  $lb =~ s/^(\d)/$prefix[$1 % 4]/;
  return $lb;
}

sub feast_caps {
  my ($self, $date) = @_;
  my $lb = $feast[$date->day_of_year_0];
  $lb =~ s/_/ /g;
  $lb =~ s/^(\d)(.)/\u$prefix[$1 % 4]\u$2/;
  return $lb;
}

sub    full_date_format      { $_[0]->date_formats->{full} }
sub    long_date_format      { $_[0]->date_formats->{long} }
sub  medium_date_format      { $_[0]->date_formats->{medium} }
sub   short_date_format      { $_[0]->date_formats->{short} }
sub default_date_format      { $_[0]->date_formats->{ $_[0]->{default_date_format_length} } }

sub    full_time_format      { $_[0]->time_formats->{full} }
sub    long_time_format      { $_[0]->time_formats->{long} }
sub  medium_time_format      { $_[0]->time_formats->{medium} }
sub   short_time_format      { $_[0]->time_formats->{short} }
sub default_time_format      { $_[0]->time_formats->{ $_[0]->{default_time_format_length} } }

sub _datetime_format_pattern_order { $_[0]->date_before_time ? (0, 1) : (1, 0) }

sub    full_datetime_format { join ' ', ( $_[0]->full_date_format, $_[0]->full_time_format )[ $_[0]->_datetime_format_pattern_order ] }
sub    long_datetime_format { join ' ', ( $_[0]->long_date_format, $_[0]->long_time_format )[ $_[0]->_datetime_format_pattern_order ] }
sub  medium_datetime_format { join ' ', ( $_[0]->medium_date_format, $_[0]->medium_time_format )[ $_[0]->_datetime_format_pattern_order ] }
sub   short_datetime_format { join ' ', ( $_[0]->short_date_format, $_[0]->short_time_format )[ $_[0]->_datetime_format_pattern_order ] }
sub default_datetime_format { join ' ', ( $_[0]->default_date_format, $_[0]->default_time_format )[ $_[0]->_datetime_format_pattern_order ] }

sub default_date_format_length { $_[0]->{default_date_format_length} }
sub default_time_format_length { $_[0]->{default_time_format_length} }

sub month_names         { [ @months ] }
sub month_abbreviations { [ @months_short ] }
sub day_names           { [ @decade_days ] }
sub day_abbreviations   { [ @decade_days_short ] }
sub am_pms              { [ @am_pms ] }
sub date_formats                   { \%date_formats                   }
sub time_formats                   { \%time_formats                   }
sub date_before_time               { $date_before_time                }
sub _default_date_format_length    { $default_date_format_length      }
sub _default_time_format_length    { $default_time_format_length      }
sub date_parts_order               { $date_parts_order                }

sub on_date {
  my ($self, $date) = @_;
  _load_events() unless %event;
  $event{$date->strftime('%m%d')} || "";
}

sub _load_events {
  %event = ('dummy', split /(\d{4})\n/, <<'EVENTS');
0101
1 Vendmiaire I. Entre des troupes franaises en Savoie

1 Vendmiaire III. Les postes du bois d'Aix-la-Chapelle et de Reckem sont enlevs 
par l'Arme du Nord.

0102
2 Vendmiaire I. Conqute de Chambry.

2 Vendmiaire III. Prise de la redoute et du camp de Costouge par l'Arme des
Pyrnes orientales.

2 Vendmiaire V. L'Arme d'Italie met en droute l'ennemi  Governolo.

0103
3 Vendmiaire IV. Affaire de Garesio

0104
4 Vendmiaire II. L'Arme des Alpes enlve de vive force les retranchements
de Chatillon ; les Pimontais sont mis en droute et repassent la rivire de Giffe.

0105
5 Vendmiaire III Arme des Pyrnes orientales. Dfaite des
Espagnols  Olia et Monteilla.

0106
6 Vendmiaire III. Capitulation de Crevecoeur devant l'Arme du Nord.

6 Vendmiaire III Arme du Rhin. Reprise de Kayserlautern et d'Alsborn.

6 Vendmiaire V Arme de Sambre et Meuse. L'ennemi attaque sur les
points de Wurstatt, Nider-Ulm, Ober et Nider-Ingelheim et est repouss.

0107
7 Vendmiaire I. Prise de la ville de Nice et de la forteresse de Montalban.

7 Vendmiaire II. L'Arme des Alpes dfait l'ennemi dans les gorges
de Sallanges et prend la redoute de Saint-Martin.

0108
8 Vendmiaire V Arme d'Italie. 150 hommes de font une sortie de Mantoue pour
se procurer du fourrage et doivent se rendre aux habitants de Reggio.

0109
9 Vendmiaire I. Les Franais se rendent matres de la ville de Spire.

9 Vendmiaire II. L'Arme des Alpes enlve de vive-force les
retranchements de Mont-Cormet tenus par les Pimontais.

0111
11 Vendmiaire II Arme des Alpes. Capture du poste de Valmeyer, du
poste de Beaufort, de Moutiers, du bourg Saint-Maurice et du Col de la
Madeleine.

11 Vendmiaire III Arme de Sambre-et-Meuse. Bataille d'Aldenhoven
et droute des troupes coalises.

11 Vendmiaire V. L'Arme du Rhin et Moselle attaque sur toute la
ligne et met l'ennemi en droute.

0112
12 Vendmiaire II. Les Espagnols sont forcs dans leurs camps du Boulon 
et Argels par l'Arme des Pyrnes orientales.

12 Vendmiaire III. Le pays de Juliers se rend  l'Arme de Sambre-et-Meuse.

0113
13 Vendmiaire I. Les Autrichiens sont forcs d'vacuer la ville de Worms.

13 Vendmiaire II Arme des Pyrnes orientales. Prise de Campredon et
droute de la cavalerie espagnole par la garnison de Colioure.

13 Vendmiaire II. L'Arme des Pyrnes occidentales attaque les postes d'Arau
et de la valle d'Aure et les enlve.

13 Vendmiaire IV. Bonaparte rprime une manifestation royaliste  l'glise Saint-Roch

0115
15 Vendmiaire III. Cologne se rend  l'Arme de Sambre-et-Meuse.

0116
16 Vendmiaire V. L'ennemi, bloqu  Mantoue par l'Arme d'Italie tente
une sortie de 4 600 hommes, sortie qui se solde par un chec.

0117
17 Vendmiaire I. Les Autrichiens lvent le sige de Lille.

17 Vendmiaire III. Combat et prise de Frankenthal par l'Arme du Rhin

0118
18 Vendmiaire II. Bombardement de Lyon.

18 Vendmiaire III. Prise de Shelaudenbach et de Vollfstein par l'Arme du Rhin
et jonction avec l'Arme de la Moselle  Lautreck.

0119
19 Vendmiaire III. Devant Maestricht, l'Arme de Sambre-et-Meuse reprend
le chteau de Mont-Saint-Pierre.

0120
20 Vendmiaire III. L'Arme de la Moselle marche sur Birkenfeldt, Oberstein,
Kirn et Meisenheim.

0121
21 Vendmiaire III. Entre de l'Arme du Nord dans Bois-le-Duc.

0122
22 Vendmiaire I. Kellerman force les Prussiens  vacuer la ville de Verdun.

0123
23 Vendmiaire III. L'Arme du Rhin prend Otterberg, Rockenhausen, 
Landsberg, Alzein et Oberhausen.

0124
24 Vendmiaire II. L'Arme de la Moselle combat et provoque la retraite
prcipite des coaliss qui s'taient ports sur Bitche et Rorbach.

24 Vendmiaire III. Combat et prise de Gellheim et de Grunstad par 
l'Arme du Rhin ; les Franais reprennent aussi Frankenthal.

0125
25 Vendmiaire II. Combat prs de Sarreguemines ; l'Arme de la Moselle
repousse l'ennemi.

25 Vendmiaire II. Excution de Marie-Antoinette.

0126
26 Vendmiaire I. Les Autrichiens attaquent plusieurs fois inutilement Hasnon
et sont repousss avec perte.

26 Vendmiaire II. La bataille de Wattignies prs de Maubeuge est remporte
par l'Arme du Nord sur les Autrichiens et le blocus de Maubeuge est lev.

26 Vendmiaire III. L'Arme des Pyrnes occidentales prend la 
mture d'Iraty et les fonderies d'Egay et d'Orbaycette.

26 Vendmiaire III Arme de la Moselle. Prise de Creutznach et de Worms.

26 Vendmiaire VI Arme d'Italie. Trait de paix dfinitif  Campo-Formio
prs d'Udine entre le gnral Bonaparte et les plnipotentiaires de l'Empereur,
roi de Hongrie et de Bohme.

26 Vendmiaire VI. Congrs  Rastadt pour la conclusion de la paix entre
la Rpublique franaise et l'Empire germanique.

0127
27 Vendmiaire II. 600 rpublicains de l'Arme d'Italie remportent
l'avantage  Gillette sur 4 000 Autrichiens, Croates et Pimontais et les
repoussent.

27 Vendmiaire III. L'Arme des Pyrnes occidentales dfait 7 000 
Espagnols prs de Buruet et d'Almandos.

27 Vendmiaire III. L'Arme du Rhin met en droute l'ennemi prs
de Kircheim et de Worms et prend ces deux villes.

0128
28 Vendmiaire II. L'Arme d'Italie remporte
une victoire complte  Gilette sur les Pimontais.

28 Vendmiaire III. L'Arme du Nord dfait l'ennemi prs de Nimgue
et dtruit la lgion de Rohan.

28 Vendmiaire V. L'Arme du Rhin et Moselle est attaque  Retzengen
et  Simonswald.

0129
29 Vendmiaire I. L'Arme franaise force les
Autrichiens  vacuer Mayence.

29 Vendmiaire III. L'Arme de la Moselle entre dans Bingen
aprs avoir chass les Prussiens des positions qu'ils tenaient en avant
de la ville.

29 Vendmiaire V Arme d'Italie. Dbarquement en Corse, prise
de Bastia, de Saint-Florent et de Bonifacio.

29 Vendmiaire XIV Bataille de Trafalgar.

0130
30 Vendmiaire II. L'Arme des Pyrnes occidentales met
en droute trois colonnes espagnoles aprs une fusillade de cinq heures.

30 Vendmiaire V Arme de Sambre et Meuse. L'ennemi passe le Rhin sur
six points depuis Bacharach jusqu' Andernach, attaque la tte de pont
de Neuwied et est forc  la retraite.

0201
1 Brumaire I Reprise de la ville de Longwi, les Prussiens vacuent le
territoire franais.

1 Brumaire II Arme des Pyrnes orientales. Avantage sur les
espagnols dans la valle de Baigory.

1 Brumaire II Arme du Nord. Enlvement des postes de Warneton,
Comines, Werwick, Ronek, Alluin, Menin, Furnes et Poperingues.

1 Brumaire II Arme du Rhin. Prise d'Alzey et d'Oppenheim.

0202
2 Brumaire II Arme d'Italie. Dfaite  Utel de cinq mille ennemis par
neuf cents rpublicains, aprs onze heures de combat.

2 Brumaire II Arme du Rhin. Attaque du poste de Breitenstein par les
Autrichiens ; l'ennemi repouss.

2 Brumaire III Arme de Sambre et Meuse. Prise de Coblentz.

2 Brumaire III Arme des Pyrnes orientales. Combat  Bhaga, 
les Espagnols sont repousss.

2 Brumaire III Arme des Pyrnes orientales. Enlvement
des postes de Dori et Tozas et des retranchements de Casteillan.

0203
3 Brumaire V Trait de paix conclu entre la Rpublique franaise et le
roi de Naples et des deux Siciles.

0204
4 Brumaire IV Dbut du Directoire.

4 Brumaire VI Arme d'Italie. Trait d'alliance entre la Rpublique
franaise et le roi de Sardaigne.

0205
5 Brumaire III Arme du Nord. Prise de Hultz, Axel et Sas-de-Gand.

5 Brumaire V Arme de Sambre et Meuse. Attaque et prise de Saint
Wendel, Kayserslautern, Kirchenpoland, Bingen et de la montagne de
Saint-Roch.

5 Brumaire V Arme du Rhin et Moselle. Passage du Rhin par les
Franais, prise du fort de Khel.

0207
7 Brumaire V Arme d'Italie. Sortie ennemie de Mantoue repousse.

0208
8 Brumaire III Arme du Nord. Prise de Venlo.

0209
9 Brumaire II Arme des Pyrnes orientales. Reprise  la baonnette,
d'une batterie ennemie, en avant de Ville longue.

0211
11 Brumaire III Arme des Pyrnes orientales. Droute des Espagnols
sur les revers de la montagne Noire.

0212
12 Brumaire I. Les Autrichiens sont forcs d'vacuer Lanoy.

12 Brumaire III Arme de la Moselle. Entre des Franais dans
Rheinfels, vacu par douze cents ennemis.

12 Brumaire V Arme d'Italie. Prise du village de Saint-Michel ; les
ponts sur l'Adige brls par les Franais. L'ennemi se porte sur le
Lavis, o il est battu et repouss jusque dans le village de
Segonzano.

0214
14 Brumaire V Arme de Sambre et Meuse. Prise de Maestricht.

0215
15 Brumaire V Arme d'Italie. L'ennemi ayant pass la Brenta est
oblig de la repasser aprs un combat meurtrier.

0216
16 Brumaire I. Bataille de Gemmapes. Les Franais entrent dans Mons.

16 Brumaire III Arme du Nord. Prise du fort de Schenk.

0217
17 Brumaire III Arme du Nord. La sortie de la garnison de
Berg-op-zomm est repousse.

0218
18 Brumaire I. Prise de la ville de Tournay par les Franais.

18 Brumaire III Arme du Nord. Entre triomphante des Franais dans
Nimgue.

18 Brumaire VIII. Coup d'tat de Bonaparte : fin du Directoire, dbut du Consulat

0219
19 Brumaire IV Arme du Nord. Prise de Burick.

0220
20 Brumaire IV Arme de Sambre et Meuse. Combat prs de Creutzenach,
dans lequel l'ennemi a t forc de repasser la Nahe.

0221
21 Brumaire V Arme d'Italie. L'arme franaise, sur l'Adige,
rencontre l'ennemi entre Saint-Michel et Saint-Martin, le culbute et
le poursuit l'espace de trois milles.

0222
22 Brumaire I Arme du Nord. La ville de Gand ouvre ses portes 
l'arme franaise.

22 Brumaire I. Prise de Charleroy par les Franais.

22 Brumaire III Arme du Rhin. Prise de Monbach et de tous les postes
de la fort en avant de ce village.

22 Brumaire III Arme du Rhin. Prise de Weissenau.

0223
23 Brumaire I. Bataille d'Anderlecht prs Bruxelles. Dfaite
complte de l'ennemi, l'arme franaise fait son entre triomphante
dans Bruxelles.

0224
24 Brumaire I. Prise de la ville de Francfort.

24 Brumaire II Arme de l'Ouest. Dfaite des rebelles de la Vende
sous les murs de Granville.

0225
25 Brumaire V Arme d'Italie. Bataille d'Arcole, conclue le 27.

0226
26 Brumaire I. Les Franais se rendent matres de la ville et du port
d'Ostende, vacu par les Autrichiens.

26 Brumaire I. Prise de Sainte-Remi.

26 Brumaire I. Capitulation de la ville de Malines.

26 Brumaire II Arme du Rhin. L'arme surprend et enlve prs de
Strasbourg trois postes ennemis vaillamment dfendus.

26 Brumaire II Le sige de la ville de Granville est lev.

26 Brumaire IV. Combat du champ di Pietri.

0227
27 Brumaire II Arme de la Moselle Dfaite de quatre mille Autrichiens
devant Bitche. Droute complte des Autrichiens prs Lbach. Prise
de Bising et de Blise-Castel.

27 Brumaire III Arme des Pyrnes orientales. Dugommier gnral en
chef, tu d'un coup d'obus dans l'affaire de St. Sbastien de la
Mouga.

27 Brumaire III Arme des Pyrnes orientales. Bataille gagne sur
les Espagnols  Saint-Sbastien.

0228
28 Brumaire I Prise des villes d'Ypres, Furnes et Bruges. Entre des
Franais dans la ville d'Anvers.

28 Brumaire II Arme du Rhin. Enlvement de vive force du poste de
Neuviller, et de quatre autres environnants. Prise d'une forte
redoute et de sept pices de canons prs de Wantzenau.

28 Brumaire V
Trait de paix conclu entre la Rpublique franaise et le duc de
Parme.

0229
29 Brumaire II L'Arme du Rhin enlve deux redoutes formidables prs
de Bouxweiller.

0230
30 Brumaire II Arme des Pyrnes orientales. Bataille gagne  Escola,
Liers, Vilartoly, sur cinquante mille Espagnols.

30 Brumaire II Arme de la Moselle. Dfaite de douze cents hommes
d'infanterie, et de trois cents de cavalerie auprs de Blascheidt, et
de Lorentsweiller.

0301
1 Frimaire I Arme des Ardennes. Prise de la ville de Namur par les
Franais.

1 Frimaire III Arme de la Moselle. Dfaite de plus de quatre cents
ennemis dans la fort de Grunnevald, prs Luxembourg.

1 Frimaire V Arme d'Italie. L'ennemi est attaqu et repouss de
position en position ; de Castel-Nobo  Rivoli, la Corona, et le long
de l'Adige jusqu' Dolce.

0302
2 Frimaire I Arme du Rhin. Cinq mille Franais mettent en droute
toute l'arme ennemie devant Tirlemont.

2 Frimaire II Arme du Rhin. Combats successifs et enlvement des
postes de Bouxweiller, Brumpt et Haguenau par les Franais ; droute
de l'ennemi.

2 Frimaire IV Arme d'Italie. Bataille de Loano, droute des
Austro-Sardes ; prise de la Pietra, Loano, Finale, Vado et Savonne.

2 Frimaire V Arme du Rhin et Moselle. Sortie par la
garnison de Kehl.

0303
3 Frimaire IV Arme d'Italie. Combat d'Intrapa et de Garesio.

3 Frimaire V. Sortie faite par la garnison de Mantoue, qui est
brusquement repousse.

0304
4 Frimaire II Arme d'Italie. Dfaite de huit cents Pimontais par
cinq cents Franais,  Castel-Genest et  Brec, prise de Figaretto.

4 Frimaire III Arme des Pyrnes occidentales. Victoire remporte 
Osts, aprs un combat de deux jours.

0306
6 Frimaire IV Arme d'Italie. Combat de Spinardo.

0307
7 Frimaire I Arme du Rhin. Prise de la ville de Lige, prcde
d'une victoire complte remports sur les Autrichiens, aprs un combat
de dix heures.

7 Frimaire III Arme des Pyrnes orientales. Prise de la forteresse
de Figuires.

0308
8 Frimaire III Arme des Pyrnes orientales. Bataille gagne sur les
Espagnols  Begara, Ascuatia et Aspetia.

0310
10 Frimaire I Arme du Nord. Capitulation de la citadelle d'Anvers

10 Frimaire II Arme du Nord. Attaque des postes ennemis sur
la Lys.

10 Frimaire IV Arme de Sambre et Meuse. Attaque et prise de
Creutzenach.

0311
11 Frimaire I Arme des Ardennes. Capitulation de la citadelle de
Namur.

11 Frimaire II Arme du Rhin. Enlvement de la redoute du pont de
Landgraben et des retranchements de Gambsheim.

11 Frimaire III Arme du Rhin et Moselle. Enlvement de la redoute,
dite de Merlin, devant Mayence.

11 Frimaire V. L'ennemi attaque la tte du pont d'Huningue et s'empare
de la demi-lune mais en est dlog.

11 Frimaire XIII. Napolon Premier est couronn Empereur des Franais

11 Frimaire XIV. Bataille d'Austerlitz : l'arme franaise crase l'arme austro-russe

0312
12 Frimaire II Arme des Ardennes. Vigoureuse sortie de la garnison
de Givet.

12 Frimaire II Arme du Rhin. Combat prs du bois de Gambshein.

12 Frimaire VIII Bataille d'Hohenlinden.

0314
14 Frimaire II Arme du Rhin. L'ennemi, chass du village
d'Oppendorff, est poursuivi jusqu' Druzenheim.

14 Frimaire III Arme de la Moselle. Les rpublicains enlvent de
vive force les redoutes de Salbach.

0319
19 Frimaire II Arme du Rhin. Prise des hauteurs de Dawendorff, aprs
une action trs vive.

0321
21 Frimaire I Arme du Nord. Prise des villes de Wezem et de Wert et
de Ruremonde, capitale de la Gueldre autrichienne.

0322
22 Frimaire II Arme de l'Ouest. Victoire remporte sur les rebelles
de la Vende, prs et dans la ville du Mans.

0323
23 Frimaire II Arme des Pyrnes occidentales. Droute des Espagnols
prs de Saint-Jean-de-Luz ; ils sont forcs de repasser la Bidassoa.

0324
24 Frimaire I. Aprs plusieurs combats, les troupes franaises se
rendent matres des villes de Mertzicq, de Fredembourg et de
Saarbruck.

0325
25 Frimaire II Arme de la Moselle. Enlvement de vive force des
hauteurs de Marsal du Dahubruck et de Lambach.

25 Frimaire II Arme d'Italie. Les Rpublicains enlvent de vive
force les retranchements et redoutes qui dfendaient Toulon.

0326
26 Frimaire I. Prise de Consarbruck.

26 Frimaire II Arme d'Italie. Prise de Toulon, fuite prcipite des
Anglais et des Espagnols.

26 Frimaire IV Arme de Sambre et Meuse. Combat sur toute la ligne
dans le Hundstruck ; l'ennemi est battu sur tous les points.

0327
27 Frimaire II Arme des Ardennes. Combat prs de Philippeville,
dans le bois de Jamaque, entre une partie de la garnison de Givet et
les Autrichiens ; l'ennemi est repouss avec perte.

0329
29 Frimaire II Arme des Pyrnes orientales. Enlvement  la
baonnette par deux mille cinq cents Franais, des hauteurs prs
Villelongue.

0402
2 Nivse II Arme du Rhin et Moselle. Dfaite de l'ennemi  Werd.

0403
3 Nivse II Arme du Rhin et Moselle. Enlvement de tous les
retranchements de Bischweiller, Druzenheim et Haguenau.

0405
5 Nivse II Arme du Rhin et Moselle. Droute de l'ennemi 
Obersebach. Prise du chteau de Geisberg.

0406
Arme du Rhin et Moselle. Evacuation force des lignes de la Lauter
et de Weissembourg, et leve du blocus de Landau par l'ennemi.

0407
7 Nivse II Arme du Rhin. Les Franais enlvent les postes de
Germersheim et Spire.

0408
8 Nivse III Arme du Nord. Passage du Vaal, prise de Bommel, du fort
Saint-Andr et de quatre postes environnants, reddition de Grave.

0413
13 Nivse I Arme du Nord. Un dtachement de l'avant-garde franaise
pntre dans le pays de Luxembourg, et s'empare des caisses de
l'Empereur, dans lesquelles se trouvent deux cent mille francs
espces.

0414
14 Nivse II Arme de l'Ouest. Prise sur les rebelles de la Vende de
l'le de Noirmoutiers.

0417
17 Nivse II Arme du Rhin et Moselle. Prise de Worms.

17 Nivse III Arme des Pyrnes occidentales. Prise du fort de la
Trinit.

0420
20 Nivse VI Arme d'Italie. Deux colonnes de troupes franaises
marchent sur la ville de Rome pour venger la mort du gnral Duphot,
et l'insulte faite  l'ambassadeur de la Rpublique franaise ;  leur
approche, l'insurrection clate dans l'Ombrie ; ses habitants secouent
le joug du gouvernement papal et se dclarent libres et indpendants.

0422
22 Nivse III Arme du Nord. Prise de Thiel et de six forts.

0423
23 Nivse II Arme des Pyrnes occidentales. Enlvement de vive
force du poste de la Montagne de Louis XIV par quatre cents
rpublicains.

23 Nivse V Arme d'Italie. Combat de Saint-Michel devant Vronne.

23 Nivse V Arme d'Italie. L'ennemi attaque la tte de la ligne de
Montebaldo et est repouss.

0424
24 Nivse III Arme du Nord. Prise d'Heusdin.

0425
25 Nivse V Arme d'Italie. Bataille de Rivoli, l'ennemi en droute
complte.

0426
26 Nivse V Arme d'Italie. Dix mille ennemis forcent le passage
d'Anghiari.

26 Nivse V Arme d'Italie. Le gnral Provera  la tte de six mille
hommes, attaque le faubourg Saint-Georges de Mantoue pendant toute la
journe, mais inutilement.

0427
27 Nivse II Arme du Rhin et Moselle. Les ennemis font une sortie du
fort Vauban et sont repousss.

27 Nivse V Bataille de la Favorite (faubourg de Mantoue), Wurmser
choue dans sa sortie de Mantoue et Provera est oblig de capituler.

0428
28 Nivse III Arme du Nord. Prise d'Utrecht, d'Amersford et des
lignes du Greb, passage de la Lech.

0429
29 Nivse II Arme du Rhin. Evacuation totale du dpartement du
Bas-Rhin par les coaliss ; reprise du fort Vauban.

29 Nivse III Arme du Nord. Prise de Gertuydemberg.

0502
2 Pluvise I Excution de Louis XVI.

2 Pluvise II Arme des Pyrnes occidentales. Deux cents Franais
enlvent  la baonette la redoute d'Harriette prs Ispeguy.

2 Pluvise III Arme du Nord. Les villes de Gorcum, Dordrecht et
d'Amsterdam se rendent aux Franais.

0504
4 Pluvise II Arme du Var. A l'approche des troupes Franaises, les
Anglais abandonnent les les d'Hyres.

0507
7 Pluvise V Arme d'Italie. L'ennemi, chass au-del de la Brenta,
est atteint  Carpenedelo, et est forc  la retraite.

0508
8 Pluvise V Arme d'Italie. L'ennemi poursuivi dans les gorges du
Tyrol est atteint  Avio.

0509
9 Pluvise V Arme d'Italie. Le gnral Murat dbarque  Torgole et chasse les ennemis ; 
le gnral Vial les tourne et leur fait quatre cent cinquante
prisonniers. Entre des Franais dans Roveredo et Trente.

9 Pluvise VI Arme d'Italie. Prise de la ville d'Ancne, par l'arme
franaise.

0510
10 Pluvise V Arme du Rhin et Moselle. A trois heures du matin, les
Rpublicains sur deux colonnes, font une sortie de la tte de pont
d'Huningue et chassent l'ennemi des deux premires parallles.

0513
13 Pluvise I. La rpublique franaise dclare la guerre au roi
d'Angleterre et au stathouder de Hollande.

13 Pluvise VI Arme d'Italie. Une des colonnes de l'arme d'Italie,
premire division, traverse le territoire Gnvois et tablit son
quartier gnral  Ferney-Voltaire.

0514
14 Pluvise V Arme d'Italie. Les Franais attaquent les dbris de
l'arme autrichienne derrire le Lavis et les repoussent jusqu'
Saint-Michel.
Entre des Franais  Jmola, Faenza et Forli.
Capitulation de Mantoue.

0515
15 Pluvise III Arme des Pyrnes occidentales. Prise de Roses,
aprs 27 jours de sige.

Arme du Nord. Conqute de la Hollande : toutes les places fortes et
les vaisseaux de guerre restent au pouvoir des Franais. Entre des
troupes franaises  Midelbourg et  Flesingue.

0517
17 Pluvise III Arme des Pyrnes occidentales. Droute complte
des Espagnols  Sare et Berra.
Droute de quinze mille Espagnols battus  Urrugne et  Chauvin-Dragon
par cinq mille rpublicains.

0518
18 Pluvise V Arme d'Italie. Les avant-postes de l'ennemi repousss
sur la droite de l'Adige ; prise de Derunbano.

0521
21 Pluvise V Arme d'Italie. Prise d'Ancne.

21 Pluvise VI Arme d'Italie. Les troupes franaises continuent leur
marche sur Rome.

0522
22 Pluvise V Arme d'Italie. Prise de Lorette.

0527
27 Pluvise VI Arme d'Italie. Entre des Franais dans Rome ; le
gnral Berthier se rend au capitole, o, au nom de la Rpublique
franaise, il proclame la Rpublique romaine.

0601
1 Ventse II Arme du Rhin. Les Franais enlvent de vive force le
poste d'Ogersheim.

1 Ventse V Arme d'Italie. Trait de paix avec le pape, conclu 
Tolentino.

0604
4 Ventse V Arme d'Italie. Reprise du poste de Treviso.

0605
5 Ventse V Arme d'Italie. Affaire de Foi : l'ennemi est chass de
ses retranchements ; les Franais tombent ensuite sur un corps de
chasseurs Tyroliens et les dfont.

Les Franais, attaqus  Bidole, battent compltement l'ennemi.
Kellerman passe la Piave  San-Mamma, et met en fuite un poste de
hussards ennemis qui en dfendaient le passage.

0607
7 Ventse X. Naissance de Victor Hugo

0611
11 Ventse III Arme des Pyrnes orientales. Prise de Bezalu.

0612
12 Ventse V Arme d'Italie. Les Franais attaquent l'ennemi  Monte
di-Savaro et le dfont.

0615
15 Ventse VI Arme en Helvtie. Capitulation de la ville de Berne.

0616
16 Ventse II Arme des Ardennes. Combat prs Soumoy et Cerffontaine ; 
dfaite de l'ennemi.

0617
17 Ventse I. Dclaration de guerre au roi d'Espagne.

0618
18 Ventse II Arme de la Moselle. Dfaite de trois bataillons
autrichiens sur les hauteurs des forges de Joegerthal.

0620
20 Ventse V. Arme d'Italie. Une division de l'arme franaise se
rend  Feltre ;  son approche l'ennemi vacue la ligne de Cordevoie
et se porte sur Bellurn.

0622
22 Ventse V. Arme d'Italie. Passage de la Piave vis--vis le
village de Vidor, l'ennemi vacue son camp de la Gampana.

0623
23 Ventse V. Arme d'Italie. Combat de Sacile.
Affaire de Bellurn, dans laquelle l'arrire-garde ennemie est
enveloppe et faite prisonnire.

23 Ventse VI Aprs cinq combats successifs et meurtriers, les Suisses
vacuent Morat.

0626
26 Ventse V Arme d'Italie. Passage du Tagliamento, malgr des
forces suprieures et une rsistance opinitre.
Prise du village de Gradisca.

0627
27 Ventse VI Trait d'alliance et de commerce entre les Rpubliques
franaise et cisalpine.

0628
28 Ventse V Arme d'Italie. Prise de Palma Nova, que l'ennemi est
forc d'vacuer.

0629
29 Ventse V Arme d'Italie. Prise de la ville de Gradisca. Passage
du pont de Casasola.

29 Ventse XII Excution du duc d'Enghien.

0630
30 Ventse V Arme d'Italie. Combat de Lavis. Les troupes ennemies,
aprs un combat opinitre, sont enveloppes par les Franais.

0701
1 Germinal V Arme d'Italie. Entre des Franais dans Goritz.
Affaire de Caminia, entre l'avant-garde franaise et l'arrire-garde
ennemie.

0702
2 Germinal IV Arme d'Italie. Combat de Tramin et Combat de
Caporetto.

0703
3 Germinal V Arme d'Italie. Combat de Clausen. L'ennemi battu 
Botzen, s'enferme dans Clausen, o il est attaqu par les Franais
puis est oblig de cder.

0704
4 Germinal V Arme des Pyrnes orientales. Entre des Franais 
Trieste. Les Franais s'emparent des clbres mines d'Ydria.

0705
5 Germinal II Arme de la Moselle. Avantage remport sur les
Prussiens, qui attaquent les avant-postes d'Apach au nord de Sierck.

5 Germinal V Arme d'Italie. Combat de Tarvis ; aprs une opinitre
rsistance, l'ennemi est mis en droute.

0706
6 Germinal V Arme d'Italie. Affaire de la Chinse ; prise de ce poste
important.

0708
8 Germinal V Arme d'Italie. Des bataillons ennemis, frachement
arrivs du Rhin, entreprennent de dfendre la gorge d'Innsbruck ; ils
sont culbuts par la 85e demi-brigade.

0709
9 Germinal V Arme d'Italie. Les Franais entrent dans la ville de
Clagenfurth, capitale de la haute et basse Carinthie ; le prince
Charles avec les dbris de son arme, extrmement dcourage, fuit
devant eux.

0712
12 Germinal V Arme d'Italie. Combat des gorges de Neumarck ;
l'arrire garde ennemie est culbute par l'avant-garde franaise et
les Franais entrent dans Neumarck et Freissels.

0714
14 Germinal II Arme des Pyrnes occidentales. Les Franais enlvent
de vive force les retranchemens d'Ozon, prs Saint-Jean de Luz, et
mettent en fuite les Espagnols.

14 Germinal V Arme d'Italie. Les Autrichiens, vaincus sur tous les
points, vacuent le Tyrol. Le prince Charles fait sa retraite  marche
force sur la route de Vienne ; il est battu par la division Massena.

0715
15 Germinal V Arme d'Italie. Combat de Hundsmarck ; l'arrire-garde ennemie est
dfaite par l'avant-garde franaise. Entre des Franais dans
Hundsmark, Kiotenfeld, Mureau et Judembourg.

0716
16 Germinal IV Arme d'Italie. Reconnaissance militaire vers Cairo ;
les postes ennemis sont culbuts.

0717
17 Germinal II Arme des Pyrnes occidentales. Dfaite des Espagnols
prs d'Hendaye.

Arme d'Italie. Prise du camp de Fougasse.

17 Germinal II Excution de Georges Danton, Camille Desmoulins et Fabre d'glantine.

0718
18 Germinal II Arme d'Italie. Enlvement de tous les postes aux
environs de Breglio, dans le comt de Nice.

18 Germinal V Suspension d'armes de cinq jours, entre les armes
franaise en Italie, et impriale.

0719
19 Germinal II Arme d'Italie. Prise d'Oneille.

0720
20 Germinal IV Arme d'Italie. Affaire de Voltry.

0721
21 Germinal II Arme des Pyrnes orientales. Dfaite des Espagnols 
Monteilla ; prise d'Urgel.

Arme des Ardennes. Avantage signal remport par un faible
dtachement sorti de Philippeville, qui chasse l'ennemi du bois situ
entre Villiers et Florence, et le met en droute.

21 Germinal IV Arme d'Italie. Attaque de la redoute de Montelezimo,
dfendue par les Franais ; l'ennemi est repouss.

0722
22 Germinal VI Arme de Mayence. Blocus du fort d'Ehreinbrestein.

0723
23 Germinal IV Arme d'Italie. Bataille de Montenotte ; droute
complte des ennemis.

0725
25 Germinal III Trait de paix entre la Rpublique franaise et le roi
de Prusse.

25 Germinal IV Arme d'Italie. Prise de Cossaria.

0726
26 Germinal II Arme de la Moselle. Combat sur les hauteurs de
Tiperdange, entre une compagnie du 1er bataillon du Haut Rhin et
quatre-vingt chasseurs rpublicains, contre soixante hussards de
Wurmser et quatre cents paysans arms.

26 Germinal IV Arme d'Italie. Bataille de Millesimo, gagne sur les
Austro-Sardes. Combat de Dego, droute de l'ennemi. Combat et prise
de Saint-Jean, dans la valle de la Barmida. Prise de Batisolo, de
Bagnosco et de Pontenocetto. Prise des redoutes de Montezemo.

0727
27 Germinal II Arme de la Moselle. Les Franais occupent les
hauteurs de Mertzig, aprs en avoir chass l'ennemi.

Arme d'Italie. Dfaite de quinze cents Autrichiens  Ponte-di-Nava.

27 Germinal IV Arme d'Italie. Prise du camp retranch de la ville de
Cera.

0728
28 Germinal II Arme d'Italie. Prise d'Ormea.

0729
29 Germinal II Arme de la Moselle. Bataille d'Arlon ; prise de cette
ville, droute complte de l'ennemi.

0802
2 Floral I Arme des Pyrnes occidentales. Affaire de Jurgazza
Mondi, dans laquelle les troupes rpublicaines ont mis dans une
droute complte un corps d'Espagnols.

0803
3 Floral II Arme des Ardennes. Droute complte de l'ennemi 
Aussoy, prs Philippeville, aprs un combat de douze heures.

3 Floral IV Arme d'Italie. Combat et prise de la ville de Mondovi.

0804
4 Floral II Arme du Rhin. Victoire remporte auprs de
Kurweiller.

0805
5 Floral I Arme des Pyrnes orientales. Affaire de Samouragaldi,
dans laquelle deux cents Franais ont battu compltement quatre cents
Espagnols.

Bombardement de Fontarabie.

5 Floral II Arme des Alpes. Enlvement de vive force de toutes
les redoutes des Monts Valaisan et Saint-Bernard et du poste de la
Thuile.

5 Floral IV Arme d'Italie. Entre des Franais dans la ville de
Bne.

0806
6 Floral IV Arme d'Italie. Prise de Fossano, de Cherasco, d'Alba.

0807
7 Floral II Arme des Pyrnes occidentales. Droute des Espagnols
et des migrs, repouss des postes d'Arnguy et d'Irameaca.

Arme des Ardennes. Victoire remporte, aprs quatre heures d'une
rsistance opinitre. Enlvement de vive force, des hauteurs de Bossu ; 
entre et runion des armes des Ardennes et du Nord dans la ville
de Beaumont.

Arme du Nord. Prise de Courtray, aprs une bataille gnrale sur
toute la ligne, depuis Dunkerque jusqu' Givet.

Arme des Pyrnes orientales. Les Franais enlvent de vive force le
poste du rocher d'Arrola.

Droute de quatre mille hommes d'infanterie et de dix escadrons de
cavalerie espagnole  Roqueluche ; perte considrable de l'ennemi.

7 Floral VI Naissance d'Eugne Delacroix

0808
8 Floral II Arme des Pyrnes orientales. Les Franais, au nombre
de trois mille, chassent dix mille ennemis du village d'Oms ; ils
enlvent les gorges et le pont du Ceret.

0809
9 Floral IV Arme d'Italie. Armistice conclu avec le roi de
Sardaigne.

0810
10 Floral II Arme du Nord. Victoire  Mont-Castel sur vingt mille
Autrichiens.

Prise de Menin et d'une grande quantit d'artillerie.
Arme d'Italie. Victoire sur les Pimontais.

10 Floral IV Entre des Franais dans la cit de Ceva et de Coni.

10 Floral V Trait de paix entre la Rpublique franaise et le pape.

0811
11 Floral II Arme des Pyrnes orientales. Bataille gagne sur les
Espagnols, aux Albres ; enlvement de la fameuse redoute de
Montesquiou.

11 Floral V Arme d'Italie. Prliminaires de paix entre la
Rpublique franaise et l'Empereur, signs  Leoben par le gnral
Buonaparte et les plnipotentiaires de l'Empereur.

0812
12 Floral II Arme du Rhin. Prise de Lambsheim et de Franckental par
les Franais ; les portes de cette dernire ville sont enfonces 
coups de canons.

0815
15 Floral II Arme des Pyrnes orientales. Les Franais occupent
les hauteurs du cap de Bearn et du pays de Las-Daines, o six mille
hommes arrivent  travers les plus nombreux obstacles ; commencement
du sige de Collioure.

15 Floral III Arme des Pyrnes orientales. Les Espagnols attaquant
le camp de Cistella, sont compltement battus et repousss.

0816
16 Floral IV Arme d'Italie. Entre des Franais dans la ville de
Tortonne.

0817
17 Floral III Arme des Pyrnes orientales. Reconnoissance gnrale
faite par les Franais sur les hauteurs de Crespia, de Bascara et sur
la Fluvia.

0818
18 Floral IV Arme d'Italie. Reconnoissance faite sur la rive du P,
vers Plaisance.

0819
19 Floral II Lavoisier est guillotin.

19 Floral IV Arme d'Italie. Passage du P par l'avant-garde
rpublicaine, et combat de Fombio.

0820
20 Floral II Arme des Alpes. Prise du fort Mirabouck, aprs
quatorze heures d'attaque, et du poste de Villeneuve-des-Prats.
Prise de la redoute de Maupertuis.

20 Floral III Arme des Pyrnes orientales. Attaque du camp de la
montagne de Musquirachu ; l'ennemi mis en fuite, abandonne son camp
tout tendu et tous les effets de campement ; cent quarante ennemis
tus, cinquante faits prisonniers.

20 Floral IV Arme d'Italie. Les Autrichiens attaquent prs de
Cordogno la division Laharpe, et sont vigoureusement repousss par les
Rpublicains, qui s'emparent de Casale.
Conclusion de l'armistice avec le duc de Parme.

0821
21 Floral II Arme des Ardennes. Prise de Thuin par les Franais,
aprs un combat opinitre : enlvement  la baonnette de tous les
retranchements Autrichiens.

21 Floral IV Arme d'Italie. Bataille de Lody : passage du pont
dfendu par l'arme entire de Beaulieu.

0822
22 Floral II Arme du Nord. Dfaite des ennemis devant Tournay.
Combat de sept heures devant Courtray : droute complte de
l'ennemi. Droute de l'ennemi  Ingelsmunster.

22 Floral IV Arme d'Italie. Buonaparte, gnral en chef. Prise de
Pizzighitone. Entre des Franais dans Crmone.

0823
23 Floral II Arme des Ardennes. Les Franais enlvent tous les
ouvrages du camp de Merbes, d'o l'ennemi est forc de se retirer.
Au passage de la Sambre, les grenadiers du 49e rgiment s'lancent 
l'eau pour soutenir les tirailleurs, et mettent en droute la lgion
de Bourbon.

Le 68e rgiment soutient seul sur un pont l'attaque des Autrichiens
suprieurs en nombre, quoiqu'en butte  l'artillerie, et conserve son
poste.

0824
24 Floral II Arme des Ardennes. Combat opinitre : prise et reprise
trois fois du village de Grandreng prs Beaumont.

0825
25 Floral II Arme des Alpes. Les rpublicains enlvent de vive
force les redoutes de Riveto, de la Ramasse, et autres postes sur le
Mont-Cnis.

0826
26 Floral IV Arme d'Italie. Conclusion de la paix avec le roi de
Sardaigne.

0827
27 Floral II Arme des Pyrnes orientales. Sortie de la garnison de
Collioure : trois mille Espagnols repousss avec perte. Le gnral en
chef bless dans cette action.

0828
28 Floral IV Arme d'Italie. Les Franais occupent Milan, Pavie et
Come.

28 Floral XII &nbsp;Le gouvernement de la Rpublique Franaise est confi  un empereur.&nbsp;

0829
29 Floral II Arme du Nord. Dfaite de l'ennemi  Moescroen.
Bataille gagne sur les coaliss, entre Menin et Courtray.

Arme des Ardennes. Glorieuse rsistance de quinze cents Franais qui
s'opposent  la marche de quatorze mille Autrichiens vers Cunfoz.
Cent cinquante jeunes gens de la premire rquisition qui tiennent en
chec toute la droite de l'arme de Beaulieu devant Bouillon.

Arme des Pyrnes occidentales. Enlvement de six magasins
ennemis. Rupture des cluses de la grande mture royale : prise d'une
grande quantit de bestiaux.

Droute des Espagnols, repousss  la baonnette jusqu' leur camp de
Berra.

0830
30 Floral II Arme des Pyrnes orientales. Droute des Espagnols
prs de Figuires.

Arme des Ardennes. Belle dfense de cent soixante Franais renferms
et attaqus par de nombreux ennemis dans le chteau de Bouillon.

30 Floral VI Bombardement d'Ostende par les Anglais, et dbarquement
de quatre mille d'entre eux ; les Franais les enveloppent, font deux
mille prisonniers, et forcent le reste  se rembarquer prcipitemment
avec perte de cent hommes tus. Le gnral anglais est lui-mme
grivement bless.

0901
1 Prairial II Arme des Ardennes. Dfaite de l'ennemi  Lobbes et
Erquelinne, aprs un combat de six heures.

1 Prairial IV Arme d'Italie. Conclusion d'une armistice avec le duc
de Modne.

1 Prairial VII. Naissance d'Honor de Balzac

0904
4 Prairial II Arme du Rhin. Bataille de Schifferstadt, gagne par
quinze mille rpublicains contre quarante mille autrichiens. Un
gnral autrichien tu.

Arme de la Moselle. Droute complte de l'avant-garde de Beaulieu.

0905
5 Prairial II Arme des Ardennes. Victoire  Merbes-le-Chteau aprs
une charge gnrale.

0906
6 Prairial II Arme de la Moselle. Le poste de Saint-Hubert dfendu
par deux mille autrichiens est enlev par les Franais ; fuite de
l'ennemi.

6 Prairial IV Arme d'Italie. Huit cents habitans rvolts, attaqus
 Bagnasco, sont mis en droute ; cent des leurs tus, et leur village
brl.

6 Prairial VI Arme d'Italie. Runion de la rpublique de Genve  la
rpublique franaise.

Les troupes franaises attaquent les insurgs du Haut-Valais.

0907
7 Prairial II Arme de la Moselle. Prise des redoutes et de la ville
de Dinan.

Arme des Pyrnes orientales. Evacuation par l'ennemi des forts
Saint-Elme et Port-Vendre, reprise de Collioure.

7 Prairial III. Dix mille hommes d'infanterie, et douze cents de
cavalerie, espagnole attaquent une reconnaissance faite par les
troupes du camp des hauteurs de Pontos ; mais ils sont mis en droute.

7 Prairial IV Arme d'Italie. Rvolte de Pavie.

7 Prairial V Excution de Gracchus Babeuf.

0908
8 Prairial III. Trait de paix et d'alliance, conclu  la Haye, entre
la Rpublique franaise et les membres des tats-gnraux de Hollande.

0911
11 Prairial IV Arme d'Italie. Dfaite de cinq mille Autrichiens 
Borghetto ; passage du Mincio par les grenadiers ; prise du village de
Valeggio.

0912
12 Prairial II Arme de la Moselle. Attaque des avants-postes du camp
de S. Grard par les Franais ; les coaliss sont chasss de la
majeure partie de leurs avants-postes.

12 Prairial IV Arme de Sambre et Meuse. A minuit les rpublicains
s'emparent des avants-postes, situs en avant de Nider-Diebach, et
dans le jour forcent l'ennemi d'abandonner la gorge de Mannebach.

0913
13 Prairial II Arme de la Moselle. Prise de la ville de Dinan par
les troupes rpublicaines.

13 Prairial IV Arme d'Italie. Prise de la forteresse de Peschiera.

Arme de Sambre et Meuse. Prise des retranchemens de la Sieg et de la
Acher.

0914
14 Prairial II Arme des Ardennes. Droute des ennemis, prs du bois
de Sainte-Marie.

0915
15 Prairial II Arme des Pyrnes occidentales. Bataille gagne sur
plusieurs points ; les rpublicains enlvent  la baonnette, le camp
Ispeguy et les redoutes des Aldudes et de Berdaritz.

Arme des Pyrnes orientales. Prise de Thouzen et Riben, sur les
Espagnols, forcs  la retraite.

15 Prairial IV Arme de Sambre et Meuse. Bataille d'Altenkirchen ;
l'ennemi mis en droute.

Arme d'Italie. Entre des Franais dans Vronne.

0916
16 Prairial IV Arme d'Italie. Six cents grenadiers Franais enlvent
 la baonnette le faubourg S. Georges, et la tte du pont de Mantoue.

Prise du faubourg de Cherial, de ses retranchemens, et de la tour ;
l'ennemi est forc de se retirer dans Mantoue.

0917
17 Prairial II Arme des Alpes. Prise du fameux poste des barricades ; 
communication rtablie entre l'arme des Alpes et celle d'Italie.

17 Prairial IV Arme d'Italie. Une colonne franaise, dirige sur le
lac de Conio, enlve et dtruit le fort de Fuentes.

Arme de Sambre et Meuse. Prise de Dierdoff, et de Montabaur.

0918
18 Prairial IV Arme de Sambre et Meuse. Prise de Weilbourg.

0919
19 Prairial II Arme des Pyrnes orientales. Dfaite de quatre mille
Espagnols par un petit nombre de Franais, au-del de la Jonquire ;
investissement de Bellegarde.

Les Franais se rendent matres de Campredon et de diffrents postes.

0920
20 Prairial IV Arme du Rhin et Moselle. L'ennemi vacue
Kayserslautern, Tripstadt, Neustadt et Spire.

0923
23 Prairial II Arme des Alpes. Droute de quinze cents Pimontais,
par deux cents Franais, dans la valle d'Aoste.

Arme des Pyrnes orientales. Les Franais se rendent matres de
Ripoll, et dtruisent ses forges.

23 Prairial VI Arme de l'Orient. Prise de l'le de Malte.

0924
24 Prairial II Arme de la Moselle. Passage de la Sambre, par l'arme
de la Moselle ; investissement de Charleroy.

Arme de la Moselle, des Ardennes, et du Nord runies. Action
vigoureuse sur plusieurs colonnes qui repoussent tous les
avants-postes de Charleroy, et se portent victorieuses jusqu'au dessus
de Gosselies.

24 Prairial III Arme de Sambre et Meuse. Prise de Luxembourg.

0925
25 Prairial VIII. Bataille de Marengo en Italie, Klber est assassin au Caire

0926
26 Prairial II Arme de la Moselle, des Ardennes, et du Nord runies.
Les Franais enlvent et dtruisent sous le feu du canon ennemi, une
redoute prs Charleroy, aprs avoir vigoureusement repouss la
garnison.

En moins de dix minutes, les Franais enlvent devant Charleroy, la
redoute place  ct de la chausse de Bruxelles ; le premier
bataillon du Bas-Rhin repousse vigoureusement une sortie de la
garnison de Charleroy.

26 Prairial III Arme des Pyrnes orientales. Bataille de la Fluvia ; 
droute de vingt-huit mille Espagnols.

26 Prairial IV Arme de Sambre et Meuse. Six compagnies de grenadiers
s'emparent de Nassau.

Arme du Rhin et Moselle. Les retranchemens des Autrichiens entre
Franckental et le Rehut, sont forcs par les Franais.

0927
27 Prairial IV Arme de Sambre et Meuse. Combat prs de Wetzlar ; les
ennemis sont forcs de repasser la Dyle.

0928
28 Prairial II Arme de la Moselle, des Ardennes, et du Nord.
Victoire remporte sur les coaliss auprs de Trassignies.

0929
29 Prairial IV Arme du Nord. Prise d'Ypres.

0930
30 Prairial II Arme des Alpes. Dfaite des Pimontais, au petit
St. Bernard.

1001
1 Messidor II Arme des Pyrnes orientales. Reprise de Campredon,
aprs un combat opinitre.

1 Messidor IV Arme d'Italie. Entre des Franais dans Reggio et
Bologne.

Reddition du fort Urbain, et de trois cents hommes de garnison.

Ferrare et son chteau sont occups par les Franais.

1002
2 Messidor II Arme des Pyrnes orientales. Prise des postes de
l'toile et de Bezalu.

1003
3 Messidor IV Arme d'Italie. Les Franais attaquent les avant-postes
de Beaulieu, et les mettent en droute.

1005
5 Messidor II Arme des Pyrnes occidentales. Bataille de la Croix
des bouquets, et enlvement des postes du Rocher et Dos d'Asne.

Arme d'Italie. Conclusion de l'armistice avec le Pape.

1006
6 Messidor IV Arme de Rhin et Moselle. Passage du Rhin prs
Strasbourg ; prise du fort de Kell.

1007
7 Messidor II Arme du Nord, des Ardennes, et de la Moselle. Prise de
Charleroy.

7 Messidor IV Arme de Rhin et Moselle. Prise de Wilstett.

1008
8 Messidor II Arme du Nord, des Ardennes, et de la Moselle. Victoire
mmorable de Fleurus, remporte aprs dix-huit heures de combat, par
soixante-dix mille rpublicains, contre cent mille hommes des armes
coalises. Premire utilisation de la reconnaissance arienne par le 
capitaine Coutelle,  bord du ballon L'Entreprenant.

Arme des Pyrnes orientales. Prise de Relver, et droute complte
des Espagnols.

Arme de Sambre et Meuse. Avantage considrable remport sur
l'ennemi, aux portes de Lernes, Marchiennes, Monceau et Souvret.

8 Messidor III Arme des Alpes et d'Italie. Dfaite d'un corps
nombreux de Pimontais, venus pour s'emparer d'Ormea.

8 Messidor IV Arme de Rhin et Moselle. Prise d'Offembourg.

1009
9 Messidor IV Arme de Rhin et Moselle. L'ennemi est repouss
d'Appenwhir.

L'ennemi est repouss d'Urtassen.

Arme d'Italie. Entre des Franais dans Livourne.

1010
10 Messidor III Arme des Pyrnes occidentales. Prise du camp
retranch de Deva.

10 Messidor IV Arme de Rhin et Moselle. Bataille de Renchen.

1011
11 Messidor IV Arme d'Italie. Capitulation du chteau de Milan.

1012
12 Messidor XII Naissance de George Sand

1013
13 Messidor II Arme de Sambre et Meuse. Enlvement des redoutes et
du camp de Roxule, des postes du Mont-Palisel et du bois d'Harv.

Prise de Mons.

Arme du Nord. Prise de la ville d'Ostende et de son port.

1014
Arme du Nord. Entre des Franais dans Tournay.

Arme du Rhin. Les retranchemens ennemis et plusieurs de leurs
avant-postes sont forcs et pris par les Franais.

Arme des Pyrnes occidentales. Les Rpublicains enlvent toutes les
positions ennemies jusqu' Lecumbery, et le forcent de se retirer
jusqu' Yrursum.

Arme de Rhin et Moselle. Attaque de la montagne de Knubis ; prise
d'une redoute place au sommet.

Arme de Sambre et Meuse. Passage du Rhin prs de Neuwied ; prise de
plusieurs redoutes armes.

14 Messidor VI
Arme d'Egypte. L'arme franaise effectue son dbarquement 
Alexandrie, dfait les Mamelucks, et soumet les villes d'Alexandrie,
de Rosette et du Caire.

1015
15 Messidor II Arme d'Italie. Droute de quatre mille Pimontais par
la garnison de Louano, qui les chasse de Pietra.

1016
16 Messidor IV Arme de Sambre et Meuse. Combat prs Willerdorff.

Arme de Rhin et Moselle. Combat d'Oss ; attaque et prise de Baden et
de Freudenstatt.

1017
17 Messidor II Arme du Nord. Prise d'Oudenarde et de Gand.

17 Messidor IV Arme du Rhin et Moselle. Bataille de Rastadt ; perte
norme de l'ennemi sur le champ de bataille ; il est chass de
Kupenheim, et contraint de repasser la Murg.

Arme d'Italie. Enlvement  la baonette des retranchemens
autrichiens, entre la tte du lac de Garde et l'Adige, et de la
position de Ballone.

1018
18 Messidor II Arme de Sambre et Meuse. Dfaite de trente mille
ennemis  Vaterlo, par l'avant-garde franaise, compose de quatorze
mille hommes.

18 Messidor III Arme des Pyrnes occidentales. Combat d'Yrursum ;
l'infanterie franaise charge et dfait la cavalerie espagnole.

18 Messidor IV Arme d'Italie. Plusieurs milliers de paysans rvolts
sont attaqus au village de Lugo par un bataillon Franais et mis en
droute.

1019
19 Messidor II Arme de Sambre et Meuse. Victoire remporte sur les
coaliss  Sombref.

19 Messidor IV Combat devant Limbourg ; l'ennemi est poursuivi jusques
dans la ville.

1020
20 Messidor II Arme de Sambre et Meuse. Combat trs vif 
Chapelle-Saint-Lambert ; droute de l'ennemi.

20 Messidor V Arme d'Italie. Par suite des conqutes de l'arme
d'Italie, le gnral Buonaparte se rend  Milan, et proclame la
Rpublique cisalpine.

1021
21 Messidor IV Arme de Sambre et Meuse. Passage de la Lahn ; marche
de l'arme sur Francfort et Mayence.

Arme du Rhin et Moselle. Combat en avant de Raspadret dans la gorge
en avant de Guersbach ; l'ennemi est forc de se retirer derrire
Dourlach.

Arme de Sambre et Meuse. Combat en avant de Butzbach, d'Obermel et
de Camberg ; prise de Friedberg.

1022
22 Messidor II Arme de Sambre et Meuse. Entre victorieuse de
l'arme dans Bruxelles.

Arme des Pyrnes occidentales. Les Franais enlvent de vive force
le camp des migrs prs Berdaritz.

22 Messidor IV Arme de Rhin et Moselle. L'ennemi est chass
d'Ettlingen, Durlach et Carlsruh.

1024
24 Messidor III Arme des Pyrnes occidentales. Prise du camp
retranch de Deybat.

1025
25 Messidor I Jean-Paul Marat est assassin dans son bain par Charlotte Corday.

25 Messidor II Arme du Rhin. Bataille gagne sur toute la ligne ;
prise de quinze canons et des postes de Freibach, Freimersheim, et des
montagnes de Platzberg et de Sankolp.

25 Messidor III Arme des Pyrnes occidentales. Prise de Durango.

1026
26 Messidor II Arme du Rhin. Prise des gorges d'Hoehspire, et entre
des Franais dans Spire et Neustadt.

Arme d'Italie. Prise de Verttaute par les Franais.

Arme de la Moselle. Prise  la baonnette des redoutes et du poste
de Tripstadt.

Arme de Rhin et Moselle. Prise des postes d'Haslach et de Haussen.

1027
27 Messidor II Arme de Sambre et Meuse. Le poste de la Montagne de
Fer, aprs Louvain, est enlev de vive force par les Franais, qui se
rendent matres de la ville de Louvain, malgr la vigoureuse
rsistance de l'ennemi.

Arme du Nord. Prise de la ville de Malines.

1028
28 Messidor II Arme de Sambre et Meuse. Prise de Namur.

Arme d'Italie. Quatre mille cinq cents Autrichiens de la garnison de
Mantoue, font une sortie, et sont repousss jusqu'aux palissades.

Arme de Sambre et Meuse. Prise de Francfort.

1029
29 Messidor I Charlotte Corday, qui a assassin Jean-Paul Marat, est excute.

29 Messidor II Arme du Rhin. Prise de Kayserlauter.

Arme de Sambre et Meuse. Reddition de Landrcies, aprs six jours de
tranche.

29 Messidor III L'ennemi, forc dans toutes ses positions, abandonne
la Biscaye et se retire derrire l'Ebre ; prise des Salines de
Mictorie et de Bilbao.

29 Messidor IV Attaque et prise du poste d'Alpersbach.

Attaque et droute de tous les postes ennemis, entre le Necker et la
Kinche.

Prise de Rheinfelden, Seckingen et de tout le Friekthal.

Reconnaissance militaire faite par les Franais sur la route
d'Aschaffenbourg.

1030
30 Messidor II Arme du Nord. Prise de Nieuport, aprs cinq jours de
tranche.

30 Messidor IV Arme d'Italie. Attaque du camp retranch des
Autrichiens sous Mantoue ; ils sont repousss sous les murs de la
place ; pendant ce temps, les Franais mettent le feu en cinq endroits
de la ville, et ouvrent la tranche  cinquante toises des ouvrages
avancs.

Arme de Rhin et Moselle. Entre des Franais dans Stutgard ; combat
opinitre  Echingen ; les Franais restent matres de toute la rive
gauche de Necker.

1101
1 Thermidor II Arme de Sambre et Meuse. Dfaite de l'ennemi sur les
hauteurs en arrire de Tirlemont.

1103
3 Thermidor II Arme de Sambre et Meuse. Droute de l'ennemi  Hui :
prise de Saint-Tros.

3 Thermidor III Victoire de Hoche  Quiberon contre les royalistes

1104
4 Thermidor III Trait de paix conclu entre la Rpublique franaise et
le roi d'Espagne.

4 Thermidor IV Arme de Sambre et Meuse. Prise de Schwinfurt.

1105
5 Thermidor X Naissance d'Alexandre Dumas pre.

1106
6 Thermidor II Arme des Pyrnes orientales. Entre des rpublicains
dans la valle de Bastan, bombardement de Fontarabie.

6 Thermidor IV Arme de Sambre et Meuse. Capitulation de la ville et
citadelle de Wurtsbourg.

1108
8 Thermidor II Arme d'Italie. Prise de vive force, par les Franais,
du village de Roccavion.

8 Thermidor IV Arme de Sambre et Meuse. Capitulation du fort de
Koenigstein.

1109
9 Thermidor I Arme de Sambre et Meuse. Entre des Franais dans
Lige.

9 Thermidor II. La chute de Robespierre.

1110
10 Thermidor II Arme du Nord. Prise de Cassandria et passage du
Cacysche.

1111
11 Thermidor III Arme des Alpes et d'Italie. Enlvement des redoutes
du champ di Pietri.

11 Thermidor IV Arme de Sambre et Meuse. Sortie de la garnison de
Mayence : l'ennemi est vigoureusement repouss.

1112
12 Thermidor II Arme des Pyrnes occidentales. Conqute de la
valle de Bastan. Prise du fort de Figuier, de Fontarabie.

1113
13 Thermidor IV Arme d'Italie. Dfaite des Autrichiens  Solo.
L'ennemi est battu  Lonado.

1114
Arme d'Italie. Reprise de Brescia.

1115
15 Thermidor IV Arme de Sambre et Meuse. prise de Koenigshoffen.

1116
16 Thermidor II Arme des Pyrnes occidentales. Les Franais se
rendent matres du poste important d'Ernani, de la ville de
Saint-Sbastien, de sa citadelle et du port du passage.

16 Thermidor IV Arme du Rhin et Moselle. Prise du poste de
Heidenheim.

Arme d'Italie. Dfaite complte des Autrichiens ; reprise de Solo,
Lonado et Castiglione.

1117
17 Thermidor IV Arme d'Italie. Prise de Saint-Ozeto. Un bataillon
franais marche sur Gavardo et culbute les ennemis. Dfaite d'une
colonne ennemie  Gavardo.

Arme de Sambre et Meuse. Prise de Bamberg.

1118
18 Thermidor IV Arme d'Italie. L'arme de Wurmser, poste entre le
village de Solfrino, et la Chiesa, est mise en droute.

1119
19 Thermidor IV L'ennemi retranch derrire le Mincio, entre Peschiera
et Mantoue, est attaqu, mis en droute, et lve le sige de
Peschiera.

Arme de Sambre et Meuse. Combat d'Altendorff.

1120
20 Thermidor IV Arme d'Italie. Les Franais reprennent leurs
anciennes positions, passent le Mincio et pntrent  Vrone.

1121
21 Thermidor II Arme de la Moselle. Enlvement des retranchements et
hauteurs de Pelingen. Les Franais enlvent de vive force le pont de
Vasserbilich.

Arme du Rhin et Moselle. L'ennemi vacue Neresheim.

Arme de Sambre et Meuse. Combat sur la Rednitz ; prise de Forscheim.

1122
22 Thermidor II Arme de la Moselle. Entre des Franais dans Trves.

Arme des Pyrnes occidentales. Prise de Toloza.

1123
23 Thermidor IV Arme d'Italie. Les Franais reprennent leurs
positions devant Mantoue.

1124
24 Thermidor IV Arme d'Italie. Les Franais attaquent l'ennemi  la
Corona, et  Montebaldo ; ils s'emparent de ces postes et de Prabolo.

Arme du Rhin et Moselle. Bataille de Heidenheim, aprs dix-sept
heures de combat ; l'ennemi fait sa retraite derrire la Vernitz.

Arme de Sambre et Meuse. Prise du fort de Rhotemberg.

Arme du Rhin et Moselle. Entre des Franais dans Brgentz.

1125
25 Thermidor IV Arme d'Italie. L'ennemi est forc  la
Roque-Danfonce et  Lodron. Une autre colonne de Franais passe
l'Adige, pousse l'ennemi sur Roveredo, et fait quelques centaines de
prisonniers.

1126
26 Thermidor II Arme des Pyrnes occidentales. Les Espagnols se
laissent enlever plusieurs postes, ainsi que la redoute d'Alloqui.

Arme des Pyrnes orientales. Victoire remporte par les Franais
auprs de St.-Laurent de la Mouga. Dfaite  Rocaseins, de quinze
mille Espagnols, par quatre mille rpublicains.

1128
28 Thermidor II Arme de Sambre et Meuse. Reprise du Quesnoy.

28 Thermidor IV Prise de Neumarch.

1129
29 Thermidor IV Trait de paix entre la Rpublique franaise et le duc
de Wurtemberg.

1130
30 Thermidor IV Arme de Sambre et Meuse. L'ennemi est chass de la
hauteur de Sulzbach.

Bataille de Poperg et Leinfeld, prise de Castel.

1202
2 Fructidor IV Arme d'Italie. Retraite de l'arme de Wurmser
derrire Trente, aprs avoir brl sa marine sur le lac de Garde.

1206
6 Fructidor VI Expdition d'Irlande. Les troupes franaises oprent
leur dbarqument en Irlande et se rendent matre de Killala.

1207
7 Fructidor IV Arme d'Italie. Prise de Borgoforte et de Governolo,
aprs une vive canonnade.

Arme du Rhin et Moselle. Combat de Friedberg et passage du Lech  la
nage par les Franais ; l'ennemi est repouss et mis en droute.

7 Fructidor VI Trait d'alliance offensive et dfensive entre les
Rpubliques franaise et helvtique.

1208
8 Fructidor III Arme des Alpes et d'Italie. Victoire remporte sur
un corps considrable de Pimontais.

1209
9 Fructidor II Arme du Nord. Prise du fort l'Ecluse.

1210
10 Fructidor II Arme de Sambre et Meuse. Enlvement  la baonette
du village d'Anzain et des postes et redoutes tenant  Valenciennes.

Reprise de Valenciennes.

10 Fructidor VI Expdition d'Irlande. Les Franais dbarqus en
Irlande attaquent le gnral Lack  Castlbar, lui prennent six pices
de canons et le mettent en fuite.

1211
11 Fructidor II Arme des Pyrnes occidentales. Dfaite de sept mille
Espagnols  Eibon. Droute des Espagnols  Ermilla. Droute de
quatre mille ennemis et entre des Franais  Oudoroa.

1213
13 Fructidor II Arme de Sambre et Meuse. Reprise de Cond.

1214
14 Fructidor III Arme des Alpes et d'Italie. Droute de quatre mille
Pimontais, venus pour attaquer le Mont-Genve.

14 Fructidor IV Trait de paix entre la Rpublique franaise et le
margrave de Baden.

1215
15 Fructidor III Arme des Alpes et d'Italie. Dfaite de quinze cents
Pimontais, venus pour attaquer le poste de Cerise.

15 Fructidor III Trait de paix entre la Rpublique franaise et le
landgrave de Hesse-Cassel.

1216
16 Fructidor II Arme de la Moselle. Combat trs vif prs
Sandweiller.

1217
17 Fructidor IV Arme du Rhin et Moselle. L'ennemi attaquant et
attaqu depuis Ingolstaldt jusqu' Fresing, est battu sur tous les
points.

1218
18 Fructidor II Arme des Pyrnes occidentales. Dfaite dans la
valle d'Aspe de six mille Espagnols par six cents Franais.

Droute des Espagnols, mis en fuite par les avant postes de Lescun.

18 Fructidor IV Arme d'Italie. Attaque par les Franais de
Santo-Marco. L'ennemi chass de Pive et Roveredo, se retire au
chteau de la Pietra.

Arme du Rhin et Moselle. La garnison de Philisbourg et Manheim est
repousse jusque sous les murs de Philisbourg.

18 Fructidor V Coup d'tat contre les royalistes.

1219
19 Fructidor III Arme de Sambre et Meuse. Passage du Rhin par l'aile
gauche de l'arme. L'ennemi est chass de tous ses retranchements.

Prise de Keyserwerth avec son artillerie et de Dusseldorff.

1221
21 Fructidor I Arme du Nord. Bataille d'Honscoote.

Arme des Ardennes. Les ennemis abandonnent les postes d'Hastires.

Arme d'Italie. Droute complte des Pimontais, repousss des postes
de Brouis-Hutel et Levenzo.

21 Fructidor IV
Arme du Rhin et Moselle. Armistice conclu avec S. A. S. R. Bavaro
palatine.

L'avant-garde du centre, rencontre l'ennemi  Mainbourg, et le
culbute.

Arme d'Italie. Attaque du camp retranch de Primolac ; l'ennemi mis
en fuite, se rallie dans le fort de Coveto, qu'il est forc d'vacuer.

1222
22 Fructidor I Arme du Nord. Fuite prcipite du duc d'Yorc ;
retraite de quarante mille Anglais, Hessois et coaliss, forcs de
lever le blocus de Dunkerque et de Bergues.

22 Fructidor IV Arme d'Italie. L'ennemi chass de la rive droite de
la Brenta, se retire  Bassano ; les rpublicains lui livrent bataille
en avant de la ville, le mettent en droute, et le poursuivent jusqu'
Citadella.

1223
23 Fructidor VI Arme franaise en Helvtie. Affaire de Stanz ; les
Suisses sont mis en pleine droute.

1224
24 Fructidor I Arme des Alpes. Avantage remport par les Franais,
dans la plaine d'Aigne-Belle.

24 Fructidor III Arme de Sambre et Meuse. L'arme franaise passe le
Rhin en prsence de l'ennemi, qui s'y oppose inutilement, et le
repousse au-del de la ville de Dusseldorff, dont il reste le matre.

1225
25 Fructidor I Arme du Rhin. L'ennemi attaqu sur tous les points,
est chass de tous ses postes, auprs de Lauterbourg.

1226
26 Fructidor I Arme du Nord. Combat  Werwick et Comines.

26 Fructidor II Arme de la Moselle. Combat en avant de Courteren.

26 Fructidor IV Arme du Rhin et Moselle. Combat de Kamlach ;
l'ennemi est repouss jusqu' Mindelheim.

26 Fructidor V Trait de paix conclu entre la Rpublique franaise et
la reine de Portugal.

1227
27 Fructidor I Arme des Alpes. L'ennemi est chass des hauteurs de
Belleville ; prise de la redoute et des retranchements d'Epierre.

27 Fructidor III Arme de Sambre et Meuse. Combat d'Enef et
d'Hanleshorn.

27 Fructidor IV Arme d'Italie. Prise de Porto-Tegnago.

1228
28 Fructidor I Arme du Rhin. Les Franais enlvent le camp retranch
de Nothweiller, et poursuivent l'ennemi jusqu'au-del de Bondenthal.

28 Fructidor II Arme des Alpes. L'ennemi est chass par les
Franais, des camps de la Chenal, Sambuck, Prati, et de divers autres
postes.

1229
29 Fructidor IV Arme d'Italie. Bataille de S. Georges ; l'ennemi,
battu sur tous les points, est contraint de se sauver dans Mantoue.

1230
30 Fructidor I Arme de l'Ouest. Victoire remporte par les
rpublicains sur les rebelles de la Vende, prs de Montaigu.

Arme des Pyrnes occidentales. Avantage remport par les Franais
sur les Espagnols,  Urdach, dans la valle de Bastan.

30 Fructidor II Arme du Nord. Droute totale de l'ennemi  Boxtel.

30 Fructidor IV Arme de Sambre et Meuse. Combat et prise
d'Altenkirchen ; l'ennemi, complettement battu, se retire sur la Lahn.

1301
1 jour complmentaire I Arme des Pyrnes orientales. Reprise du
poste de Verret.

Arme des Pyrnes orientales. Reprise de Bellegarde, dernire place
franaise occupe par l'ennemi.

1302
2 jour complmentaire I Arme des Pyrnes orientales. Les Franais
se rendent matres de Sterry.

2 jour complmentaire II Arme de Sambre et Meuse. Victoire remporte
par toute la ligne de l'arme franaise, depuis Maseick jusqu'
Sprimont.

Prise de Lauwfeld, d'Emale et de Montenack ; passage de l'Ourte et de
Laywale.

2 jour complmentaire IV Arme de Rhin et Moselle. Attaque
infructueuse du fort de Kehl par l'ennemi.

1303
3 jour complmentaire III Arme de Sambre et Meuse. Combat sur la
Lahn ; prise de Limbourg, Dietz et Nasseau.

Arme d'Italie. Combat sur la ligne de Borghetto ; dfaite des
Autrichiens.

3 jour complmentaire V. Mort du gnral Hoche, gnral en chef de
l'arme de Sambre et Meuse.

1304
4 jour complmentaire I Arme des Pyrnes occidentales. Prise de
Villefranche et du camp de Prades.

Prise d'Escalo et d'Uaborsy, occups par les Espagnols.

4 jour complmentaire II Arme de Sambre et Meuse. Enlvement de vive
force des hauteurs de Clermont, aprs sept attaques successives.

Arme d'Italie. Victoire du Cairo sur les Pimontais, soutenus par
dix mille Autrichiens.

4 jour complmentaire III. Reddition de Manheim par capitulation.

1305
5 jour complmentaire II Arme des Pyrnes occidentales. Droute des
Espagnols au Mont-Roch.

5 jour complmentaire IV Mort du gnral Marceau, g de 27 ans, tu 
Altenkirchen par un coup de carabine.
EVENTS
  delete $event{dummy};
}

# A module must return a true value. Traditionally, a module returns 1.
# But this module is a revolutionary one, so it discards all old traditions.
"Dansons la carmagnole, vive le son du canon.";
