use strict;

use Test;
use vars qw($loaded $gen $autoseed
            $num1 $num2 $num3 $num4 $num5 $num6
            $int1 $int2 $int3 $int4 $int5 $int6 );

BEGIN { plan tests => 36 }
END   { print "not ok 1\n" unless $loaded }

# OO interface
# Test the ability to automatically generate a seed, return it, and reproduce
# the same series of random number by specifying this seed manually.

use Math::Random::MT;
ok($loaded = 1);

# Generate a series of 6 random numbers using an autogenerated seed
ok($gen = Math::Random::MT->new());
ok($num1 = $gen->rand());
ok($num2 = $gen->rand());
ok($num3 = $gen->rand());
ok($int1 = $gen->irand());
ok($int2 = $gen->irand());
ok($int3 = $gen->irand());
ok($autoseed = $gen->get_seed());

# Generate a series of 6 random numbers the using same seed value but manually specified
ok($gen = Math::Random::MT->new($autoseed));
ok($num4 = $gen->rand());
ok($num5 = $gen->rand());
ok($num6 = $gen->rand());
ok($int4 = $gen->irand());
ok($int5 = $gen->irand());
ok($int6 = $gen->irand());

# Both series of number should be the same
ok($num1 == $num4);
ok($num2 == $num5);
ok($num3 == $num6);
ok($int1 == $int4);
ok($int2 == $int5);
ok($int3 == $int6);

# Generate a series of 6 random numbers the using same seed value but manually specified
ok($gen = Math::Random::MT->new());
ok($gen->set_seed($autoseed) == $autoseed);
ok($num4 = $gen->rand());
ok($num5 = $gen->rand());
ok($num6 = $gen->rand());
ok($int4 = $gen->irand());
ok($int5 = $gen->irand());
ok($int6 = $gen->irand());

# Both series of number should be the same
ok($num1 == $num4);
ok($num2 == $num5);
ok($num3 == $num6);
ok($int1 == $int4);
ok($int2 == $int5);
ok($int3 == $int6);
