### load a PNG file bitmap from file then put it in a matrix

use 'GFX-Tools-Buffer::matrix'; ### uses this math matrix class !

sub new {
    my $class = shift;

    $self = { };

    bless $self, $class;

}

### This returns a MatrixBitmap.pm of hexes of a PNG bitmap
### (each hex a color, not a RGBA number on itself)
sub loadPNGFile {
    my ($self, $pngfilename) = @_;

    my $png = Image::PNG->new;
    $png->read($pngfilename);

    my $matrix = matrix->new($png->height, $png->width); ### see use at the top
    my $rows = ${$png->rows}; ### was a reference

    my $pngbppmultiplynumber = 4; ### R,G,B and A
    
    for (my $j = 0; $j < $matrix->getRowsNumber * $pngbppmultiplynumber; $j++) {
      my @rowofbytes = unpack('C*', $rows[$j]); ### https://stackoverflow.com/questions/13158976/split-binary-data-into-byte-array-in-perl
      for (my $i = 0; $i < $matrix->getColumnsNumber * $pngbppmultiplynumber; $i++) {
	$matrix->setAtIndex($j, $i, hex(@rowofbytes[$j][$i]));
      }
    }

    ### NOTE : returns a class 
    return MatrixBitmap->new->setMatrix($matrix);
}

1;
