# Generated by default/object.tt
package Paws::Snowball::NFSOnDeviceServiceConfiguration;
  use Moose;
  has StorageLimit => (is => 'ro', isa => 'Int');
  has StorageUnit => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Snowball::NFSOnDeviceServiceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Snowball::NFSOnDeviceServiceConfiguration object:

  $service_obj->Method(Att1 => { StorageLimit => $value, ..., StorageUnit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Snowball::NFSOnDeviceServiceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->StorageLimit

=head1 DESCRIPTION

An object that represents metadata and configuration settings for NFS
service on an AWS Snow Family device.

=head1 ATTRIBUTES


=head2 StorageLimit => Int

The maximum NFS storage for one Snowball Family device.


=head2 StorageUnit => Str

The scale unit of the NFS storage on the device.

Valid values: TB.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Snowball>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

