/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.borland.BorlandLinker;
import net.sf.antcontrib.cpptasks.borland.BorlandProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;
import org.apache.tools.ant.BuildException;

public class BorlandLibrarian
extends CommandLineLinker {
    private static final BorlandLibrarian instance = new BorlandLibrarian();

    public static BorlandLibrarian getInstance() {
        return instance;
    }

    private BorlandLibrarian() {
        super("tlib", "--version", new String[]{".obj"}, new String[0], ".lib", false, null);
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    protected void addEntry(String entry, Vector args) {
    }

    protected String getCommandFileSwitch(String cmdFile) {
        StringBuffer buf = new StringBuffer("@");
        BorlandProcessor.quoteFile(buf, cmdFile);
        return buf.toString();
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return BorlandProcessor.getLibraryPatterns(libnames, libType);
    }

    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    public String[] getOutputFileSwitch(String outFile) {
        return BorlandProcessor.getOutputFileSwitch(outFile);
    }

    public boolean isCaseSensitive() {
        return BorlandProcessor.isCaseSensitive();
    }

    public String getIdentifier() {
        return "TLIB 4.5 Copyright (c) 1987, 1999 Inprise Corporation";
    }

    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        int i;
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        StringBuffer buf = new StringBuffer();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement(this.quoteFilename(buf, outputFileName));
        for (int i2 = 0; i2 < preargs.length; ++i2) {
            execArgs.addElement(preargs[i2]);
        }
        int pageSizeIndex = execArgs.size();
        execArgs.addElement(null);
        int objBytes = 0;
        for (i = 0; i < sourceFiles.length; ++i) {
            String last4 = sourceFiles[i].substring(sourceFiles[i].length() - 4).toLowerCase();
            if (last4.equals(".def") || last4.equals(".res") || last4.equals(".lib")) continue;
            execArgs.addElement("+" + this.quoteFilename(buf, sourceFiles[i]));
            objBytes = (int)((long)objBytes + new File(sourceFiles[i]).length());
        }
        for (i = 0; i < endargs.length; ++i) {
            execArgs.addElement(endargs[i]);
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        int minPageSize = objBytes >> 16;
        int pageSize = 0;
        for (int i3 = 4; i3 <= 15 && (pageSize = 1 << i3) <= minPageSize; ++i3) {
        }
        execArguments[pageSizeIndex] = "/P" + Integer.toString(pageSize);
        return execArguments;
    }

    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        String[] cmdargs = BorlandProcessor.prepareResponseFile(outputFile, args, " & \n");
        cmdargs[cmdargs.length - 1] = this.getCommandFileSwitch(cmdargs[cmdargs.length - 1]);
        return cmdargs;
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        outputFile.delete();
        super.link(task, outputFile, sourceFiles, config);
    }

    protected String quoteFilename(StringBuffer buf, String filename) {
        buf.setLength(0);
        BorlandProcessor.quoteFile(buf, filename);
        return buf.toString();
    }
}

