/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.sun;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.sun.C89Processor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class C89Linker
extends CommandLineLinker {
    private static final C89Linker dllLinker = new C89Linker("lib", ".so");
    private static final C89Linker instance = new C89Linker("", "");
    private String outputPrefix;

    public static C89Linker getInstance() {
        return instance;
    }

    private C89Linker(String outputPrefix, String outputSuffix) {
        super("ld", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[0], outputSuffix, false, null);
        this.outputPrefix = outputPrefix;
    }

    protected void addBase(long base, Vector args) {
    }

    protected void addFixed(Boolean fixed, Vector args) {
    }

    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-G");
        }
    }

    protected void addIncremental(boolean incremental, Vector args) {
    }

    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        StringBuffer buf = new StringBuffer("-l");
        for (int i = 0; i < libsets.length; ++i) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                endargs.addElement("-L");
                endargs.addElement(libdir.getAbsolutePath());
            }
            for (int j = 0; j < libs.length; ++j) {
                buf.setLength(2);
                buf.append(libs[j]);
                endargs.addElement(buf.toString());
            }
        }
        return null;
    }

    protected void addMap(boolean map, Vector args) {
    }

    protected void addStack(int stack, Vector args) {
    }

    protected void addEntry(String entry, Vector args) {
    }

    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return C89Processor.getLibraryPatterns(libnames, libType);
    }

    public Linker getLinker(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public String[] getOutputFileNames(String baseName, VersionInfo versionInfo) {
        String[] baseNames = super.getOutputFileNames(baseName, versionInfo);
        if (this.outputPrefix.length() > 0) {
            for (int i = 0; i < baseNames.length; ++i) {
                baseNames[i] = this.outputPrefix + baseNames[i];
            }
        }
        return baseNames;
    }

    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    public boolean isCaseSensitive() {
        return C89Processor.isCaseSensitive();
    }
}

