package Bundle::Test::SQL::Statement;

use warnings;
use strict;

=head1 NAME

Bundle::Test::SQL::Statement - Requirement Bundle to allow wider tests of SQL::Statement

=cut

our $VERSION = '1.33';

=head1 SYNOPSIS

There is no intention to use this module beside automatic tests.

=head1 DESCRIPTION

This module requires almost everything what could be used by SQL::Statement
to run more test cases.

=head1 AUTHOR

Jens Rehsack, C<< <rehsack at cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-bundle-test-sql-statement at rt.cpan.org>, or through the web interface
at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Bundle-Test-SQL-Statement>.
I will be notified, and then you'll automatically be notified of progress on
your bug as I make changes.

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Bundle::Test::SQL::Statement

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Bundle-Test-SQL-Statement>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Bundle-Test-SQL-Statement>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Bundle-Test-SQL-Statement>

=item * Search CPAN

L<http://search.cpan.org/dist/Bundle-Test-SQL-Statement/>

=back

=head1 ACKNOWLEDGEMENTS


=head1 LICENSE AND COPYRIGHT

Copyright 2011 Jens Rehsack.

This program is free software; you can redistribute it and/or modify it
under the terms of either: the GNU General Public License as published
by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.


=cut

1; # End of Bundle::Test::SQL::Statement
