/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.execute.JarDDL;
import org.apache.derby.io.StorageFile;

public class JarUtil {
    public static final String ADD_JAR_DDL = "ADD JAR";
    public static final String DROP_JAR_DDL = "DROP JAR";
    public static final String REPLACE_JAR_DDL = "REPLACE JAR";
    public static final String READ_JAR = "READ JAR";
    private UUID id;
    private String schemaName;
    private String sqlName;
    private LanguageConnectionContext lcc;
    private FileResource fr;
    private DataDictionary dd;
    private DataDescriptorGenerator ddg;

    public JarUtil(UUID uUID, String string, String string2) throws StandardException {
        this.id = uUID;
        this.schemaName = string;
        this.sqlName = string2;
        this.lcc = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        this.fr = this.lcc.getTransactionExecute().getFileHandler();
        this.dd = this.lcc.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long add(UUID uUID, String string, String string2, String string3) throws StandardException {
        long l;
        JarUtil jarUtil = new JarUtil(uUID, string, string2);
        InputStream inputStream = null;
        try {
            try {
                inputStream = FileUtil.getInputStream(string3, 0);
                l = jarUtil.add(inputStream);
                Object var9_8 = null;
            }
            catch (IOException iOException) {
                throw StandardException.newException("46001", iOException, (Object)string3);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return l;
        }
        if (inputStream == null) return l;
        inputStream.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(InputStream inputStream) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor != null) {
            throw StandardException.newException("X0Y32.S", fileInfoDescriptor.getDescriptorType(), (Object)this.sqlName, (Object)fileInfoDescriptor.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            long l = this.fr.add(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), inputStream);
            SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
            fileInfoDescriptor = this.ddg.newFileInfoDescriptor(this.id, schemaDescriptor, this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor, schemaDescriptor, 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static void drop(UUID uUID, String string, String string2, boolean bl) throws StandardException {
        JarUtil jarUtil = new JarUtil(uUID, string, string2);
        jarUtil.drop(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(boolean bl) throws StandardException {
        String[][] stringArray;
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", this.sqlName, (Object)this.schemaName);
        }
        String string = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "derby.database.classpath");
        if (string != null) {
            stringArray = IdUtil.parseDbClassPath(string, this.lcc.getIdentifierCasing() != 1);
            boolean bl2 = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray.length != 2 || !stringArray[i][0].equals(this.schemaName) || !stringArray[i][1].equals(this.sqlName)) continue;
                bl2 = true;
            }
            if (bl2) {
                throw StandardException.newException("X0X07.S", IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)string);
            }
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            stringArray = this.dd.getDependencyManager();
            stringArray.invalidateFor(fileInfoDescriptor, 17, this.lcc);
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            this.fr.remove(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), fileInfoDescriptor.getGenerationId(), true);
        }
        finally {
            this.notifyLoader(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long replace(UUID uUID, String string, String string2, String string3, boolean bl) throws StandardException {
        long l;
        JarUtil jarUtil = new JarUtil(uUID, string, string2);
        InputStream inputStream = null;
        try {
            try {
                inputStream = FileUtil.getInputStream(string3, 0);
                l = jarUtil.replace(inputStream, bl);
                Object var10_9 = null;
            }
            catch (IOException iOException) {
                throw StandardException.newException("46001", iOException, (Object)string3);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return l;
        }
        if (inputStream == null) return l;
        inputStream.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replace(InputStream inputStream, boolean bl) throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fileInfoDescriptor = this.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", this.sqlName, (Object)this.schemaName);
        }
        try {
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fileInfoDescriptor);
            long l = this.fr.replace(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), fileInfoDescriptor.getGenerationId(), inputStream, bl);
            FileInfoDescriptor fileInfoDescriptor2 = this.ddg.newFileInfoDescriptor(fileInfoDescriptor.getUUID(), fileInfoDescriptor.getSchemaDescriptor(), this.sqlName, l);
            this.dd.addDescriptor(fileInfoDescriptor2, fileInfoDescriptor.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            long l2 = l;
            return l2;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static FileInfoDescriptor getInfo(String string, String string2, String string3) throws StandardException {
        JarUtil jarUtil = new JarUtil(null, string, string2);
        return jarUtil.getInfo();
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(this.schemaName, null, true);
        return this.dd.getFileInfoDescriptor(schemaDescriptor, this.sqlName);
    }

    public static Object getAsObject(String string, String string2) throws StandardException {
        JarUtil jarUtil = new JarUtil(null, string, string2);
        FileInfoDescriptor fileInfoDescriptor = jarUtil.getInfo();
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", string2, (Object)string);
        }
        long l = fileInfoDescriptor.getGenerationId();
        StorageFile storageFile = jarUtil.getAsFile(l);
        if (storageFile != null) {
            return storageFile;
        }
        return jarUtil.getAsStream(l);
    }

    private StorageFile getAsFile(long l) {
        return this.fr.getAsFile(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), l);
    }

    public static InputStream getAsStream(String string, String string2, long l) throws StandardException {
        JarUtil jarUtil = new JarUtil(null, string, string2);
        return jarUtil.getAsStream(l);
    }

    private InputStream getAsStream(long l) throws StandardException {
        try {
            return this.fr.getAsStream(JarDDL.mkExternalName(this.schemaName, this.sqlName, this.fr.getSeparatorChar()), l);
        }
        catch (IOException iOException) {
            throw StandardException.newException("X0X63.S", iOException.toString(), (Object)iOException);
        }
    }

    private void notifyLoader(boolean bl) throws StandardException {
        ClassFactory classFactory = this.lcc.getLanguageConnectionFactory().getClassFactory();
        classFactory.notifyModifyJar(bl);
    }
}

