/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

public class ScalarAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public boolean singleInputRow;
    protected ExecIndexRow sortTemplateRow;
    protected boolean isInSortedOrder;
    protected ExecIndexRow sourceExecIndexRow;
    private boolean nextSatisfied;
    protected int countOfRows;

    public ScalarAggregateResultSet(NoPutResultSet noPutResultSet, boolean bl, int n, Activation activation, GeneratedMethod generatedMethod, int n2, boolean bl2, double d, double d2, GeneratedMethod generatedMethod2) throws StandardException {
        super(noPutResultSet, n, activation, generatedMethod, n2, d, d2, generatedMethod2);
        this.isInSortedOrder = bl;
        this.sortTemplateRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        this.singleInputRow = bl2;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.sourceExecIndexRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow);
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (this.nextSatisfied) {
            this.clearCurrentRow();
            return null;
        }
        Object var1_1 = null;
        Object var2_2 = null;
        ExecIndexRow execIndexRow = null;
        ExecIndexRow execIndexRow2 = null;
        boolean bl = this.singleInputRow && this.aggregates[0].aggInfo.aggregateName.equals("MIN");
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(false)) != null) {
                if (execIndexRow2 == null) {
                    execIndexRow2 = this.singleInputRow && bl ? execIndexRow : (ExecIndexRow)execIndexRow.getClone();
                    this.initializeScalarAggregation(execIndexRow2);
                } else {
                    this.accumulateScalarAggregation(execIndexRow, execIndexRow2, false);
                }
                if (!this.singleInputRow || !bl && execIndexRow2.getColumn(this.aggregates[0].aggregatorColumnId).isNull()) continue;
            }
            if (this.countOfRows == 0) {
                execIndexRow2 = this.finishAggregation(execIndexRow2);
                this.currentRow = execIndexRow2;
                this.setCurrentRow(execIndexRow2);
                ++this.countOfRows;
            }
        }
        this.nextSatisfied = true;
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execIndexRow2;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeCleanup != null) {
                this.closeCleanup.invoke(this.activation);
            }
            this.countOfRows = 0;
            this.currentRow = null;
            this.sourceExecIndexRow = null;
            this.source.close();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.nextSatisfied = false;
        this.isOpen = false;
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.originalSource.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return null;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public ExecIndexRow getRowFromResultSet(boolean bl) throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecRow execRow = this.source.getNextRowCore();
        if (execRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(bl ? execRow.getClone() : execRow);
            execIndexRow = this.sourceExecIndexRow;
        }
        return execIndexRow;
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.countOfRows = 0;
        this.nextSatisfied = false;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    protected void accumulateScalarAggregation(ExecRow execRow, ExecRow execRow2, boolean bl) throws StandardException {
        int n = this.aggregates.length;
        for (int i = 0; i < n; ++i) {
            GenericAggregator genericAggregator = this.aggregates[i];
            if (bl && !genericAggregator.getAggregatorInfo().isDistinct()) {
                genericAggregator.merge(execRow, execRow2);
                continue;
            }
            genericAggregator.accumulate(execRow, execRow2);
        }
    }

    private void initializeScalarAggregation(ExecRow execRow) throws StandardException {
        int n = this.aggregates.length;
        for (int i = 0; i < n; ++i) {
            GenericAggregator genericAggregator = this.aggregates[i];
            genericAggregator.initialize(execRow);
            genericAggregator.accumulate(execRow, execRow);
        }
    }
}

