/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealTableScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public boolean coarserLock;
    public int fetchSize;
    public String isolationLevel;
    public String tableName;
    public String indexName;
    public String lockString;
    public String qualifiers;
    public String startPosition;
    public String stopPosition;
    public FormatableProperties scanProperties;

    public RealTableScanStatistics(int n, int n2, int n3, long l, long l2, long l3, long l4, int n4, String string, String string2, boolean bl, String string3, Properties properties, String string4, String string5, String string6, String string7, int n5, boolean bl2, double d, double d2) {
        super(n, n2, n3, l, l2, l3, l4, n4, d, d2);
        this.tableName = string;
        this.indexName = string2;
        this.isConstraint = bl;
        this.qualifiers = string3;
        this.scanProperties = new FormatableProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string8 = (String)enumeration.nextElement();
            this.scanProperties.put(string8, properties.get(string8));
        }
        this.startPosition = string4;
        this.stopPosition = string5;
        this.isolationLevel = string6;
        this.lockString = string7;
        this.fetchSize = n5;
        this.coarserLock = bl2;
    }

    public String getStatementExecutionPlanText(int n) {
        Object var3_2 = null;
        this.initFormatInfo(n);
        String string = this.indexName != null ? this.indent + MessageService.getTextMessage("43Y09.U", this.tableName, MessageService.getTextMessage(this.isConstraint ? "43X24.U" : "43X25.U"), this.indexName) : this.indent + MessageService.getTextMessage("43Y10.U", this.tableName);
        string = string + " " + MessageService.getTextMessage("43X72.U", this.isolationLevel, this.lockString);
        if (this.coarserLock) {
            string = string + " (" + MessageService.getTextMessage("43Y11.U") + ")";
        }
        string = string + "\n";
        String string2 = this.indent + MessageService.getTextMessage("43X28.U") + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        return string + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage("43Y12.U") + " = " + this.fetchSize + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + string2 + this.subIndent + MessageService.getTextMessage("43X34.U") + ": \n" + this.startPosition + this.subIndent + MessageService.getTextMessage("43X35.U") + ": \n" + this.stopPosition + this.subIndent + MessageService.getTextMessage("43Y13.U") + ":\n" + this.qualifiers + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String string, int n) {
        if (string == null || string.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(n);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeName() {
        return MessageService.getTextMessage(this.indexName == null ? "43X73.U" : "43X74.U");
    }

    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage("43X75.U", this.tableName);
        }
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }
}

