package Minilla::ModuleMaker::ModuleBuild;
use strict;
use warnings;
use utf8;
use Data::Section::Simple qw(get_data_section);
use Text::MicroTemplate qw(render_mt);
use Data::Dumper;

use Moo;

no Moo;

use Minilla::Util qw(spew_raw);

sub generate {
    my ($self, $project) = @_;

    local $Data::Dumper::Terse = 1;
    local $Data::Dumper::Useqq = 1;
    local $Data::Dumper::Purity = 1;
    local $Data::Dumper::Indent = 0;
    my $content = get_data_section('Build.PL');
    my $mt = Text::MicroTemplate->new(template => $content, escape_func => sub { $_[0] });
    my $src = $mt->build->($project);
    spew_raw('Build.PL', $src);
}

sub prereqs {
    return +{
        configure => {
            requires => {
                'Module::Build'       => 0.38,
                'CPAN::Meta'          => 0,
                'CPAN::Meta::Prereqs' => 0,
            }
        }
    }
}

1;
__DATA__

@@ Build.PL
? my $project = shift;
# =========================================================================
# THIS FILE IS AUTOMATICALLY GENERATED BY MINILLA.
# DO NOT EDIT DIRECTLY.
# =========================================================================

use 5.008_001;

use strict;
use warnings;
use utf8;

use <?= $project->build_class ?>;
use File::Basename;
use File::Spec;
use CPAN::Meta;
use CPAN::Meta::Prereqs;

my %args = (
    license              => 'perl',
    dynamic_config       => 0,

    configure_requires => {
        'Module::Build' => 0.38,
    },

    name            => '<?= $project->dist_name ?>',
    module_name     => '<?= $project->name ?>',
    allow_pureperl => <?= $project->allow_pureperl ?>,

    script_files => [<?= $project->script_files ?>],
    c_source     => [qw(<?= $project->c_source ?>)],
    PL_files => <?= Data::Dumper::Dumper($project->PL_files) ?>,

    test_files           => ((-d '.git' || $ENV{RELEASE_TESTING}) && -d 'xt') ? 't/ xt/' : 't/',
    recursive_test_files => 1,
);
if (-d 'share') {
    $args{share_dir} = 'share';
}

my $builder = <?= $project->build_class ?>->subclass(
    class => 'MyBuilder',
    code => q{
        sub ACTION_distmeta {
            die "Do not run distmeta. Install Minilla and `minil install` instead.\n";
        }
        sub ACTION_installdeps {
            die "Do not run installdeps. Run `cpanm --installdeps .` instead.\n";
        }
    }
)->new(%args);
$builder->create_build_script();

my $mbmeta = CPAN::Meta->load_file('MYMETA.json');
my $meta = CPAN::Meta->load_file('META.json');
my $prereqs_hash = CPAN::Meta::Prereqs->new(
    $meta->prereqs
)->with_merged_prereqs(
    CPAN::Meta::Prereqs->new($mbmeta->prereqs)
)->as_string_hash;
my $mymeta = CPAN::Meta->new(
    {
        %{$meta->as_struct},
        prereqs => $prereqs_hash
    }
);
print "Merging cpanfile prereqs to MYMETA.yml\n";
$mymeta->save('MYMETA.yml', { version => 1.4 });
print "Merging cpanfile prereqs to MYMETA.json\n";
$mymeta->save('MYMETA.json', { version => 2 });
