package JIRA::REST::Class::Issue::Type;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01';

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents a JIRA issue type as an object.

__PACKAGE__->mk_data_ro_accessors(qw/ description iconUrl id name self subtask /);

use overload
    '""'   => sub { shift->name    },
    '0+'   => sub { shift->id      },
    'bool' => sub { shift->subtask },
    '<=>'  => sub {
        my($A, $B) = @_;
        my $AA = ref $A ? $A->id : $A;
        my $BB = ref $B ? $B->id : $B;
        $AA <=> $BB
    },
    'cmp'  => sub {
        my($A, $B) = @_;
        my $AA = ref $A ? $A->name : $A;
        my $BB = ref $B ? $B->name : $B;
        $AA cmp $BB
    };

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Type - A helper class for C<JIRA::REST::Class> that represents a JIRA issue type as an object.

=head1 VERSION

version 0.01

=head1 READ-ONLY ACCESSORS

=head2 B<description>
Returns the description of the issue type.

=head2 B<iconUrl>
Returns the URL of the icon the issue type.

=head2 B<id>
Returns the id of the issue type.

=head2 B<name>
Returns the name of the issue type.

=head2 B<self>
Returns the JIRA REST API URL of the issue type.

=head2 B<subtask>
Returns a boolean indicating whether the issue type is a subtask.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
