#!/usr/bin/perl

package eBay::API::XML::Call::AddDispute::AddDisputeRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddDisputeRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::AddDispute::AddDisputeRequestType

=head1 DESCRIPTION

Enables a seller to create a new Unpaid Item dispute. (Item Not Received
disputes can only be created via the eBay web site.)



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::AddDispute::AddDisputeRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::DisputeExplanationCodeType;
use eBay::API::XML::DataType::Enum::DisputeReasonCodeType;


my @gaProperties = ( [ 'DisputeExplanation', 'ns:DisputeExplanationCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeExplanationCodeType', '' ]
	, [ 'DisputeReason', 'ns:DisputeReasonCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::DisputeReasonCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDisputeExplanation()

An explanation of the dispute that supplements the
DisputeReason. The allowed value depends on the value of
DisputeReason.

  RequiredInput: Yes
#    Argument: 'ns:DisputeExplanationCodeType'

=cut

sub setDisputeExplanation {
  my $self = shift;
  $self->{'DisputeExplanation'} = shift
}

=head2 getDisputeExplanation()

#    Returns: 'ns:DisputeExplanationCodeType'

=cut

sub getDisputeExplanation {
  my $self = shift;
  return $self->{'DisputeExplanation'};
}


=head2 setDisputeReason()

The top-level reason for the Unpaid Item Dispute.
DisputeReasonCodeType has several possible values. However, only
BuyerHasNotPaid and TransactionMutuallyCanceled apply to
AddDispute--you can only use AddDisputeCall to create Unpaid
Item disputes.

  RequiredInput: Yes
#    Argument: 'ns:DisputeReasonCodeType'

=cut

sub setDisputeReason {
  my $self = shift;
  $self->{'DisputeReason'} = shift
}

=head2 getDisputeReason()

#    Returns: 'ns:DisputeReasonCodeType'

=cut

sub getDisputeReason {
  my $self = shift;
  return $self->{'DisputeReason'};
}


=head2 setItemID()

The eBay ID of the item in dispute, an item which has been
sold but not yet paid for.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setTransactionID()

The eBay ID of a transaction, created when the buyer committed
to purchasing the item. A transaction ID is unique to the item
but not across the entire eBay site. The transaction ID must be
combined with an item ID to uniquely identify an item.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
