#!/usr/bin/perl

package eBay::API::XML::Call::GetBestOffers;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetBestOffers.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetBestOffers

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetBestOffers inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetBestOffers::GetBestOffersRequestType;
use eBay::API::XML::Call::GetBestOffers::GetBestOffersResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetBestOffers';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetBestOffers::GetBestOffersRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetBestOffers::GetBestOffersResponseType';
}

#
# input properties
#

=head2 setBestOfferID()

Need not be specified by a buyer or a seller.
The BestOfferID is the specific Best Offer you want information about.
If you are the seller, you can get a list of all best offers
(according to BestOfferStatus) by omitting this field.

  RequiredInput: No
#    Argument: 'ns:BestOfferIDType'

=cut
       
sub setBestOfferID {
   my $self   = shift;
   my $pBestOfferID = shift;
   $self->getRequestDataType()->setBestOfferID($pBestOfferID);
}

=head2 setBestOfferStatus()

A filter determining which Best Offers to return for an item. Active is the default.

  RequiredInput: No
  OnlyTheseValues: All, Active
#    Argument: 'ns:BestOfferStatusCodeType'

=cut
       
sub setBestOfferStatus {
   my $self   = shift;
   my $sBestOfferStatus = shift;
   $self->getRequestDataType()->setBestOfferStatus($sBestOfferStatus);
}

=head2 setItemID()

The item for which Best Offer information is to be returned.
If you are a buyer and you have a valid best offer, 
then your best-offer information will be returned for the item you specify.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}



#
# output properties
#

=head2 getBestOfferArray()

All best offers for the item according to the filter or
best offer id (or both) used in the input. The buyer and
seller messages are returned only if the detail level is
defined. Includes the buyer and seller message only if
detail level ReturnAll is used.
Only returned if best offers have been made.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:BestOfferArrayType'

=cut
       
sub getBestOfferArray {
   my $self = shift;
   return $self->getResponseDataType()->getBestOfferArray();
}

=head2 getItem()

The item for which Best Offers are being returned.
Only returned if best offers have been made.

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:ItemType'

=cut
       
sub getItem {
   my $self = shift;
   return $self->getResponseDataType()->getItem();
}





1;   
