#!/usr/bin/perl

package eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoryFeaturesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesResponseType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategoryFeatures::GetCategoryFeaturesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::CategoryFeatureType;
use eBay::API::XML::DataType::FeatureDefinitionsType;
use eBay::API::XML::DataType::SiteDefaultsType;


my @gaProperties = ( [ 'Category', 'ns:CategoryFeatureType', '1'
	     ,'eBay::API::XML::DataType::CategoryFeatureType', '1' ]
	, [ 'CategoryVersion', 'xs:string', '', '', '' ]
	, [ 'FeatureDefinitions', 'ns:FeatureDefinitionsType', ''
	     ,'eBay::API::XML::DataType::FeatureDefinitionsType', '1' ]
	, [ 'SiteDefaults', 'ns:SiteDefaultsType', ''
	     ,'eBay::API::XML::DataType::SiteDefaultsType', '1' ]
	, [ 'UpdateTime', 'xs:dateTime', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategory()

A category whose feature settings are different from the settings of its parent category.<br<
<br<
For example, suppose there is a branch of the category tree with 5 category levels 
(L1, L2, L3, L4, and L5). Suppose the feature settings for SiteDefaults, L1, L4, and L5 
are all "A", and the settings for L2 and L3 are "B". In this case:<br<
L1's settings (A) match the site default, so L1 is not returned.<br<
L2's settings (B) are different from L1's, so L2 is returned.<br<
L3's settings (B) are the same as L2's, so L3 is not returned<br<
L4's settings (A) are different from L3's, so L4 is returned<br<
L5's settings (A) are the same as L4's, so L5 is not returned.<br<
<br<
If you specified a particular FeatureID in the request, this field
only returns feature settings for that feature.
Only returned when the category is different from its parent.
If the category has children and they aren't returned,
it means the children inherit the category's feature settings.

#    Argument: reference to an array  
                      of 'ns:CategoryFeatureType'

=cut

sub setCategory {
  my $self = shift;
  $self->{'Category'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategory()

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: reference to an array  
                      of 'ns:CategoryFeatureType'

=cut

sub getCategory {
  my $self = shift;
  return $self->_getDataTypeArray('Category');
}


=head2 setCategoryVersion()

Returns the current version of the set of feature meta-data.
Compare this value to the version of the last version you
downloaded to determine whether the data may have changed.

#    Argument: 'xs:string'

=cut

sub setCategoryVersion {
  my $self = shift;
  $self->{'CategoryVersion'} = shift
}

=head2 getCategoryVersion()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'xs:string'

=cut

sub getCategoryVersion {
  my $self = shift;
  return $self->{'CategoryVersion'};
}


=head2 setFeatureDefinitions()

Returns definitions of the various features on the site,
or the features you requested in FeatureID (if any).
Each feature has a node within FeatureDefinitions.

#    Argument: 'ns:FeatureDefinitionsType'

=cut

sub setFeatureDefinitions {
  my $self = shift;
  $self->{'FeatureDefinitions'} = shift
}

=head2 getFeatureDefinitions()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:FeatureDefinitionsType'

=cut

sub getFeatureDefinitions {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FeatureDefinitions'
		,'eBay::API::XML::DataType::FeatureDefinitionsType');
}


=head2 setSiteDefaults()

Returns the feature settings defined for most categories on the site.
Most categories share these settings. However, some categories can
override some settings, as indicated in the Category nodes
(if any).

#    Argument: 'ns:SiteDefaultsType'

=cut

sub setSiteDefaults {
  my $self = shift;
  $self->{'SiteDefaults'} = shift
}

=head2 getSiteDefaults()

  Returned: Always
  Details: DetailLevel: ReturnAll
#    Returns: 'ns:SiteDefaultsType'

=cut

sub getSiteDefaults {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SiteDefaults'
		,'eBay::API::XML::DataType::SiteDefaultsType');
}


=head2 setUpdateTime()

Gives the time in GMT that the feature flags for the
category hierarchy were last updated.

#    Argument: 'xs:dateTime'

=cut

sub setUpdateTime {
  my $self = shift;
  $self->{'UpdateTime'} = shift
}

=head2 getUpdateTime()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'xs:dateTime'

=cut

sub getUpdateTime {
  my $self = shift;
  return $self->{'UpdateTime'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
