#!/usr/bin/perl

package eBay::API::XML::Call::GetCategoryListings::GetCategoryListingsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCategoryListingsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCategoryListings::GetCategoryListingsResponseType

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCategoryListings::GetCategoryListingsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::BuyingGuideDetailsType;
use eBay::API::XML::DataType::CategoryArrayType;
use eBay::API::XML::DataType::CategoryType;
use eBay::API::XML::DataType::ItemArrayType;
use eBay::API::XML::DataType::PaginationResultType;
use eBay::API::XML::DataType::RelatedSearchKeywordArrayType;


my @gaProperties = ( [ 'BuyingGuideDetails', 'ns:BuyingGuideDetailsType', ''
	     ,'eBay::API::XML::DataType::BuyingGuideDetailsType', '1' ]
	, [ 'Category', 'ns:CategoryType', ''
	     ,'eBay::API::XML::DataType::CategoryType', '1' ]
	, [ 'HasMoreItems', 'xs:boolean', '', '', '' ]
	, [ 'ItemArray', 'ns:ItemArrayType', ''
	     ,'eBay::API::XML::DataType::ItemArrayType', '1' ]
	, [ 'ItemsPerPage', 'xs:int', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
	, [ 'RelatedSearchKeywordArray', 'ns:RelatedSearchKeywordArrayType', ''
	     ,'eBay::API::XML::DataType::RelatedSearchKeywordArrayType', '1' ]
	, [ 'SubCategories', 'ns:CategoryArrayType', ''
	     ,'eBay::API::XML::DataType::CategoryArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBuyingGuideDetails()

Contains information about relevant buying guides (if any) and the
site's buying guide hub. Buying guides are useful to buyers who do not
have a specific product in mind. For example, a digital camera buying
guide could help a buyer determine what kind of digital camera is right
for them.

#    Argument: 'ns:BuyingGuideDetailsType'

=cut

sub setBuyingGuideDetails {
  my $self = shift;
  $self->{'BuyingGuideDetails'} = shift
}

=head2 getBuyingGuideDetails()

  Returned: Conditionally
#    Returns: 'ns:BuyingGuideDetailsType'

=cut

sub getBuyingGuideDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyingGuideDetails'
		,'eBay::API::XML::DataType::BuyingGuideDetailsType');
}


=head2 setCategory()

Indicates the category from which the listings were drawn.

#    Argument: 'ns:CategoryType'

=cut

sub setCategory {
  my $self = shift;
  $self->{'Category'} = shift
}

=head2 getCategory()

  Returned: Always
#    Returns: 'ns:CategoryType'

=cut

sub getCategory {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Category'
		,'eBay::API::XML::DataType::CategoryType');
}


=head2 setHasMoreItems()

Indicates whether there are more item listings that can be returned
(items listed in the specified category and that meet any input filtering
criteria).

#    Argument: 'xs:boolean'

=cut

sub setHasMoreItems {
  my $self = shift;
  $self->{'HasMoreItems'} = shift
}

=head2 isHasMoreItems()

  Returned: Always
#    Returns: 'xs:boolean'

=cut

sub isHasMoreItems {
  my $self = shift;
  return $self->{'HasMoreItems'};
}


=head2 setItemArray()

Contains the item listings for the specified category and which meet the
input filtering criteria (if any is specified). Consists of one ItemType
object for each returned item listing.

#    Argument: 'ns:ItemArrayType'

=cut

sub setItemArray {
  my $self = shift;
  $self->{'ItemArray'} = shift
}

=head2 getItemArray()

  Returned: Conditionally
#    Returns: 'ns:ItemArrayType'

=cut

sub getItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemArray'
		,'eBay::API::XML::DataType::ItemArrayType');
}


=head2 setItemsPerPage()

Indicates the maximum number of item listings that will be returned per
call.

#    Argument: 'xs:int'

=cut

sub setItemsPerPage {
  my $self = shift;
  $self->{'ItemsPerPage'} = shift
}

=head2 getItemsPerPage()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getItemsPerPage {
  my $self = shift;
  return $self->{'ItemsPerPage'};
}


=head2 setPageNumber()

Indicates the page of data returned in the current call.

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

Indicates the results of the pagination, including the total number of
pages of data there are to be returned and the total number of items
there are to be returned.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}


=head2 setRelatedSearchKeywordArray()

Container for keywords related to the category ID in the request.
Can be returned if the request specified more than zero in
the MaxRelatedSearchKeywords field.

#    Argument: 'ns:RelatedSearchKeywordArrayType'

=cut

sub setRelatedSearchKeywordArray {
  my $self = shift;
  $self->{'RelatedSearchKeywordArray'} = shift
}

=head2 getRelatedSearchKeywordArray()

  Returned: Conditionally
#    Returns: 'ns:RelatedSearchKeywordArrayType'

=cut

sub getRelatedSearchKeywordArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'RelatedSearchKeywordArray'
		,'eBay::API::XML::DataType::RelatedSearchKeywordArrayType');
}


=head2 setSubCategories()

Collection of the sub-categories that are child to the category indicated
in Category. Data for each sub-category is conveyed in a CategoryType
object.

#    Argument: 'ns:CategoryArrayType'

=cut

sub setSubCategories {
  my $self = shift;
  $self->{'SubCategories'} = shift
}

=head2 getSubCategories()

  Returned: Conditionally
#    Returns: 'ns:CategoryArrayType'

=cut

sub getSubCategories {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SubCategories'
		,'eBay::API::XML::DataType::CategoryArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
