#!/usr/bin/perl

package eBay::API::XML::Call::GetRuName::GetRuNameRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetRuNameRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetRuName::GetRuNameRequestType

=head1 DESCRIPTION

Returns a globally unique runame (unique identifier for an authentication data
entry). 
<br>
<br>
Unlike most other Trading API calls, this call requires the eBay
Username and Password values that you created for use by your applications.
(Most Trading API calls, in contrast, require an authentication token.)
These values are not described in the
current documentation topic. For more information about these values,
please use the Setup for Authentication link below.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetRuName::GetRuNameRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'ClientUseCase', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setClientUseCase()

Optional value that is appended to the generated runame.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setClientUseCase {
  my $self = shift;
  $self->{'ClientUseCase'} = shift
}

=head2 getClientUseCase()

#    Returns: 'xs:string'

=cut

sub getClientUseCase {
  my $self = shift;
  return $self->{'ClientUseCase'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
