#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerEvents::GetSellerEventsRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerEventsRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerEvents::GetSellerEventsRequestType

=head1 DESCRIPTION

Retrieves price changes, item revisions, description revisions,
and other changes that have occurred within the last 48 hours
related to a seller's eBay listings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerEvents::GetSellerEventsRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'EndTimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'EndTimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'IncludeWatchCount', 'xs:boolean', '', '', '' ]
	, [ 'ModTimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'ModTimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'NewItemFilter', 'xs:boolean', '', '', '' ]
	, [ 'StartTimeFrom', 'xs:dateTime', '', '', '' ]
	, [ 'StartTimeTo', 'xs:dateTime', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEndTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item end time. Must be specified if EndTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
For better results, the time period you use should be less than 48 hours.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut

sub setEndTimeFrom {
  my $self = shift;
  $self->{'EndTimeFrom'} = shift
}

=head2 getEndTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getEndTimeFrom {
  my $self = shift;
  return $self->{'EndTimeFrom'};
}


=head2 setEndTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on item end time. If you specify the corresponding From filter,
but you do not include EndTimeTo, then EndTimeTo is set
to the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setEndTimeTo {
  my $self = shift;
  $self->{'EndTimeTo'} = shift
}

=head2 getEndTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getEndTimeTo {
  my $self = shift;
  return $self->{'EndTimeTo'};
}


=head2 setIncludeWatchCount()

Specifies whether to include WatchCount in Item nodes returned. WatchCount
is the number of watches buyers have placed on the item from their My eBay
accounts.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeWatchCount {
  my $self = shift;
  $self->{'IncludeWatchCount'} = shift
}

=head2 isIncludeWatchCount()

#    Returns: 'xs:boolean'

=cut

sub isIncludeWatchCount {
  my $self = shift;
  return $self->{'IncludeWatchCount'};
}


=head2 setModTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item modification time. Must be specified if ModTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
<br><br>
For better results, the time period you use should be less than 48 hours.
<br><br>
If an unexpected item is returned (including an old item
or an unchanged active item), please ignore the item.
Although a maintenance process may have triggered a change in the modification time,
item characteristics are unchanged.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut

sub setModTimeFrom {
  my $self = shift;
  $self->{'ModTimeFrom'} = shift
}

=head2 getModTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeFrom {
  my $self = shift;
  return $self->{'ModTimeFrom'};
}


=head2 setModTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on the time an item's record was modified. If you specify
the corresponding From filter, but you do not include ModTimeTo,
then ModTimeTo is set to the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setModTimeTo {
  my $self = shift;
  $self->{'ModTimeTo'} = shift
}

=head2 getModTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getModTimeTo {
  my $self = shift;
  return $self->{'ModTimeTo'};
}


=head2 setNewItemFilter()

Specifies that only new items are to be returned. NewItemFilter is an
optional input.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setNewItemFilter {
  my $self = shift;
  $self->{'NewItemFilter'} = shift
}

=head2 isNewItemFilter()

#    Returns: 'xs:boolean'

=cut

sub isNewItemFilter {
  my $self = shift;
  return $self->{'NewItemFilter'};
}


=head2 setStartTimeFrom()

Describes the earliest (oldest) date to use in a date range filter based
on item start time. Must be specified if StartTimeTo is specified. Either
the StartTimeFrom, EndTimeFrom, or ModTimeFrom filter must be specified.
If you do not specify the correspoding To filter,
it is set to the time you make the call.
For better results, the time period you use should be less than 48 hours.

  RequiredInput: Conditionally
#    Argument: 'xs:dateTime'

=cut

sub setStartTimeFrom {
  my $self = shift;
  $self->{'StartTimeFrom'} = shift
}

=head2 getStartTimeFrom()

#    Returns: 'xs:dateTime'

=cut

sub getStartTimeFrom {
  my $self = shift;
  return $self->{'StartTimeFrom'};
}


=head2 setStartTimeTo()

Describes the latest (most recent) date to use in a date range filter
based on item start time. If you specify the corresponding From filter,
but you do not include StartTimeTo, the StartTimeTo is set to
the time you make the call.

  RequiredInput: No
#    Argument: 'xs:dateTime'

=cut

sub setStartTimeTo {
  my $self = shift;
  $self->{'StartTimeTo'} = shift
}

=head2 getStartTimeTo()

#    Returns: 'xs:dateTime'

=cut

sub getStartTimeTo {
  my $self = shift;
  return $self->{'StartTimeTo'};
}


=head2 setUserID()

eBay user ID for the seller whose events are to be returned.
If not specified, retrieves events for the user identified by
the authentication token passed in the request. Note that since user information is anonymous to everyone except the bidder and the seller (during an active auction), only sellers looking for information about
their own listings and bidders who know the user IDs of their sellers
will be able to make this API call successfully. See <a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AnonymousUserInfo">Working with Anonymous User Information</a>in the eBay Web Services Guide for more information.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
