#!/usr/bin/perl

package eBay::API::XML::Call::SetPromotionalSale;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetPromotionalSale.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetPromotionalSale

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetPromotionalSale inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleRequestType;
use eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetPromotionalSale';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetPromotionalSale::SetPromotionalSaleResponseType';
}

#
# input properties
#

=head2 setAction()

Specifies adding, removing, or modifying promotional sales.

  RequiredInput: Yes
#    Argument: 'ns:ModifyActionCodeType'

=cut
       
sub setAction {
   my $self   = shift;
   my $sAction = shift;
   $self->getRequestDataType()->setAction($sAction);
}

=head2 setPromotionalSaleDetails()

Specifies details about the promotional sale.

  RequiredInput: Yes
#    Argument: 'ns:PromotionalSaleType'

=cut
       
sub setPromotionalSaleDetails {
   my $self   = shift;
   my $pPromotionalSaleDetails = shift;
   $self->getRequestDataType()->setPromotionalSaleDetails($pPromotionalSaleDetails);
}



#
# output properties
#

=head2 getPromotionalSaleID()

Contains the ID of a promotional sale.

  Returned: Always
#    Returns: 'xs:long'

=cut
       
sub getPromotionalSaleID {
   my $self = shift;
   return $self->getResponseDataType()->getPromotionalSaleID();
}

=head2 getStatus()

Contains the status of a promotional sale.

  Returned: Always
#    Returns: 'ns:PromotionalSaleStatusCodeType'

=cut
       
sub getStatus {
   my $self = shift;
   return $self->getResponseDataType()->getStatus();
}





1;   
