#!/usr/bin/perl

package eBay::API::XML::Call::UploadSiteHostedPictures;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UploadSiteHostedPictures.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::UploadSiteHostedPictures

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::UploadSiteHostedPictures inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesRequestType;
use eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'UploadSiteHostedPictures';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::UploadSiteHostedPictures::UploadSiteHostedPicturesResponseType';
}

#
# input properties
#

=head2 setPictureData()

An optional reference ID to the binary attachment.
The PictureData field does not contain the binary attachment.
The binary attachment is image data,
including headers, from a JPG, GIF, PNG, BMP, or TIF format image file.
The binary attachment must be sent as a MIME attachment,
in your POST request, after the XML input.

  RequiredInput: No
#    Argument: 'ns:Base64BinaryType'

=cut
       
sub setPictureData {
   my $self   = shift;
   my $pPictureData = shift;
   $self->getRequestDataType()->setPictureData($pPictureData);
}

=head2 setPictureName()

A name you provide for the picture. 
Returned as SiteHostedPictureDetails.PictureName in the call response.

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setPictureName {
   my $self   = shift;
   my $sPictureName = shift;
   $self->getRequestDataType()->setPictureName($sPictureName);
}

=head2 setPictureSet()

The image sizes that will be generated.

  RequiredInput: No
  AllValuesExcept: Large
  Default: Standard
#    Argument: 'ns:PictureSetCodeType'

=cut
       
sub setPictureSet {
   my $self   = shift;
   my $sPictureSet = shift;
   $self->getRequestDataType()->setPictureSet($sPictureSet);
}

=head2 setPictureSystemVersion()

Specifies the picture system version. Only version 2 is valid. 
Available to support future changes in the picture system version.

  RequiredInput: No
  Default: 2
#    Argument: 'xs:int'

=cut
       
sub setPictureSystemVersion {
   my $self   = shift;
   my $sPictureSystemVersion = shift;
   $self->getRequestDataType()->setPictureSystemVersion($sPictureSystemVersion);
}

=head2 setPictureUploadPolicy()

When the My Picture Uploads feature is available (see the Trading API Release Notes), applications
(including non-listing apps, such as photo-editors and digital-camera software) will be able to use 
the PictureUploadPolicy field to specify that an uploaded picture is available to a seller on the eBay site. When you use PictureUploadPolicy, you are specifying that the picture you uploaded (and its URL) is stored for 48 hours on the eBay site. (If, within 48 hours, the picture is associated with an item, 
then it persists on the eBay site for the same time length as other pictures uploaded using 
the UploadSiteHostedPictures call).
As a result of the storage on the eBay site, the picture is available to the seller on 
the My Picture Uploads tab within the Sell Your Item (SYI) pages.
A maximum of 25 URLs can be stored.

  RequiredInput: No
#    Argument: 'ns:PictureUploadPolicyCodeType'

=cut
       
sub setPictureUploadPolicy {
   my $self   = shift;
   my $sPictureUploadPolicy = shift;
   $self->getRequestDataType()->setPictureUploadPolicy($sPictureUploadPolicy);
}



#
# output properties
#

=head2 getPictureSystemVersion()

Specifies the picture system version that was used to upload pictures.
Only version 2 is valid.

  Returned: Always
#    Returns: 'xs:int'

=cut
       
sub getPictureSystemVersion {
   my $self = shift;
   return $self->getResponseDataType()->getPictureSystemVersion();
}

=head2 getSiteHostedPictureDetails()

Contains information about an UploadSiteHostedPictures upload,
including the URL of the uploaded picture.

  Returned: Always
#    Returns: 'ns:SiteHostedPictureDetailsType'

=cut
       
sub getSiteHostedPictureDetails {
   my $self = shift;
   return $self->getResponseDataType()->getSiteHostedPictureDetails();
}





1;   
