#!/usr/bin/perl

package eBay::API::XML::Call::VeROReportItems;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. VeROReportItems.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::VeROReportItems

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::VeROReportItems inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::VeROReportItems::VeROReportItemsRequestType;
use eBay::API::XML::Call::VeROReportItems::VeROReportItemsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'VeROReportItems';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::VeROReportItems::VeROReportItemsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::VeROReportItems::VeROReportItemsResponseType';
}

#
# input properties
#

=head2 setReportItems()

Container (packet) for items being reported. You can report the same item 
more than once in a packet if a different reason code is used each time.

  RequiredInput: No
#    Argument: 'ns:VeROReportItemsType'

=cut
       
sub setReportItems {
   my $self   = shift;
   my $pReportItems = shift;
   $self->getRequestDataType()->setReportItems($pReportItems);
}

=head2 setRightsOwnerID()

User ID of the VeRO member reporting the items.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut
       
sub setRightsOwnerID {
   my $self   = shift;
   my $pRightsOwnerID = shift;
   $self->getRequestDataType()->setRightsOwnerID($pRightsOwnerID);
}



#
# output properties
#

=head2 getVeROReportPacketID()

A unique packet identifier for the items reported.

  Returned: Conditionally
#    Returns: 'xs:long'

=cut
       
sub getVeROReportPacketID {
   my $self = shift;
   return $self->getResponseDataType()->getVeROReportPacketID();
}

=head2 getVeROReportPacketStatus()

The processing status of the packet.

  Returned: Conditionally
#    Returns: 'ns:VeROReportPacketStatusCodeType'

=cut
       
sub getVeROReportPacketStatus {
   my $self = shift;
   return $self->getResponseDataType()->getVeROReportPacketStatus();
}





1;   
