#!/usr/bin/perl

package eBay::API::XML::DataType::DisputeArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DisputeArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DisputeArrayType

=head1 DESCRIPTION

Represents a list of disputes. Can hold zero or more Dispute
types, each of which describes a dispute.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DisputeArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::DisputeType;


my @gaProperties = ( [ 'Dispute', 'ns:DisputeType', '1'
	     ,'eBay::API::XML::DataType::DisputeType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDispute()

The information that describes a dispute, including
the buyer's name, the transaction ID, the dispute state
and status, whether the dispute is resolved,
and any messages posted to the dispute.

#    Argument: reference to an array  
                      of 'ns:DisputeType'

=cut

sub setDispute {
  my $self = shift;
  $self->{'Dispute'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDispute()

  Calls: GetUserDisputes
  Returned: Always
  Details: DetailLevel: ReturnSummary, ReturnAll, none

#    Returns: reference to an array  
                      of 'ns:DisputeType'

=cut

sub getDispute {
  my $self = shift;
  return $self->_getDataTypeArray('Dispute');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
