#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::AckCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AckCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::AckCodeType

=head1 DESCRIPTION

This code identifies the acknowledgement code types that
eBay could use to communicate the status of processing a
(request) message to an application. This code would be used
as part of a response message that contains an
application-level acknowledgement element.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Success

(out) Request processing succeeded



=cut


use constant Success => scalar('Success');


=head2 Failure

(out) Request processing failed



=cut


use constant Failure => scalar('Failure');


=head2 Warning

(out) Request processing completed with warning information
being included in the response message



=cut


use constant Warning => scalar('Warning');


=head2 PartialFailure

(out) Request processing completed with some failures.
See the Errors data to determine which portions of the request failed.



=cut


use constant PartialFailure => scalar('PartialFailure');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
