#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::ExpressHistogramSortCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressHistogramSortCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::ExpressHistogramSortCodeType

=head1 DESCRIPTION

Sort options for the Express histogram.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ItemCount

(in) Sort the domains in the histogram by the item count in descending order.
The domain with the most matching items is returned first.
This is the default setting.



=cut


use constant ItemCount => scalar('ItemCount');


=head2 ProductCount

(in) Sort the domains by the product count in descending order.
The domain with the most matching products is returned first.



=cut


use constant ProductCount => scalar('ProductCount');


=head2 Alphabetical

(in) Sort the domains alphabetically by DomainDetails.Name.
Domains at the same depth are sorted first. Within each domain,
child domains are also sorted. For example, a "Books_Dept" department
and its aisles or product types would be returned before a
stand-alone "Hard_Domain_Music" product type.
And that "Hard_Domain_Music" product type would be returned before
a stand-alone "OldNavyAisle" aisle and its product types.



=cut


use constant Alphabetical => scalar('Alphabetical');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
