#!/usr/bin/perl

package eBay::API::XML::DataType::ItemsCanceledEventType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ItemsCanceledEventType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ItemsCanceledEventType

=head1 DESCRIPTION

Return the canceled items along with the seller info



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ItemsCanceledEventType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::ItemIDArrayType;
use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'CanceledItemIDArray', 'ns:ItemIDArrayType', ''
	     ,'eBay::API::XML::DataType::ItemIDArrayType', '1' ]
	, [ 'EligibleForRelist', 'xs:boolean', '', '', '' ]
	, [ 'SellerID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCanceledItemIDArray()

Array of items ended

#    Argument: 'ns:ItemIDArrayType'

=cut

sub setCanceledItemIDArray {
  my $self = shift;
  $self->{'CanceledItemIDArray'} = shift
}

=head2 getCanceledItemIDArray()

#    Returns: 'ns:ItemIDArrayType'

=cut

sub getCanceledItemIDArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CanceledItemIDArray'
		,'eBay::API::XML::DataType::ItemIDArrayType');
}


=head2 setEligibleForRelist()

To indicate to seller whether the items ended are eligible for
Relist or not

#    Argument: 'xs:boolean'

=cut

sub setEligibleForRelist {
  my $self = shift;
  $self->{'EligibleForRelist'} = shift
}

=head2 isEligibleForRelist()

#    Returns: 'xs:boolean'

=cut

sub isEligibleForRelist {
  my $self = shift;
  return $self->{'EligibleForRelist'};
}


=head2 setSellerID()

Seller numeric id

#    Argument: 'ns:UserIDType'

=cut

sub setSellerID {
  my $self = shift;
  $self->{'SellerID'} = shift
}

=head2 getSellerID()

#    Returns: 'ns:UserIDType'

=cut

sub getSellerID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SellerID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
