#!/usr/bin/perl

package eBay::API::XML::DataType::ListingDurationReferenceType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingDurationReferenceType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingDurationReferenceType

=head1 DESCRIPTION

Identifies the type of listing as an attribute on the ListingDuration node.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingDurationReferenceType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::ListingTypeCodeType;


my @gaProperties = ( [ 'content', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'type', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setValue()

#    Argument: 'xs:int'

=cut

sub setValue {
  my $self = shift;
  $self->{'content'} = shift
}

=head2 getValue()

#    Returns: 'xs:int'

=cut

sub getValue {
  my $self = shift;
  return $self->{'content'};
}




=head2 setType()

The type of listing a set of durations describes.

#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setType {
  my $self = shift;
  $self->{'type'} = shift
}

=head2 getType()

  Calls: GetCategoryFeatures
  Returned: Conditionally
  AllValuesExcept: Unknown, Auction, Half
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getType {
  my $self = shift;
  return $self->{'type'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
