#!/usr/bin/perl

package eBay::API::XML::DataType::SafePaymentRequiredDefinitionType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SafePaymentRequiredDefinitionType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SafePaymentRequiredDefinitionType

=head1 DESCRIPTION

For the US, Canada and Australia sites, users registered after January 17,2007 are 
required to offer at least one safe payment method (i.e. PayPal/PaisaPay, or one 
of the credit cards specified in Item.PaymentMethods).
<br>
If a seller has a 'SafePaymentExempt' status, they are exempt from the category 
requirement to offer at least one safe payment method when listing an item on a 
site that has the safe payment requirement.
<br>
The safe payment requirement also applies to two-category listings that have one 
ship-to or available-to location in the US, Canada, or Australia. The French 
Canadian (CAFR) site is a special case, because listings on the CAFR site with 
ship-to or available-to locations in Canada do not require a Safe Payment method, 
yet listings on the CAFR site with ship-to or available-to locations in the US or 
Australia do require a safe payment method.
<br>
The Business and Industrial, Motors, Real Estate, and Mature Audiences categories, 
and all listings that don't support Item.PaymentMethods are exempt from this 
requirement. Therefore, listings in those categories do not require a safe payment 
method.
<br>
Currently, this field contains no other special meta-data.(An empty element is 
returned.)
<br> 
Use SiteDefaults.SafePaymentRequired and Category.SafePaymentRequired to determine 
which categories require a safe payment method.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SafePaymentRequiredDefinitionType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( 
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}






##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
