#!/usr/bin/perl

package eBay::API::XML::DataType::SummaryEventScheduleType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SummaryEventScheduleType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SummaryEventScheduleType

=head1 DESCRIPTION

Details about a summary event schedule.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SummaryEventScheduleType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType;
use eBay::API::XML::DataType::Enum::SummaryFrequencyCodeType;
use eBay::API::XML::DataType::Enum::SummaryWindowPeriodCodeType;


my @gaProperties = ( [ 'EventType', 'ns:NotificationEventTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::NotificationEventTypeCodeType', '' ]
	, [ 'Frequency', 'ns:SummaryFrequencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SummaryFrequencyCodeType', '' ]
	, [ 'SummaryPeriod', 'ns:SummaryWindowPeriodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SummaryWindowPeriodCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEventType()

The event type associated with this alert.

  Calls: SetNotificationPreferences
  RequiredInput: Conditionally
  AllValuesExcept: None

#    Argument: 'ns:NotificationEventTypeCodeType'

=cut

sub setEventType {
  my $self = shift;
  $self->{'EventType'} = shift
}

=head2 getEventType()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:NotificationEventTypeCodeType'

=cut

sub getEventType {
  my $self = shift;
  return $self->{'EventType'};
}


=head2 setFrequency()

How often the summary is to be delivered.

  Calls: SetNotificationPreferences
  RequiredInput: Conditionally

#    Argument: 'ns:SummaryFrequencyCodeType'

=cut

sub setFrequency {
  my $self = shift;
  $self->{'Frequency'} = shift
}

=head2 getFrequency()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:SummaryFrequencyCodeType'

=cut

sub getFrequency {
  my $self = shift;
  return $self->{'Frequency'};
}


=head2 setSummaryPeriod()

The period of time for which to create a summary.

  Calls: SetNotificationPreferences
  RequiredInput: Conditionally

#    Argument: 'ns:SummaryWindowPeriodCodeType'

=cut

sub setSummaryPeriod {
  my $self = shift;
  $self->{'SummaryPeriod'} = shift
}

=head2 getSummaryPeriod()

  Calls: GetNotificationPreferences
  Returned: Conditionally

#    Returns: 'ns:SummaryWindowPeriodCodeType'

=cut

sub getSummaryPeriod {
  my $self = shift;
  return $self->{'SummaryPeriod'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
