#!/usr/bin/perl

package eBay::API::XML::DataType::PromotedItemType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. PromotedItemType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::PromotedItemType

=head1 DESCRIPTION

Contains the data describing one cross-promoted item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::PromotedItemType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::PromotionDetailsType;
use eBay::API::XML::DataType::Enum::ListingTypeCodeType;
use eBay::API::XML::DataType::Enum::PromotionItemSelectionCodeType;


my @gaProperties = ( [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'ListingType', 'ns:ListingTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ListingTypeCodeType', '' ]
	, [ 'PictureURL', 'xs:string', '', '', '' ]
	, [ 'Position', 'xs:int', '', '', '' ]
	, [ 'PromotionDetails', 'ns:PromotionDetailsType', '1'
	     ,'eBay::API::XML::DataType::PromotionDetailsType', '1' ]
	, [ 'SelectionType', 'ns:PromotionItemSelectionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::PromotionItemSelectionCodeType', '' ]
	, [ 'TimeLeft', 'xs:duration', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setItemID()

The unique ID of the item for which there is a promotion.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

  Calls: GetPromotionRules
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setListingType()

The listing type under which the cross-promoted item
is being offered.<br>
<br>
<span class="tablenote"><b>Note:</b>
Lead generated items are only cross-promoted
if they are in the classified ad format (ListingSubtype=ClassifiedAd).</span>

#    Argument: 'ns:ListingTypeCodeType'

=cut

sub setListingType {
  my $self = shift;
  $self->{'ListingType'} = shift
}

=head2 getListingType()

  Calls: GetItem
  Returned: Conditionally
  AllValuesExcept: Unknown, Live, Auction, PersonalOffer,
							Half, Express
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always
  AllValuesExcept: Unknown, Live, Auction, PersonalOffer,
							Half, Express

#    Returns: 'ns:ListingTypeCodeType'

=cut

sub getListingType {
  my $self = shift;
  return $self->{'ListingType'};
}


=head2 setPictureURL()

URL for an image hosted by eBay Picture Services (EPS) or self-hosted for
the promoted item, if any.

#    Argument: 'xs:string'

=cut

sub setPictureURL {
  my $self = shift;
  $self->{'PictureURL'} = shift
}

=head2 getPictureURL()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPictureURL {
  my $self = shift;
  return $self->{'PictureURL'};
}


=head2 setPosition()

The ordinal position of the cross-promoted item
in the display. If the display is from top to bottom,
1 is at top. If the display is from left to right, 1
is at left.

#    Argument: 'xs:int'

=cut

sub setPosition {
  my $self = shift;
  $self->{'Position'} = shift
}

=head2 getPosition()

  Calls: GetPromotionRules
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getPosition {
  my $self = shift;
  return $self->{'Position'};
}


=head2 setPromotionDetails()

Contains the details about the promoted item for a given PromotionPriceType. Output only.
Returned with request versions 485 or higher.

#    Argument: reference to an array  
                      of 'ns:PromotionDetailsType'

=cut

sub setPromotionDetails {
  my $self = shift;
  $self->{'PromotionDetails'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getPromotionDetails()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: reference to an array  
                      of 'ns:PromotionDetailsType'

=cut

sub getPromotionDetails {
  my $self = shift;
  return $self->_getDataTypeArray('PromotionDetails');
}


=head2 setSelectionType()

The manner in which the cross-promoted item was chosen
to be associated with the referring item. Output only.

#    Argument: 'ns:PromotionItemSelectionCodeType'

=cut

sub setSelectionType {
  my $self = shift;
  $self->{'SelectionType'} = shift
}

=head2 getSelectionType()

  Calls: GetPromotionRules
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: 'ns:PromotionItemSelectionCodeType'

=cut

sub getSelectionType {
  my $self = shift;
  return $self->{'SelectionType'};
}


=head2 setTimeLeft()

Time left before the listing for the cross-promoted item ends. Output only.
The duration is represented in the ISO 8601 duration format (PnYnMnDTnHnMnS).
See Data Types in the eBay Web Services guide for information about this
format.
For ended listings, the time left is PT0S (zero seconds).

#    Argument: 'xs:duration'

=cut

sub setTimeLeft {
  my $self = shift;
  $self->{'TimeLeft'} = shift
}

=head2 getTimeLeft()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: 'xs:duration'

=cut

sub getTimeLeft {
  my $self = shift;
  return $self->{'TimeLeft'};
}


=head2 setTitle()

The title of the promoted item for display in the
referring item's page. Output only.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

  Calls: GetCrossPromotions
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
