#!/usr/bin/perl

package eBay::API::XML::Call::GetBestOffers::GetBestOffersResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetBestOffersResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetBestOffers::GetBestOffersResponseType

=head1 DESCRIPTION

All best offers for the item according to the filter or best offer
id (or both) used in the input.
For the notification client usage, this response includes a
single Best Offer.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetBestOffers::GetBestOffersResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::BestOfferArrayType;
use eBay::API::XML::DataType::ItemType;


my @gaProperties = ( [ 'BestOfferArray', 'ns:BestOfferArrayType', ''
	     ,'eBay::API::XML::DataType::BestOfferArrayType', '1' ]
	, [ 'Item', 'ns:ItemType', ''
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOfferArray()

All best offers for the item according to the filter or
best offer id (or both) used in the input. The buyer and
seller messages are returned only if the detail level is
defined. Includes the buyer and seller message only if
detail level ReturnAll is used.
Only returned if best offers have been made.

#    Argument: 'ns:BestOfferArrayType'

=cut

sub setBestOfferArray {
  my $self = shift;
  $self->{'BestOfferArray'} = shift
}

=head2 getBestOfferArray()

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:BestOfferArrayType'

=cut

sub getBestOfferArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferArray'
		,'eBay::API::XML::DataType::BestOfferArrayType');
}


=head2 setItem()

The item for which Best Offers are being returned.
Only returned if best offers have been made.

#    Argument: 'ns:ItemType'

=cut

sub setItem {
  my $self = shift;
  $self->{'Item'} = shift
}

=head2 getItem()

  Returned: Always
  Details: DetailLevel: none, ReturnAll
#    Returns: 'ns:ItemType'

=cut

sub getItem {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Item'
		,'eBay::API::XML::DataType::ItemType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
