#!/usr/bin/perl

package eBay::API::XML::Call::GetCrossPromotions;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCrossPromotions.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCrossPromotions

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCrossPromotions inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsRequestType;
use eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetCrossPromotions';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetCrossPromotions::GetCrossPromotionsResponseType';
}

#
# input properties
#

=head2 setItemID()

The unique ID of the referring item. The cross-promoted
items will supplement this item.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setPromotionMethod()

The cross-promotion method you want to use for the
returned list, either UpSell or CrossSell.

  RequiredInput: Yes
#    Argument: 'ns:PromotionMethodCodeType'

=cut
       
sub setPromotionMethod {
   my $self   = shift;
   my $sPromotionMethod = shift;
   $self->getRequestDataType()->setPromotionMethod($sPromotionMethod);
}

=head2 setPromotionViewMode()

The role of the person requesting to view the cross-promoted
items, either seller or buyer. Default is buyer.

  RequiredInput: No
#    Argument: 'ns:TradingRoleCodeType'

=cut
       
sub setPromotionViewMode {
   my $self   = shift;
   my $sPromotionViewMode = shift;
   $self->getRequestDataType()->setPromotionViewMode($sPromotionViewMode);
}



#
# output properties
#

=head2 getCrossPromotion()

A list of cross-promoted items defined for a specific
referring item. The list is either upsell or cross-sell
items, according to the value of PromotionMethod in
GetCrossPromotionsRequest.

  Returned: Always
#    Returns: 'ns:CrossPromotionsType'

=cut
       
sub getCrossPromotion {
   my $self = shift;
   return $self->getResponseDataType()->getCrossPromotion();
}





1;   
