#!/usr/bin/perl

package eBay::API::XML::DataType::FeesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. FeesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::FeesType

=head1 DESCRIPTION

Identifies a set of one or more fees that a member pays to eBay (or
an eBay company). Instances of this type can hold one or more fees.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::FeesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::FeeType;


my @gaProperties = ( [ 'Fee', 'ns:FeeType', '1'
	     ,'eBay::API::XML::DataType::FeeType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setFee()

Contains the data for one fee (such as name and amount).

#    Argument: reference to an array  
                      of 'ns:FeeType'

=cut

sub setFee {
  my $self = shift;
  $self->{'Fee'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getFee()

  Calls: AddItem
         AddLiveAuctionItem
         RelistItem
         ReviseItem
         ReviseLiveAuctionItem
         VerifyAddItem
  Returned: Always

#    Returns: reference to an array  
                      of 'ns:FeeType'

=cut

sub getFee {
  my $self = shift;
  return $self->_getDataTypeArray('Fee');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
