#!/usr/bin/perl

package eBay::API::XML::DataType::SKUArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SKUArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SKUArrayType

=head1 DESCRIPTION

A list of stock-keeping unit (SKU) identifiers that a seller uses in listings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SKUArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SKUType;


my @gaProperties = ( [ 'SKU', 'ns:SKUType', '1'
	     ,'eBay::API::XML::DataType::SKUType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setSKU()

Identifier defined and used by a seller to identify an item. The
seller can use a SKU to identify one item or use the same SKU for
multiple items. Preferable to ApplicationData for SKUs and inventory
tracking. Different sellers can use the same SKUs. This element can
be used by sellers to track complex flows of products and
information. This element preserves a SKU, enabling a seller to
obtain it before and after a transaction is created.

MaxLength: 50

  Calls: GetSellerTransactions
         GetSellerList
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:SKUType'

=cut

sub setSKU {
  my $self = shift;
  $self->{'SKU'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSKU()

#    Returns: reference to an array  
                      of 'ns:SKUType'

=cut

sub getSKU {
  my $self = shift;
  return $self->_getDataTypeArray('SKU');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
