#!/usr/bin/perl

package eBay::API::XML::DataType::TokenStatusType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. TokenStatusType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::TokenStatusType

=head1 DESCRIPTION

Returns token status.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::TokenStatusType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::TokenStatusCodeType;


my @gaProperties = ( [ 'EIASToken', 'xs:string', '', '', '' ]
	, [ 'ExpirationTime', 'xs:dateTime', '', '', '' ]
	, [ 'RevocationTime', 'xs:dateTime', '', '', '' ]
	, [ 'Status', 'ns:TokenStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TokenStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEIASToken()

Identifies the user to whom the token belongs.

#    Argument: 'xs:string'

=cut

sub setEIASToken {
  my $self = shift;
  $self->{'EIASToken'} = shift
}

=head2 getEIASToken()

  Calls: GetTokenStatus
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getEIASToken {
  my $self = shift;
  return $self->{'EIASToken'};
}


=head2 setExpirationTime()

Original expiration time for the token.

#    Argument: 'xs:dateTime'

=cut

sub setExpirationTime {
  my $self = shift;
  $self->{'ExpirationTime'} = shift
}

=head2 getExpirationTime()

  Calls: GetTokenStatus
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getExpirationTime {
  my $self = shift;
  return $self->{'ExpirationTime'};
}


=head2 setRevocationTime()

Token revocation time, if the token has been revoked.

#    Argument: 'xs:dateTime'

=cut

sub setRevocationTime {
  my $self = shift;
  $self->{'RevocationTime'} = shift
}

=head2 getRevocationTime()

  Calls: GetTokenStatus
  Returned: Always

#    Returns: 'xs:dateTime'

=cut

sub getRevocationTime {
  my $self = shift;
  return $self->{'RevocationTime'};
}


=head2 setStatus()

Current token status.

#    Argument: 'ns:TokenStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetTokenStatus
  Returned: Always

#    Returns: 'ns:TokenStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
