/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.util;

import com.vizdom.util.CharacterEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

class CharacterEncoderReader
extends Reader {
    private CharacterEncoder mEncoder;
    private InputStream mInputStream;

    CharacterEncoderReader(InputStream anInputStream, CharacterEncoder anEncoder) {
        this.mEncoder = anEncoder;
        this.mInputStream = anInputStream;
    }

    private void mEnsureValid() throws IOException {
        if (this.mInputStream == null || this.mEncoder == null) {
            throw new IOException();
        }
    }

    @Override
    public int read(char[] aCharacterBuffer, int anOffset, int aLength) throws IOException {
        this.mEnsureValid();
        if (aCharacterBuffer == null) {
            throw new NullPointerException();
        }
        if (anOffset < 0 || aLength < 0 || anOffset + aLength > aCharacterBuffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (aLength == 0) {
            return 0;
        }
        byte[] bytes = new byte[aLength];
        int count = this.mInputStream.read(bytes);
        if (count == -1) {
            return count;
        }
        for (int i = 0; i < bytes.length; ++i) {
            aCharacterBuffer[anOffset + i] = this.mEncoder.getUnicode(bytes[i]);
        }
        return count;
    }

    @Override
    public void close() throws IOException {
        this.mEnsureValid();
        this.mInputStream.close();
        this.mInputStream = null;
        this.mEncoder = null;
    }
}

