/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import java.util.regex.Matcher;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.core.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommandMultilines2<S extends Diagram>
implements Command<S> {
    private final RegexConcat starting;
    private final MultilinesStrategy strategy;

    public CommandMultilines2(RegexConcat regexConcat, MultilinesStrategy multilinesStrategy) {
        if (!regexConcat.getPattern().startsWith("^") || !regexConcat.getPattern().endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + regexConcat.getPattern());
        }
        this.strategy = multilinesStrategy;
        this.starting = regexConcat;
    }

    public abstract String getPatternEnd();

    @Override
    public String[] getDescription() {
        return new String[]{"START: " + this.starting.getPattern(), "END: " + this.getPatternEnd()};
    }

    @Override
    public final CommandControl isValid(List<String> list) {
        list = this.strategy.filter(list);
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        boolean bl = this.starting.match(list.get(0).trim());
        if (!bl) {
            return CommandControl.NOT_OK;
        }
        if (list.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        Matcher matcher = MyPattern.cmpile(this.getPatternEnd()).matcher(list.get(list.size() - 1).trim());
        if (!matcher.matches()) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    @Override
    public final CommandExecutionResult execute(S s, List<String> list) {
        return this.executeNow(s, this.strategy.filter(list));
    }

    public abstract CommandExecutionResult executeNow(S var1, List<String> var2);

    protected boolean isCommandForbidden() {
        return false;
    }

    protected void actionIfCommandValid() {
    }

    protected final RegexConcat getStartingPattern() {
        return this.starting;
    }
}

