untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46LsPhiK/kw/tB1/nPFma1cHAVkyy5iRLZ86oqy4C4Ohk1FncquyRNjwwD8XxeB8szievJM28fN58u3E/kybXFA4=

OpenBSD 6.9 errata 024, December 14, 2021:

Multiple input validation failures in the X server request parsing
code can lead to out of bounds memory accesses for authorized
clients.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 024_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X server
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/Xext/saver.c
===================================================================
RCS file: /cvs/xenocara/xserver/Xext/saver.c,v
diff -u -p -r1.18 saver.c
--- xserver/Xext/saver.c	27 Jul 2019 07:57:07 -0000	1.18
+++ xserver/Xext/saver.c	6 Dec 2021 20:48:53 -0000
@@ -1350,9 +1350,9 @@ SProcScreenSaverSuspend(ClientPtr client
 {
     REQUEST(xScreenSaverSuspendReq);
 
+    REQUEST_SIZE_MATCH(xScreenSaverSuspendReq);
     swaps(&stuff->length);
     swapl(&stuff->suspend);
-    REQUEST_SIZE_MATCH(xScreenSaverSuspendReq);
     return ProcScreenSaverSuspend(client);
 }
 
Index: xserver/record/record.c
===================================================================
RCS file: /cvs/xenocara/xserver/record/record.c,v
diff -u -p -r1.21 record.c
--- xserver/record/record.c	26 Feb 2021 14:10:26 -0000	1.21
+++ xserver/record/record.c	6 Dec 2021 20:49:07 -0000
@@ -2515,8 +2515,8 @@ SwapCreateRegister(ClientPtr client, xRe
         swapl(pClientID);
     }
     if (stuff->nRanges >
-        client->req_len - bytes_to_int32(sz_xRecordRegisterClientsReq)
-        - stuff->nClients)
+        (client->req_len - bytes_to_int32(sz_xRecordRegisterClientsReq)
+        - stuff->nClients) / bytes_to_int32(sz_xRecordRange))
         return BadLength;
     RecordSwapRanges((xRecordRange *) pClientID, stuff->nRanges);
     return Success;
Index: xserver/render/render.c
===================================================================
RCS file: /cvs/xenocara/xserver/render/render.c,v
diff -u -p -r1.24 render.c
--- xserver/render/render.c	12 Dec 2019 06:05:20 -0000	1.24
+++ xserver/render/render.c	6 Dec 2021 20:49:12 -0000
@@ -2309,6 +2309,8 @@ SProcRenderCompositeGlyphs(ClientPtr cli
 
         i = elt->len;
         if (i == 0xff) {
+            if (buffer + 4 >= end)
+                return BadLength;
             swapl((int *) buffer);
             buffer += 4;
         }
@@ -2320,12 +2322,16 @@ SProcRenderCompositeGlyphs(ClientPtr cli
                 break;
             case 2:
                 while (i--) {
+                    if (buffer + 2 >= end)
+                        return BadLength;
                     swaps((short *) buffer);
                     buffer += 2;
                 }
                 break;
             case 4:
                 while (i--) {
+                    if (buffer + 4 >= end)
+                        return BadLength;
                     swapl((int *) buffer);
                     buffer += 4;
                 }
Index: xserver/xfixes/cursor.c
===================================================================
RCS file: /cvs/xenocara/xserver/xfixes/cursor.c,v
diff -u -p -r1.18 cursor.c
--- xserver/xfixes/cursor.c	27 Jul 2019 07:57:26 -0000	1.18
+++ xserver/xfixes/cursor.c	6 Dec 2021 20:49:12 -0000
@@ -1027,7 +1027,7 @@ SProcXFixesCreatePointerBarrier(ClientPt
 
     swaps(&stuff->length);
     swaps(&stuff->num_devices);
-    REQUEST_FIXED_SIZE(xXFixesCreatePointerBarrierReq, pad_to_int32(stuff->num_devices));
+    REQUEST_FIXED_SIZE(xXFixesCreatePointerBarrierReq, pad_to_int32(stuff->num_devices * 2));
 
     swapl(&stuff->barrier);
     swapl(&stuff->window);
