untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46JAJQFp6hPraMAFl7wD9EKrJFo6iX+hX44/PSsyjXm0IyYcTqHOQLE8hdLtASblrdi/wO/PEoz24b0Yn/1zRwgg=

OpenBSD 6.9 errata 032, March 15, 2022:

A malicious certificate can cause an infinite loop.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 032_bignum.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto and unwind:
    cd /usr/src/lib/libcrypto
    make obj
    make includes
    make
    make install
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: lib/libcrypto/bn/bn_sqrt.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/bn/bn_sqrt.c,v
retrieving revision 1.9
diff -u -p -r1.9 bn_sqrt.c
--- lib/libcrypto/bn/bn_sqrt.c	29 Jan 2017 17:49:22 -0000	1.9
+++ lib/libcrypto/bn/bn_sqrt.c	8 Mar 2022 19:28:17 -0000
@@ -351,21 +351,22 @@ BN_mod_sqrt(BIGNUM *in, const BIGNUM *a,
 			goto vrfy;
 		}
 
-
-		/* find smallest  i  such that  b^(2^i) = 1 */
-		i = 1;
-		if (!BN_mod_sqr(t, b, p, ctx))
-			goto end;
-		while (!BN_is_one(t)) {
-			i++;
-			if (i == e) {
-				BNerror(BN_R_NOT_A_SQUARE);
-				goto end;
+		/* Find the smallest i with 0 < i < e such that b^(2^i) = 1. */
+		for (i = 1; i < e; i++) {
+			if (i == 1) {
+				if (!BN_mod_sqr(t, b, p, ctx))
+					goto end;
+			} else {
+				if (!BN_mod_sqr(t, t, p, ctx))
+					goto end;
 			}
-			if (!BN_mod_mul(t, t, t, p, ctx))
-				goto end;
+			if (BN_is_one(t))
+				break;
+		}
+		if (i >= e) {
+			BNerror(BN_R_NOT_A_SQUARE);
+			goto end;
 		}
-
 
 		/* t := y^2^(e - i - 1) */
 		if (!BN_copy(t, y))
