untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8EgQoNTz8eyXOnBDAMRyRj41BWoGaUialmslXH8EDUT/cplGZtRUchTNCdjn33dad8jScKygSpp76MS+c6sSZAs=

OpenBSD 7.2 errata 007, November 26, 2022:

A crafted TCP query from localhost could crash the unwind(8) daemon.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 007_unwind.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install unwind:
    cd /usr/src/sbin/unwind
    make obj
    make
    make install

Index: sbin/unwind/frontend.c
===================================================================
RCS file: /cvs/src/sbin/unwind/frontend.c,v
diff -u -p -r1.73 frontend.c
--- sbin/unwind/frontend.c	13 Mar 2022 15:14:01 -0000	1.73
+++ sbin/unwind/frontend.c	23 Nov 2022 18:06:35 -0000
@@ -63,6 +63,7 @@
 #include "control.h"
 #include "dns64_synth.h"
 
+#define	MINIMUM(a, b)		(((a) < (b)) ? (a) : (b))
 #define	ROUTE_SOCKET_BUF_SIZE   16384
 
 /*
@@ -1699,6 +1700,7 @@ tcp_request(int fd, short events, void *
 
 	if (sldns_buffer_position(pq->qbuf) >= 2 && !pq->abuf) {
 		struct sldns_buffer	*tmp;
+		size_t			 rem;
 		uint16_t		 len;
 
 		sldns_buffer_flip(pq->qbuf);
@@ -1709,8 +1711,9 @@ tcp_request(int fd, short events, void *
 		if (!tmp || !pq->abuf)
 			goto fail;
 
+		rem = sldns_buffer_remaining(pq->qbuf);
 		sldns_buffer_write(tmp, sldns_buffer_current(pq->qbuf),
-		    sldns_buffer_remaining(pq->qbuf));
+		    MINIMUM(len, rem));
 		sldns_buffer_free(pq->qbuf);
 		pq->qbuf = tmp;
 	}
