untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8IUyg5BiZCSOt6ZQYIxiC2c4HwSN3keXuqAhuGCiYjDom0yEqMR/VYOQbhd685WbQ1jnpGDqajBI/AaZoEkrnwo=

OpenBSD 7.2 errata 024, March 29, 2023:

Xserver, CVE-2023-1393: use after free bug in the Composite server extension.

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 024_xserver.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install the X server:
    cd /usr/xenocara/xserver
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: xserver/composite/compwindow.c
===================================================================
RCS file: /cvs/xenocara/xserver/composite/compwindow.c,v
diff -u -p -r1.18 compwindow.c
--- xserver/composite/compwindow.c	11 Nov 2021 09:03:02 -0000	1.18
+++ xserver/composite/compwindow.c	16 Mar 2023 21:48:15 -0000
@@ -620,6 +620,11 @@ compDestroyWindow(WindowPtr pWin)
     ret = (*pScreen->DestroyWindow) (pWin);
     cs->DestroyWindow = pScreen->DestroyWindow;
     pScreen->DestroyWindow = compDestroyWindow;
+
+    /* Did we just destroy the overlay window? */
+    if (pWin == cs->pOverlayWin)
+        cs->pOverlayWin = NULL;
+
 /*    compCheckTree (pWin->drawable.pScreen); can't check -- tree isn't good*/
     return ret;
 }
